DROP TABLE IF EXISTS wptz_ai1ec_event_category_meta;

CREATE TABLE `wptz_ai1ec_event_category_meta` (
  `term_id` bigint(20) NOT NULL,
  `term_color` varchar(255) NOT NULL,
  `term_image` varchar(254) DEFAULT NULL,
  PRIMARY KEY (`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO wptz_ai1ec_event_category_meta VALUES("15", "", "");
INSERT INTO wptz_ai1ec_event_category_meta VALUES("16", "", "");

DROP TABLE IF EXISTS wptz_ai1ec_event_instances;

CREATE TABLE `wptz_ai1ec_event_instances` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) NOT NULL,
  `start` int(10) unsigned NOT NULL,
  `end` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `evt_instance` (`post_id`,`start`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO wptz_ai1ec_event_instances VALUES("1", "254", "1539788400", "1539993600");
INSERT INTO wptz_ai1ec_event_instances VALUES("2", "255", "1525305600", "1525392000");
INSERT INTO wptz_ai1ec_event_instances VALUES("3", "256", "1526067000", "1526077800");
INSERT INTO wptz_ai1ec_event_instances VALUES("4", "257", "1525401420", "1525405020");
INSERT INTO wptz_ai1ec_event_instances VALUES("5", "258", "1528988400", "1529193600");
INSERT INTO wptz_ai1ec_event_instances VALUES("6", "259", "1526054400", "1526065200");
INSERT INTO wptz_ai1ec_event_instances VALUES("7", "260", "1525401600", "1525405200");
INSERT INTO wptz_ai1ec_event_instances VALUES("8", "261", "1525401600", "1525405200");
INSERT INTO wptz_ai1ec_event_instances VALUES("9", "262", "1525401600", "1525405200");
INSERT INTO wptz_ai1ec_event_instances VALUES("10", "263", "1525401600", "1525405200");
INSERT INTO wptz_ai1ec_event_instances VALUES("11", "264", "1525401660", "1525405260");
INSERT INTO wptz_ai1ec_event_instances VALUES("12", "288", "1537426800", "1537599600");

DROP TABLE IF EXISTS wptz_ai1ec_events;

CREATE TABLE `wptz_ai1ec_events` (
  `post_id` bigint(20) NOT NULL,
  `start` int(10) unsigned NOT NULL,
  `end` int(10) unsigned DEFAULT NULL,
  `timezone_name` varchar(50) DEFAULT NULL,
  `allday` tinyint(1) NOT NULL,
  `instant_event` tinyint(1) NOT NULL DEFAULT 0,
  `recurrence_rules` longtext DEFAULT NULL,
  `exception_rules` longtext DEFAULT NULL,
  `recurrence_dates` longtext DEFAULT NULL,
  `exception_dates` longtext DEFAULT NULL,
  `venue` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `province` varchar(255) DEFAULT NULL,
  `postal_code` varchar(32) DEFAULT NULL,
  `show_map` tinyint(1) DEFAULT NULL,
  `contact_name` varchar(255) DEFAULT NULL,
  `contact_phone` varchar(32) DEFAULT NULL,
  `contact_email` varchar(128) DEFAULT NULL,
  `contact_url` varchar(255) DEFAULT NULL,
  `cost` varchar(255) DEFAULT NULL,
  `ticket_url` varchar(255) DEFAULT NULL,
  `ical_feed_url` varchar(255) DEFAULT NULL,
  `ical_source_url` varchar(255) DEFAULT NULL,
  `ical_organizer` varchar(255) DEFAULT NULL,
  `ical_contact` varchar(255) DEFAULT NULL,
  `ical_uid` varchar(255) DEFAULT NULL,
  `show_coordinates` tinyint(1) DEFAULT NULL,
  `latitude` decimal(20,15) DEFAULT NULL,
  `longitude` decimal(20,15) DEFAULT NULL,
  `force_regenerate` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`post_id`),
  KEY `feed_source` (`ical_feed_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO wptz_ai1ec_events VALUES("254", "1539788400", "1539993600", "America/Los_Angeles", "0", "0", "", "", "", "", "", "United States", "San Diego, CA, USA", "San Diego", "California", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-254@wolfeinteractivedemo.com/CSROA", "1", "32.715738000000000", "-117.161084000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("255", "1525305600", "1525392000", "Atlantic/Azores", "1", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-255@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("256", "1526067000", "1526077800", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "http://stanislaus.k12oms.org/475-149096", "", "", "", "", "ai1ec-256@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("257", "1525401420", "1525405020", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-257@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("258", "1528988400", "1529193600", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-258@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("259", "1526054400", "1526065200", "America/Los_Angeles", "0", "0", "", "", "", "", "Stanislaus County Office of Education", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:5:\"85.00\";s:7:\"is_free\";b:0;}", "http://stanislaus.k12oms.org/475-149095", "", "", "", "", "ai1ec-259@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("260", "1525401600", "1525405200", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-260@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("261", "1525401600", "1525405200", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-261@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("262", "1525401600", "1525405200", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-262@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("263", "1525401600", "1525405200", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-263@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("264", "1525401660", "1525405260", "America/Los_Angeles", "0", "0", "", "", "", "", "", "", "", "", "", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-264@wolfeinteractivedemo.com/CSROA", "0", "0.000000000000000", "0.000000000000000", "0");
INSERT INTO wptz_ai1ec_events VALUES("288", "1537426800", "1537599600", "America/Los_Angeles", "1", "0", "", "", "", "", "", "United States", "San Diego, CA, USA", "San Diego", "California", "", "0", "", "", "", "", "a:2:{s:4:\"cost\";s:0:\"\";s:7:\"is_free\";b:0;}", "", "", "", "", "", "ai1ec-288@wolfeinteractivedemo.com/CSROA", "1", "32.715738000000000", "-117.161084000000000", "0");

DROP TABLE IF EXISTS wptz_commentmeta;

CREATE TABLE `wptz_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wptz_comments;

CREATE TABLE `wptz_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wptz_db7_forms;

CREATE TABLE `wptz_db7_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_post_id` bigint(20) NOT NULL,
  `form_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wptz_db7_forms VALUES("1", "268", "a:17:{s:12:\"cfdb7_status\";s:4:\"read\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Linda\";s:9:\"last-name\";s:5:\"Wolfe\";s:5:\"title\";s:4:\"Test\";s:10:\"your-email\";s:26:\"linda@wolfeinteractive.com\";s:3:\"org\";s:4:\"Test\";s:6:\"school\";s:4:\"Test\";s:7:\"address\";s:35:\"111 Elm Street\r\nTemecula, CA  99999\";s:5:\"phone\";s:12:\"961-222-2222\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:4:\"1234\";s:9:\"order-num\";s:4:\"1234\";s:8:\"initials\";s:3:\"lkw\";}", "2018-06-15 12:22:07");
INSERT INTO wptz_db7_forms VALUES("2", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Linda\";s:9:\"last-name\";s:5:\"Wolfe\";s:5:\"title\";s:4:\"Test\";s:10:\"your-email\";s:26:\"linda@wolfeinteractive.com\";s:3:\"org\";s:4:\"Test\";s:6:\"school\";s:4:\"Test\";s:7:\"address\";s:28:\"111 Elm\r\nTemecula, CA  99999\";s:5:\"phone\";s:12:\"951-222-2221\";s:4:\"cell\";s:12:\"999-999-9999\";s:5:\"item1\";s:5:\"Learn\";s:5:\"item2\";s:15:\"Meet new people\";s:5:\"item3\";s:8:\"Have fun\";s:5:\"check\";s:4:\"1234\";s:9:\"order-num\";s:4:\"2333\";s:8:\"initials\";s:3:\"LKW\";}", "2018-06-15 12:29:40");
INSERT INTO wptz_db7_forms VALUES("3", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Jewel\";s:9:\"last-name\";s:6:\"Forbes\";s:5:\"title\";s:48:\"Coordinator II Community Health and Safe Schools\";s:10:\"your-email\";s:22:\"Forbes_jewel@lacoe.edu\";s:3:\"org\";s:38:\"Los Angeles County Office of Education\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:37:\"9300 Imperial Hwy\r\nDowney, CA 9090242\";s:5:\"phone\";s:12:\"562 922-6391\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"jdf\";}", "2018-08-06 10:20:32");
INSERT INTO wptz_db7_forms VALUES("4", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Adrienne\";s:9:\"last-name\";s:6:\"Maggay\";s:5:\"title\";s:20:\"Education Specialist\";s:10:\"your-email\";s:23:\"training@learn4life.org\";s:3:\"org\";s:19:\"Diego Hills Central\";s:6:\"school\";s:19:\"Diego Hills Central\";s:7:\"address\";s:38:\"177 Holston Drive, Lancaster, CA 93535\";s:5:\"phone\";s:10:\"6612721225\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:28:\"Mentoring incarcerated youth\";s:5:\"item2\";s:39:\"Help girls develop a sense of resilency\";s:5:\"item3\";s:25:\"Help girls handle anxiety\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"AM\";}", "2018-08-10 12:29:48");
INSERT INTO wptz_db7_forms VALUES("5", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Irene\";s:9:\"last-name\";s:7:\"Sanchez\";s:5:\"title\";s:7:\"Teacher\";s:10:\"your-email\";s:18:\"isanchez@euhsd.org\";s:3:\"org\";s:5:\"EUHSD\";s:6:\"school\";s:4:\"SPHS\";s:7:\"address\";s:42:\"3300BearValley Partkway Escondido Ca 92025\";s:5:\"phone\";s:10:\"7604438196\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:42:\"Ready to use strategies to engage my girls\";s:5:\"item2\";s:52:\"Information on creating support groups for our girls\";s:5:\"item3\";s:44:\"networking opportunity of like minded people\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"IMS\";}", "2018-08-10 14:59:59");
INSERT INTO wptz_db7_forms VALUES("6", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Veronica\";s:9:\"last-name\";s:6:\"Wright\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:26:\"wright_counselor@yahoo.com\";s:3:\"org\";s:0:\"\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:44:\"302 South Haskell Drive\r\nel centro, ca 92243\";s:5:\"phone\";s:10:\"7603374746\";s:4:\"cell\";s:10:\"7604277927\";s:5:\"item1\";s:22:\"Updates on the subject\";s:5:\"item2\";s:13:\"Conversations\";s:5:\"item3\";s:30:\"How to ultilize&#047; hands on\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"vw\";}", "2018-08-13 13:49:23");
INSERT INTO wptz_db7_forms VALUES("7", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:6:\"thelma\";s:9:\"last-name\";s:7:\"mubaiwa\";s:5:\"title\";s:27:\"Crime Prevention Specialist\";s:10:\"your-email\";s:24:\"thelma.mubaiwa@sdcda.org\";s:3:\"org\";s:17:\"District Attorney\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:42:\"12 N Euclid Avenue\r\nNational City CA 91950\";s:5:\"phone\";s:10:\"6197535578\";s:4:\"cell\";s:10:\"6197535578\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"tm\";}", "2018-08-14 16:09:28");
INSERT INTO wptz_db7_forms VALUES("8", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"danielle\";s:9:\"last-name\";s:4:\"fair\";s:5:\"title\";s:19:\"professional expert\";s:10:\"your-email\";s:23:\"danielle.fair@sdcda.org\";s:3:\"org\";s:17:\"district attorney\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:42:\"12 N Euclid Avenue\r\nnational city ca 91950\";s:5:\"phone\";s:10:\"9197535578\";s:4:\"cell\";s:10:\"6197535578\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"df\";}", "2018-08-14 16:22:10");
INSERT INTO wptz_db7_forms VALUES("9", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"stephanie\";s:9:\"last-name\";s:7:\"beltran\";s:5:\"title\";s:14:\"student worker\";s:10:\"your-email\";s:27:\"stephanie.beltran@sdcda.org\";s:3:\"org\";s:17:\"district attorney\";s:6:\"school\";s:24:\"thelma.mubaiwa@sdcda.org\";s:7:\"address\";s:42:\"12 N Euclid Avenue\r\nnational city ca 91950\";s:5:\"phone\";s:10:\"6197535578\";s:4:\"cell\";s:10:\"6197535578\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-08-14 16:23:08");
INSERT INTO wptz_db7_forms VALUES("10", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Veronica\";s:9:\"last-name\";s:6:\"Wright\";s:5:\"title\";s:9:\"counselor\";s:10:\"your-email\";s:26:\"wright_counselor@yahoo.com\";s:3:\"org\";s:0:\"\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:39:\"534 South 8th St\r\n\r\nEl Centro, CA 92243\";s:5:\"phone\";s:10:\"7603374746\";s:4:\"cell\";s:10:\"7604277927\";s:5:\"item1\";s:23:\"I\'d like to be updated \";s:5:\"item2\";s:28:\"What Resources are available\";s:5:\"item3\";s:19:\"Share the knowledge\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"vw\";}", "2018-08-15 09:08:50");
INSERT INTO wptz_db7_forms VALUES("11", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Monique\";s:9:\"last-name\";s:6:\"Reeves\";s:5:\"title\";s:20:\"School Social Worker\";s:10:\"your-email\";s:17:\"mreeves@euhsd.org\";s:3:\"org\";s:36:\"Escondido Union High School District\";s:6:\"school\";s:21:\"Escondido High School\";s:7:\"address\";s:36:\"1535 North Broadway, Escondido 92026\";s:5:\"phone\";s:10:\"7602914029\";s:4:\"cell\";s:10:\"7608030704\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"MMR\";}", "2018-08-16 14:38:14");
INSERT INTO wptz_db7_forms VALUES("12", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Allison\";s:9:\"last-name\";s:4:\"Ware\";s:5:\"title\";s:25:\"Girls Academy Coordinator\";s:10:\"your-email\";s:23:\"Allison.Ware@Rescue.org\";s:3:\"org\";s:30:\"International Rescue Committee\";s:6:\"school\";s:43:\"Crawford HS, Hoover HS, El Cajon Valley HS \";s:7:\"address\";s:48:\"5348 University Ave, Suite 115 \r\nSan Diego 92105\";s:5:\"phone\";s:12:\"619-641-7510\";s:4:\"cell\";s:12:\"760-215-4057\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:8:\"#126049 \";s:9:\"order-num\";s:2:\"NA\";s:8:\"initials\";s:3:\"AW \";}", "2018-08-20 09:26:04");
INSERT INTO wptz_db7_forms VALUES("13", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Melissa\";s:9:\"last-name\";s:5:\"Kelly\";s:5:\"title\";s:29:\"Alt. Ed. School Social Worker\";s:10:\"your-email\";s:18:\"deslusser@kern.org\";s:3:\"org\";s:37:\"Kern County Superintendent of Schools\";s:6:\"school\";s:29:\"School Community Partnerships\";s:7:\"address\";s:81:\"Kern County Superintendent of Schools\r\n1300 17th St. - SCP\r\nBakersfield, CA 93301\";s:5:\"phone\";s:12:\"661-852-5531\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"MK\";}", "2018-08-21 09:53:10");
INSERT INTO wptz_db7_forms VALUES("14", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"Christian\";s:9:\"last-name\";s:5:\"Munoz\";s:5:\"title\";s:20:\"School Social Worker\";s:10:\"your-email\";s:18:\"deslusser@kern.org\";s:3:\"org\";s:37:\"Kern County Superintendent of Schools\";s:6:\"school\";s:29:\"School Community Partnerships\";s:7:\"address\";s:81:\"Kern County Superintendent of Schools\r\n1300 17th St. - SCP\r\nBakersfield, CA 93301\";s:5:\"phone\";s:12:\"661-852-5677\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"CM\";}", "2018-08-21 09:58:25");
INSERT INTO wptz_db7_forms VALUES("15", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Jose\";s:9:\"last-name\";s:8:\"Espinoza\";s:5:\"title\";s:20:\"School Social Worker\";s:10:\"your-email\";s:18:\"deslusser@kern.org\";s:3:\"org\";s:37:\"Kern County Superintendent of Schools\";s:6:\"school\";s:15:\"Richland Jr. HS\";s:7:\"address\";s:81:\"Kern County Superintendent of Schools\r\n1300 17th St. - SCP\r\nBakersfield, CA 93301\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:12:\"661-319-4145\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"JE\";}", "2018-08-21 10:08:58");
INSERT INTO wptz_db7_forms VALUES("16", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Jeff\";s:9:\"last-name\";s:6:\"Coggan\";s:5:\"title\";s:20:\"School Social Worker\";s:10:\"your-email\";s:18:\"deslusser@kern.org\";s:3:\"org\";s:37:\"Kern County Superintendent of Schools\";s:6:\"school\";s:16:\"Valle Verde UESD\";s:7:\"address\";s:81:\"Kern County Superintendent of Schools\r\n1300 17th St. - SCP\r\nBakersfield, CA 93301\";s:5:\"phone\";s:12:\"661-721-3601\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"JC\";}", "2018-08-21 10:12:02");
INSERT INTO wptz_db7_forms VALUES("17", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Adriana\";s:9:\"last-name\";s:6:\"Martin\";s:5:\"title\";s:20:\"School Social Worker\";s:10:\"your-email\";s:18:\"deslusser@kern.org\";s:3:\"org\";s:37:\"Kern County Superintendent of Schools\";s:6:\"school\";s:12:\"La Vina M.S.\";s:7:\"address\";s:81:\"Kern County Superintendent of Schools\r\n1300 17th St. - SCP\r\nBakersfield, CA 93301\";s:5:\"phone\";s:12:\"661-721-5030\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"AM\";}", "2018-08-21 10:17:25");
INSERT INTO wptz_db7_forms VALUES("18", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"Stephanie\";s:9:\"last-name\";s:6:\"Guzman\";s:5:\"title\";s:44:\"School Social Worker - Foster Youth Services\";s:10:\"your-email\";s:18:\"deslusser@kern.org\";s:3:\"org\";s:37:\"Kern County Superintendent of Schools\";s:6:\"school\";s:10:\"North Kern\";s:7:\"address\";s:81:\"Kern County Superintendent of Schools\r\n1300 17th St. - SCP\r\nBakersfield, CA 93301\";s:5:\"phone\";s:12:\"661-327-8600\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"SG\";}", "2018-08-21 10:20:48");
INSERT INTO wptz_db7_forms VALUES("19", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Janet\";s:9:\"last-name\";s:4:\"Ruiz\";s:5:\"title\";s:37:\"Human Trafficking Prevention Manager \";s:10:\"your-email\";s:19:\"jruiz@pciglobal.org\";s:3:\"org\";s:29:\"Project Concern International\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:28:\"4305 University Ave\r\nSte 345\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:4:\"7576\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"JR\";}", "2018-08-21 12:11:11");
INSERT INTO wptz_db7_forms VALUES("20", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Bianca \";s:9:\"last-name\";s:12:\"Morales-Egan\";s:5:\"title\";s:50:\"Sr. Program Manager, Human Trafficking Prevention \";s:10:\"your-email\";s:27:\"bmorales-egan@pciglobal.org\";s:3:\"org\";s:29:\"Project Concern International\";s:6:\"school\";s:19:\"jruiz@pciglobal.org\";s:7:\"address\";s:28:\"4305 University Ave\r\nSte 345\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:4:\"7576\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"BME\";}", "2018-08-21 12:12:30");
INSERT INTO wptz_db7_forms VALUES("21", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"James\";s:9:\"last-name\";s:4:\"Shaw\";s:5:\"title\";s:3:\"SRO\";s:10:\"your-email\";s:26:\"jshaw@dhcentralcharter.org\";s:3:\"org\";s:25:\"Dahesa&#047; Learn 4 Life\";s:6:\"school\";s:34:\"Diego Hills Central Charter School\";s:7:\"address\";s:16:\"4585 College Ave\";s:5:\"phone\";s:12:\"619-792-5758\";s:4:\"cell\";s:12:\"619-792-5758\";s:5:\"item1\";s:26:\" Mentoring high-risk youth\";s:5:\"item2\";s:20:\" ; Drug use trends; \";s:5:\"item3\";s:27:\" Anxiety in girls and women\";s:5:\"check\";s:4:\"0000\";s:9:\"order-num\";s:4:\"0000\";s:8:\"initials\";s:2:\"js\";}", "2018-08-21 21:27:27");
INSERT INTO wptz_db7_forms VALUES("22", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Monique\";s:9:\"last-name\";s:6:\"Reeves\";s:5:\"title\";s:20:\"School Social Worker\";s:10:\"your-email\";s:17:\"mreeves@euhsd.org\";s:3:\"org\";s:36:\"Escondido Union High School District\";s:6:\"school\";s:21:\"Escondido High School\";s:7:\"address\";s:36:\"1535 N. Broadway, Escondido CA 92026\";s:5:\"phone\";s:12:\"760-291-4029\";s:4:\"cell\";s:12:\"760-803-0704\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"js\";}", "2018-08-23 10:20:25");
INSERT INTO wptz_db7_forms VALUES("23", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Graciela\";s:9:\"last-name\";s:6:\"Lococo\";s:5:\"title\";s:14:\"Vice Principal\";s:10:\"your-email\";s:22:\"glococo@kingchavez.org\";s:3:\"org\";s:35:\"King Chavez Neighborhood of Schools\";s:6:\"school\";s:33:\"King-Chavez Academy of Excellence\";s:7:\"address\";s:35:\"2716 Marcy Ave. San Diego, CA 92113\";s:5:\"phone\";s:10:\"6192322825\";s:4:\"cell\";s:10:\"6199205263\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"GL\";}", "2018-08-27 11:31:43");
INSERT INTO wptz_db7_forms VALUES("24", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Aura\";s:9:\"last-name\";s:7:\"Jimenez\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:23:\"ajimenez@kingchavez.org\";s:3:\"org\";s:35:\"King Chavez Neighborhood of Schools\";s:6:\"school\";s:33:\"King-Chavez Academy of Excellence\";s:7:\"address\";s:15:\"2716 Marcy Ave.\";s:5:\"phone\";s:10:\"6192322825\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"AJ\";}", "2018-08-27 11:32:52");
INSERT INTO wptz_db7_forms VALUES("25", "268", "a:17:{s:12:\"cfdb7_status\";s:4:\"read\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:3:\"Eva\";s:9:\"last-name\";s:9:\"Hernandez\";s:5:\"title\";s:19:\"School Psychologist\";s:10:\"your-email\";s:25:\"ehernandez@kingchavez.org\";s:3:\"org\";s:35:\"King Chavez Neighborhood of Schools\";s:6:\"school\";s:33:\"King-Chavez Academy of Excellence\";s:7:\"address\";s:15:\"2716 Marcy Ave.\";s:5:\"phone\";s:10:\"6192322825\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"EH\";}", "2018-08-27 11:33:41");
INSERT INTO wptz_db7_forms VALUES("26", "291", "a:15:{s:12:\"cfdb7_status\";s:6:\"unread\";s:14:\"workshop-title\";s:34:\"Pushed Out and Applying for Prison\";s:8:\"abstract\";s:729:\"Pushed Out & Applying to Prison\r\n\r\nAfter spending so many years ashamed of being kicked out of high school, I realized the negative impact harsh student discipline and juvenile justice policies can have on children and their likelihood of entering the criminal justice system, commonly known as the School-to-Prison Pipeline. Detention, prosecution and incarceration are not the only options; prevention, intervention and rehabilitation are equally important crime solutions. In this in-depth presentation, geared for law enforcement, educators, and policy makers, I share my story, break down the economic and human impact of pushing kids out of school and into prison, and explore proven alternative restorative justice models.\";s:14:\"presenter-name\";s:11:\"Debra Mares\";s:15:\"presenter-title\";s:54:\"Co Founder and Executive Director Women Wonder Writers\";s:15:\"presenter-email\";s:27:\"debra@womenwonderwriter.com\";s:15:\"presenter-phone\";s:10:\"8185171587\";s:13:\"presenter-bio\";s:1283:\"Debra Máres is a Latina writer, teacher and speaker. Growing up with addiction and violence trauma, she followed her dreams and encourages girls to do the same. An attorney and founder of a successful nonprofit, her TEDx talk has inspired countless lives and her female empowerment program grows resilience in young women through journaling, cultural arts and restorative justice. Debra has garnered numerous awards in Riverside County including the Community Hero award, Prosecutor of Year twice, and the Bulldog: Stick it To Em award.  Debra holds a bachelor’s degree in Political Science from UCLA, where she competed on the Speech & Debate Team and law degree from Loyola Law School, where she ranked 2nd nationally in the Hispanic National Bar Association Moot Court Competition.  She is the author of the Mamacita Murders legal thriller and It’s This Monkey’s Business children’s book, bringing awareness to domestic violence and child sex trafficking. Debra is the co-creator of The Write of Your L!fe,™a cultural arts, trauma-informed, and resiliency-building curriculum. She teaches about the Impact of Trauma on Children of Incarcerated Parents and Art & Social Change at Pacific Oaks College in Pasadena. Learn more at DebraMares.com and WomenWonderWriters.com.\";s:17:\"co-presenter-name\";s:11:\"Debra Mares\";s:18:\"co-presenter-title\";s:55:\"Co Foounder and Executive Director Women Wonder Writers\";s:18:\"co-presenter-email\";s:28:\"debra@womenwonderwriters.com\";s:18:\"co-presenter-phone\";s:10:\"8185171587\";s:16:\"co-presenter-bio\";s:0:\"\";s:4:\"bio1\";s:0:\"\";s:4:\"bio3\";s:0:\"\";}", "2018-08-28 15:00:08");
INSERT INTO wptz_db7_forms VALUES("27", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"Lorain K.\";s:9:\"last-name\";s:5:\"Rihan\";s:5:\"title\";s:21:\"Education Specialist \";s:10:\"your-email\";s:21:\"lorain@ajaproject.org\";s:3:\"org\";s:15:\"The AjA Project\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:38:\"4089 Fairmount Ave, San Diego CA 92105\";s:5:\"phone\";s:12:\"619-223-7001\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"LKR\";}", "2018-08-29 12:28:10");
INSERT INTO wptz_db7_forms VALUES("28", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Phyllis\";s:9:\"last-name\";s:8:\"Meredith\";s:5:\"title\";s:3:\"Ms.\";s:10:\"your-email\";s:20:\"pmeredith1@sandi.net\";s:3:\"org\";s:33:\"San Diego Unified School District\";s:6:\"school\";s:22:\"Standley Middle School\";s:7:\"address\";s:41:\"6298 Radcliffe Drive\r\nSan Diego CA, 92122\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:12:\"619-884-6896\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:4:\"5242\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"PM\";}", "2018-08-29 14:49:47");
INSERT INTO wptz_db7_forms VALUES("29", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Kimberly\";s:9:\"last-name\";s:5:\"Ridge\";s:5:\"title\";s:22:\"Intervention Counselor\";s:10:\"your-email\";s:16:\"kridge@sandi.net\";s:3:\"org\";s:33:\"San Diego Unified School District\";s:6:\"school\";s:32:\"Children and Youth in Transition\";s:7:\"address\";s:49:\"4100 Normal Street, Annex 13\r\nSan Diego, CA 92103\";s:5:\"phone\";s:12:\"619-725-7652\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:3:\"UNK\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"KR\";}", "2018-08-29 22:27:02");
INSERT INTO wptz_db7_forms VALUES("30", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"Mary Ann \";s:9:\"last-name\";s:7:\"Donohue\";s:5:\"title\";s:13:\"Administrator\";s:10:\"your-email\";s:14:\"ataics@aol.com\";s:3:\"org\";s:25:\"All Tribes Charter School\";s:6:\"school\";s:8:\"S&#047;a\";s:7:\"address\";s:47:\"34320 Valley Center Rd\r\nValley Center, CA 92082\";s:5:\"phone\";s:12:\"760 749-5982\";s:4:\"cell\";s:11:\"760 272-609\";s:5:\"item1\";s:33:\"Current issues dealing with girls\";s:5:\"item2\";s:54:\"Interested in Native American issues will be addressed\";s:5:\"item3\";s:32:\"Issues Foster children deal with\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:8:\"2018-002\";s:8:\"initials\";s:3:\"MAD\";}", "2018-08-29 23:57:50");
INSERT INTO wptz_db7_forms VALUES("31", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:6:\"Beckie\";s:9:\"last-name\";s:5:\"Couch\";s:5:\"title\";s:24:\"Secretary&#047;Counselor\";s:10:\"your-email\";s:24:\"alltribescharter@aol.com\";s:3:\"org\";s:25:\"All Tribes Charter School\";s:6:\"school\";s:8:\"S&#047;a\";s:7:\"address\";s:48:\"34320 Valley Center Rd\r\nValley Center, CA. 92082\";s:5:\"phone\";s:12:\"760 749-5982\";s:4:\"cell\";s:12:\"760 696-1717\";s:5:\"item1\";s:25:\"Current issues with girls\";s:5:\"item2\";s:15:\"Drug use trends\";s:5:\"item3\";s:20:\"Anxiety girls suffer\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:8:\"2018-002\";s:8:\"initials\";s:3:\"mad\";}", "2018-08-30 00:05:34");
INSERT INTO wptz_db7_forms VALUES("32", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Anna\";s:9:\"last-name\";s:7:\"Pacheco\";s:5:\"title\";s:16:\"School Counselor\";s:10:\"your-email\";s:18:\"apcheco1@sandi.net\";s:3:\"org\";s:33:\"San Diego Unified School District\";s:6:\"school\";s:14:\"San Diego High\";s:7:\"address\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:14:\"(619) 779-1204\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:3:\"UNK\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"AP\";}", "2018-08-30 08:30:46");
INSERT INTO wptz_db7_forms VALUES("33", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Roxanna\";s:9:\"last-name\";s:6:\"Angles\";s:5:\"title\";s:16:\"School Counselor\";s:10:\"your-email\";s:16:\"rangles@psusd.us\";s:3:\"org\";s:36:\"Palm Springs Unified School District\";s:6:\"school\";s:26:\"Cielo Vista Charter School\";s:7:\"address\";s:44:\"650 S. Paseo Dorotea\r\nPalm Springs, CA 92264\";s:5:\"phone\";s:10:\"7604168250\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:11:\"CVC PO 1908\";s:8:\"initials\";s:2:\"RA\";}", "2018-08-30 09:39:37");
INSERT INTO wptz_db7_forms VALUES("34", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Deborah\";s:9:\"last-name\";s:18:\"D&#039;Andria-Yahr\";s:5:\"title\";s:7:\"Teacher\";s:10:\"your-email\";s:15:\"dyahr@sandi.net\";s:3:\"org\";s:33:\"San Diego Unified School District\";s:6:\"school\";s:25:\"Home&#047;Hospital (UCSD)\";s:7:\"address\";s:36:\"9400 Ruffin Ct., San Diego, CA 92123\";s:5:\"phone\";s:10:\"8584741144\";s:4:\"cell\";s:10:\"6198046213\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:3:\"UNK\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"DYD\";}", "2018-08-30 12:37:33");
INSERT INTO wptz_db7_forms VALUES("35", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Cynthia\";s:9:\"last-name\";s:7:\"Vasquez\";s:5:\"title\";s:10:\"Counselor \";s:10:\"your-email\";s:25:\"vasquez_cynthia@lacoe.edu\";s:3:\"org\";s:38:\"Los Angeles County Office of Education\";s:6:\"school\";s:15:\"District Office\";s:7:\"address\";s:36:\"9300 Imperial Hwy \r\nDowney, CA 90240\";s:5:\"phone\";s:10:\"5629226030\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:21:\"Mentoring Strategies \";s:5:\"item2\";s:22:\"Empowerment Strategies\";s:5:\"item3\";s:21:\"Growth Opportunities \";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"CV\";}", "2018-08-31 09:45:49");
INSERT INTO wptz_db7_forms VALUES("36", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Stephani\";s:9:\"last-name\";s:7:\"Congdon\";s:5:\"title\";s:17:\"Community Liaison\";s:10:\"your-email\";s:27:\"scongdon@innovationhigh.org\";s:3:\"org\";s:33:\"ALTA VISTA INNOVATION HIGH SCHOOL\";s:6:\"school\";s:33:\"ALTA VISTA INNOVATION HIGH SCHOOL\";s:7:\"address\";s:38:\"177 Holston Drive, Lancaster, CA 93535\";s:5:\"phone\";s:10:\"6612721225\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:3:\"TBD\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-08-31 12:09:41");
INSERT INTO wptz_db7_forms VALUES("37", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Cynthia\";s:9:\"last-name\";s:7:\"Vasquez\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:25:\"vasquez_cynthia@lacoe.edu\";s:3:\"org\";s:38:\"Los Angeles County Office of Education\";s:6:\"school\";s:15:\"District Office\";s:7:\"address\";s:36:\"9300 Imperial Hwy.\r\nDowney, CA 90240\";s:5:\"phone\";s:12:\"562-922-6030\";s:4:\"cell\";s:12:\"626-233-1340\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:10:\"Processing\";s:9:\"order-num\";s:11:\"Processing \";s:8:\"initials\";s:2:\"CV\";}", "2018-08-31 16:02:58");
INSERT INTO wptz_db7_forms VALUES("38", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Lourdes\";s:9:\"last-name\";s:9:\"Fernandez\";s:5:\"title\";s:4:\"MTSS\";s:10:\"your-email\";s:26:\"Lourdes.Fernandez@oside.us\";s:3:\"org\";s:33:\"Oceanside Unified School District\";s:6:\"school\";s:23:\"Jefferson Middle School\";s:7:\"address\";s:35:\"823 Acacia Ave\r\nOceanside, CA 92058\";s:5:\"phone\";s:12:\"760-966-4700\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:37:\"Understand critical issues girls face\";s:5:\"item2\";s:35:\"Knowledge of trends affecting girls\";s:5:\"item3\";s:41:\"Strategies to intervene and support girls\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:5:\"32491\";s:8:\"initials\";s:2:\"LF\";}", "2018-08-31 16:39:54");
INSERT INTO wptz_db7_forms VALUES("39", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Cindy\";s:9:\"last-name\";s:7:\"Coscuna\";s:5:\"title\";s:19:\"Assistant Principal\";s:10:\"your-email\";s:22:\"Cindy.Coscuna@oside.us\";s:3:\"org\";s:33:\"Oceanside Unified School District\";s:6:\"school\";s:23:\"Jefferson Middle School\";s:7:\"address\";s:35:\"823 Acacia Ave\r\nOceanside, CA 92058\";s:5:\"phone\";s:12:\"760-966-4700\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:37:\"Understand critical issues girls face\";s:5:\"item2\";s:35:\"Knowledge of trends affecting girls\";s:5:\"item3\";s:41:\"Strategies to intervene and support girls\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:5:\"32500\";s:8:\"initials\";s:2:\"CC\";}", "2018-08-31 16:48:27");
INSERT INTO wptz_db7_forms VALUES("40", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:3:\"Ana\";s:9:\"last-name\";s:5:\"Amaya\";s:5:\"title\";s:24:\"Student Resource Officer\";s:10:\"your-email\";s:22:\"aamaya@brawleyhigh.org\";s:3:\"org\";s:34:\"Brawley Union High School District\";s:6:\"school\";s:26:\"Brawley Union High School \";s:7:\"address\";s:18:\"480 N Imperial Ave\";s:5:\"phone\";s:10:\"7603125819\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:10:\"PO19-00136\";s:8:\"initials\";s:2:\"AA\";}", "2018-09-04 10:31:05");
INSERT INTO wptz_db7_forms VALUES("41", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Adriana\";s:9:\"last-name\";s:8:\"Martinez\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:25:\"amartinez@brawleyhigh.org\";s:3:\"org\";s:34:\"Brawley Union High School District\";s:6:\"school\";s:34:\"Brawley Union High School District\";s:7:\"address\";s:18:\"480 N Imperial Ave\";s:5:\"phone\";s:10:\"7603125819\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:10:\"PO19-00136\";s:8:\"initials\";s:2:\"AM\";}", "2018-09-04 10:39:15");
INSERT INTO wptz_db7_forms VALUES("42", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Deborah\";s:9:\"last-name\";s:9:\"La Touche\";s:5:\"title\";s:24:\"Deputy District Attorney\";s:10:\"your-email\";s:26:\"deborah.latouche@sdcda.org\";s:3:\"org\";s:31:\"Office of the District Attorney\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:43:\"2851 Meadow Lark Drive\r\nSan Diego, CA 92123\";s:5:\"phone\";s:12:\"858-514-8500\";s:4:\"cell\";s:12:\"619-681-4132\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-04 13:13:50");
INSERT INTO wptz_db7_forms VALUES("43", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Crystal\";s:9:\"last-name\";s:8:\"Castillo\";s:5:\"title\";s:36:\"Student Assistance Program Counselor\";s:10:\"your-email\";s:20:\"aluna@rusd.k12.ca.us\";s:3:\"org\";s:34:\"Riverside Unified School District \";s:6:\"school\";s:14:\"Pupil Services\";s:7:\"address\";s:21:\"5700 Arlington Avenue\";s:5:\"phone\";s:10:\"9513521200\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"AL\";}", "2018-09-05 14:26:54");
INSERT INTO wptz_db7_forms VALUES("44", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Leticia \";s:9:\"last-name\";s:5:\"Lopez\";s:5:\"title\";s:36:\"Student Assistance Program Counselor\";s:10:\"your-email\";s:20:\"aluna@rusd.k12.ca.us\";s:3:\"org\";s:34:\"Riverside Unified School District \";s:6:\"school\";s:14:\"Pupil Services\";s:7:\"address\";s:21:\"5700 Arlington Avenue\";s:5:\"phone\";s:10:\"9513521200\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-05 14:29:24");
INSERT INTO wptz_db7_forms VALUES("45", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:6:\"Maria \";s:9:\"last-name\";s:6:\"Flores\";s:5:\"title\";s:41:\"Director of Strategic Program Initiatives\";s:10:\"your-email\";s:29:\"mflores@homeboyindustries.org\";s:3:\"org\";s:22:\"Homeboy Industries.org\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:42:\"130 West Bruno St. \r\nLos Angeles, CA 90012\";s:5:\"phone\";s:13:\"323-526-1554 \";s:4:\"cell\";s:12:\"626-290-1589\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"MF\";}", "2018-09-06 12:16:03");
INSERT INTO wptz_db7_forms VALUES("46", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:17:\"SELECT CONFERENCE\";s:10:\"first-name\";s:8:\"Victoria\";s:9:\"last-name\";s:6:\"Garcia\";s:5:\"title\";s:11:\"Facilitator\";s:10:\"your-email\";s:15:\"vgarcia@tkf.org\";s:3:\"org\";s:24:\"Tariq Khamisa Foundation\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:14:\"9948 Hibert St\";s:5:\"phone\";s:12:\"619-995-8777\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-07 10:31:32");
INSERT INTO wptz_db7_forms VALUES("47", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Erikah \";s:9:\"last-name\";s:6:\"Smalls\";s:5:\"title\";s:26:\"Rehabilitation Cousnelor  \";s:10:\"your-email\";s:31:\"esmalls@secondchanceprogram.org\";s:3:\"org\";s:22:\"Second Chance Program \";s:6:\"school\";s:0:\"\";s:7:\"address\";s:38:\"6145 Imperial Ave, San Diego, CA 92114\";s:5:\"phone\";s:12:\"619-952-6446\";s:4:\"cell\";s:12:\"619-952-6446\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"ES\";}", "2018-09-07 13:37:52");
INSERT INTO wptz_db7_forms VALUES("48", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"sarah\";s:9:\"last-name\";s:6:\"haffey\";s:5:\"title\";s:0:\"\";s:10:\"your-email\";s:16:\"shatch@sdcoe.net\";s:3:\"org\";s:5:\"SDCOE\";s:6:\"school\";s:5:\"SDCOE\";s:7:\"address\";s:20:\"5020 Savannah Street\";s:5:\"phone\";s:10:\"6199930333\";s:4:\"cell\";s:10:\"6199930333\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-08 10:44:59");
INSERT INTO wptz_db7_forms VALUES("49", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Marisol\";s:9:\"last-name\";s:8:\"Guerrero\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:18:\"mguerrero@psusd.us\";s:3:\"org\";s:5:\"PSUSD\";s:6:\"school\";s:26:\"Raymond Cree Middle School\";s:7:\"address\";s:19:\"100 Vista Chino Rd.\";s:5:\"phone\";s:12:\"760-416-8283\";s:4:\"cell\";s:12:\"760-106-1413\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"MG\";}", "2018-09-10 09:59:28");
INSERT INTO wptz_db7_forms VALUES("50", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Consuelo\";s:9:\"last-name\";s:6:\"Flores\";s:5:\"title\";s:21:\"Prevention Specialist\";s:10:\"your-email\";s:17:\"cflores1@psusd.us\";s:3:\"org\";s:5:\"PSUSD\";s:6:\"school\";s:26:\"Raymond Cree Middle School\";s:7:\"address\";s:39:\"1011 Vista Chino\r\nPalm Springs CA 92234\";s:5:\"phone\";s:12:\"760-416-8283\";s:4:\"cell\";s:12:\"760-880-2025\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"CF\";}", "2018-09-10 10:02:34");
INSERT INTO wptz_db7_forms VALUES("51", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Tyowanda\";s:9:\"last-name\";s:12:\"Harvey-Amoke\";s:5:\"title\";s:24:\"Rehabilitation Counselor\";s:10:\"your-email\";s:36:\"tharveyamoke@secondchanceprogram.org\";s:3:\"org\";s:13:\"Second Chance\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:42:\"6145 Imperial Avenue\r\nSan Diego, CA  92114\";s:5:\"phone\";s:12:\"619-234-8888\";s:4:\"cell\";s:12:\"619-952-5939\";s:5:\"item1\";s:46:\"Strategies on working with girls in the system\";s:5:\"item2\";s:24:\"Trends that are occuring\";s:5:\"item3\";s:19:\"Resources available\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-10 10:30:17");
INSERT INTO wptz_db7_forms VALUES("52", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Marisol\";s:9:\"last-name\";s:8:\"Guerrero\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:18:\"mguerrero@psusd.us\";s:3:\"org\";s:5:\"PSUSD\";s:6:\"school\";s:26:\"Raymond Cree Middle School\";s:7:\"address\";s:43:\"1011 Vista Chino Rd.\r\nPalm Springs CA 92262\";s:5:\"phone\";s:12:\"760-416-8283\";s:4:\"cell\";s:12:\"760-406-1413\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:9:\"TE0000111\";s:8:\"initials\";s:2:\"MG\";}", "2018-09-10 11:43:31");
INSERT INTO wptz_db7_forms VALUES("53", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Consuelo\";s:9:\"last-name\";s:6:\"Flores\";s:5:\"title\";s:21:\"Prevention Specialist\";s:10:\"your-email\";s:17:\"cflores1@psusd.us\";s:3:\"org\";s:5:\"PSUSD\";s:6:\"school\";s:26:\"Raymond Cree Middle School\";s:7:\"address\";s:43:\"1011 Vista Chino Rd.\r\nPalm Springs Ca 92262\";s:5:\"phone\";s:12:\"760-416-8283\";s:4:\"cell\";s:12:\"760-880-2025\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:9:\"TE0000111\";s:8:\"initials\";s:2:\"CF\";}", "2018-09-10 12:35:05");
INSERT INTO wptz_db7_forms VALUES("54", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Rosemary\";s:9:\"last-name\";s:8:\"Gonzalez\";s:5:\"title\";s:16:\"School Counselor\";s:10:\"your-email\";s:27:\"Rosemary.Gonzalez@cvesd.org\";s:3:\"org\";s:38:\"Chula Vista Elementary School District\";s:6:\"school\";s:15:\"Otay Elementary\";s:7:\"address\";s:37:\"1651 Albany Ave, Chula Vista CA 91911\";s:5:\"phone\";s:10:\"6194254311\";s:4:\"cell\";s:10:\"6192594146\";s:5:\"item1\";s:48:\"Information on how to address self harm in girls\";s:5:\"item2\";s:10:\"Prevention\";s:5:\"item3\";s:15:\"Proper protocol\";s:5:\"check\";s:4:\"0002\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"RG\";}", "2018-09-10 13:31:00");
INSERT INTO wptz_db7_forms VALUES("55", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Araceli\";s:9:\"last-name\";s:6:\"Huerta\";s:5:\"title\";s:23:\"Family Service Manager \";s:10:\"your-email\";s:25:\"ahuerta@a-step-beyond.org\";s:3:\"org\";s:13:\"A Step Beyond\";s:6:\"school\";s:13:\"A Step Beyond\";s:7:\"address\";s:41:\"340 N Escondido Blvd\r\nEscondido, CA 92025\";s:5:\"phone\";s:10:\"7606704119\";s:4:\"cell\";s:10:\"7607179202\";s:5:\"item1\";s:45:\"Gain new knowledge regarding topics presented\";s:5:\"item2\";s:33:\"Networks with other professionals\";s:5:\"item3\";s:9:\"Resources\";s:5:\"check\";s:3:\"342\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:14:\"Araceli Huerta\";}", "2018-09-10 14:39:43");
INSERT INTO wptz_db7_forms VALUES("56", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Sarah\";s:9:\"last-name\";s:5:\"Silva\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:20:\"edservices@cuhsd.net\";s:3:\"org\";s:34:\"Central Union HIgh School District\";s:6:\"school\";s:34:\"Central Union HIgh School District\";s:7:\"address\";s:15:\"351 W ROSS AVE.\";s:5:\"phone\";s:10:\"7603364500\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-12 11:23:24");
INSERT INTO wptz_db7_forms VALUES("57", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:10:\"Priscilla \";s:9:\"last-name\";s:6:\"Dicken\";s:5:\"title\";s:22:\"Residential Counselor \";s:10:\"your-email\";s:20:\"pdicken911@gmail.com\";s:3:\"org\";s:10:\"Storefront\";s:6:\"school\";s:10:\"Storefront\";s:7:\"address\";s:30:\"6111 Fulmar Street Sd ca 92114\";s:5:\"phone\";s:12:\"619 253-2259\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:9:\"resources\";s:5:\"item2\";s:14:\"best practices\";s:5:\"item3\";s:7:\"network\";s:5:\"check\";s:8:\"n&#047;a\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-12 14:48:12");
INSERT INTO wptz_db7_forms VALUES("58", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Mirna\";s:9:\"last-name\";s:4:\"Cruz\";s:5:\"title\";s:24:\"Youth Center Coordinator\";s:10:\"your-email\";s:23:\"mirnac@casafamiliar.org\";s:3:\"org\";s:13:\"Casa Familiar\";s:6:\"school\";s:8:\"N&#047;A\";s:7:\"address\";s:38:\"119 W. Hall Ave.\r\nSan Ysidro, CA 92173\";s:5:\"phone\";s:14:\"(619) 428-1115\";s:4:\"cell\";s:14:\"(619) 929-8173\";s:5:\"item1\";s:68:\"Tools needed to implement a mentorship program for youth ages 13-24.\";s:5:\"item2\";s:64:\"Apply knowledge gained in programs provided at the Youth Center.\";s:5:\"item3\";s:58:\"Gain input on experiences working with incarcerated youth.\";s:5:\"check\";s:5:\"10704\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"MC\";}", "2018-09-12 15:39:57");
INSERT INTO wptz_db7_forms VALUES("59", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Mirna\";s:9:\"last-name\";s:4:\"Cruz\";s:5:\"title\";s:24:\"Youth Center Coordinator\";s:10:\"your-email\";s:23:\"mirnac@casafamiliar.org\";s:3:\"org\";s:13:\"Casa Familiar\";s:6:\"school\";s:8:\"N&#047;A\";s:7:\"address\";s:38:\"119 W. Hall Ave.\r\nSan Ysidro, CA 92173\";s:5:\"phone\";s:14:\"(619) 428-1115\";s:4:\"cell\";s:14:\"(619) 929-8173\";s:5:\"item1\";s:68:\"Tools needed to implement a mentorship program for youth ages 13-24.\";s:5:\"item2\";s:64:\"Apply knowledge gained in programs provided at the Youth Center.\";s:5:\"item3\";s:58:\"Gain input on experiences working with incarcerated youth.\";s:5:\"check\";s:5:\"10682\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"MC\";}", "2018-09-12 18:45:22");
INSERT INTO wptz_db7_forms VALUES("60", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Maria\";s:9:\"last-name\";s:9:\"Fernandez\";s:5:\"title\";s:27:\"Learning Center Coordinator\";s:10:\"your-email\";s:24:\"drobinson@learn4life.org\";s:3:\"org\";s:10:\"Learn4life\";s:6:\"school\";s:30:\"Vista Real Charter High School\";s:7:\"address\";s:37:\"401 South A. Street, Suite 3\r\nOxnard \";s:5:\"phone\";s:10:\"6612721225\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-13 10:03:39");
INSERT INTO wptz_db7_forms VALUES("61", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Janelle\";s:9:\"last-name\";s:4:\"Kell\";s:5:\"title\";s:9:\"Counselor\";s:10:\"your-email\";s:15:\"jkell@mvusd.net\";s:3:\"org\";s:29:\"Moreno Valley School District\";s:6:\"school\";s:26:\"Vista del Lago High School\";s:7:\"address\";s:17:\"15150 Lasselle St\";s:5:\"phone\";s:10:\"9515714880\";s:4:\"cell\";s:10:\"9512172333\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"JK\";}", "2018-09-13 12:54:01");
INSERT INTO wptz_db7_forms VALUES("62", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Candace\";s:9:\"last-name\";s:6:\"Alonzo\";s:5:\"title\";s:16:\"School Counselor\";s:10:\"your-email\";s:24:\"drobinson@learn4life.org\";s:3:\"org\";s:10:\"Learn4life\";s:6:\"school\";s:11:\"Santa Paula\";s:7:\"address\";s:38:\"177 Holston Drive, Lancaster, CA 93535\";s:5:\"phone\";s:10:\"6612721225\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-13 14:30:22");
INSERT INTO wptz_db7_forms VALUES("63", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Sheena \";s:9:\"last-name\";s:8:\"Shelton \";s:5:\"title\";s:0:\"\";s:10:\"your-email\";s:24:\"sheena.shelton@gmail.com\";s:3:\"org\";s:0:\"\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:0:\"\";s:5:\"phone\";s:10:\"6198083280\";s:4:\"cell\";s:10:\"6198083280\";s:5:\"item1\";s:46:\"Motivation to continue educating young girls. \";s:5:\"item2\";s:11:\"Networking \";s:5:\"item3\";s:35:\"Learn new and updated information. \";s:5:\"check\";s:16:\"waived per CSROA\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"SS\";}", "2018-09-13 18:59:34");
INSERT INTO wptz_db7_forms VALUES("64", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:17:\"SELECT CONFERENCE\";s:10:\"first-name\";s:8:\"Victoria\";s:9:\"last-name\";s:6:\"Garcia\";s:5:\"title\";s:11:\"Facilitator\";s:10:\"your-email\";s:15:\"vgarcia@tkf.org\";s:3:\"org\";s:0:\"\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:46:\"9948 Hibert St. Suite 103\r\nSan Diego, CA 92131\";s:5:\"phone\";s:10:\"6199958777\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:3:\"345\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"VG\";}", "2018-09-13 23:51:03");
INSERT INTO wptz_db7_forms VALUES("65", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Rita\";s:9:\"last-name\";s:4:\"Zuno\";s:5:\"title\";s:24:\"Family Resource Director\";s:10:\"your-email\";s:21:\"rzuno@brawleyhigh.org\";s:3:\"org\";s:34:\"Brawley Union High School District\";s:6:\"school\";s:25:\"Brawley Union High School\";s:7:\"address\";s:38:\"480 N Imperial Ave\r\nBrawley, CA  92227\";s:5:\"phone\";s:10:\"7603126068\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-14 07:37:34");
INSERT INTO wptz_db7_forms VALUES("66", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Gabriela\";s:9:\"last-name\";s:9:\"Hooshmand\";s:5:\"title\";s:24:\"School Community Advisor\";s:10:\"your-email\";s:27:\"gabriela.hooshmand@oside.us\";s:3:\"org\";s:33:\"Oceanside Unified School District\";s:6:\"school\";s:21:\"El Camino High School\";s:7:\"address\";s:45:\"400 Rancho Del Oro Drive\r\nOceanside, CA 92057\";s:5:\"phone\";s:12:\"760-901-8026\";s:4:\"cell\";s:12:\"760-533-2169\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:3:\"TBA\";s:8:\"initials\";s:2:\"GH\";}", "2018-09-14 07:51:04");
INSERT INTO wptz_db7_forms VALUES("67", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Tish\";s:9:\"last-name\";s:5:\"Bates\";s:5:\"title\";s:21:\"High School Counselor\";s:10:\"your-email\";s:19:\"tbates@powayusd.com\";s:3:\"org\";s:29:\"Poway Unified School District\";s:6:\"school\";s:27:\"Rancho Bernardo High School\";s:7:\"address\";s:40:\"13010 Paseo Lucido\r\nSan Diego, CA  92128\";s:5:\"phone\";s:12:\"858-485-4800\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:26:\"Purchase order forthcoming\";s:8:\"initials\";s:2:\"LN\";}", "2018-09-14 12:36:31");
INSERT INTO wptz_db7_forms VALUES("68", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:2:\"DD\";s:9:\"last-name\";s:7:\"Ramirez\";s:5:\"title\";s:30:\"School Based Probation Officer\";s:10:\"your-email\";s:26:\"dd.ramirez@sdcounty.ca.gov\";s:3:\"org\";s:44:\"Probation and Lakeside Union School District\";s:6:\"school\";s:55:\"Lakeside Middle School and Tierra Del Sol Middle School\";s:7:\"address\";s:38:\"250 E. Main Street\r\nEl Cajon, CA 92020\";s:5:\"phone\";s:12:\"619-987-4347\";s:4:\"cell\";s:12:\"619-987-4347\";s:5:\"item1\";s:24:\"gain resources for girls\";s:5:\"item2\";s:45:\"gain knowledge on supporting girls on campus \";s:5:\"item3\";s:20:\"network with others \";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:16:\"waived per csroa\";s:8:\"initials\";s:2:\"DR\";}", "2018-09-14 14:00:30");
INSERT INTO wptz_db7_forms VALUES("69", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Karla\";s:9:\"last-name\";s:5:\"Lopez\";s:5:\"title\";s:13:\"Migrant Clerk\";s:10:\"your-email\";s:20:\"edservices@cuhsd.net\";s:3:\"org\";s:34:\"Central Union HIgh School District\";s:6:\"school\";s:21:\"Southwest High School\";s:7:\"address\";s:15:\"351 W ROSS AVE.\";s:5:\"phone\";s:10:\"7603364500\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-14 14:44:46");
INSERT INTO wptz_db7_forms VALUES("70", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:3:\"Nao\";s:9:\"last-name\";s:9:\"Kabashima\";s:5:\"title\";s:18:\"Executive Director\";s:10:\"your-email\";s:21:\"nao@karensandiego.org\";s:3:\"org\";s:31:\"Karen Organization of San Diego\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:50:\"5354 University Avenue Suite 1\r\nSan Diego CA 92105\";s:5:\"phone\";s:12:\"619-582-0783\";s:4:\"cell\";s:12:\"619-719-0567\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:3:\"927\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-14 15:17:10");
INSERT INTO wptz_db7_forms VALUES("71", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Claudia \";s:9:\"last-name\";s:9:\"Hernandez\";s:5:\"title\";s:7:\"Teacher\";s:10:\"your-email\";s:27:\"claudia.hernandez@smusd.org\";s:3:\"org\";s:34:\"San Marcos Unified School District\";s:6:\"school\";s:21:\"Twin Oaks High School\";s:7:\"address\";s:39:\"158 Cassou Rd. \r\nSan Marcos, CA 92069\r\n\";s:5:\"phone\";s:12:\"760-290-2555\";s:4:\"cell\";s:12:\"760-208-5375\";s:5:\"item1\";s:40:\"Information on how to empower our girls.\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"CH\";}", "2018-09-17 08:04:41");
INSERT INTO wptz_db7_forms VALUES("72", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:5:\"Wayne\";s:9:\"last-name\";s:8:\"Sakamoto\";s:5:\"title\";s:18:\"Executive Director\";s:10:\"your-email\";s:19:\"wsakamoto@csroa.org\";s:3:\"org\";s:5:\"CSROA\";s:6:\"school\";s:2:\"NA\";s:7:\"address\";s:2:\"NA\";s:5:\"phone\";s:10:\"9512193456\";s:4:\"cell\";s:10:\"9512193456\";s:5:\"item1\";s:2:\"NA\";s:5:\"item2\";s:2:\"NA\";s:5:\"item3\";s:2:\"NA\";s:5:\"check\";s:20:\"Fee Waived Per Wayne\";s:9:\"order-num\";s:9:\"See above\";s:8:\"initials\";s:2:\"WS\";}", "2018-09-17 10:52:37");
INSERT INTO wptz_db7_forms VALUES("73", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:8:\"Jennifer\";s:9:\"last-name\";s:5:\"Brown\";s:5:\"title\";s:7:\"Teacher\";s:10:\"your-email\";s:20:\"jbrown2@hemetusd.org\";s:3:\"org\";s:9:\"Hemet USD\";s:6:\"school\";s:2:\"NA\";s:7:\"address\";s:0:\"\";s:5:\"phone\";s:10:\"9517655100\";s:4:\"cell\";s:10:\"9517655100\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:20:\"Fee Waived Per Wayne\";s:9:\"order-num\";s:9:\"See above\";s:8:\"initials\";s:2:\"WS\";}", "2018-09-17 11:00:53");
INSERT INTO wptz_db7_forms VALUES("74", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:17:\"SELECT CONFERENCE\";s:10:\"first-name\";s:5:\"Craig\";s:9:\"last-name\";s:5:\"Frame\";s:5:\"title\";s:25:\"Director, Risk Management\";s:10:\"your-email\";s:27:\"craig_frame@chino.k12.ca.us\";s:3:\"org\";s:36:\"Chino Valley Unified School District\";s:6:\"school\";s:15:\"District Office\";s:7:\"address\";s:34:\"5130 Riverside Dr\r\nChino, CA 91710\";s:5:\"phone\";s:10:\"9099932235\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:20:\"Drug use among girls\";s:5:\"item2\";s:22:\"Gang roles among girls\";s:5:\"item3\";s:30:\"Human Trafficking implications\";s:5:\"check\";s:28:\"Fee Waived by Wayne Sakamoto\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"CSF\";}", "2018-09-17 11:21:43");
INSERT INTO wptz_db7_forms VALUES("75", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Gloria \";s:9:\"last-name\";s:7:\"Vazquez\";s:5:\"title\";s:14:\"Youth Director\";s:10:\"your-email\";s:17:\"ergovaz@yahoo.com\";s:3:\"org\";s:16:\"Amigas Punto Com\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:42:\"1057 Tierra del Rey\r\nChula Vista, CA 91910\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:14:\"(619) 948 5005\";s:5:\"item1\";s:21:\"CONVERSATION STARTERS\";s:5:\"item2\";s:36:\"KNOW MORE ABOUT THEIR CURRENT WORLD \";s:5:\"item3\";s:15:\"ART AS A TOOL  \";s:5:\"check\";s:4:\"1711\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"GV\";}", "2018-09-17 12:59:03");
INSERT INTO wptz_db7_forms VALUES("76", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:6:\"Alicia\";s:9:\"last-name\";s:5:\"Lucio\";s:5:\"title\";s:0:\"\";s:10:\"your-email\";s:16:\"atorres@besd.org\";s:3:\"org\";s:34:\"Brawley Elementary School District\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:27:\"261 D St\r\nBrawley, CA 92227\";s:5:\"phone\";s:10:\"7603442330\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:7:\"pending\";s:8:\"initials\";s:0:\"\";}", "2018-09-18 07:43:27");
INSERT INTO wptz_db7_forms VALUES("77", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:4:\"Alma\";s:9:\"last-name\";s:8:\"Martinez\";s:5:\"title\";s:0:\"\";s:10:\"your-email\";s:16:\"atorres@besd.org\";s:3:\"org\";s:34:\"Brawley Elementary School District\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:27:\"261 D St\r\nBrawley, CA 92227\";s:5:\"phone\";s:10:\"7603442330\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:7:\"pending\";s:8:\"initials\";s:0:\"\";}", "2018-09-18 07:44:15");
INSERT INTO wptz_db7_forms VALUES("78", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Martha \";s:9:\"last-name\";s:12:\"Alaniz-Brown\";s:5:\"title\";s:32:\"Behavioral Health Parent Partner\";s:10:\"your-email\";s:19:\"mbrown@nclifeli.org\";s:3:\"org\";s:22:\"North County Lifeline \";s:6:\"school\";s:12:\"North County\";s:7:\"address\";s:32:\"200 Michigan Ave\r\nVista CA 92084\";s:5:\"phone\";s:12:\"760-420-2691\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:50:\"learning new ways to empower girls in this society\";s:5:\"item2\";s:62:\"prevention  sexual harrasment and helping girls how to face it\";s:5:\"item3\";s:48:\"learning how to teach resiliency in todays world\";s:5:\"check\";s:12:\"sent already\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"MA\";}", "2018-09-18 10:34:11");
INSERT INTO wptz_db7_forms VALUES("79", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"Veronica \";s:9:\"last-name\";s:8:\"Arreguin\";s:5:\"title\";s:30:\"Behavioral Health Case Manager\";s:10:\"your-email\";s:24:\"varreguin@nclifeline.org\";s:3:\"org\";s:22:\"North County Lifeline \";s:6:\"school\";s:12:\"North County\";s:7:\"address\";s:32:\"200 Michigan Ave\r\nVista CA 92084\";s:5:\"phone\";s:10:\"7605093422\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:31:\"learning about anxiety in women\";s:5:\"item2\";s:20:\"how to empower girls\";s:5:\"item3\";s:48:\"learn more about girls in gangs how to help them\";s:5:\"check\";s:12:\"already sent\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"VA\";}", "2018-09-18 10:37:54");
INSERT INTO wptz_db7_forms VALUES("80", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Fanny J\";s:9:\"last-name\";s:5:\"Fraim\";s:5:\"title\";s:30:\"Behavioral Health Case Manager\";s:10:\"your-email\";s:21:\"ffraim@nclifeline.org\";s:3:\"org\";s:21:\"North County Lifeline\";s:6:\"school\";s:12:\"North County\";s:7:\"address\";s:33:\"200 Michigan Ave\r\nVista, CA 92084\";s:5:\"phone\";s:13:\"760-726-4900 \";s:4:\"cell\";s:12:\"760-509-3340\";s:5:\"item1\";s:62:\"Have information on how to be more effective in building trust\";s:5:\"item2\";s:25:\"Leran about newest trends\";s:5:\"item3\";s:58:\"Red flags, triggers and signs to identify and prevent harm\";s:5:\"check\";s:21:\"Already and received \";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-18 10:44:37");
INSERT INTO wptz_db7_forms VALUES("81", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:7:\"Felicia\";s:9:\"last-name\";s:9:\"Singleton\";s:5:\"title\";s:11:\"Coordinator\";s:10:\"your-email\";s:27:\"felicia.singleton@sdcoe.net\";s:3:\"org\";s:36:\"San Diego County Office of Education\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:21:\"6401 Linda Vista Road\";s:5:\"phone\";s:12:\"858-569-5476\";s:4:\"cell\";s:12:\"619-784-5472\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:0:\"\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:17:\"Felicia Singleton\";}", "2018-09-18 10:52:14");
INSERT INTO wptz_db7_forms VALUES("82", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:12:\"Rodolfo Izai\";s:9:\"last-name\";s:8:\"Castillo\";s:5:\"title\";s:16:\"School Counselor\";s:10:\"your-email\";s:26:\"rodolfo.castillo@cvesd.org\";s:3:\"org\";s:38:\"Chula Vista Elementary School District\";s:6:\"school\";s:15:\"Mueller Charter\";s:7:\"address\";s:35:\"715 I. St. \r\nChula Vista, CA. 91910\";s:5:\"phone\";s:11:\"619422-6192\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:4:\"3660\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:4:\"R.C.\";}", "2018-09-19 11:29:16");
INSERT INTO wptz_db7_forms VALUES("83", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:9:\"Christine\";s:9:\"last-name\";s:5:\"Hatch\";s:5:\"title\";s:0:\"\";s:10:\"your-email\";s:23:\"chatch@hightechhigh.org\";s:3:\"org\";s:17:\"San Diego Unified\";s:6:\"school\";s:16:\"High Tech Middle\";s:7:\"address\";s:38:\"2359 Truxtun Road\r\nSan Diego, CA 92106\";s:5:\"phone\";s:15:\"(619) 814-5060 \";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:19:\"Learn about anxiety\";s:5:\"item2\";s:32:\"Strengthening the voice of girls\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:42:\"The business department is sending a check\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"ch\";}", "2018-09-19 15:54:31");
INSERT INTO wptz_db7_forms VALUES("84", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:3:\"Ana\";s:9:\"last-name\";s:9:\"Diaz Pina\";s:5:\"title\";s:24:\"Senior Probation Officer\";s:10:\"your-email\";s:24:\"ana.pina@sdcounty.ca.gov\";s:3:\"org\";s:20:\"Probation Department\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:37:\"4110 54th Street\r\nSan Diego, CA 92105\";s:5:\"phone\";s:12:\"619-531-2715\";s:4:\"cell\";s:12:\"619-888-6903\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:10:\"Probation \";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:0:\"\";}", "2018-09-19 15:57:19");
INSERT INTO wptz_db7_forms VALUES("85", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:3:\"Ana\";s:9:\"last-name\";s:9:\"Diaz Pina\";s:5:\"title\";s:24:\"Senior Probation Officer\";s:10:\"your-email\";s:24:\"ana.pina@sdcounty.ca.gov\";s:3:\"org\";s:1:\"P\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:4:\"cell\";s:0:\"\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:10:\"Probation \";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:2:\"AD\";}", "2018-09-19 15:57:57");
INSERT INTO wptz_db7_forms VALUES("86", "268", "a:17:{s:12:\"cfdb7_status\";s:6:\"unread\";s:15:\"conference-name\";s:58:\"Spotlignt on Girls: Critical Issues, Trends and Strategies\";s:10:\"first-name\";s:3:\"Ana\";s:9:\"last-name\";s:9:\"Diaz Pina\";s:5:\"title\";s:24:\"Senior Probation Officer\";s:10:\"your-email\";s:24:\"ana.pina@sdcounty.ca.gov\";s:3:\"org\";s:20:\"Probation Department\";s:6:\"school\";s:0:\"\";s:7:\"address\";s:31:\"4110 54th\r\nSan Diego,  CA 92105\";s:5:\"phone\";s:12:\"619-531-2715\";s:4:\"cell\";s:12:\"619-888-6903\";s:5:\"item1\";s:0:\"\";s:5:\"item2\";s:0:\"\";s:5:\"item3\";s:0:\"\";s:5:\"check\";s:9:\"PROBATION\";s:9:\"order-num\";s:0:\"\";s:8:\"initials\";s:3:\"ADP\";}", "2018-09-19 15:59:10");

DROP TABLE IF EXISTS wptz_layerslider;

CREATE TABLE `wptz_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT 0,
  `schedule_end` int(10) NOT NULL DEFAULT 0,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `flag_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `flag_popup` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wptz_layerslider_revisions;

CREATE TABLE `wptz_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT 0,
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wptz_links;

CREATE TABLE `wptz_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wptz_ngg_album;

CREATE TABLE `wptz_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT 0,
  `albumdesc` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sortorder` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT 0,
  `extras_post_id` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wptz_ngg_gallery;

CREATE TABLE `wptz_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `galdesc` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT 0,
  `previewpic` bigint(20) NOT NULL DEFAULT 0,
  `author` bigint(20) NOT NULL DEFAULT 0,
  `extras_post_id` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`gid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wptz_ngg_gallery VALUES("1", "gallery", "Gallery", "/wp-content/gallery/gallery/", "Gallery", "", "0", "1", "1", "339");

DROP TABLE IF EXISTS wptz_ngg_pictures;

CREATE TABLE `wptz_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT 0,
  `galleryid` bigint(20) NOT NULL DEFAULT 0,
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alttext` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT 0,
  `sortorder` bigint(20) NOT NULL DEFAULT 0,
  `meta_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras_post_id` bigint(20) NOT NULL DEFAULT 0,
  `updated_at` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`pid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wptz_ngg_pictures VALUES("1", "20180511_094406", "0", "1", "20180511_094406.jpg", "Active Shooter for Schools", "Active Shooter for Schools", "2018-05-18 18:56:17", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiIyMDE4MDUxMV8wOTQ0MDYuanBnIiwid2lkdGgiOjQwMzIsImhlaWdodCI6MzAyNCwiZ2VuZXJhdGVkIjoiMC42NjUyMDQwMCAxNTI2NjY5Nzc3In0sImFwZXJ0dXJlIjpmYWxzZSwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjpmYWxzZSwiY2FwdGlvbiI6ZmFsc2UsImNyZWF0ZWRfdGltZXN0YW1wIjpmYWxzZSwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjpmYWxzZSwiaXNvIjpmYWxzZSwic2h1dHRlcl9zcGVlZCI6ZmFsc2UsImZsYXNoIjpmYWxzZSwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ZmFsc2UsIndpZHRoIjo0MDMyLCJoZWlnaHQiOjMwMjQsInNhdmVkIjp0cnVlLCJtZDUiOiJkYmNkMjgwMTlkMGIzOWU0ZmJlYWE5NWNmNTQ0YTA4NyIsImZ1bGwiOnsid2lkdGgiOjQwMzIsImhlaWdodCI6MzAyNCwibWQ1IjoiZGJjZDI4MDE5ZDBiMzllNGZiZWFhOTVjZjU0NGEwODcifSwidGh1bWJuYWlsIjp7IndpZHRoIjoyNDAsImhlaWdodCI6MTYwLCJmaWxlbmFtZSI6InRodW1ic18yMDE4MDUxMV8wOTQ0MDYuanBnIiwiZ2VuZXJhdGVkIjoiMC45MjQyNTIwMCAxNTI2NjY5Nzc4In19", "338", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("2", "20180511_094426", "0", "1", "20180511_094426.jpg", "", "20180511_094426", "2018-05-18 18:56:22", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiIyMDE4MDUxMV8wOTQ0MjYuanBnIiwid2lkdGgiOjQwMzIsImhlaWdodCI6MzAyNCwiZ2VuZXJhdGVkIjoiMC40NDUwMDQwMCAxNTI2NjY5NzgyIn0sImFwZXJ0dXJlIjpmYWxzZSwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjpmYWxzZSwiY2FwdGlvbiI6ZmFsc2UsImNyZWF0ZWRfdGltZXN0YW1wIjpmYWxzZSwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjpmYWxzZSwiaXNvIjpmYWxzZSwic2h1dHRlcl9zcGVlZCI6ZmFsc2UsImZsYXNoIjpmYWxzZSwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ZmFsc2UsIndpZHRoIjo0MDMyLCJoZWlnaHQiOjMwMjQsInNhdmVkIjp0cnVlLCJtZDUiOiI5OTNkNDBmMTc1Y2Q5OWM4ZDQ3MWRmODNjNGY1Zjc1YSIsImZ1bGwiOnsid2lkdGgiOjQwMzIsImhlaWdodCI6MzAyNCwibWQ1IjoiOTkzZDQwZjE3NWNkOTljOGQ0NzFkZjgzYzRmNWY3NWEifSwidGh1bWJuYWlsIjp7IndpZHRoIjoyNDAsImhlaWdodCI6MTYwLCJmaWxlbmFtZSI6InRodW1ic18yMDE4MDUxMV8wOTQ0MjYuanBnIiwiZ2VuZXJhdGVkIjoiMC43NTA1MzIwMCAxNTI2NjY5NzgzIn19", "341", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("3", "barros-at-mexican-american-opp-preschool", "0", "1", "barros-at-mexican-american-opp-preschool.JPG", "", "barros at mexican american opp preschool", "2018-03-02 11:43:48", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJiYXJyb3MtYXQtbWV4aWNhbi1hbWVyaWNhbi1vcHAtcHJlc2Nob29sLkpQRyIsIndpZHRoIjozMjY0LCJoZWlnaHQiOjI0NDgsImdlbmVyYXRlZCI6IjAuNzUzNjI4MDAgMTUyNjY2OTc4OCJ9LCJhcGVydHVyZSI6IkYgMy4zIiwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjoiRE1DLVRaNCIsImNhcHRpb24iOmZhbHNlLCJjcmVhdGVkX3RpbWVzdGFtcCI6MTUxOTk5MTAyOCwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjoiNC43IG1tIiwiaXNvIjo1MDAsInNodXR0ZXJfc3BlZWQiOiIxXC8zMCBzZWMiLCJmbGFzaCI6IkZpcmVkIiwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ZmFsc2UsIndpZHRoIjozMjY0LCJoZWlnaHQiOjI0NDgsInNhdmVkIjp0cnVlLCJtZDUiOiJjNWMyYmE4MGEyNTVlMmQ5NjM0ZTJkYjk0MDNkNGFhOSIsImZ1bGwiOnsid2lkdGgiOjMyNjQsImhlaWdodCI6MjQ0OCwibWQ1IjoiYzVjMmJhODBhMjU1ZTJkOTYzNGUyZGI5NDAzZDRhYTkifSwidGh1bWJuYWlsIjp7IndpZHRoIjoyNDAsImhlaWdodCI6MTYwLCJmaWxlbmFtZSI6InRodW1ic19iYXJyb3MtYXQtbWV4aWNhbi1hbWVyaWNhbi1vcHAtcHJlc2Nob29sLkpQRyIsImdlbmVyYXRlZCI6IjAuNjYzNjI4MDAgMTUyNjY2OTc4OSJ9fQ==", "343", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("4", "celeb-reader-hort-elem-jan-2016-017", "0", "1", "Celeb-reader-Hort-Elem-jan-2016-017.JPG", "", "Celeb reader Hort Elem jan 2016 017", "2016-01-11 12:04:00", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJDZWxlYi1yZWFkZXItSG9ydC1FbGVtLWphbi0yMDE2LTAxNy5KUEciLCJ3aWR0aCI6MjI1NiwiaGVpZ2h0IjoxNTA0LCJnZW5lcmF0ZWQiOiIwLjY5NDEwMDAwIDE1MjY2Njk3OTAifSwiYXBlcnR1cmUiOiJGIDUuNiIsImNyZWRpdCI6ZmFsc2UsImNhbWVyYSI6IkNhbm9uIEVPUyBESUdJVEFMIFJFQkVMIFhTaSIsImNhcHRpb24iOmZhbHNlLCJjcmVhdGVkX3RpbWVzdGFtcCI6MTQ1MjUxMzg0MCwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjoiNDkgbW0iLCJpc28iOjQwMCwic2h1dHRlcl9zcGVlZCI6IjFcLzYwIHNlYyIsImZsYXNoIjoiRmlyZWQiLCJ0aXRsZSI6ZmFsc2UsImtleXdvcmRzIjoiQ2VsZWIgcmVhZGVyIEhvcnQgRWxlbSBqYW4gMjAxNiIsIndpZHRoIjoyMjU2LCJoZWlnaHQiOjE1MDQsInNhdmVkIjp0cnVlLCJtZDUiOiI5MTE2YmMxMDU0ZThkM2IwNDg1NjFjODBlNTQzNTMxZCIsImZ1bGwiOnsid2lkdGgiOjIyNTYsImhlaWdodCI6MTUwNCwibWQ1IjoiOTExNmJjMTA1NGU4ZDNiMDQ4NTYxYzgwZTU0MzUzMWQifSwidGh1bWJuYWlsIjp7IndpZHRoIjoyNDAsImhlaWdodCI6MTYwLCJmaWxlbmFtZSI6InRodW1ic19DZWxlYi1yZWFkZXItSG9ydC1FbGVtLWphbi0yMDE2LTAxNy5KUEciLCJnZW5lcmF0ZWQiOiIwLjE1NTYxNDAwIDE1MjY2Njk3OTEifX0=", "345", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("5", "celeb-reader-hort-elem-jan-2016-048", "0", "1", "Celeb-reader-Hort-Elem-jan-2016-048.JPG", "", "Celeb reader Hort Elem jan 2016 048", "2016-01-11 12:25:32", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJDZWxlYi1yZWFkZXItSG9ydC1FbGVtLWphbi0yMDE2LTA0OC5KUEciLCJ3aWR0aCI6MjI1NiwiaGVpZ2h0IjoxNTA0LCJnZW5lcmF0ZWQiOiIwLjk2MDY0NDAwIDE1MjY2Njk3OTUifSwiYXBlcnR1cmUiOiJGIDQuNSIsImNyZWRpdCI6ZmFsc2UsImNhbWVyYSI6IkNhbm9uIEVPUyBESUdJVEFMIFJFQkVMIFhTaSIsImNhcHRpb24iOmZhbHNlLCJjcmVhdGVkX3RpbWVzdGFtcCI6MTQ1MjUxNTEzMiwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjoiMzYgbW0iLCJpc28iOjQwMCwic2h1dHRlcl9zcGVlZCI6IjFcLzYwIHNlYyIsImZsYXNoIjoiRmlyZWQiLCJ0aXRsZSI6ZmFsc2UsImtleXdvcmRzIjoiQ2VsZWIgcmVhZGVyIEhvcnQgRWxlbSBqYW4gMjAxNiIsIndpZHRoIjoyMjU2LCJoZWlnaHQiOjE1MDQsInNhdmVkIjp0cnVlLCJtZDUiOiI2Mjg5MDVhZWFkYjE4MmMxNjM0Mjk5YzhhMmUzZmZkMCIsImZ1bGwiOnsid2lkdGgiOjIyNTYsImhlaWdodCI6MTUwNCwibWQ1IjoiNjI4OTA1YWVhZGIxODJjMTYzNDI5OWM4YTJlM2ZmZDAifSwidGh1bWJuYWlsIjp7IndpZHRoIjoyNDAsImhlaWdodCI6MTYwLCJmaWxlbmFtZSI6InRodW1ic19DZWxlYi1yZWFkZXItSG9ydC1FbGVtLWphbi0yMDE2LTA0OC5KUEciLCJnZW5lcmF0ZWQiOiIwLjM4MjgyMjAwIDE1MjY2Njk3OTYifX0=", "347", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("6", "celeb-reader-hort-elem-jan-2016-049", "0", "1", "Celeb-reader-Hort-Elem-jan-2016-049.JPG", "", "Celeb reader Hort Elem jan 2016 049", "2016-01-11 12:25:39", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJDZWxlYi1yZWFkZXItSG9ydC1FbGVtLWphbi0yMDE2LTA0OS5KUEciLCJ3aWR0aCI6MjA4MSwiaGVpZ2h0IjoxNTAzLCJnZW5lcmF0ZWQiOiIwLjM4MzY1MjAwIDE1MjY2Njk3OTcifSwiYXBlcnR1cmUiOiJGIDUiLCJjcmVkaXQiOmZhbHNlLCJjYW1lcmEiOiJDYW5vbiBFT1MgRElHSVRBTCBSRUJFTCBYU2kiLCJjYXB0aW9uIjpmYWxzZSwiY3JlYXRlZF90aW1lc3RhbXAiOjE0NTI1MTUxMzksImNvcHlyaWdodCI6ZmFsc2UsImZvY2FsX2xlbmd0aCI6IjQzIG1tIiwiaXNvIjo0MDAsInNodXR0ZXJfc3BlZWQiOiIxXC82MCBzZWMiLCJmbGFzaCI6IkZpcmVkIiwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6IkNlbGViIHJlYWRlciBIb3J0IEVsZW0gamFuIDIwMTYiLCJ3aWR0aCI6MjA4MSwiaGVpZ2h0IjoxNTAzLCJzYXZlZCI6dHJ1ZSwibWQ1IjoiOGFjNTg1NjdkZjgwNjA3NTRjNDllN2U5OWQxOTY1NjYiLCJmdWxsIjp7IndpZHRoIjoyMDgxLCJoZWlnaHQiOjE1MDMsIm1kNSI6IjhhYzU4NTY3ZGY4MDYwNzU0YzQ5ZTdlOTlkMTk2NTY2In0sInRodW1ibmFpbCI6eyJ3aWR0aCI6MjQwLCJoZWlnaHQiOjE2MCwiZmlsZW5hbWUiOiJ0aHVtYnNfQ2VsZWItcmVhZGVyLUhvcnQtRWxlbS1qYW4tMjAxNi0wNDkuSlBHIiwiZ2VuZXJhdGVkIjoiMC43ODQyOTgwMCAxNTI2NjY5Nzk3In19", "349", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("7", "d-walters-mexican-american-preschool", "0", "1", "D-walters-mexican-american-preschool.JPG", "", "D walters mexican american preschool", "2018-03-02 11:29:33", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJELXdhbHRlcnMtbWV4aWNhbi1hbWVyaWNhbi1wcmVzY2hvb2wuSlBHIiwid2lkdGgiOjI0NDgsImhlaWdodCI6MzI2NCwiZ2VuZXJhdGVkIjoiMC43MTI5MjQwMCAxNTI2NjY5ODA0In0sImFwZXJ0dXJlIjoiRiAzLjkiLCJjcmVkaXQiOmZhbHNlLCJjYW1lcmEiOiJETUMtVFo0IiwiY2FwdGlvbiI6ZmFsc2UsImNyZWF0ZWRfdGltZXN0YW1wIjoxNTE5OTkwMTczLCJjb3B5cmlnaHQiOmZhbHNlLCJmb2NhbF9sZW5ndGgiOiI2LjcgbW0iLCJpc28iOjQwMCwic2h1dHRlcl9zcGVlZCI6IjFcLzMwIHNlYyIsImZsYXNoIjoiRmlyZWQiLCJ0aXRsZSI6ZmFsc2UsImtleXdvcmRzIjpmYWxzZSwid2lkdGgiOjI0NDgsImhlaWdodCI6MzI2NCwic2F2ZWQiOnRydWUsIm1kNSI6IjEyZGEwMmVlYTYxNWFhYjQ3MDEwMTUzNmVhMzBlNmMxIiwiZnVsbCI6eyJ3aWR0aCI6MjQ0OCwiaGVpZ2h0IjozMjY0LCJtZDUiOiIxMmRhMDJlZWE2MTVhYWI0NzAxMDE1MzZlYTMwZTZjMSJ9LCJ0aHVtYm5haWwiOnsid2lkdGgiOjI0MCwiaGVpZ2h0IjoxNjAsImZpbGVuYW1lIjoidGh1bWJzX0Qtd2FsdGVycy1tZXhpY2FuLWFtZXJpY2FuLXByZXNjaG9vbC5KUEciLCJnZW5lcmF0ZWQiOiIwLjU3NzM3NTAwIDE1MjY2Njk4MDUifX0=", "351", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("8", "school-reader-and-comm-center-cpted-2016-007", "0", "1", "School-Reader-and-Comm-Center-CPTED-2016-007.JPG", "", "School Reader and Comm Center CPTED 2016 007", "2016-03-02 10:45:11", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJTY2hvb2wtUmVhZGVyLWFuZC1Db21tLUNlbnRlci1DUFRFRC0yMDE2LTAwNy5KUEciLCJ3aWR0aCI6MjI1NiwiaGVpZ2h0IjoxNTA0LCJnZW5lcmF0ZWQiOiIwLjk1NjYyNTAwIDE1MjY2Njk4MDkifSwiYXBlcnR1cmUiOiJGIDEwIiwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjoiQ2Fub24gRU9TIERJR0lUQUwgUkVCRUwgWFNpIiwiY2FwdGlvbiI6ZmFsc2UsImNyZWF0ZWRfdGltZXN0YW1wIjoxNDU2OTE1NTExLCJjb3B5cmlnaHQiOmZhbHNlLCJmb2NhbF9sZW5ndGgiOiIxOCBtbSIsImlzbyI6NDAwLCJzaHV0dGVyX3NwZWVkIjoiMVwvMjAwIHNlYyIsImZsYXNoIjoiRmlyZWQiLCJ0aXRsZSI6ZmFsc2UsImtleXdvcmRzIjoiU2Nob29sIFJlYWRlciBhbmQgQ29tbSBDZW50ZXIgQ1BURUQgMjAxNiIsIndpZHRoIjoyMjU2LCJoZWlnaHQiOjE1MDQsInNhdmVkIjp0cnVlLCJtZDUiOiJmNGM3ZDk1ZTk0ZjNjZTUxYmE1ZGM5OGNjOTU1YjZhYyIsImZ1bGwiOnsid2lkdGgiOjIyNTYsImhlaWdodCI6MTUwNCwibWQ1IjoiZjRjN2Q5NWU5NGYzY2U1MWJhNWRjOThjYzk1NWI2YWMifSwidGh1bWJuYWlsIjp7IndpZHRoIjoyNDAsImhlaWdodCI6MTYwLCJmaWxlbmFtZSI6InRodW1ic19TY2hvb2wtUmVhZGVyLWFuZC1Db21tLUNlbnRlci1DUFRFRC0yMDE2LTAwNy5KUEciLCJnZW5lcmF0ZWQiOiIwLjM5OTQ3MjAwIDE1MjY2Njk4MTAifX0=", "353", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("9", "shafter-hs-cyberbullying-presentation", "0", "1", "shafter-HS-Cyberbullying-Presentation.jpeg", "", "shafter HS Cyberbullying Presentation", "2014-11-20 08:07:37", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJzaGFmdGVyLUhTLUN5YmVyYnVsbHlpbmctUHJlc2VudGF0aW9uLmpwZWciLCJ3aWR0aCI6MTI4MCwiaGVpZ2h0Ijo5NjAsImdlbmVyYXRlZCI6IjAuMzQ3MDY2MDAgMTUyNjY2OTgxMSJ9LCJhcGVydHVyZSI6IkYgMi40IiwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjoiaVBob25lIDUiLCJjYXB0aW9uIjpmYWxzZSwiY3JlYXRlZF90aW1lc3RhbXAiOjE0MTY0NzA4NTcsImNvcHlyaWdodCI6ZmFsc2UsImZvY2FsX2xlbmd0aCI6IjQuMTIgbW0iLCJpc28iOjY0MCwic2h1dHRlcl9zcGVlZCI6IjFcLzIwIHNlYyIsImZsYXNoIjoiTm90IGZpcmVkIiwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ZmFsc2UsIndpZHRoIjoxMjgwLCJoZWlnaHQiOjk2MCwic2F2ZWQiOnRydWUsIm1kNSI6ImExN2M3MjcyNTg1ZDllYTdhNWVlYjQ0N2JkMzQwYWMzIiwiZnVsbCI6eyJ3aWR0aCI6MTI4MCwiaGVpZ2h0Ijo5NjAsIm1kNSI6ImExN2M3MjcyNTg1ZDllYTdhNWVlYjQ0N2JkMzQwYWMzIn0sInRodW1ibmFpbCI6eyJ3aWR0aCI6MjQwLCJoZWlnaHQiOjE2MCwiZmlsZW5hbWUiOiJ0aHVtYnNfc2hhZnRlci1IUy1DeWJlcmJ1bGx5aW5nLVByZXNlbnRhdGlvbi5qcGVnIiwiZ2VuZXJhdGVkIjoiMC41MDg2MjkwMCAxNTI2NjY5ODExIn19", "355", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("10", "teen-dating-violence-at-vista-west", "0", "1", "teen-dating-violence-at-vista-west.jpg", "", "teen dating violence at vista west", "2018-05-18 18:56:53", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJ0ZWVuLWRhdGluZy12aW9sZW5jZS1hdC12aXN0YS13ZXN0LmpwZyIsIndpZHRoIjoyMDQ4LCJoZWlnaHQiOjE1MzYsImdlbmVyYXRlZCI6IjAuMTM3NjgyMDAgMTUyNjY2OTgxMyJ9LCJhcGVydHVyZSI6ZmFsc2UsImNyZWRpdCI6ZmFsc2UsImNhbWVyYSI6ZmFsc2UsImNhcHRpb24iOmZhbHNlLCJjcmVhdGVkX3RpbWVzdGFtcCI6ZmFsc2UsImNvcHlyaWdodCI6ZmFsc2UsImZvY2FsX2xlbmd0aCI6ZmFsc2UsImlzbyI6ZmFsc2UsInNodXR0ZXJfc3BlZWQiOmZhbHNlLCJmbGFzaCI6ZmFsc2UsInRpdGxlIjpmYWxzZSwia2V5d29yZHMiOmZhbHNlLCJ3aWR0aCI6MjA0OCwiaGVpZ2h0IjoxNTM2LCJzYXZlZCI6dHJ1ZSwibWQ1IjoiNWRmNDBjZWE1N2FjYTQ0Mjk3MzdmNDRiOWY1OWFkZDAiLCJmdWxsIjp7IndpZHRoIjoyMDQ4LCJoZWlnaHQiOjE1MzYsIm1kNSI6IjVkZjQwY2VhNTdhY2E0NDI5NzM3ZjQ0YjlmNTlhZGQwIn0sInRodW1ibmFpbCI6eyJ3aWR0aCI6MjQwLCJoZWlnaHQiOjE2MCwiZmlsZW5hbWUiOiJ0aHVtYnNfdGVlbi1kYXRpbmctdmlvbGVuY2UtYXQtdmlzdGEtd2VzdC5qcGciLCJnZW5lcmF0ZWQiOiIwLjQ4NTMzNzAwIDE1MjY2Njk4MTMifX0=", "357", "1528223234");
INSERT INTO wptz_ngg_pictures VALUES("11", "vega-reading-at-bessie-owens-5-2016", "0", "1", "vega-reading-at-bessie-owens-5-2016.jpg", "", "vega reading at bessie owens 5 - 2016", "2016-05-25 09:50:20", "0", "0", "eyJiYWNrdXAiOnsiZmlsZW5hbWUiOiJ2ZWdhLXJlYWRpbmctYXQtYmVzc2llLW93ZW5zLTUtMjAxNi5qcGciLCJ3aWR0aCI6MjI1NiwiaGVpZ2h0IjoxNTA0LCJnZW5lcmF0ZWQiOiIwLjQ1NDU5MzAwIDE1MjY2Njk4MTQifSwiYXBlcnR1cmUiOiJGIDQiLCJjcmVkaXQiOmZhbHNlLCJjYW1lcmEiOiJDYW5vbiBFT1MgRElHSVRBTCBSRUJFTCBYU2kiLCJjYXB0aW9uIjpmYWxzZSwiY3JlYXRlZF90aW1lc3RhbXAiOjE0NjQxNjk4MjAsImNvcHlyaWdodCI6ZmFsc2UsImZvY2FsX2xlbmd0aCI6IjI3IG1tIiwiaXNvIjo0MDAsInNodXR0ZXJfc3BlZWQiOiIxXC82MCBzZWMiLCJmbGFzaCI6IkZpcmVkIiwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ImFtZXJpcHJpZGUgQ1BURUQgYW5kIFZlZ2EgQmVzc2llIE93ZW5zIENlbGVicml0eSByZWFkZXIiLCJ3aWR0aCI6MjI1NiwiaGVpZ2h0IjoxNTA0LCJzYXZlZCI6dHJ1ZSwibWQ1IjoiODM1YjRlYWIyMGU0Mzg3NzMxMmU1ZDRhMjRkMDQxMTgiLCJmdWxsIjp7IndpZHRoIjoyMjU2LCJoZWlnaHQiOjE1MDQsIm1kNSI6IjgzNWI0ZWFiMjBlNDM4NzczMTJlNWQ0YTI0ZDA0MTE4In0sInRodW1ibmFpbCI6eyJ3aWR0aCI6MjQwLCJoZWlnaHQiOjE2MCwiZmlsZW5hbWUiOiJ0aHVtYnNfdmVnYS1yZWFkaW5nLWF0LWJlc3NpZS1vd2Vucy01LTIwMTYuanBnIiwiZ2VuZXJhdGVkIjoiMC44Njg3OTUwMCAxNTI2NjY5ODE0In19", "359", "1528223234");

DROP TABLE IF EXISTS wptz_options;

CREATE TABLE `wptz_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=37889 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wptz_options VALUES("1", "siteurl", "https://csroa.org", "yes");
INSERT INTO wptz_options VALUES("2", "home", "https://csroa.org", "yes");
INSERT INTO wptz_options VALUES("3", "blogname", "California School Resource Officers Association", "yes");
INSERT INTO wptz_options VALUES("4", "blogdescription", "CSROA", "yes");
INSERT INTO wptz_options VALUES("5", "users_can_register", "0", "yes");
INSERT INTO wptz_options VALUES("6", "admin_email", "linda@wolfeinteractive.com", "yes");
INSERT INTO wptz_options VALUES("7", "start_of_week", "1", "yes");
INSERT INTO wptz_options VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO wptz_options VALUES("9", "use_smilies", "1", "yes");
INSERT INTO wptz_options VALUES("10", "require_name_email", "1", "yes");
INSERT INTO wptz_options VALUES("11", "comments_notify", "1", "yes");
INSERT INTO wptz_options VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO wptz_options VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO wptz_options VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO wptz_options VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO wptz_options VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO wptz_options VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO wptz_options VALUES("18", "default_category", "1", "yes");
INSERT INTO wptz_options VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO wptz_options VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO wptz_options VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO wptz_options VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO wptz_options VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO wptz_options VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO wptz_options VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO wptz_options VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO wptz_options VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO wptz_options VALUES("28", "permalink_structure", "/{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}postname{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}/", "yes");
INSERT INTO wptz_options VALUES("37881", "gadwp_cache_qr2_2243491754", "a:2:{s:5:\"value\";O:31:\"Deconf_Service_Analytics_GaData\":24:{s:17:\"\0*\0collection_key\";s:4:\"rows\";s:25:\"\0*\0internal_gapi_mappings\";a:0:{}s:20:\"\0*\0columnHeadersType\";s:44:\"Deconf_Service_Analytics_GaDataColumnHeaders\";s:24:\"\0*\0columnHeadersDataType\";s:5:\"array\";s:19:\"containsSampledData\";b:0;s:16:\"\0*\0dataTableType\";s:40:\"Deconf_Service_Analytics_GaDataDataTable\";s:20:\"\0*\0dataTableDataType\";s:0:\"\";s:2:\"id\";s:160:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:176690023&dimensions=ga:date,ga:dayOfWeekName&metrics=ga:sessions&start-date=30daysAgo&end-date=yesterday\";s:12:\"itemsPerPage\";i:1000;s:4:\"kind\";s:16:\"analytics#gaData\";s:8:\"nextLink\";N;s:12:\"previousLink\";N;s:18:\"\0*\0profileInfoType\";s:42:\"Deconf_Service_Analytics_GaDataProfileInfo\";s:22:\"\0*\0profileInfoDataType\";s:0:\"\";s:12:\"\0*\0queryType\";s:36:\"Deconf_Service_Analytics_GaDataQuery\";s:16:\"\0*\0queryDataType\";s:0:\"\";s:4:\"rows\";a:30:{i:0;a:3:{i:0;s:8:\"20181208\";i:1;s:8:\"Saturday\";i:2;s:2:\"14\";}i:1;a:3:{i:0;s:8:\"20181209\";i:1;s:6:\"Sunday\";i:2;s:1:\"2\";}i:2;a:3:{i:0;s:8:\"20181210\";i:1;s:6:\"Monday\";i:2;s:1:\"4\";}i:3;a:3:{i:0;s:8:\"20181211\";i:1;s:7:\"Tuesday\";i:2;s:1:\"8\";}i:4;a:3:{i:0;s:8:\"20181212\";i:1;s:9:\"Wednesday\";i:2;s:1:\"2\";}i:5;a:3:{i:0;s:8:\"20181213\";i:1;s:8:\"Thursday\";i:2;s:1:\"4\";}i:6;a:3:{i:0;s:8:\"20181214\";i:1;s:6:\"Friday\";i:2;s:1:\"1\";}i:7;a:3:{i:0;s:8:\"20181215\";i:1;s:8:\"Saturday\";i:2;s:1:\"1\";}i:8;a:3:{i:0;s:8:\"20181216\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:9;a:3:{i:0;s:8:\"20181217\";i:1;s:6:\"Monday\";i:2;s:1:\"1\";}i:10;a:3:{i:0;s:8:\"20181218\";i:1;s:7:\"Tuesday\";i:2;s:1:\"9\";}i:11;a:3:{i:0;s:8:\"20181219\";i:1;s:9:\"Wednesday\";i:2;s:1:\"3\";}i:12;a:3:{i:0;s:8:\"20181220\";i:1;s:8:\"Thursday\";i:2;s:1:\"5\";}i:13;a:3:{i:0;s:8:\"20181221\";i:1;s:6:\"Friday\";i:2;s:1:\"3\";}i:14;a:3:{i:0;s:8:\"20181222\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:15;a:3:{i:0;s:8:\"20181223\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:16;a:3:{i:0;s:8:\"20181224\";i:1;s:6:\"Monday\";i:2;s:1:\"1\";}i:17;a:3:{i:0;s:8:\"20181225\";i:1;s:7:\"Tuesday\";i:2;s:1:\"2\";}i:18;a:3:{i:0;s:8:\"20181226\";i:1;s:9:\"Wednesday\";i:2;s:1:\"1\";}i:19;a:3:{i:0;s:8:\"20181227\";i:1;s:8:\"Thursday\";i:2;s:1:\"3\";}i:20;a:3:{i:0;s:8:\"20181228\";i:1;s:6:\"Friday\";i:2;s:1:\"1\";}i:21;a:3:{i:0;s:8:\"20181229\";i:1;s:8:\"Saturday\";i:2;s:1:\"1\";}i:22;a:3:{i:0;s:8:\"20181230\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:23;a:3:{i:0;s:8:\"20181231\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:24;a:3:{i:0;s:8:\"20190101\";i:1;s:7:\"Tuesday\";i:2;s:1:\"2\";}i:25;a:3:{i:0;s:8:\"20190102\";i:1;s:9:\"Wednesday\";i:2;s:1:\"5\";}i:26;a:3:{i:0;s:8:\"20190103\";i:1;s:8:\"Thursday\";i:2;s:1:\"3\";}i:27;a:3:{i:0;s:8:\"20190104\";i:1;s:6:\"Friday\";i:2;s:1:\"4\";}i:28;a:3:{i:0;s:8:\"20190105\";i:1;s:8:\"Saturday\";i:2;s:1:\"2\";}i:29;a:3:{i:0;s:8:\"20190106\";i:1;s:6:\"Sunday\";i:2;s:1:\"2\";}}s:10:\"sampleSize\";N;s:11:\"sampleSpace\";N;s:8:\"selfLink\";s:160:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:176690023&dimensions=ga:date,ga:dayOfWeekName&metrics=ga:sessions&start-date=30daysAgo&end-date=yesterday\";s:12:\"totalResults\";i:30;s:19:\"totalsForAllResults\";a:1:{s:11:\"ga:sessions\";s:2:\"84\";}s:12:\"\0*\0modelData\";a:3:{s:5:\"query\";a:8:{s:10:\"start-date\";s:9:\"30daysAgo\";s:8:\"end-date\";s:9:\"yesterday\";s:3:\"ids\";s:12:\"ga:176690023\";s:10:\"dimensions\";s:24:\"ga:date,ga:dayOfWeekName\";s:7:\"metrics\";a:1:{i:0;s:11:\"ga:sessions\";}s:11:\"start-index\";i:1;s:11:\"max-results\";i:1000;s:13:\"samplingLevel\";s:16:\"HIGHER_PRECISION\";}s:11:\"profileInfo\";a:6:{s:9:\"profileId\";s:9:\"176690023\";s:9:\"accountId\";s:8:\"51807754\";s:13:\"webPropertyId\";s:14:\"UA-51807754-19\";s:21:\"internalWebPropertyId\";s:9:\"178123371\";s:11:\"profileName\";s:17:\"All Web Site Data\";s:7:\"tableId\";s:12:\"ga:176690023\";}s:13:\"columnHeaders\";a:3:{i:0;a:3:{s:4:\"name\";s:7:\"ga:date\";s:10:\"columnType\";s:9:\"DIMENSION\";s:8:\"dataType\";s:6:\"STRING\";}i:1;a:3:{s:4:\"name\";s:16:\"ga:dayOfWeekName\";s:10:\"columnType\";s:9:\"DIMENSION\";s:8:\"dataType\";s:6:\"STRING\";}i:2;a:3:{s:4:\"name\";s:11:\"ga:sessions\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}}}s:12:\"\0*\0processed\";a:0:{}}s:7:\"expires\";i:1546930800;}", "no");
INSERT INTO wptz_options VALUES("37883", "_site_transient_timeout_ai1ec_update_plugins", "1546921625", "no");
INSERT INTO wptz_options VALUES("37884", "_site_transient_ai1ec_update_plugins", "a:1:{s:55:\"all-in-one-event-calendar/all-in-one-event-calendar.php\";a:11:{s:6:\"plugin\";s:55:\"all-in-one-event-calendar/all-in-one-event-calendar.php\";s:11:\"new_version\";s:6:\"2.5.26\";s:7:\"version\";s:6:\"2.5.26\";s:4:\"name\";s:4:\"Core\";s:4:\"slug\";s:25:\"all-in-one-event-calendar\";s:3:\"url\";s:15:\"https://time.ly\";s:8:\"homepage\";s:15:\"https://time.ly\";s:7:\"package\";s:70:\"https://checkout.time.ly/packages/all-in-one-event-calendar_2.5.26.zip\";s:13:\"download_link\";s:70:\"https://checkout.time.ly/packages/all-in-one-event-calendar_2.5.26.zip\";s:8:\"sections\";a:2:{s:11:\"description\";s:390:\"The <a href=\"https://time.ly\" target=\"_blank\">All-in-One Event Calendar</a> from\r\n<a href=\"https://time.ly\" target=\"_blank\">Timely</a> is a beautiful way to list your events in\r\nWordPress and easily share them with the rest of the world. Our\r\ncalendar system combines clean visual design with a powerful set of\r\nfeatures to create the most advanced calendar system available for\r\nWordPress.\";s:9:\"changelog\";s:84:\"<strong>2.5.26</strong>\r\n<ul>\r\n	<li>Fixed: Compatibility with PHP < 5.4.</li>\r\n</ul>\";}s:6:\"author\";s:65:\"<a href=\"https://time.ly\" target=\"_blank\">Timely Network Inc.</a>\";}}", "no");
INSERT INTO wptz_options VALUES("30", "hack_file", "0", "yes");
INSERT INTO wptz_options VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO wptz_options VALUES("32", "moderation_keys", "", "no");
INSERT INTO wptz_options VALUES("33", "active_plugins", "a:15:{i:0;s:49:\"acurax-social-media-widget/acurax-social-icon.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:55:\"all-in-one-event-calendar/all-in-one-event-calendar.php\";i:3;s:19:\"bbpress/bbpress.php\";i:4;s:33:\"classic-editor/classic-editor.php\";i:5;s:36:\"contact-form-7/wp-contact-form-7.php\";i:6;s:42:\"contact-form-cfdb7/contact-form-cfdb-7.php\";i:7;s:32:\"duplicate-page/duplicatepage.php\";i:8;s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";i:9;s:29:\"pdf-embedder/pdf_embedder.php\";i:10;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:11;s:17:\"userpro/index.php\";i:12;s:24:\"wordpress-seo/wp-seo.php\";i:13;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:14;s:29:\"nextgen-gallery/nggallery.php\";}", "yes");
INSERT INTO wptz_options VALUES("34", "category_base", "", "yes");
INSERT INTO wptz_options VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO wptz_options VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO wptz_options VALUES("37", "gmt_offset", "", "yes");
INSERT INTO wptz_options VALUES("38", "default_email_category", "1", "yes");
INSERT INTO wptz_options VALUES("39", "recently_edited", "", "no");
INSERT INTO wptz_options VALUES("40", "template", "enfold", "yes");
INSERT INTO wptz_options VALUES("41", "stylesheet", "enfold", "yes");
INSERT INTO wptz_options VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO wptz_options VALUES("43", "blacklist_keys", "", "no");
INSERT INTO wptz_options VALUES("44", "comment_registration", "0", "yes");
INSERT INTO wptz_options VALUES("45", "html_type", "text/html", "yes");
INSERT INTO wptz_options VALUES("46", "use_trackback", "0", "yes");
INSERT INTO wptz_options VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO wptz_options VALUES("48", "db_version", "43764", "yes");
INSERT INTO wptz_options VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO wptz_options VALUES("50", "upload_path", "", "yes");
INSERT INTO wptz_options VALUES("51", "blog_public", "1", "yes");
INSERT INTO wptz_options VALUES("52", "default_link_category", "2", "yes");
INSERT INTO wptz_options VALUES("53", "show_on_front", "page", "yes");
INSERT INTO wptz_options VALUES("54", "tag_base", "", "yes");
INSERT INTO wptz_options VALUES("55", "show_avatars", "1", "yes");
INSERT INTO wptz_options VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO wptz_options VALUES("57", "upload_url_path", "", "yes");
INSERT INTO wptz_options VALUES("58", "thumbnail_size_w", "80", "yes");
INSERT INTO wptz_options VALUES("59", "thumbnail_size_h", "80", "yes");
INSERT INTO wptz_options VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO wptz_options VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO wptz_options VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO wptz_options VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO wptz_options VALUES("64", "large_size_w", "1030", "yes");
INSERT INTO wptz_options VALUES("65", "large_size_h", "1030", "yes");
INSERT INTO wptz_options VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO wptz_options VALUES("67", "image_default_size", "", "yes");
INSERT INTO wptz_options VALUES("68", "image_default_align", "", "yes");
INSERT INTO wptz_options VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO wptz_options VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO wptz_options VALUES("71", "thread_comments", "1", "yes");
INSERT INTO wptz_options VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO wptz_options VALUES("73", "page_comments", "0", "yes");
INSERT INTO wptz_options VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO wptz_options VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO wptz_options VALUES("76", "comment_order", "asc", "yes");
INSERT INTO wptz_options VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("79", "widget_text", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("81", "uninstall_plugins", "a:4:{s:104:\"home/wolfedemo/public_html/CSROA/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:94:\"home/csroa/public_html/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";a:2:{i:0;s:15:\"GADWP_Uninstall\";i:1;s:9:\"uninstall\";}s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO wptz_options VALUES("82", "timezone_string", "America/Los_Angeles", "yes");
INSERT INTO wptz_options VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO wptz_options VALUES("84", "page_on_front", "126", "yes");
INSERT INTO wptz_options VALUES("85", "default_post_format", "0", "yes");
INSERT INTO wptz_options VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO wptz_options VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO wptz_options VALUES("88", "site_icon", "0", "yes");
INSERT INTO wptz_options VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO wptz_options VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO wptz_options VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO wptz_options VALUES("92", "wptz_user_roles", "a:11:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:89:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"read_ai1ec_event\";b:1;s:16:\"edit_ai1ec_event\";b:1;s:17:\"edit_ai1ec_events\";b:1;s:25:\"edit_private_ai1ec_events\";b:1;s:27:\"edit_published_ai1ec_events\";b:1;s:18:\"delete_ai1ec_event\";b:1;s:19:\"delete_ai1ec_events\";b:1;s:29:\"delete_published_ai1ec_events\";b:1;s:27:\"delete_private_ai1ec_events\";b:1;s:20:\"publish_ai1ec_events\";b:1;s:25:\"read_private_ai1ec_events\";b:1;s:24:\"manage_events_categories\";b:1;s:18:\"manage_ai1ec_feeds\";b:1;s:19:\"switch_ai1ec_themes\";b:1;s:20:\"manage_ai1ec_options\";b:1;s:24:\"edit_others_ai1ec_events\";b:1;s:26:\"delete_others_ai1ec_events\";b:1;s:24:\"NextGEN Gallery overview\";b:1;s:19:\"NextGEN Use TinyMCE\";b:1;s:21:\"NextGEN Upload images\";b:1;s:22:\"NextGEN Manage gallery\";b:1;s:19:\"NextGEN Manage tags\";b:1;s:29:\"NextGEN Manage others gallery\";b:1;s:18:\"NextGEN Edit album\";b:1;s:20:\"NextGEN Change style\";b:1;s:22:\"NextGEN Change options\";b:1;s:24:\"NextGEN Attach Interface\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:50:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"read_ai1ec_event\";b:1;s:16:\"edit_ai1ec_event\";b:1;s:17:\"edit_ai1ec_events\";b:1;s:25:\"edit_private_ai1ec_events\";b:1;s:27:\"edit_published_ai1ec_events\";b:1;s:18:\"delete_ai1ec_event\";b:1;s:19:\"delete_ai1ec_events\";b:1;s:29:\"delete_published_ai1ec_events\";b:1;s:27:\"delete_private_ai1ec_events\";b:1;s:20:\"publish_ai1ec_events\";b:1;s:25:\"read_private_ai1ec_events\";b:1;s:24:\"manage_events_categories\";b:1;s:18:\"manage_ai1ec_feeds\";b:1;s:24:\"edit_others_ai1ec_events\";b:1;s:26:\"delete_others_ai1ec_events\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:23:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:16:\"read_ai1ec_event\";b:1;s:16:\"edit_ai1ec_event\";b:1;s:17:\"edit_ai1ec_events\";b:1;s:25:\"edit_private_ai1ec_events\";b:1;s:27:\"edit_published_ai1ec_events\";b:1;s:18:\"delete_ai1ec_event\";b:1;s:19:\"delete_ai1ec_events\";b:1;s:29:\"delete_published_ai1ec_events\";b:1;s:27:\"delete_private_ai1ec_events\";b:1;s:20:\"publish_ai1ec_events\";b:1;s:25:\"read_private_ai1ec_events\";b:1;s:24:\"manage_events_categories\";b:1;s:18:\"manage_ai1ec_feeds\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:21:\"ai1ec_event_assistant\";a:2:{s:4:\"name\";s:17:\"Event Contributor\";s:12:\"capabilities\";a:7:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_ai1ec_events\";b:1;s:17:\"read_ai1ec_events\";b:1;s:19:\"delete_ai1ec_events\";b:1;s:27:\"edit_published_ai1ec_events\";b:1;s:29:\"delete_published_ai1ec_events\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:52:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"read_ai1ec_event\";b:1;s:16:\"edit_ai1ec_event\";b:1;s:17:\"edit_ai1ec_events\";b:1;s:25:\"edit_private_ai1ec_events\";b:1;s:27:\"edit_published_ai1ec_events\";b:1;s:18:\"delete_ai1ec_event\";b:1;s:19:\"delete_ai1ec_events\";b:1;s:29:\"delete_published_ai1ec_events\";b:1;s:27:\"delete_private_ai1ec_events\";b:1;s:20:\"publish_ai1ec_events\";b:1;s:25:\"read_private_ai1ec_events\";b:1;s:24:\"manage_events_categories\";b:1;s:18:\"manage_ai1ec_feeds\";b:1;s:24:\"edit_others_ai1ec_events\";b:1;s:26:\"delete_others_ai1ec_events\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:51:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"read_ai1ec_event\";b:1;s:16:\"edit_ai1ec_event\";b:1;s:17:\"edit_ai1ec_events\";b:1;s:25:\"edit_private_ai1ec_events\";b:1;s:27:\"edit_published_ai1ec_events\";b:1;s:18:\"delete_ai1ec_event\";b:1;s:19:\"delete_ai1ec_events\";b:1;s:29:\"delete_published_ai1ec_events\";b:1;s:27:\"delete_private_ai1ec_events\";b:1;s:20:\"publish_ai1ec_events\";b:1;s:25:\"read_private_ai1ec_events\";b:1;s:24:\"manage_events_categories\";b:1;s:18:\"manage_ai1ec_feeds\";b:1;s:24:\"edit_others_ai1ec_events\";b:1;s:26:\"delete_others_ai1ec_events\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:0:{}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:0:{}}}", "yes");
INSERT INTO wptz_options VALUES("93", "fresh_site", "0", "yes");
INSERT INTO wptz_options VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("99", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:10:\"archives-2\";i:1;s:6:\"meta-2\";i:2;s:8:\"search-2\";i:3;s:12:\"categories-2\";i:4;s:14:\"recent-posts-2\";i:5;s:17:\"recent-comments-2\";}s:13:\"av_everywhere\";a:0:{}s:7:\"av_blog\";a:1:{i:0;s:10:\"nav_menu-2\";}s:8:\"av_pages\";a:1:{i:0;s:9:\"newsbox-2\";}s:11:\"av_footer_1\";a:1:{i:0;s:25:\"acx-social-icons-widget-2\";}s:11:\"av_footer_2\";a:1:{i:0;s:13:\"custom_html-2\";}s:11:\"av_footer_3\";a:1:{i:0;s:13:\"custom_html-3\";}s:11:\"av_footer_4\";a:1:{i:0;s:10:\"nav_menu-3\";}s:8:\"av_forum\";a:4:{i:0;s:18:\"bbp_login_widget-2\";i:1;s:19:\"bbp_search_widget-2\";i:2;s:19:\"bbp_topics_widget-2\";i:3;s:18:\"bbp_views_widget-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO wptz_options VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("102", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("103", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("104", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("105", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("106", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("107", "widget_nav_menu", "a:3:{i:2;a:2:{s:5:\"title\";s:17:\"Links / Resources\";s:8:\"nav_menu\";i:21;}i:3;a:2:{s:5:\"title\";s:17:\"Links / Resources\";s:8:\"nav_menu\";i:21;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("108", "widget_custom_html", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:6:\"&nbsp;\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:6:\"&nbsp;\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("109", "cron", "a:7:{i:1546920658;a:1:{s:29:\"ngg_delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"ngg_custom\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1546920857;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1546933269;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1546976274;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1546979418;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1546980969;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO wptz_options VALUES("110", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1523562170;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO wptz_options VALUES("16438", "category_children", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("35461", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO wptz_options VALUES("35462", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO wptz_options VALUES("35492", "_transient_timeout_members_cache_delete", "1548110461", "no");
INSERT INTO wptz_options VALUES("35493", "_transient_members_cache_delete", "members_cache_delete", "no");
INSERT INTO wptz_options VALUES("2972", "wpclone_directory_scan", "a:4:{s:6:\"dbsize\";s:7:\"7.61 MB\";s:4:\"size\";s:9:\"237.07 MB\";s:5:\"files\";i:8962;s:4:\"time\";i:1542249905;}", "yes");
INSERT INTO wptz_options VALUES("2896", "cfdb7_view_install_date", "2018-06-05 18:25:52", "yes");
INSERT INTO wptz_options VALUES("324", "acx_widget_si_next_date", "1526580358", "yes");
INSERT INTO wptz_options VALUES("325", "acx_widget_si_td", "hide", "yes");
INSERT INTO wptz_options VALUES("326", "widget_acx-social-icons-widget", "a:2:{i:2;a:4:{s:5:\"title\";s:10:\"Folllow Us\";s:9:\"icon_size\";s:2:\"32\";s:10:\"icon_theme\";s:0:\"\";s:10:\"icon_align\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("329", "acx_widget_si_installed_date", "1523988453", "yes");
INSERT INTO wptz_options VALUES("330", "social_widget_icon_array_order", "s:70:\"a:8:{i:0;i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;}\";", "yes");
INSERT INTO wptz_options VALUES("331", "acx_widget_si_theme", "1", "yes");
INSERT INTO wptz_options VALUES("332", "acx_widget_si_icon_size", "32", "yes");
INSERT INTO wptz_options VALUES("333", "acx_widget_si_twitter", "", "yes");
INSERT INTO wptz_options VALUES("334", "acx_widget_si_facebook", "https://www.facebook.com/groups/486633118359478/", "yes");
INSERT INTO wptz_options VALUES("335", "acx_widget_si_gplus", "", "yes");
INSERT INTO wptz_options VALUES("336", "acx_widget_si_pinterest", "", "yes");
INSERT INTO wptz_options VALUES("337", "acx_widget_si_youtube", "", "yes");
INSERT INTO wptz_options VALUES("338", "acx_widget_si_linkedin", "", "yes");
INSERT INTO wptz_options VALUES("339", "acx_widget_si_feed", "", "yes");
INSERT INTO wptz_options VALUES("340", "acx_widget_si_instagram", "", "yes");
INSERT INTO wptz_options VALUES("30091", "wpseo_sitemap_portfolio_cache_validator", "3aXva", "no");
INSERT INTO wptz_options VALUES("30747", "wpseo_sitemap_author_cache_validator", "uVAq", "no");
INSERT INTO wptz_options VALUES("30865", "wpseo_sitemap_ngg_tag_cache_validator", "3H1aR", "no");
INSERT INTO wptz_options VALUES("29964", "wpseo_sitemap_events_categories_cache_validator", "59gYB", "no");
INSERT INTO wptz_options VALUES("6522", "exactmetrics_tracking_notice", "1", "yes");
INSERT INTO wptz_options VALUES("19171", "widget_bbp_views_widget", "a:2:{i:2;a:1:{s:5:\"title\";s:6:\"Topics\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("12943", "rlrsssl_options", "a:14:{s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:0;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"3.1.3\";s:5:\"debug\";b:0;s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:0;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:1;s:11:\"wp_redirect\";b:1;s:31:\"switch_mixed_content_fixer_hook\";b:0;}", "yes");
INSERT INTO wptz_options VALUES("37882", "gadwp_cache_qr3_1854621860", "a:2:{s:5:\"value\";O:31:\"Deconf_Service_Analytics_GaData\":24:{s:17:\"\0*\0collection_key\";s:4:\"rows\";s:25:\"\0*\0internal_gapi_mappings\";a:0:{}s:20:\"\0*\0columnHeadersType\";s:44:\"Deconf_Service_Analytics_GaDataColumnHeaders\";s:24:\"\0*\0columnHeadersDataType\";s:5:\"array\";s:19:\"containsSampledData\";b:0;s:16:\"\0*\0dataTableType\";s:40:\"Deconf_Service_Analytics_GaDataDataTable\";s:20:\"\0*\0dataTableDataType\";s:0:\"\";s:2:\"id\";s:260:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:176690023&metrics=ga:sessions,ga:users,ga:pageviews,ga:BounceRate,ga:organicSearches,ga:pageviewsPerSession,ga:avgTimeOnPage,ga:avgPageLoadTime,ga:avgSessionDuration&start-date=30daysAgo&end-date=yesterday\";s:12:\"itemsPerPage\";i:1000;s:4:\"kind\";s:16:\"analytics#gaData\";s:8:\"nextLink\";N;s:12:\"previousLink\";N;s:18:\"\0*\0profileInfoType\";s:42:\"Deconf_Service_Analytics_GaDataProfileInfo\";s:22:\"\0*\0profileInfoDataType\";s:0:\"\";s:12:\"\0*\0queryType\";s:36:\"Deconf_Service_Analytics_GaDataQuery\";s:16:\"\0*\0queryDataType\";s:0:\"\";s:4:\"rows\";a:1:{i:0;a:9:{i:0;s:2:\"84\";i:1;s:2:\"67\";i:2;s:3:\"246\";i:3;s:17:\"46.42857142857143\";i:4;s:2:\"32\";i:5;s:18:\"2.9285714285714284\";i:6;s:17:\"87.30246913580247\";i:7;s:3:\"0.0\";i:8;s:18:\"168.36904761904762\";}}s:10:\"sampleSize\";N;s:11:\"sampleSpace\";N;s:8:\"selfLink\";s:260:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:176690023&metrics=ga:sessions,ga:users,ga:pageviews,ga:BounceRate,ga:organicSearches,ga:pageviewsPerSession,ga:avgTimeOnPage,ga:avgPageLoadTime,ga:avgSessionDuration&start-date=30daysAgo&end-date=yesterday\";s:12:\"totalResults\";i:1;s:19:\"totalsForAllResults\";a:9:{s:11:\"ga:sessions\";s:2:\"84\";s:8:\"ga:users\";s:2:\"67\";s:12:\"ga:pageviews\";s:3:\"246\";s:13:\"ga:BounceRate\";s:17:\"46.42857142857143\";s:18:\"ga:organicSearches\";s:2:\"32\";s:22:\"ga:pageviewsPerSession\";s:18:\"2.9285714285714284\";s:16:\"ga:avgTimeOnPage\";s:17:\"87.30246913580247\";s:18:\"ga:avgPageLoadTime\";s:3:\"0.0\";s:21:\"ga:avgSessionDuration\";s:18:\"168.36904761904762\";}s:12:\"\0*\0modelData\";a:3:{s:5:\"query\";a:7:{s:10:\"start-date\";s:9:\"30daysAgo\";s:8:\"end-date\";s:9:\"yesterday\";s:3:\"ids\";s:12:\"ga:176690023\";s:7:\"metrics\";a:9:{i:0;s:11:\"ga:sessions\";i:1;s:8:\"ga:users\";i:2;s:12:\"ga:pageviews\";i:3;s:13:\"ga:BounceRate\";i:4;s:18:\"ga:organicSearches\";i:5;s:22:\"ga:pageviewsPerSession\";i:6;s:16:\"ga:avgTimeOnPage\";i:7;s:18:\"ga:avgPageLoadTime\";i:8;s:21:\"ga:avgSessionDuration\";}s:11:\"start-index\";i:1;s:11:\"max-results\";i:1000;s:13:\"samplingLevel\";s:16:\"HIGHER_PRECISION\";}s:11:\"profileInfo\";a:6:{s:9:\"profileId\";s:9:\"176690023\";s:9:\"accountId\";s:8:\"51807754\";s:13:\"webPropertyId\";s:14:\"UA-51807754-19\";s:21:\"internalWebPropertyId\";s:9:\"178123371\";s:11:\"profileName\";s:17:\"All Web Site Data\";s:7:\"tableId\";s:12:\"ga:176690023\";}s:13:\"columnHeaders\";a:9:{i:0;a:3:{s:4:\"name\";s:11:\"ga:sessions\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:1;a:3:{s:4:\"name\";s:8:\"ga:users\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:2;a:3:{s:4:\"name\";s:12:\"ga:pageviews\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:3;a:3:{s:4:\"name\";s:13:\"ga:BounceRate\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"PERCENT\";}i:4;a:3:{s:4:\"name\";s:18:\"ga:organicSearches\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:5;a:3:{s:4:\"name\";s:22:\"ga:pageviewsPerSession\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:5:\"FLOAT\";}i:6;a:3:{s:4:\"name\";s:16:\"ga:avgTimeOnPage\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:4:\"TIME\";}i:7;a:3:{s:4:\"name\";s:18:\"ga:avgPageLoadTime\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:5:\"FLOAT\";}i:8;a:3:{s:4:\"name\";s:21:\"ga:avgSessionDuration\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:4:\"TIME\";}}}s:12:\"\0*\0processed\";a:0:{}}s:7:\"expires\";i:1546930800;}", "no");
INSERT INTO wptz_options VALUES("35454", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("35478", "rewrite_rules", "a:389:{s:62:\"(?:.+/)?events-calendar(\\/[a-z][a-z0-9\\-_~\\/]*~[a-z0-9\\-_~\\/])\";s:21:\"index.php?page_id=219\";s:9:\"forums/?$\";s:25:\"index.php?post_type=forum\";s:39:\"forums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:34:\"forums/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:26:\"forums/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"topics/?$\";s:25:\"index.php?post_type=topic\";s:39:\"topics/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"topics/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"topics/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:28:\"forums/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:28:\"forums/topic/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:28:\"forums/reply/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:32:\"forums/topic-tag/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:47:\"forums/user/([^/]+)/topics/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:48:\"forums/user/([^/]+)/replies/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:50:\"forums/user/([^/]+)/favorites/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:54:\"forums/user/([^/]+)/subscriptions/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:29:\"forums/user/([^/]+)/topics/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:30:\"forums/user/([^/]+)/replies/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:32:\"forums/user/([^/]+)/favorites/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:36:\"forums/user/([^/]+)/subscriptions/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:27:\"forums/user/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:22:\"forums/user/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:40:\"forums/view/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:27:\"forums/view/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:22:\"forums/view/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:34:\"forums/search/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:16:\"forums/search/?$\";s:20:\"index.php?bbp_search\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:8:\"event/?$\";s:31:\"index.php?post_type=ai1ec_event\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=ai1ec_event&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=ai1ec_event&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=ai1ec_event&paged=$matches[1]\";s:19:\"followers/([^/]+)/?\";s:52:\"index.php?pagename=followers&up_username=$matches[1]\";s:27:\"profile/followers/([^/]+)/?\";s:60:\"index.php?pagename=profile/followers&up_username=$matches[1]\";s:17:\"profile/followers\";s:36:\"index.php?pagename=profile/followers\";s:19:\"following/([^/]+)/?\";s:52:\"index.php?pagename=following&up_username=$matches[1]\";s:27:\"profile/following/([^/]+)/?\";s:60:\"index.php?pagename=profile/following&up_username=$matches[1]\";s:17:\"profile/following\";s:36:\"index.php?pagename=profile/following\";s:21:\"connections/([^/]+)/?\";s:62:\"index.php?pagename=profile/connections&up_username=$matches[1]\";s:19:\"profile/connections\";s:38:\"index.php?pagename=profile/connections\";s:16:\"profile/register\";s:35:\"index.php?pagename=profile/register\";s:13:\"profile/login\";s:32:\"index.php?pagename=profile/login\";s:22:\"profile/edit/([^/]+)/?\";s:55:\"index.php?pagename=profile/edit&up_username=$matches[1]\";s:12:\"profile/edit\";s:31:\"index.php?pagename=profile/edit\";s:17:\"profile/([^/]+)/?\";s:50:\"index.php?pagename=profile&up_username=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"forums/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"forums/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"forums/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"forums/forum/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"forums/forum/(.+?)/embed/?$\";s:38:\"index.php?forum=$matches[1]&embed=true\";s:31:\"forums/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:51:\"forums/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:46:\"forums/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:39:\"forums/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:46:\"forums/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:35:\"forums/forum/(.+?)(?:/([0-9]+))?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:40:\"forums/topic/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/topic/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"forums/topic/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"forums/topic/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"forums/topic/([^/]+)/embed/?$\";s:38:\"index.php?topic=$matches[1]&embed=true\";s:33:\"forums/topic/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:53:\"forums/topic/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:48:\"forums/topic/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:41:\"forums/topic/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:48:\"forums/topic/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:37:\"forums/topic/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:29:\"forums/topic/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/topic/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"forums/topic/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forums/topic/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"forums/reply/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/reply/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"forums/reply/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"forums/reply/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"forums/reply/([^/]+)/embed/?$\";s:38:\"index.php?reply=$matches[1]&embed=true\";s:33:\"forums/reply/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:41:\"forums/reply/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:48:\"forums/reply/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:37:\"forums/reply/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:29:\"forums/reply/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/reply/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"forums/reply/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forums/reply/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"forums/topic-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:52:\"forums/topic-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:33:\"forums/topic-tag/([^/]+)/embed/?$\";s:42:\"index.php?topic-tag=$matches[1]&embed=true\";s:45:\"forums/topic-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:27:\"forums/topic-tag/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:42:\"forums/search/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:24:\"forums/search/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:48:\"ngg_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?ngg_tag=$matches[1]&feed=$matches[2]\";s:43:\"ngg_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?ngg_tag=$matches[1]&feed=$matches[2]\";s:24:\"ngg_tag/([^/]+)/embed/?$\";s:40:\"index.php?ngg_tag=$matches[1]&embed=true\";s:36:\"ngg_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?ngg_tag=$matches[1]&paged=$matches[2]\";s:18:\"ngg_tag/([^/]+)/?$\";s:29:\"index.php?ngg_tag=$matches[1]\";s:58:\"events_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?events_categories=$matches[1]&feed=$matches[2]\";s:53:\"events_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?events_categories=$matches[1]&feed=$matches[2]\";s:34:\"events_categories/([^/]+)/embed/?$\";s:50:\"index.php?events_categories=$matches[1]&embed=true\";s:46:\"events_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?events_categories=$matches[1]&paged=$matches[2]\";s:28:\"events_categories/([^/]+)/?$\";s:39:\"index.php?events_categories=$matches[1]\";s:52:\"events_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?events_tags=$matches[1]&feed=$matches[2]\";s:47:\"events_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?events_tags=$matches[1]&feed=$matches[2]\";s:28:\"events_tags/([^/]+)/embed/?$\";s:44:\"index.php?events_tags=$matches[1]&embed=true\";s:40:\"events_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?events_tags=$matches[1]&paged=$matches[2]\";s:22:\"events_tags/([^/]+)/?$\";s:33:\"index.php?events_tags=$matches[1]\";s:53:\"events_feeds/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?events_feeds=$matches[1]&feed=$matches[2]\";s:48:\"events_feeds/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?events_feeds=$matches[1]&feed=$matches[2]\";s:29:\"events_feeds/([^/]+)/embed/?$\";s:45:\"index.php?events_feeds=$matches[1]&embed=true\";s:41:\"events_feeds/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?events_feeds=$matches[1]&paged=$matches[2]\";s:23:\"events_feeds/([^/]+)/?$\";s:34:\"index.php?events_feeds=$matches[1]\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:44:\"index.php?ai1ec_event=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:38:\"index.php?ai1ec_event=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?ai1ec_event=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?ai1ec_event=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?ai1ec_event=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?ai1ec_event=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?ai1ec_event=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"amn_exact-metrics/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"amn_exact-metrics/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"amn_exact-metrics/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"amn_exact-metrics/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"amn_exact-metrics/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"amn_exact-metrics/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"amn_exact-metrics/([^/]+)/embed/?$\";s:50:\"index.php?amn_exact-metrics=$matches[1]&embed=true\";s:38:\"amn_exact-metrics/([^/]+)/trackback/?$\";s:44:\"index.php?amn_exact-metrics=$matches[1]&tb=1\";s:46:\"amn_exact-metrics/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?amn_exact-metrics=$matches[1]&paged=$matches[2]\";s:53:\"amn_exact-metrics/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?amn_exact-metrics=$matches[1]&cpage=$matches[2]\";s:42:\"amn_exact-metrics/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?amn_exact-metrics=$matches[1]&page=$matches[2]\";s:34:\"amn_exact-metrics/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"amn_exact-metrics/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"amn_exact-metrics/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"amn_exact-metrics/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"amn_exact-metrics/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"amn_exact-metrics/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"ngg_album/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"ngg_album/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"ngg_album/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"ngg_album/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"ngg_album/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"ngg_album/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"ngg_album/([^/]+)/embed/?$\";s:42:\"index.php?ngg_album=$matches[1]&embed=true\";s:30:\"ngg_album/([^/]+)/trackback/?$\";s:36:\"index.php?ngg_album=$matches[1]&tb=1\";s:38:\"ngg_album/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?ngg_album=$matches[1]&paged=$matches[2]\";s:45:\"ngg_album/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?ngg_album=$matches[1]&cpage=$matches[2]\";s:34:\"ngg_album/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?ngg_album=$matches[1]&page=$matches[2]\";s:26:\"ngg_album/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"ngg_album/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"ngg_album/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"ngg_album/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"ngg_album/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"ngg_album/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"ngg_gallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"ngg_gallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"ngg_gallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"ngg_gallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"ngg_gallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"ngg_gallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"ngg_gallery/([^/]+)/embed/?$\";s:44:\"index.php?ngg_gallery=$matches[1]&embed=true\";s:32:\"ngg_gallery/([^/]+)/trackback/?$\";s:38:\"index.php?ngg_gallery=$matches[1]&tb=1\";s:40:\"ngg_gallery/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?ngg_gallery=$matches[1]&paged=$matches[2]\";s:47:\"ngg_gallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?ngg_gallery=$matches[1]&cpage=$matches[2]\";s:36:\"ngg_gallery/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?ngg_gallery=$matches[1]&page=$matches[2]\";s:28:\"ngg_gallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"ngg_gallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"ngg_gallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"ngg_gallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"ngg_gallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"ngg_gallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"ngg_pictures/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"ngg_pictures/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"ngg_pictures/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"ngg_pictures/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"ngg_pictures/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"ngg_pictures/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"ngg_pictures/([^/]+)/embed/?$\";s:45:\"index.php?ngg_pictures=$matches[1]&embed=true\";s:33:\"ngg_pictures/([^/]+)/trackback/?$\";s:39:\"index.php?ngg_pictures=$matches[1]&tb=1\";s:41:\"ngg_pictures/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?ngg_pictures=$matches[1]&paged=$matches[2]\";s:48:\"ngg_pictures/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?ngg_pictures=$matches[1]&cpage=$matches[2]\";s:37:\"ngg_pictures/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?ngg_pictures=$matches[1]&page=$matches[2]\";s:29:\"ngg_pictures/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"ngg_pictures/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"ngg_pictures/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"ngg_pictures/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"ngg_pictures/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"ngg_pictures/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"lightbox_library/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"lightbox_library/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"lightbox_library/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"lightbox_library/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"lightbox_library/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"lightbox_library/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"lightbox_library/([^/]+)/embed/?$\";s:49:\"index.php?lightbox_library=$matches[1]&embed=true\";s:37:\"lightbox_library/([^/]+)/trackback/?$\";s:43:\"index.php?lightbox_library=$matches[1]&tb=1\";s:45:\"lightbox_library/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?lightbox_library=$matches[1]&paged=$matches[2]\";s:52:\"lightbox_library/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?lightbox_library=$matches[1]&cpage=$matches[2]\";s:41:\"lightbox_library/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?lightbox_library=$matches[1]&page=$matches[2]\";s:33:\"lightbox_library/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"lightbox_library/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"lightbox_library/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"lightbox_library/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"lightbox_library/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"lightbox_library/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"portfolio-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"portfolio-item/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:39:\"portfolio-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"portfolio-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:53:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:34:\"portfolio_entries/([^/]+)/embed/?$\";s:50:\"index.php?portfolio_entries=$matches[1]&embed=true\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:45:\"displayed_gallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"displayed_gallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"displayed_gallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"displayed_gallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"displayed_gallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"displayed_gallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"displayed_gallery/([^/]+)/embed/?$\";s:50:\"index.php?displayed_gallery=$matches[1]&embed=true\";s:38:\"displayed_gallery/([^/]+)/trackback/?$\";s:44:\"index.php?displayed_gallery=$matches[1]&tb=1\";s:46:\"displayed_gallery/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?displayed_gallery=$matches[1]&paged=$matches[2]\";s:53:\"displayed_gallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?displayed_gallery=$matches[1]&cpage=$matches[2]\";s:42:\"displayed_gallery/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?displayed_gallery=$matches[1]&page=$matches[2]\";s:34:\"displayed_gallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"displayed_gallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"displayed_gallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"displayed_gallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"displayed_gallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"displayed_gallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"display_type/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"display_type/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"display_type/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"display_type/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"display_type/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"display_type/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"display_type/([^/]+)/embed/?$\";s:45:\"index.php?display_type=$matches[1]&embed=true\";s:33:\"display_type/([^/]+)/trackback/?$\";s:39:\"index.php?display_type=$matches[1]&tb=1\";s:41:\"display_type/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?display_type=$matches[1]&paged=$matches[2]\";s:48:\"display_type/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?display_type=$matches[1]&cpage=$matches[2]\";s:37:\"display_type/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?display_type=$matches[1]&page=$matches[2]\";s:29:\"display_type/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"display_type/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"display_type/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"display_type/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"display_type/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"display_type/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"gal_display_source/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"gal_display_source/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"gal_display_source/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"gal_display_source/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"gal_display_source/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"gal_display_source/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"gal_display_source/([^/]+)/embed/?$\";s:51:\"index.php?gal_display_source=$matches[1]&embed=true\";s:39:\"gal_display_source/([^/]+)/trackback/?$\";s:45:\"index.php?gal_display_source=$matches[1]&tb=1\";s:47:\"gal_display_source/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?gal_display_source=$matches[1]&paged=$matches[2]\";s:54:\"gal_display_source/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?gal_display_source=$matches[1]&cpage=$matches[2]\";s:43:\"gal_display_source/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?gal_display_source=$matches[1]&page=$matches[2]\";s:35:\"gal_display_source/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"gal_display_source/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"gal_display_source/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gal_display_source/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gal_display_source/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"gal_display_source/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=126&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO wptz_options VALUES("35466", "can_compress_scripts", "1", "no");
INSERT INTO wptz_options VALUES("2015", "userpro_fields_groups", "a:5:{s:8:\"register\";a:1:{s:7:\"default\";a:18:{s:11:\"accountinfo\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Account Details\";}s:10:\"user_login\";a:17:{s:9:\"ajaxcheck\";s:15:\"username_exists\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:8:\"Username\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:10:\"user_email\";a:17:{s:9:\"ajaxcheck\";s:12:\"email_exists\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"E-mail Address\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"1\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:9:\"user_pass\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:5:\"label\";s:8:\"Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"1\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}s:17:\"user_pass_confirm\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:21:\"Confirm your Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}s:16:\"passwordstrength\";a:23:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:23:\"Password Strength Meter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:4:\"good\";s:4:\"Good\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:6:\"strong\";s:6:\"Strong\";s:9:\"too_short\";s:18:\"Password too short\";s:4:\"type\";s:16:\"passwordstrength\";s:11:\"very_strong\";s:11:\"Very Strong\";s:9:\"very_weak\";s:9:\"Very Weak\";s:4:\"weak\";s:4:\"Weak\";s:3:\"woo\";s:1:\"0\";}s:7:\"profile\";a:3:{s:9:\"collapsed\";s:1:\"1\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Profile Details\";}s:14:\"title_position\";a:13:{s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"Title/Position\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"0\";s:9:\"ajaxcheck\";s:0:\"\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:19:\"agency_organization\";a:13:{s:4:\"help\";s:0:\"\";s:5:\"label\";s:19:\"Agency/Organization\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"0\";s:9:\"ajaxcheck\";s:0:\"\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:12:\"display_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:5:\"label\";s:20:\"Profile Display Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:14:\"profilepicture\";a:14:{s:9:\"ajaxcheck\";s:0:\"\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:7:\"picture\";s:3:\"woo\";s:1:\"0\";}s:6:\"gender\";a:18:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{i:0;s:4:\"Male\";i:1;s:6:\"Female\";}s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:5:\"radio\";s:3:\"woo\";s:1:\"0\";}s:7:\"country\";a:18:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:250:{i:0;s:11:\"Afghanistan\";i:1;s:14:\"Åland Islands\";i:2;s:7:\"Albania\";i:3;s:7:\"Algeria\";i:4;s:14:\"American Samoa\";i:5;s:7:\"Andorra\";i:6;s:6:\"Angola\";i:7;s:8:\"Anguilla\";i:8;s:10:\"Antarctica\";i:9;s:19:\"Antigua and Barbuda\";i:10;s:9:\"Argentina\";i:11;s:7:\"Armenia\";i:12;s:5:\"Aruba\";i:13;s:9:\"Australia\";i:14;s:7:\"Austria\";i:15;s:10:\"Azerbaijan\";i:16;s:7:\"Bahamas\";i:17;s:7:\"Bahrain\";i:18;s:10:\"Bangladesh\";i:19;s:8:\"Barbados\";i:20;s:7:\"Belarus\";i:21;s:7:\"Belgium\";i:22;s:6:\"Belize\";i:23;s:5:\"Benin\";i:24;s:7:\"Bermuda\";i:25;s:6:\"Bhutan\";i:26;s:31:\"Bolivia, Plurinational State of\";i:27;s:32:\"Bonaire, Sint Eustatius and Saba\";i:28;s:22:\"Bosnia and Herzegovina\";i:29;s:8:\"Botswana\";i:30;s:13:\"Bouvet Island\";i:31;s:6:\"Brazil\";i:32;s:30:\"British Indian Ocean Territory\";i:33;s:17:\"Brunei Darussalam\";i:34;s:8:\"Bulgaria\";i:35;s:12:\"Burkina Faso\";i:36;s:7:\"Burundi\";i:37;s:8:\"Cambodia\";i:38;s:8:\"Cameroon\";i:39;s:6:\"Canada\";i:40;s:10:\"Cape Verde\";i:41;s:14:\"Cayman Islands\";i:42;s:24:\"Central African Republic\";i:43;s:4:\"Chad\";i:44;s:5:\"Chile\";i:45;s:5:\"China\";i:46;s:16:\"Christmas Island\";i:47;s:23:\"Cocos (Keeling) Islands\";i:48;s:8:\"Colombia\";i:49;s:7:\"Comoros\";i:50;s:5:\"Congo\";i:51;s:37:\"Congo, the Democratic Republic of the\";i:52;s:12:\"Cook Islands\";i:53;s:10:\"Costa Rica\";i:54;s:14:\"Côte d\'Ivoire\";i:55;s:7:\"Croatia\";i:56;s:4:\"Cuba\";i:57;s:8:\"Curaçao\";i:58;s:6:\"Cyprus\";i:59;s:14:\"Czech Republic\";i:60;s:7:\"Denmark\";i:61;s:8:\"Djibouti\";i:62;s:8:\"Dominica\";i:63;s:18:\"Dominican Republic\";i:64;s:7:\"Ecuador\";i:65;s:5:\"Egypt\";i:66;s:11:\"El Salvador\";i:67;s:17:\"Equatorial Guinea\";i:68;s:7:\"Eritrea\";i:69;s:7:\"Estonia\";i:70;s:8:\"Ethiopia\";i:71;s:27:\"Falkland Islands (Malvinas)\";i:72;s:13:\"Faroe Islands\";i:73;s:4:\"Fiji\";i:74;s:7:\"Finland\";i:75;s:6:\"France\";i:76;s:13:\"French Guiana\";i:77;s:16:\"French Polynesia\";i:78;s:27:\"French Southern Territories\";i:79;s:5:\"Gabon\";i:80;s:6:\"Gambia\";i:81;s:7:\"Georgia\";i:82;s:7:\"Germany\";i:83;s:5:\"Ghana\";i:84;s:9:\"Gibraltar\";i:85;s:6:\"Greece\";i:86;s:9:\"Greenland\";i:87;s:7:\"Grenada\";i:88;s:10:\"Guadeloupe\";i:89;s:4:\"Guam\";i:90;s:9:\"Guatemala\";i:91;s:8:\"Guernsey\";i:92;s:6:\"Guinea\";i:93;s:13:\"Guinea-Bissau\";i:94;s:6:\"Guyana\";i:95;s:5:\"Haiti\";i:96;s:33:\"Heard Island and McDonald Islands\";i:97;s:29:\"Holy See (Vatican City State)\";i:98;s:8:\"Honduras\";i:99;s:9:\"Hong Kong\";i:100;s:7:\"Hungary\";i:101;s:7:\"Iceland\";i:102;s:5:\"India\";i:103;s:9:\"Indonesia\";i:104;s:25:\"Iran, Islamic Republic of\";i:105;s:4:\"Iraq\";i:106;s:7:\"Ireland\";i:107;s:11:\"Isle of Man\";i:108;s:6:\"Israel\";i:109;s:5:\"Italy\";i:110;s:7:\"Jamaica\";i:111;s:5:\"Japan\";i:112;s:6:\"Jersey\";i:113;s:6:\"Jordan\";i:114;s:10:\"Kazakhstan\";i:115;s:5:\"Kenya\";i:116;s:8:\"Kiribati\";i:117;s:38:\"Korea, Democratic People\'s Republic of\";i:118;s:18:\"Korea, Republic of\";i:119;s:6:\"Kuwait\";i:120;s:10:\"Kyrgyzstan\";i:121;s:32:\"Lao People\'s Democratic Republic\";i:122;s:6:\"Latvia\";i:123;s:7:\"Lebanon\";i:124;s:7:\"Lesotho\";i:125;s:7:\"Liberia\";i:126;s:5:\"Libya\";i:127;s:13:\"Liechtenstein\";i:128;s:9:\"Lithuania\";i:129;s:10:\"Luxembourg\";i:130;s:5:\"Macao\";i:131;s:42:\"Macedonia, The Former Yugoslav Republic of\";i:132;s:10:\"Madagascar\";i:133;s:6:\"Malawi\";i:134;s:8:\"Malaysia\";i:135;s:8:\"Maldives\";i:136;s:4:\"Mali\";i:137;s:5:\"Malta\";i:138;s:16:\"Marshall Islands\";i:139;s:10:\"Martinique\";i:140;s:10:\"Mauritania\";i:141;s:9:\"Mauritius\";i:142;s:7:\"Mayotte\";i:143;s:6:\"Mexico\";i:144;s:31:\"Micronesia, Federated States of\";i:145;s:20:\"Moldova, Republic of\";i:146;s:6:\"Monaco\";i:147;s:8:\"Mongolia\";i:148;s:10:\"Montenegro\";i:149;s:10:\"Montserrat\";i:150;s:7:\"Morocco\";i:151;s:10:\"Mozambique\";i:152;s:7:\"Myanmar\";i:153;s:7:\"Namibia\";i:154;s:5:\"Nauru\";i:155;s:5:\"Nepal\";i:156;s:11:\"Netherlands\";i:157;s:13:\"New Caledonia\";i:158;s:11:\"New Zealand\";i:159;s:9:\"Nicaragua\";i:160;s:5:\"Niger\";i:161;s:7:\"Nigeria\";i:162;s:4:\"Niue\";i:163;s:14:\"Norfolk Island\";i:164;s:24:\"Northern Mariana Islands\";i:165;s:6:\"Norway\";i:166;s:4:\"Oman\";i:167;s:8:\"Pakistan\";i:168;s:5:\"Palau\";i:169;s:21:\"Palestinian Territory\";i:170;s:6:\"Panama\";i:171;s:16:\"Papua New Guinea\";i:172;s:8:\"Paraguay\";i:173;s:4:\"Peru\";i:174;s:11:\"Philippines\";i:175;s:8:\"Pitcairn\";i:176;s:6:\"Poland\";i:177;s:8:\"Portugal\";i:178;s:11:\"Puerto Rico\";i:179;s:5:\"Qatar\";i:180;s:8:\"Réunion\";i:181;s:7:\"Romania\";i:182;s:18:\"Russian Federation\";i:183;s:6:\"Rwanda\";i:184;s:17:\"Saint Barthélemy\";i:185;s:44:\"Saint Helena, Ascension and Tristan da Cunha\";i:186;s:21:\"Saint Kitts and Nevis\";i:187;s:11:\"Saint Lucia\";i:188;s:26:\"Saint Martin (French part)\";i:189;s:25:\"Saint Pierre and Miquelon\";i:190;s:32:\"Saint Vincent and the Grenadines\";i:191;s:5:\"Samoa\";i:192;s:10:\"San Marino\";i:193;s:21:\"Sao Tome and Principe\";i:194;s:12:\"Saudi Arabia\";i:195;s:8:\"Scotland\";i:196;s:7:\"Senegal\";i:197;s:6:\"Serbia\";i:198;s:10:\"Seychelles\";i:199;s:12:\"Sierra Leone\";i:200;s:9:\"Singapore\";i:201;s:25:\"Sint Maarten (Dutch part)\";i:202;s:8:\"Slovakia\";i:203;s:8:\"Slovenia\";i:204;s:15:\"Solomon Islands\";i:205;s:7:\"Somalia\";i:206;s:12:\"South Africa\";i:207;s:44:\"South Georgia and the South Sandwich Islands\";i:208;s:11:\"South Sudan\";i:209;s:5:\"Spain\";i:210;s:9:\"Sri Lanka\";i:211;s:5:\"Sudan\";i:212;s:8:\"Suriname\";i:213;s:22:\"Svalbard and Jan Mayen\";i:214;s:9:\"Swaziland\";i:215;s:6:\"Sweden\";i:216;s:11:\"Switzerland\";i:217;s:20:\"Syrian Arab Republic\";i:218;s:25:\"Taiwan, Province of China\";i:219;s:10:\"Tajikistan\";i:220;s:28:\"Tanzania, United Republic of\";i:221;s:8:\"Thailand\";i:222;s:11:\"Timor-Leste\";i:223;s:4:\"Togo\";i:224;s:7:\"Tokelau\";i:225;s:5:\"Tonga\";i:226;s:19:\"Trinidad and Tobago\";i:227;s:7:\"Tunisia\";i:228;s:6:\"Turkey\";i:229;s:12:\"Turkmenistan\";i:230;s:24:\"Turks and Caicos Islands\";i:231;s:6:\"Tuvalu\";i:232;s:6:\"Uganda\";i:233;s:7:\"Ukraine\";i:234;s:20:\"United Arab Emirates\";i:235;s:14:\"United Kingdom\";i:236;s:13:\"United States\";i:237;s:36:\"United States Minor Outlying Islands\";i:238;s:7:\"Uruguay\";i:239;s:10:\"Uzbekistan\";i:240;s:7:\"Vanuatu\";i:241;s:33:\"Venezuela, Bolivarian Republic of\";i:242;s:8:\"Viet Nam\";i:243;s:23:\"Virgin Islands, British\";i:244;s:20:\"Virgin Islands, U.S.\";i:245;s:17:\"Wallis and Futuna\";i:246;s:14:\"Western Sahara\";i:247;s:5:\"Yemen\";i:248;s:6:\"Zambia\";i:249;s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:6:\"select\";s:3:\"woo\";s:1:\"0\";}s:6:\"social\";a:3:{s:9:\"collapsed\";s:1:\"1\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Social Profiles\";}s:8:\"facebook\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Facebook Page\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:7:\"twitter\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Twitter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"google_plus\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Google+\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:8:\"user_url\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Website (URL)\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_login\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}}}s:5:\"login\";a:1:{s:7:\"default\";a:2:{s:17:\"username_or_email\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:18:\"Username or E-mail\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:17:\"username_or_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:9:\"user_pass\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:5:\"label\";s:8:\"Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:17:\"username_or_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"1\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}}}s:4:\"edit\";a:1:{s:7:\"default\";a:20:{s:7:\"profile\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Profile Details\";}s:14:\"title_position\";a:13:{s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"Title/Position\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"0\";s:9:\"ajaxcheck\";s:0:\"\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:19:\"agency_organization\";a:13:{s:4:\"help\";s:0:\"\";s:5:\"label\";s:19:\"Agency/Organization\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"0\";s:9:\"ajaxcheck\";s:0:\"\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:12:\"display_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:5:\"label\";s:20:\"Profile Display Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:14:\"profilepicture\";a:14:{s:9:\"ajaxcheck\";s:0:\"\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:7:\"picture\";s:3:\"woo\";s:1:\"0\";}s:10:\"first_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:10:\"First Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:9:\"last_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:9:\"Last Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"description\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:18:\"Describe yourself.\";s:5:\"label\";s:9:\"Biography\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"textarea\";s:3:\"woo\";s:1:\"0\";}s:6:\"gender\";a:18:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{i:0;s:4:\"Male\";i:1;s:6:\"Female\";}s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:5:\"radio\";s:3:\"woo\";s:1:\"0\";}s:7:\"country\";a:18:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:250:{i:0;s:11:\"Afghanistan\";i:1;s:14:\"Åland Islands\";i:2;s:7:\"Albania\";i:3;s:7:\"Algeria\";i:4;s:14:\"American Samoa\";i:5;s:7:\"Andorra\";i:6;s:6:\"Angola\";i:7;s:8:\"Anguilla\";i:8;s:10:\"Antarctica\";i:9;s:19:\"Antigua and Barbuda\";i:10;s:9:\"Argentina\";i:11;s:7:\"Armenia\";i:12;s:5:\"Aruba\";i:13;s:9:\"Australia\";i:14;s:7:\"Austria\";i:15;s:10:\"Azerbaijan\";i:16;s:7:\"Bahamas\";i:17;s:7:\"Bahrain\";i:18;s:10:\"Bangladesh\";i:19;s:8:\"Barbados\";i:20;s:7:\"Belarus\";i:21;s:7:\"Belgium\";i:22;s:6:\"Belize\";i:23;s:5:\"Benin\";i:24;s:7:\"Bermuda\";i:25;s:6:\"Bhutan\";i:26;s:31:\"Bolivia, Plurinational State of\";i:27;s:32:\"Bonaire, Sint Eustatius and Saba\";i:28;s:22:\"Bosnia and Herzegovina\";i:29;s:8:\"Botswana\";i:30;s:13:\"Bouvet Island\";i:31;s:6:\"Brazil\";i:32;s:30:\"British Indian Ocean Territory\";i:33;s:17:\"Brunei Darussalam\";i:34;s:8:\"Bulgaria\";i:35;s:12:\"Burkina Faso\";i:36;s:7:\"Burundi\";i:37;s:8:\"Cambodia\";i:38;s:8:\"Cameroon\";i:39;s:6:\"Canada\";i:40;s:10:\"Cape Verde\";i:41;s:14:\"Cayman Islands\";i:42;s:24:\"Central African Republic\";i:43;s:4:\"Chad\";i:44;s:5:\"Chile\";i:45;s:5:\"China\";i:46;s:16:\"Christmas Island\";i:47;s:23:\"Cocos (Keeling) Islands\";i:48;s:8:\"Colombia\";i:49;s:7:\"Comoros\";i:50;s:5:\"Congo\";i:51;s:37:\"Congo, the Democratic Republic of the\";i:52;s:12:\"Cook Islands\";i:53;s:10:\"Costa Rica\";i:54;s:14:\"Côte d\'Ivoire\";i:55;s:7:\"Croatia\";i:56;s:4:\"Cuba\";i:57;s:8:\"Curaçao\";i:58;s:6:\"Cyprus\";i:59;s:14:\"Czech Republic\";i:60;s:7:\"Denmark\";i:61;s:8:\"Djibouti\";i:62;s:8:\"Dominica\";i:63;s:18:\"Dominican Republic\";i:64;s:7:\"Ecuador\";i:65;s:5:\"Egypt\";i:66;s:11:\"El Salvador\";i:67;s:17:\"Equatorial Guinea\";i:68;s:7:\"Eritrea\";i:69;s:7:\"Estonia\";i:70;s:8:\"Ethiopia\";i:71;s:27:\"Falkland Islands (Malvinas)\";i:72;s:13:\"Faroe Islands\";i:73;s:4:\"Fiji\";i:74;s:7:\"Finland\";i:75;s:6:\"France\";i:76;s:13:\"French Guiana\";i:77;s:16:\"French Polynesia\";i:78;s:27:\"French Southern Territories\";i:79;s:5:\"Gabon\";i:80;s:6:\"Gambia\";i:81;s:7:\"Georgia\";i:82;s:7:\"Germany\";i:83;s:5:\"Ghana\";i:84;s:9:\"Gibraltar\";i:85;s:6:\"Greece\";i:86;s:9:\"Greenland\";i:87;s:7:\"Grenada\";i:88;s:10:\"Guadeloupe\";i:89;s:4:\"Guam\";i:90;s:9:\"Guatemala\";i:91;s:8:\"Guernsey\";i:92;s:6:\"Guinea\";i:93;s:13:\"Guinea-Bissau\";i:94;s:6:\"Guyana\";i:95;s:5:\"Haiti\";i:96;s:33:\"Heard Island and McDonald Islands\";i:97;s:29:\"Holy See (Vatican City State)\";i:98;s:8:\"Honduras\";i:99;s:9:\"Hong Kong\";i:100;s:7:\"Hungary\";i:101;s:7:\"Iceland\";i:102;s:5:\"India\";i:103;s:9:\"Indonesia\";i:104;s:25:\"Iran, Islamic Republic of\";i:105;s:4:\"Iraq\";i:106;s:7:\"Ireland\";i:107;s:11:\"Isle of Man\";i:108;s:6:\"Israel\";i:109;s:5:\"Italy\";i:110;s:7:\"Jamaica\";i:111;s:5:\"Japan\";i:112;s:6:\"Jersey\";i:113;s:6:\"Jordan\";i:114;s:10:\"Kazakhstan\";i:115;s:5:\"Kenya\";i:116;s:8:\"Kiribati\";i:117;s:38:\"Korea, Democratic People\'s Republic of\";i:118;s:18:\"Korea, Republic of\";i:119;s:6:\"Kuwait\";i:120;s:10:\"Kyrgyzstan\";i:121;s:32:\"Lao People\'s Democratic Republic\";i:122;s:6:\"Latvia\";i:123;s:7:\"Lebanon\";i:124;s:7:\"Lesotho\";i:125;s:7:\"Liberia\";i:126;s:5:\"Libya\";i:127;s:13:\"Liechtenstein\";i:128;s:9:\"Lithuania\";i:129;s:10:\"Luxembourg\";i:130;s:5:\"Macao\";i:131;s:42:\"Macedonia, The Former Yugoslav Republic of\";i:132;s:10:\"Madagascar\";i:133;s:6:\"Malawi\";i:134;s:8:\"Malaysia\";i:135;s:8:\"Maldives\";i:136;s:4:\"Mali\";i:137;s:5:\"Malta\";i:138;s:16:\"Marshall Islands\";i:139;s:10:\"Martinique\";i:140;s:10:\"Mauritania\";i:141;s:9:\"Mauritius\";i:142;s:7:\"Mayotte\";i:143;s:6:\"Mexico\";i:144;s:31:\"Micronesia, Federated States of\";i:145;s:20:\"Moldova, Republic of\";i:146;s:6:\"Monaco\";i:147;s:8:\"Mongolia\";i:148;s:10:\"Montenegro\";i:149;s:10:\"Montserrat\";i:150;s:7:\"Morocco\";i:151;s:10:\"Mozambique\";i:152;s:7:\"Myanmar\";i:153;s:7:\"Namibia\";i:154;s:5:\"Nauru\";i:155;s:5:\"Nepal\";i:156;s:11:\"Netherlands\";i:157;s:13:\"New Caledonia\";i:158;s:11:\"New Zealand\";i:159;s:9:\"Nicaragua\";i:160;s:5:\"Niger\";i:161;s:7:\"Nigeria\";i:162;s:4:\"Niue\";i:163;s:14:\"Norfolk Island\";i:164;s:24:\"Northern Mariana Islands\";i:165;s:6:\"Norway\";i:166;s:4:\"Oman\";i:167;s:8:\"Pakistan\";i:168;s:5:\"Palau\";i:169;s:21:\"Palestinian Territory\";i:170;s:6:\"Panama\";i:171;s:16:\"Papua New Guinea\";i:172;s:8:\"Paraguay\";i:173;s:4:\"Peru\";i:174;s:11:\"Philippines\";i:175;s:8:\"Pitcairn\";i:176;s:6:\"Poland\";i:177;s:8:\"Portugal\";i:178;s:11:\"Puerto Rico\";i:179;s:5:\"Qatar\";i:180;s:8:\"Réunion\";i:181;s:7:\"Romania\";i:182;s:18:\"Russian Federation\";i:183;s:6:\"Rwanda\";i:184;s:17:\"Saint Barthélemy\";i:185;s:44:\"Saint Helena, Ascension and Tristan da Cunha\";i:186;s:21:\"Saint Kitts and Nevis\";i:187;s:11:\"Saint Lucia\";i:188;s:26:\"Saint Martin (French part)\";i:189;s:25:\"Saint Pierre and Miquelon\";i:190;s:32:\"Saint Vincent and the Grenadines\";i:191;s:5:\"Samoa\";i:192;s:10:\"San Marino\";i:193;s:21:\"Sao Tome and Principe\";i:194;s:12:\"Saudi Arabia\";i:195;s:8:\"Scotland\";i:196;s:7:\"Senegal\";i:197;s:6:\"Serbia\";i:198;s:10:\"Seychelles\";i:199;s:12:\"Sierra Leone\";i:200;s:9:\"Singapore\";i:201;s:25:\"Sint Maarten (Dutch part)\";i:202;s:8:\"Slovakia\";i:203;s:8:\"Slovenia\";i:204;s:15:\"Solomon Islands\";i:205;s:7:\"Somalia\";i:206;s:12:\"South Africa\";i:207;s:44:\"South Georgia and the South Sandwich Islands\";i:208;s:11:\"South Sudan\";i:209;s:5:\"Spain\";i:210;s:9:\"Sri Lanka\";i:211;s:5:\"Sudan\";i:212;s:8:\"Suriname\";i:213;s:22:\"Svalbard and Jan Mayen\";i:214;s:9:\"Swaziland\";i:215;s:6:\"Sweden\";i:216;s:11:\"Switzerland\";i:217;s:20:\"Syrian Arab Republic\";i:218;s:25:\"Taiwan, Province of China\";i:219;s:10:\"Tajikistan\";i:220;s:28:\"Tanzania, United Republic of\";i:221;s:8:\"Thailand\";i:222;s:11:\"Timor-Leste\";i:223;s:4:\"Togo\";i:224;s:7:\"Tokelau\";i:225;s:5:\"Tonga\";i:226;s:19:\"Trinidad and Tobago\";i:227;s:7:\"Tunisia\";i:228;s:6:\"Turkey\";i:229;s:12:\"Turkmenistan\";i:230;s:24:\"Turks and Caicos Islands\";i:231;s:6:\"Tuvalu\";i:232;s:6:\"Uganda\";i:233;s:7:\"Ukraine\";i:234;s:20:\"United Arab Emirates\";i:235;s:14:\"United Kingdom\";i:236;s:13:\"United States\";i:237;s:36:\"United States Minor Outlying Islands\";i:238;s:7:\"Uruguay\";i:239;s:10:\"Uzbekistan\";i:240;s:7:\"Vanuatu\";i:241;s:33:\"Venezuela, Bolivarian Republic of\";i:242;s:8:\"Viet Nam\";i:243;s:23:\"Virgin Islands, British\";i:244;s:20:\"Virgin Islands, U.S.\";i:245;s:17:\"Wallis and Futuna\";i:246;s:14:\"Western Sahara\";i:247;s:5:\"Yemen\";i:248;s:6:\"Zambia\";i:249;s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:6:\"select\";s:3:\"woo\";s:1:\"0\";}s:6:\"social\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Social Profiles\";}s:8:\"facebook\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Facebook Page\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:7:\"twitter\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Twitter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"google_plus\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Google+\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:8:\"user_url\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Website (URL)\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"accountinfo\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Account Details\";}s:10:\"user_email\";a:17:{s:9:\"ajaxcheck\";s:18:\"email_domain_check\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"E-mail Address\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"1\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:9:\"user_pass\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:5:\"label\";s:8:\"Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}s:17:\"user_pass_confirm\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:21:\"Confirm your Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}s:16:\"passwordstrength\";a:23:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:23:\"Password Strength Meter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:4:\"good\";s:4:\"Good\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:6:\"strong\";s:6:\"Strong\";s:9:\"too_short\";s:18:\"Password too short\";s:4:\"type\";s:16:\"passwordstrength\";s:11:\"very_strong\";s:11:\"Very Strong\";s:9:\"very_weak\";s:9:\"Very Weak\";s:4:\"weak\";s:4:\"Weak\";s:3:\"woo\";s:1:\"0\";}}}s:6:\"social\";a:1:{s:7:\"default\";a:5:{s:10:\"user_email\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"E-mail Address\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:8:\"facebook\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Facebook Page\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:7:\"twitter\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Twitter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"google_plus\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Google+\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:8:\"user_url\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Website (URL)\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:10:\"user_email\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}}}s:4:\"view\";a:1:{s:7:\"default\";a:20:{s:7:\"profile\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Profile Details\";}s:14:\"title_position\";a:13:{s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"Title/Position\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"0\";s:9:\"ajaxcheck\";s:0:\"\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:19:\"agency_organization\";a:13:{s:4:\"help\";s:0:\"\";s:5:\"label\";s:19:\"Agency/Organization\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"0\";s:9:\"ajaxcheck\";s:0:\"\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:12:\"display_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:5:\"label\";s:20:\"Profile Display Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:14:\"profilepicture\";a:14:{s:9:\"ajaxcheck\";s:0:\"\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"placeholder\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:7:\"picture\";s:3:\"woo\";s:1:\"0\";}s:10:\"first_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:10:\"First Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:9:\"last_name\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:9:\"Last Name\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"description\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:18:\"Describe yourself.\";s:5:\"label\";s:9:\"Biography\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"textarea\";s:3:\"woo\";s:1:\"0\";}s:6:\"gender\";a:18:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{i:0;s:4:\"Male\";i:1;s:6:\"Female\";}s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:5:\"radio\";s:3:\"woo\";s:1:\"0\";}s:7:\"country\";a:18:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:250:{i:0;s:11:\"Afghanistan\";i:1;s:14:\"Åland Islands\";i:2;s:7:\"Albania\";i:3;s:7:\"Algeria\";i:4;s:14:\"American Samoa\";i:5;s:7:\"Andorra\";i:6;s:6:\"Angola\";i:7;s:8:\"Anguilla\";i:8;s:10:\"Antarctica\";i:9;s:19:\"Antigua and Barbuda\";i:10;s:9:\"Argentina\";i:11;s:7:\"Armenia\";i:12;s:5:\"Aruba\";i:13;s:9:\"Australia\";i:14;s:7:\"Austria\";i:15;s:10:\"Azerbaijan\";i:16;s:7:\"Bahamas\";i:17;s:7:\"Bahrain\";i:18;s:10:\"Bangladesh\";i:19;s:8:\"Barbados\";i:20;s:7:\"Belarus\";i:21;s:7:\"Belgium\";i:22;s:6:\"Belize\";i:23;s:5:\"Benin\";i:24;s:7:\"Bermuda\";i:25;s:6:\"Bhutan\";i:26;s:31:\"Bolivia, Plurinational State of\";i:27;s:32:\"Bonaire, Sint Eustatius and Saba\";i:28;s:22:\"Bosnia and Herzegovina\";i:29;s:8:\"Botswana\";i:30;s:13:\"Bouvet Island\";i:31;s:6:\"Brazil\";i:32;s:30:\"British Indian Ocean Territory\";i:33;s:17:\"Brunei Darussalam\";i:34;s:8:\"Bulgaria\";i:35;s:12:\"Burkina Faso\";i:36;s:7:\"Burundi\";i:37;s:8:\"Cambodia\";i:38;s:8:\"Cameroon\";i:39;s:6:\"Canada\";i:40;s:10:\"Cape Verde\";i:41;s:14:\"Cayman Islands\";i:42;s:24:\"Central African Republic\";i:43;s:4:\"Chad\";i:44;s:5:\"Chile\";i:45;s:5:\"China\";i:46;s:16:\"Christmas Island\";i:47;s:23:\"Cocos (Keeling) Islands\";i:48;s:8:\"Colombia\";i:49;s:7:\"Comoros\";i:50;s:5:\"Congo\";i:51;s:37:\"Congo, the Democratic Republic of the\";i:52;s:12:\"Cook Islands\";i:53;s:10:\"Costa Rica\";i:54;s:14:\"Côte d\'Ivoire\";i:55;s:7:\"Croatia\";i:56;s:4:\"Cuba\";i:57;s:8:\"Curaçao\";i:58;s:6:\"Cyprus\";i:59;s:14:\"Czech Republic\";i:60;s:7:\"Denmark\";i:61;s:8:\"Djibouti\";i:62;s:8:\"Dominica\";i:63;s:18:\"Dominican Republic\";i:64;s:7:\"Ecuador\";i:65;s:5:\"Egypt\";i:66;s:11:\"El Salvador\";i:67;s:17:\"Equatorial Guinea\";i:68;s:7:\"Eritrea\";i:69;s:7:\"Estonia\";i:70;s:8:\"Ethiopia\";i:71;s:27:\"Falkland Islands (Malvinas)\";i:72;s:13:\"Faroe Islands\";i:73;s:4:\"Fiji\";i:74;s:7:\"Finland\";i:75;s:6:\"France\";i:76;s:13:\"French Guiana\";i:77;s:16:\"French Polynesia\";i:78;s:27:\"French Southern Territories\";i:79;s:5:\"Gabon\";i:80;s:6:\"Gambia\";i:81;s:7:\"Georgia\";i:82;s:7:\"Germany\";i:83;s:5:\"Ghana\";i:84;s:9:\"Gibraltar\";i:85;s:6:\"Greece\";i:86;s:9:\"Greenland\";i:87;s:7:\"Grenada\";i:88;s:10:\"Guadeloupe\";i:89;s:4:\"Guam\";i:90;s:9:\"Guatemala\";i:91;s:8:\"Guernsey\";i:92;s:6:\"Guinea\";i:93;s:13:\"Guinea-Bissau\";i:94;s:6:\"Guyana\";i:95;s:5:\"Haiti\";i:96;s:33:\"Heard Island and McDonald Islands\";i:97;s:29:\"Holy See (Vatican City State)\";i:98;s:8:\"Honduras\";i:99;s:9:\"Hong Kong\";i:100;s:7:\"Hungary\";i:101;s:7:\"Iceland\";i:102;s:5:\"India\";i:103;s:9:\"Indonesia\";i:104;s:25:\"Iran, Islamic Republic of\";i:105;s:4:\"Iraq\";i:106;s:7:\"Ireland\";i:107;s:11:\"Isle of Man\";i:108;s:6:\"Israel\";i:109;s:5:\"Italy\";i:110;s:7:\"Jamaica\";i:111;s:5:\"Japan\";i:112;s:6:\"Jersey\";i:113;s:6:\"Jordan\";i:114;s:10:\"Kazakhstan\";i:115;s:5:\"Kenya\";i:116;s:8:\"Kiribati\";i:117;s:38:\"Korea, Democratic People\'s Republic of\";i:118;s:18:\"Korea, Republic of\";i:119;s:6:\"Kuwait\";i:120;s:10:\"Kyrgyzstan\";i:121;s:32:\"Lao People\'s Democratic Republic\";i:122;s:6:\"Latvia\";i:123;s:7:\"Lebanon\";i:124;s:7:\"Lesotho\";i:125;s:7:\"Liberia\";i:126;s:5:\"Libya\";i:127;s:13:\"Liechtenstein\";i:128;s:9:\"Lithuania\";i:129;s:10:\"Luxembourg\";i:130;s:5:\"Macao\";i:131;s:42:\"Macedonia, The Former Yugoslav Republic of\";i:132;s:10:\"Madagascar\";i:133;s:6:\"Malawi\";i:134;s:8:\"Malaysia\";i:135;s:8:\"Maldives\";i:136;s:4:\"Mali\";i:137;s:5:\"Malta\";i:138;s:16:\"Marshall Islands\";i:139;s:10:\"Martinique\";i:140;s:10:\"Mauritania\";i:141;s:9:\"Mauritius\";i:142;s:7:\"Mayotte\";i:143;s:6:\"Mexico\";i:144;s:31:\"Micronesia, Federated States of\";i:145;s:20:\"Moldova, Republic of\";i:146;s:6:\"Monaco\";i:147;s:8:\"Mongolia\";i:148;s:10:\"Montenegro\";i:149;s:10:\"Montserrat\";i:150;s:7:\"Morocco\";i:151;s:10:\"Mozambique\";i:152;s:7:\"Myanmar\";i:153;s:7:\"Namibia\";i:154;s:5:\"Nauru\";i:155;s:5:\"Nepal\";i:156;s:11:\"Netherlands\";i:157;s:13:\"New Caledonia\";i:158;s:11:\"New Zealand\";i:159;s:9:\"Nicaragua\";i:160;s:5:\"Niger\";i:161;s:7:\"Nigeria\";i:162;s:4:\"Niue\";i:163;s:14:\"Norfolk Island\";i:164;s:24:\"Northern Mariana Islands\";i:165;s:6:\"Norway\";i:166;s:4:\"Oman\";i:167;s:8:\"Pakistan\";i:168;s:5:\"Palau\";i:169;s:21:\"Palestinian Territory\";i:170;s:6:\"Panama\";i:171;s:16:\"Papua New Guinea\";i:172;s:8:\"Paraguay\";i:173;s:4:\"Peru\";i:174;s:11:\"Philippines\";i:175;s:8:\"Pitcairn\";i:176;s:6:\"Poland\";i:177;s:8:\"Portugal\";i:178;s:11:\"Puerto Rico\";i:179;s:5:\"Qatar\";i:180;s:8:\"Réunion\";i:181;s:7:\"Romania\";i:182;s:18:\"Russian Federation\";i:183;s:6:\"Rwanda\";i:184;s:17:\"Saint Barthélemy\";i:185;s:44:\"Saint Helena, Ascension and Tristan da Cunha\";i:186;s:21:\"Saint Kitts and Nevis\";i:187;s:11:\"Saint Lucia\";i:188;s:26:\"Saint Martin (French part)\";i:189;s:25:\"Saint Pierre and Miquelon\";i:190;s:32:\"Saint Vincent and the Grenadines\";i:191;s:5:\"Samoa\";i:192;s:10:\"San Marino\";i:193;s:21:\"Sao Tome and Principe\";i:194;s:12:\"Saudi Arabia\";i:195;s:8:\"Scotland\";i:196;s:7:\"Senegal\";i:197;s:6:\"Serbia\";i:198;s:10:\"Seychelles\";i:199;s:12:\"Sierra Leone\";i:200;s:9:\"Singapore\";i:201;s:25:\"Sint Maarten (Dutch part)\";i:202;s:8:\"Slovakia\";i:203;s:8:\"Slovenia\";i:204;s:15:\"Solomon Islands\";i:205;s:7:\"Somalia\";i:206;s:12:\"South Africa\";i:207;s:44:\"South Georgia and the South Sandwich Islands\";i:208;s:11:\"South Sudan\";i:209;s:5:\"Spain\";i:210;s:9:\"Sri Lanka\";i:211;s:5:\"Sudan\";i:212;s:8:\"Suriname\";i:213;s:22:\"Svalbard and Jan Mayen\";i:214;s:9:\"Swaziland\";i:215;s:6:\"Sweden\";i:216;s:11:\"Switzerland\";i:217;s:20:\"Syrian Arab Republic\";i:218;s:25:\"Taiwan, Province of China\";i:219;s:10:\"Tajikistan\";i:220;s:28:\"Tanzania, United Republic of\";i:221;s:8:\"Thailand\";i:222;s:11:\"Timor-Leste\";i:223;s:4:\"Togo\";i:224;s:7:\"Tokelau\";i:225;s:5:\"Tonga\";i:226;s:19:\"Trinidad and Tobago\";i:227;s:7:\"Tunisia\";i:228;s:6:\"Turkey\";i:229;s:12:\"Turkmenistan\";i:230;s:24:\"Turks and Caicos Islands\";i:231;s:6:\"Tuvalu\";i:232;s:6:\"Uganda\";i:233;s:7:\"Ukraine\";i:234;s:20:\"United Arab Emirates\";i:235;s:14:\"United Kingdom\";i:236;s:13:\"United States\";i:237;s:36:\"United States Minor Outlying Islands\";i:238;s:7:\"Uruguay\";i:239;s:10:\"Uzbekistan\";i:240;s:7:\"Vanuatu\";i:241;s:33:\"Venezuela, Bolivarian Republic of\";i:242;s:8:\"Viet Nam\";i:243;s:23:\"Virgin Islands, British\";i:244;s:20:\"Virgin Islands, U.S.\";i:245;s:17:\"Wallis and Futuna\";i:246;s:14:\"Western Sahara\";i:247;s:5:\"Yemen\";i:248;s:6:\"Zambia\";i:249;s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:6:\"select\";s:3:\"woo\";s:1:\"0\";}s:6:\"social\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Social Profiles\";}s:8:\"facebook\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Facebook Page\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:7:\"twitter\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Twitter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"google_plus\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:7:\"Google+\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:8:\"user_url\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:13:\"Website (URL)\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:11:\"accountinfo\";a:3:{s:9:\"collapsed\";s:1:\"0\";s:11:\"collapsible\";s:1:\"1\";s:7:\"heading\";s:15:\"Account Details\";}s:10:\"user_email\";a:17:{s:9:\"ajaxcheck\";s:18:\"email_domain_check\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:14:\"E-mail Address\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"1\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:3:\"woo\";s:1:\"0\";}s:9:\"user_pass\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:5:\"label\";s:8:\"Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}s:17:\"user_pass_confirm\";a:17:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:21:\"Confirm your Password\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:4:\"type\";s:8:\"password\";s:3:\"woo\";s:1:\"0\";}s:16:\"passwordstrength\";a:23:{s:9:\"ajaxcheck\";s:0:\"\";s:4:\"help\";s:0:\"\";s:5:\"label\";s:23:\"Password Strength Meter\";s:11:\"placeholder\";s:0:\"\";s:13:\"add_condition\";s:4:\"show\";s:16:\"condition_fields\";s:12:\"display_name\";s:14:\"condition_rule\";s:6:\"select\";s:15:\"condition_value\";s:0:\"\";s:8:\"_builtin\";s:1:\"1\";s:4:\"good\";s:4:\"Good\";s:6:\"hidden\";s:1:\"0\";s:8:\"hideable\";s:1:\"0\";s:4:\"html\";s:1:\"0\";s:6:\"locked\";s:1:\"0\";s:7:\"private\";s:1:\"0\";s:8:\"required\";s:1:\"0\";s:6:\"strong\";s:6:\"Strong\";s:9:\"too_short\";s:18:\"Password too short\";s:4:\"type\";s:16:\"passwordstrength\";s:11:\"very_strong\";s:11:\"Very Strong\";s:9:\"very_weak\";s:9:\"Very Weak\";s:4:\"weak\";s:4:\"Weak\";s:3:\"woo\";s:1:\"0\";}}}}", "yes");
INSERT INTO wptz_options VALUES("2014", "userpro_fields_builtin", "a:31:{s:15:\"profile_privacy\";a:6:{s:8:\"_builtin\";i:0;s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:15:\"Profile Privacy\";s:7:\"options\";a:1:{s:7:\"privacy\";s:41:\"Hide the profile completely from everyone\";}s:4:\"help\";s:56:\"You can check this option to hide the profile completely\";s:6:\"hidden\";i:1;}s:7:\"youtube\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:11:\"Youtube Url\";s:4:\"icon\";s:7:\"youtube\";}s:9:\"recaptcha\";a:4:{s:8:\"_builtin\";i:1;s:7:\"sitekey\";s:0:\"\";s:4:\"type\";s:9:\"recaptcha\";s:5:\"label\";s:9:\"reCAPTCHA\";}s:9:\"instagram\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"Instagram Page\";}s:8:\"linkedin\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Linkedin Page\";}s:10:\"securityqa\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:10:\"securityqa\";s:5:\"label\";s:16:\"Are You A Human?\";}s:15:\"followers_email\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:9:\"followers\";s:5:\"label\";s:21:\"followers email alert\";s:13:\"follower_text\";s:48:\"Get email notifications when someone follows you\";}s:8:\"antispam\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"antispam\";s:5:\"label\";s:17:\"Antispam Question\";}s:19:\"mailchimp_subscribe\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:9:\"mailchimp\";s:5:\"label\";s:23:\"Subscribe to newsletter\";s:7:\"list_id\";s:0:\"\";s:9:\"list_text\";s:43:\"Get periodic e-mail updates and newsletters\";}s:20:\"envato_purchase_code\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Envato Purchase Code\";s:4:\"help\";s:39:\"Please enter your envato purchase code.\";s:6:\"hidden\";i:1;}s:17:\"custom_profile_bg\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:18:\"Profile Background\";s:4:\"help\";s:47:\"Add a custom profile background to your profile\";}s:20:\"custom_profile_color\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:13:\"Heading Color\";s:7:\"options\";a:3:{s:0:\"\";s:11:\"Choose Skin\";s:5:\"light\";s:5:\"Light\";s:4:\"dark\";s:4:\"Dark\";}s:7:\"default\";s:4:\"Dark\";s:4:\"help\";s:77:\"You can choose the style that matches your custom background (if you set one)\";}s:12:\"phone_number\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:12:\"Phone Number\";}s:10:\"first_name\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";}s:9:\"last_name\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";}s:12:\"display_name\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";}s:10:\"user_login\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:8:\"Username\";}s:10:\"user_email\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";}s:17:\"username_or_email\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:18:\"Username or E-mail\";}s:9:\"user_pass\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";}s:17:\"user_pass_confirm\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";}s:16:\"passwordstrength\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";}s:7:\"country\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";}s:4:\"role\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:4:\"Role\";s:7:\"options\";a:1:{i:0;s:0:\"\";}s:11:\"placeholder\";s:24:\"Select your account type\";}s:14:\"profilepicture\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";}s:6:\"gender\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}}s:11:\"description\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:9:\"Biography\";s:4:\"help\";s:18:\"Describe yourself.\";s:4:\"html\";i:1;}s:8:\"facebook\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";}s:7:\"twitter\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";}s:11:\"google_plus\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";}s:8:\"user_url\";a:3:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";}}", "yes");
INSERT INTO wptz_options VALUES("2011", "userpro_connections", "a:1:{s:11:\"connections\";i:384;}", "yes");
INSERT INTO wptz_options VALUES("2012", "userpro_pages", "a:6:{s:11:\"logout_page\";i:385;s:14:\"directory_page\";i:386;s:7:\"profile\";i:387;s:4:\"edit\";i:388;s:8:\"register\";i:389;s:5:\"login\";i:390;}", "yes");
INSERT INTO wptz_options VALUES("2013", "userpro_fields", "a:35:{s:14:\"title_position\";a:4:{s:8:\"_builtin\";i:0;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"Title/Position\";s:4:\"icon\";s:0:\"\";}s:19:\"agency_organization\";a:4:{s:8:\"_builtin\";i:0;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:19:\"Agency/Organization\";s:4:\"icon\";s:0:\"\";}s:14:\"title-position\";s:14:\"title-position\";s:10:\"agency-org\";s:10:\"agency-org\";s:15:\"profile_privacy\";a:7:{s:8:\"_builtin\";i:0;s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:15:\"Profile Privacy\";s:7:\"options\";a:1:{s:7:\"privacy\";s:41:\"Hide the profile completely from everyone\";}s:4:\"help\";s:56:\"You can check this option to hide the profile completely\";s:6:\"hidden\";i:1;s:4:\"icon\";s:0:\"\";}s:7:\"youtube\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:11:\"Youtube Url\";s:4:\"icon\";s:7:\"youtube\";}s:9:\"recaptcha\";a:5:{s:8:\"_builtin\";i:1;s:7:\"sitekey\";s:0:\"\";s:4:\"type\";s:9:\"recaptcha\";s:5:\"label\";s:9:\"reCAPTCHA\";s:4:\"icon\";s:0:\"\";}s:8:\"antispam\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"antispam\";s:5:\"label\";s:17:\"Antispam Question\";s:4:\"icon\";s:0:\"\";}s:9:\"instagram\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"Instagram Page\";s:4:\"icon\";s:9:\"instagram\";}s:8:\"linkedin\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Linkedin Page\";s:4:\"icon\";s:8:\"linkedin\";}s:10:\"securityqa\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:10:\"securityqa\";s:5:\"label\";s:16:\"Are You A Human?\";s:4:\"icon\";s:0:\"\";}s:15:\"followers_email\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:9:\"followers\";s:5:\"label\";s:21:\"followers email alert\";s:13:\"follower_text\";s:48:\"Get email notifications when someone follows you\";s:4:\"icon\";s:0:\"\";}s:19:\"mailchimp_subscribe\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:9:\"mailchimp\";s:5:\"label\";s:23:\"Subscribe to newsletter\";s:7:\"list_id\";s:0:\"\";s:9:\"list_text\";s:43:\"Get periodic e-mail updates and newsletters\";s:4:\"icon\";s:0:\"\";}s:20:\"envato_purchase_code\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Envato Purchase Code\";s:4:\"help\";s:39:\"Please enter your envato purchase code.\";s:6:\"hidden\";i:1;s:4:\"icon\";s:0:\"\";}s:17:\"custom_profile_bg\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:18:\"Profile Background\";s:4:\"help\";s:47:\"Add a custom profile background to your profile\";s:4:\"icon\";s:0:\"\";}s:20:\"custom_profile_color\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:13:\"Heading Color\";s:7:\"options\";a:3:{s:0:\"\";s:11:\"Choose Skin\";s:5:\"light\";s:5:\"Light\";s:4:\"dark\";s:4:\"Dark\";}s:7:\"default\";s:4:\"Dark\";s:4:\"help\";s:77:\"You can choose the style that matches your custom background (if you set one)\";s:4:\"icon\";s:0:\"\";}s:12:\"phone_number\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:12:\"Phone Number\";s:4:\"icon\";s:0:\"\";}s:10:\"first_name\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";s:4:\"icon\";s:0:\"\";}s:9:\"last_name\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";s:4:\"icon\";s:0:\"\";}s:12:\"display_name\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:4:\"icon\";s:0:\"\";}s:10:\"user_login\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:8:\"Username\";s:4:\"icon\";s:4:\"user\";}s:10:\"user_email\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:4:\"icon\";s:12:\"envelope-alt\";}s:17:\"username_or_email\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:18:\"Username or E-mail\";s:4:\"icon\";s:4:\"user\";}s:9:\"user_pass\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:4:\"icon\";s:4:\"lock\";}s:17:\"user_pass_confirm\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:4:\"icon\";s:0:\"\";}s:16:\"passwordstrength\";a:10:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:4:\"icon\";s:0:\"\";}s:7:\"country\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:4:\"icon\";s:10:\"map-marker\";}s:4:\"role\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:4:\"Role\";s:7:\"options\";a:1:{i:0;s:0:\"\";}s:11:\"placeholder\";s:24:\"Select your account type\";s:4:\"icon\";s:0:\"\";}s:14:\"profilepicture\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:4:\"icon\";s:6:\"camera\";}s:6:\"gender\";a:5:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:4:\"icon\";s:0:\"\";}s:11:\"description\";a:6:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:9:\"Biography\";s:4:\"help\";s:18:\"Describe yourself.\";s:4:\"html\";i:1;s:4:\"icon\";s:0:\"\";}s:8:\"facebook\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:4:\"icon\";s:8:\"facebook\";}s:7:\"twitter\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:4:\"icon\";s:7:\"twitter\";}s:11:\"google_plus\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:4:\"icon\";s:11:\"google-plus\";}s:8:\"user_url\";a:4:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:4:\"icon\";s:4:\"home\";}}", "yes");
INSERT INTO wptz_options VALUES("2005", "userpro_admins_got_verified", "1", "yes");
INSERT INTO wptz_options VALUES("2006", "widget_inviteuser_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("2007", "userpro_trial", "0", "yes");
INSERT INTO wptz_options VALUES("2008", "userpro", "a:238:{s:30:\"userpro_invite_emails_template\";s:66:\"You are invited <a href=\"{invitelink}\"> Click here to register</a>\";s:14:\"slug_followers\";s:9:\"followers\";s:14:\"slug_following\";s:9:\"following\";s:16:\"slug_connections\";s:11:\"connections\";s:11:\"slug_logout\";s:6:\"logout\";s:14:\"slug_directory\";s:7:\"members\";s:4:\"slug\";s:7:\"profile\";s:9:\"slug_edit\";s:4:\"edit\";s:13:\"slug_register\";s:8:\"register\";s:10:\"slug_login\";s:5:\"login\";s:12:\"userpro_code\";s:36:\"c1082901-6266-4472-8cb3-c3ffcfd6229b\";s:17:\"mailster_activate\";s:0:\"\";s:14:\"mail_from_name\";s:47:\"California School Resource Officers Association\";s:9:\"mail_from\";s:14:\"info@csroa.org\";s:21:\"new_user_notification\";s:1:\"1\";s:25:\"enable_html_notifications\";s:1:\"1\";s:27:\"notify_user_password_update\";s:1:\"1\";s:20:\"enable_reset_by_mail\";s:1:\"y\";s:20:\"notify_user_verified\";s:1:\"1\";s:22:\"notify_user_unverified\";s:1:\"1\";s:22:\"notify_account_blocked\";s:1:\"1\";s:39:\"notify_account_pendingfor_adminapproval\";s:1:\"1\";s:26:\"notify_admin_email_approve\";s:1:\"1\";s:24:\"notify_account_unblocked\";s:1:\"1\";s:25:\"notify_admin_profile_save\";s:1:\"1\";s:27:\"notify_admin_profile_remove\";s:1:\"1\";s:29:\"notify_admin_new_registration\";s:1:\"1\";s:27:\"mail_admin_pendingapprove_s\";s:37:\"[UserPro] User awaiting manual review\";s:25:\"mail_admin_pendingapprove\";s:337:\"Hi there,\r\n\r\n{USERPRO_USERNAME} has just created a new account at {USERPRO_BLOGNAME}. The account is pending your manual review.\r\n\r\nTo approve/reject new user registrations, please click the following link:\r\n{USERPRO_PENDING_REQUESTS_URL}\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:23:\"mail_admin_newaccount_s\";s:31:\"[UserPro] New User Registration\";s:21:\"mail_admin_newaccount\";s:261:\"Hi there,\r\n\r\n{USERPRO_USERNAME} has just created a new account at {USERPRO_BLOGNAME}.\r\n\r\nYou can check his profile via the following link:\r\n{USERPRO_PROFILE_LINK}\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:26:\"mail_admin_profileupdate_s\";s:37:\"[UserPro] A profile has been updated!\";s:24:\"mail_admin_profileupdate\";s:236:\"Hi there,\r\n\r\n{USERPRO_USERNAME} has just updated their profile at {USERPRO_BLOGNAME}.\r\n\r\nTo view his/her profile:\r\n{USERPRO_PROFILE_LINK}\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:27:\"mail_admin_accountdeleted_s\";s:37:\"[UserPro] A profile has been removed!\";s:25:\"mail_admin_accountdeleted\";s:192:\"Hi there,\r\n\r\n{USERPRO_USERNAME}&#039;s profile has been just deleted from {USERPRO_BLOGNAME}.\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:25:\"mail_admin_verify_request\";s:24:\"New verification Request\";s:26:\"mail_admin_verify_requests\";s:271:\"Hi there,\r\n\r\n{USERPRO_USERNAME} has just sent you account verify request at {USERPRO_BLOGNAME}.\r\n\r\nYou can check his profile via the following link:\r\n{USERPRO_PROFILE_LINK}\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:30:\"mail_verifyemail_waiting_admin\";s:62:\"[UserPro]New Registration - Pending email verification by user\";s:22:\"mail_verifyemail_admin\";s:227:\"Hi there,\r\n\r\n{USERPRO_USERNAME} has just created a new account at {USERPRO_BLOGNAME}. The account is pending email verification.\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:18:\"mail_verifyemail_s\";s:19:\"Verify your Account\";s:16:\"mail_verifyemail\";s:306:\"Hi there,\r\n\r\nThanks for signing up at {USERPRO_BLOGNAME}. You must confirm/validate your account before logging in.\r\n\r\nPlease click on the following link to successfully activate your account:\r\n{USERPRO_VALIDATE_URL}\r\n\r\nIf you have any problems, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:25:\"mail_verifyemail_change_s\";s:40:\"Reverify your Account after Email change\";s:23:\"mail_verifyemail_change\";s:320:\"Hi there,\r\n\r\nYou have changed your email address at {USERPRO_BLOGNAME}. You must confirm/validate your account before logging in.\r\n\r\nPlease click on the following link to successfully activate your account:\r\n{USERPRO_VALIDATE_URL}\r\n\r\nIf you have any problems, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:17:\"mail_newaccount_s\";s:59:\"Welcome to California School Resource Officers Association!\";s:15:\"mail_newaccount\";s:333:\"Hi there,\r\n\r\nThanks for registering. Your account is now active.\r\n\r\nTo login please visit the following URL:\r\n{USERPRO_LOGIN_URL}\r\n\r\nYour account e-mail: {USERPRO_EMAIL}\r\nYour account username: {USERPRO_USERNAME}\r\nYour account password: {VAR1}\r\n\r\nIf you have any problems, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:16:\"mail_secretkey_s\";s:19:\"Reset Your Password\";s:14:\"mail_secretkey\";s:383:\"Hi there,\r\n\r\nYou or someone else has requested to change password for this account.\r\n\r\nThe following key was generated to you to be able to change your passsword. Login to our site and attempt to Change your Password and use that key to change your password successfully.\r\n\r\nSecret Key: {VAR1}\r\n\r\nIf you have any problems, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:21:\"reset_password_mail_s\";s:19:\"Reset your password\";s:21:\"reset_password_mail_c\";s:152:\"Hi there,\r\n\r\nPlease click below link to reset your password,\r\n\r\n&lt;a href=&quot;{USERPRO_LOGIN_URL}?a=reset&amp;sk={VAR1}&quot;&gt;Click here&lt;/a&gt;\";s:22:\"mail_password_change_s\";s:16:\"Password Updated\";s:20:\"mail_password_change\";s:161:\"Hi there,\r\n\r\nYour password has been updated\r\n\r\nYour new Password:{VAR1}\r\n\r\nIf you have any problems, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:21:\"mail_accountdeleted_s\";s:30:\"Your profile has been removed!\";s:19:\"mail_accountdeleted\";s:166:\"Hi there,\r\n\r\nYour account has been deleted from {USERPRO_BLOGNAME}.\r\n\r\nIf you have any further questions, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:22:\"mail_accountverified_s\";s:29:\"Your account is now verified!\";s:20:\"mail_accountverified\";s:163:\"Hi there,\r\n\r\nYour account is now verified at {USERPRO_BLOGNAME}.\r\n\r\nIf you have any further questions, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:24:\"mail_accountunverified_s\";s:35:\"Your account is no longer verified!\";s:22:\"mail_accountunverified\";s:183:\"Hi there,\r\n\r\nWe apologize. Your account is no longer verified at {USERPRO_BLOGNAME}.\r\n\r\nIf you have any further questions, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:26:\"pending_for_admin_approval\";s:41:\"Your account is Pending for Manual Review\";s:30:\"pending_for_admin_approval_txt\";s:163:\"Hi there,\r\n\r\nYour account is currently being reviewed at {USERPRO_BLOGNAME}.\r\n\r\nIf you have any query, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:21:\"mail_accountblocked_s\";s:28:\"Your account is now blocked!\";s:19:\"mail_accountblocked\";s:150:\"Hi there,\r\n\r\nYour account is now blocked at {USERPRO_BLOGNAME}.\r\n\r\nIf you have any query, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:23:\"mail_accountunblocked_s\";s:30:\"Your account is now unblocked!\";s:21:\"mail_accountunblocked\";s:130:\"Hi there,\r\n\r\nYour account is now unblocked.\r\n\r\nIf you have any query, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:30:\"mail_userpro_connect_request_s\";s:20:\"New Connect Request!\";s:28:\"mail_userpro_connect_request\";s:264:\"Hi there,\r\n\r\n{USERPRO_USERNAME} has just sent you connect request at {USERPRO_BLOGNAME}.\r\n\r\nYou can check his profile via the following link:\r\n{USERPRO_PROFILE_LINK}\r\n\r\nThis is an automated notification that was sent to you by UserPro. No further action is needed.\";s:19:\"mail_verifyinvite_s\";s:64:\"Get Verified at California School Resource Officers Association!\";s:17:\"mail_verifyinvite\";s:390:\"Hi there,\r\n\r\nThis is an invitation to get verified at {USERPRO_BLOGNAME}.\r\n\r\nTo accept this invitation and get verified instantly, please click the following link:\r\n{USERPRO_ACCEPT_VERIFY_INVITE}\r\n\r\nIf you do not want to GET VERIFIED, please ignore this email. No further action is required.\r\n\r\nIf you have any further questions, please contact us at {USERPRO_ADMIN_EMAIL}.\r\n\r\nBest Regards!\";s:20:\"title-position_roles\";a:8:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:4;s:10:\"subscriber\";i:5;s:21:\"ai1ec_event_assistant\";i:6;s:13:\"wpseo_manager\";i:7;s:12:\"wpseo_editor\";}s:16:\"agency-org_roles\";a:8:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:4;s:10:\"subscriber\";i:5;s:21:\"ai1ec_event_assistant\";i:6;s:13:\"wpseo_manager\";i:7;s:12:\"wpseo_editor\";}s:21:\"profile_privacy_roles\";s:0:\"\";s:13:\"youtube_roles\";s:0:\"\";s:15:\"recaptcha_roles\";s:0:\"\";s:14:\"antispam_roles\";s:0:\"\";s:15:\"instagram_roles\";s:0:\"\";s:14:\"linkedin_roles\";s:0:\"\";s:16:\"securityqa_roles\";s:0:\"\";s:21:\"followers_email_roles\";s:0:\"\";s:25:\"mailchimp_subscribe_roles\";s:0:\"\";s:26:\"envato_purchase_code_roles\";s:0:\"\";s:23:\"custom_profile_bg_roles\";s:0:\"\";s:26:\"custom_profile_color_roles\";s:0:\"\";s:18:\"phone_number_roles\";s:0:\"\";s:16:\"first_name_roles\";s:0:\"\";s:15:\"last_name_roles\";s:0:\"\";s:18:\"display_name_roles\";s:0:\"\";s:16:\"user_login_roles\";s:0:\"\";s:16:\"user_email_roles\";s:0:\"\";s:23:\"username_or_email_roles\";s:0:\"\";s:15:\"user_pass_roles\";s:0:\"\";s:23:\"user_pass_confirm_roles\";s:0:\"\";s:22:\"passwordstrength_roles\";s:0:\"\";s:13:\"country_roles\";s:0:\"\";s:10:\"role_roles\";s:0:\"\";s:20:\"profilepicture_roles\";s:0:\"\";s:12:\"gender_roles\";s:0:\"\";s:17:\"description_roles\";s:0:\"\";s:14:\"facebook_roles\";s:0:\"\";s:13:\"twitter_roles\";s:0:\"\";s:17:\"google_plus_roles\";s:0:\"\";s:14:\"user_url_roles\";s:0:\"\";s:24:\"up_delete_cache_interval\";s:2:\"30\";s:15:\"modstate_social\";s:1:\"1\";s:15:\"modstate_online\";s:1:\"0\";s:20:\"modstate_showoffline\";s:1:\"0\";s:17:\"hide_online_admin\";s:1:\"0\";s:5:\"ppfix\";s:1:\"a\";s:4:\"pimg\";s:1:\"0\";s:20:\"disable_activity_log\";s:1:\"0\";s:23:\"allow_dash_display_name\";s:1:\"0\";s:12:\"use_relative\";s:8:\"relative\";s:19:\"picture_save_method\";s:8:\"internal\";s:11:\"twitter_fix\";s:1:\"b\";s:3:\"rtl\";s:1:\"0\";s:18:\"users_can_register\";s:1:\"1\";s:18:\"enable_post_editor\";s:1:\"n\";s:14:\"enable_connect\";s:1:\"n\";s:20:\"enable_save_as_draft\";s:1:\"n\";s:13:\"users_approve\";s:1:\"1\";s:14:\"permalink_type\";s:8:\"username\";s:17:\"user_display_name\";s:12:\"display_name\";s:11:\"date_format\";s:8:\"dd-mm-yy\";s:21:\"user_display_name_key\";s:0:\"\";s:16:\"hidden_from_view\";s:171:\"display_name,profilepicture,facebook,twitter,google_plus,user_email,user_url,phone_number,custom_profile_color,custom_profile_bg,securityqa,instagram,linkedin,youtube,tags\";s:22:\"unverify_on_namechange\";s:1:\"1\";s:22:\"verified_badge_by_name\";s:1:\"1\";s:13:\"verified_link\";s:0:\"\";s:21:\"instant_publish_roles\";s:0:\"\";s:8:\"lightbox\";s:1:\"1\";s:21:\"userpro_enable_webcam\";s:1:\"0\";s:13:\"max_file_size\";s:7:\"8388608\";s:12:\"aspect_ratio\";s:1:\"1\";s:11:\"show_filter\";s:1:\"1\";s:19:\"categorie_selection\";s:1:\"1\";s:16:\"limit_categories\";s:0:\"\";s:11:\"sociallogin\";s:1:\"1\";s:23:\"alphabetical_pagination\";s:1:\"1\";s:23:\"restricted_content_text\";s:129:\"You cannot view this content because It is available to members only. Please {LOGIN_POPUP} or {REGISTER_POPUP} to view this area.\";s:19:\"up_conditional_menu\";s:1:\"0\";s:10:\"googlefont\";s:6:\"Roboto\";s:10:\"customfont\";s:0:\"\";s:5:\"width\";s:5:\"480px\";s:4:\"skin\";s:7:\"elegant\";s:11:\"thumb_style\";s:7:\"default\";s:16:\"profile_lightbox\";s:1:\"1\";s:6:\"layout\";s:5:\"float\";s:11:\"field_icons\";s:1:\"1\";s:14:\"hide_admin_bar\";s:1:\"1\";s:13:\"heading_light\";s:5:\"Light\";s:23:\"max_field_length_active\";s:1:\"1\";s:16:\"max_field_length\";s:2:\"36\";s:24:\"max_field_length_include\";s:44:\"user_login,first_name,last_name,display_name\";s:11:\"phonefields\";s:12:\"phone_number\";s:17:\"phonefields_regex\";s:24:\"/^\\(?\\+?[\\d\\(\\-\\s\\)]+$/i\";s:28:\"mailchimp_checkbox_condition\";s:1:\"1\";s:23:\"min_field_length_active\";s:1:\"1\";s:16:\"min_field_length\";s:1:\"1\";s:24:\"min_field_length_include\";s:44:\"user_login,first_name,last_name,display_name\";s:16:\"up_modern_layout\";s:1:\"0\";s:26:\"allow_guests_view_profiles\";s:1:\"1\";s:25:\"allow_users_view_profiles\";s:1:\"1\";s:26:\"upgrade_role_after_verfied\";s:4:\"none\";s:26:\"allow_users_verify_request\";s:1:\"1\";s:23:\"user_can_delete_profile\";s:1:\"1\";s:19:\"use_default_avatars\";s:1:\"0\";s:18:\"admin_user_notices\";s:1:\"1\";s:21:\"show_user_notices_him\";s:1:\"1\";s:17:\"show_user_notices\";s:1:\"1\";s:20:\"show_flag_in_profile\";s:1:\"1\";s:19:\"show_flag_in_badges\";s:1:\"1\";s:19:\"show_badges_profile\";s:1:\"1\";s:22:\"default_background_img\";s:0:\"\";s:17:\"userpro_panic_key\";s:9:\"xZaejn123\";s:31:\"allow_dashboard_for_these_roles\";s:0:\"\";s:20:\"backend_users_change\";s:1:\"0\";s:26:\"redirect_author_to_profile\";s:1:\"0\";s:24:\"dashboard_redirect_users\";s:1:\"0\";s:28:\"dashboard_redirect_users_url\";s:0:\"\";s:22:\"profile_redirect_users\";s:1:\"0\";s:26:\"profile_redirect_users_url\";s:0:\"\";s:23:\"register_redirect_users\";s:1:\"0\";s:27:\"register_redirect_users_url\";s:0:\"\";s:20:\"login_redirect_users\";s:1:\"0\";s:24:\"login_redirect_users_url\";s:0:\"\";s:17:\"show_logout_login\";s:1:\"1\";s:11:\"after_login\";s:7:\"profile\";s:22:\"show_admin_after_login\";s:1:\"1\";s:20:\"show_logout_register\";s:1:\"1\";s:24:\"after_register_autologin\";s:1:\"1\";s:14:\"after_register\";s:7:\"profile\";s:11:\"update_role\";s:7:\"no_role\";s:12:\"default_role\";s:10:\"subscriber\";s:13:\"allowed_roles\";a:1:{i:0;s:10:\"subscriber\";}s:11:\"terms_agree\";s:1:\"1\";s:16:\"terms_agree_text\";s:141:\"To complete registration, you must read and agree to our &lt;a href=&quot;#&quot;&gt;terms and conditions&lt;/a&gt;. This text can be custom.\";s:27:\"userpro_allow_email_domains\";s:0:\"\";s:27:\"userpro_block_email_domains\";s:0:\"\";s:10:\"logout_uri\";s:1:\"1\";s:17:\"logout_uri_custom\";s:0:\"\";s:16:\"reset_admin_pass\";s:1:\"1\";s:16:\"facebook_connect\";s:1:\"1\";s:15:\"facebook_app_id\";s:0:\"\";s:25:\"facebook_publish_autopost\";s:1:\"0\";s:30:\"facebook_publish_autopost_name\";s:0:\"\";s:33:\"facebook_publish_autopost_caption\";s:0:\"\";s:30:\"facebook_publish_autopost_body\";s:0:\"\";s:37:\"facebook_publish_autopost_description\";s:0:\"\";s:30:\"facebook_publish_autopost_link\";s:0:\"\";s:24:\"facebook_follow_autopost\";s:1:\"0\";s:29:\"facebook_follow_autopost_name\";s:0:\"\";s:32:\"facebook_follow_autopost_caption\";s:0:\"\";s:29:\"facebook_follow_autopost_body\";s:0:\"\";s:36:\"facebook_follow_autopost_description\";s:0:\"\";s:29:\"facebook_follow_autopost_link\";s:0:\"\";s:16:\"linkedin_connect\";s:1:\"1\";s:16:\"linkedin_app_key\";s:0:\"\";s:19:\"linkedin_Secret_Key\";s:0:\"\";s:17:\"instagram_connect\";s:1:\"1\";s:17:\"instagram_app_key\";s:0:\"\";s:20:\"instagram_Secret_Key\";s:0:\"\";s:15:\"twitter_connect\";s:1:\"1\";s:20:\"twitter_consumer_key\";s:0:\"\";s:23:\"twitter_consumer_secret\";s:0:\"\";s:16:\"twitter_autopost\";s:1:\"0\";s:20:\"twitter_autopost_msg\";s:0:\"\";s:23:\"twitter_signup_redirect\";s:0:\"\";s:23:\"twitter_signin_redirect\";s:0:\"\";s:14:\"google_connect\";s:1:\"1\";s:16:\"google_client_id\";s:0:\"\";s:20:\"google_client_secret\";s:0:\"\";s:19:\"google_redirect_uri\";s:31:\"https://csroa.org/?upslug=gplus\";s:22:\"google_signup_redirect\";s:0:\"\";s:22:\"google_signin_redirect\";s:0:\"\";s:28:\"buddypress_userpro_link_sync\";s:1:\"0\";s:30:\"buddypress_userpro_avatar_sync\";s:1:\"0\";s:35:\"buddypress_userpro_displayname_sync\";s:1:\"0\";s:25:\"bbpress_userpro_link_sync\";s:1:\"0\";s:10:\"envato_api\";s:32:\"szn7ghunkp7whgo314499ag6snadp3ns\";s:15:\"envato_username\";s:8:\"lwolfe63\";}", "yes");
INSERT INTO wptz_options VALUES("2009", "userpro_invite_check", "1", "yes");
INSERT INTO wptz_options VALUES("22715", "classic-editor-replace", "replace", "yes");
INSERT INTO wptz_options VALUES("17769", "userpro_activity", "a:48:{i:32;a:1:{i:1536139079;a:3:{s:7:\"user_id\";i:32;s:6:\"status\";s:826:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/jamcclelland/\"><img src=\"https://csroa.org/wp-content/uploads/bfi_thumb/5b9001a025d26-nvojc48clmz05lu3hv8094n9darie4o2n4qyufc6t8.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"modified avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/jamcclelland/\" title=\"View Profile\">Jo Anne McClelland</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536139079;}}i:33;a:1:{i:1536143154;a:3:{s:7:\"user_id\";i:33;s:6:\"status\";s:769:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/jcosner/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/jcosner/\" title=\"View Profile\">jcosner</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536143154;}}i:34;a:1:{i:1536154244;a:3:{s:7:\"user_id\";i:34;s:6:\"status\";s:582:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/miriamhogg1/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/miriamhogg1/\" title=\"View Profile\">miriamhogg1</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536154244;}}i:35;a:1:{i:1536200618;a:3:{s:7:\"user_id\";i:35;s:6:\"status\";s:572:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/honga42/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/honga42/\" title=\"View Profile\">honga42</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536200618;}}i:36;a:1:{i:1536233747;a:3:{s:7:\"user_id\";i:36;s:6:\"status\";s:784:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/officer_tray/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/officer_tray/\" title=\"View Profile\">officer_tray</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536233747;}}i:37;a:1:{i:1536401600;a:3:{s:7:\"user_id\";i:37;s:6:\"status\";s:766:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/djames/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/djames/\" title=\"View Profile\">djames</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536401600;}}i:1;a:2:{i:1536792692;a:3:{s:7:\"user_id\";i:1;s:6:\"status\";s:874:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/lwolfe63/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/lwolfe63/\" title=\"View Profile\">lwolfe63</a><img class=\"userpro-profile-badge-right userpro-profile-badge-verified\" src=\"https://csroa.org/wp-content/plugins/userpro/img/badges/badge-verified.png\" alt=\"\" title=\"Verified Account\" /><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has published a <a href=\"https://csroa.org/forums/forum/csroa-forum/\">new forum</a>.<span class=\"userpro-sc-i-sp\">\"CSROA Forum\"</span></span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536792692;}i:1536792729;a:3:{s:7:\"user_id\";i:1;s:6:\"status\";s:868:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/lwolfe63/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/lwolfe63/\" title=\"View Profile\">lwolfe63</a><img class=\"userpro-profile-badge-right userpro-profile-badge-verified\" src=\"https://csroa.org/wp-content/plugins/userpro/img/badges/badge-verified.png\" alt=\"\" title=\"Verified Account\" /><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has updated a <a href=\"https://csroa.org/forums/forum/csroa-forum/\">forum</a>.<span class=\"userpro-sc-i-sp\">\"CSROA Forum\"</span></span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1536792729;}}i:38;a:1:{i:1537190984;a:3:{s:7:\"user_id\";i:38;s:6:\"status\";s:593:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/subscribetome/\"><img src=\"https://csroa.org/wp-content/uploads/userpro/38/5ba00eb862596.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"modified avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/subscribetome/\" title=\"View Profile\">subscribetome@cryp.email</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537190984;}}i:39;a:1:{i:1537269225;a:3:{s:7:\"user_id\";i:39;s:6:\"status\";s:567:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/hector/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/hector/\" title=\"View Profile\">hector</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537269225;}}i:40;a:2:{i:1537281858;a:3:{s:7:\"user_id\";i:40;s:6:\"status\";s:784:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/redwoodlake1/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/redwoodlake1/\" title=\"View Profile\">redwoodlake1</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537281858;}i:1538597157;a:3:{s:7:\"user_id\";s:2:\"40\";s:6:\"status\";s:977:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/redwoodlake1/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/redwoodlake1/\" title=\"View Profile\">redwoodlake1</a><img class=\"userpro-profile-badge-right userpro-profile-badge-verified\" src=\"https://csroa.org/wp-content/plugins/userpro/img/badges/badge-verified.png\" alt=\"\" title=\"Verified Account\" /><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">is now a verified account.</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538597157;}}i:41;a:1:{i:1537433321;a:3:{s:7:\"user_id\";i:41;s:6:\"status\";s:573:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/cmtframe/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/cmtframe/\" title=\"View Profile\">cmtframe</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537433321;}}i:42;a:1:{i:1537433488;a:3:{s:7:\"user_id\";i:42;s:6:\"status\";s:570:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/smaffey/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/smaffey/\" title=\"View Profile\">smaffey</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537433488;}}i:43;a:1:{i:1537438580;a:3:{s:7:\"user_id\";i:43;s:6:\"status\";s:576:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/mcdearmid/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/mcdearmid/\" title=\"View Profile\">mcdearmid</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537438580;}}i:31;a:1:{i:1537449373;a:3:{s:7:\"user_id\";s:2:\"31\";s:6:\"status\";s:757:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/craig/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/craig/\" title=\"View Profile\">craig</a><img class=\"userpro-profile-badge-right userpro-profile-badge-verified\" src=\"https://csroa.org/wp-content/plugins/userpro/img/badges/badge-verified.png\" alt=\"\" title=\"Verified Account\" /><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">is now a verified account.</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537449373;}}i:44;a:1:{i:1537797065;a:3:{s:7:\"user_id\";i:44;s:6:\"status\";s:573:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/dramirez/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/dramirez/\" title=\"View Profile\">dramirez</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537797065;}}i:45;a:1:{i:1537996413;a:3:{s:7:\"user_id\";i:45;s:6:\"status\";s:570:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/meems95/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/meems95/\" title=\"View Profile\">meems95</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1537996413;}}i:46;a:1:{i:1538039857;a:3:{s:7:\"user_id\";i:46;s:6:\"status\";s:567:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/leenjd/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/leenjd/\" title=\"View Profile\">leenjd</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538039857;}}i:47;a:1:{i:1538052667;a:3:{s:7:\"user_id\";i:47;s:6:\"status\";s:772:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/berumenm/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/berumenm/\" title=\"View Profile\">Margie</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538052667;}}i:48;a:1:{i:1538401561;a:3:{s:7:\"user_id\";i:48;s:6:\"status\";s:771:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/tammywm/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/tammywm/\" title=\"View Profile\">tammywm</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538401561;}}i:49;a:1:{i:1538429857;a:3:{s:7:\"user_id\";i:49;s:6:\"status\";s:585:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/wharveyamoke/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/wharveyamoke/\" title=\"View Profile\">wharveyamoke</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538429857;}}i:50;a:1:{i:1538492038;a:3:{s:7:\"user_id\";i:50;s:6:\"status\";s:786:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/mguerrero24/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/mguerrero24/\" title=\"View Profile\">Miguel AGuerrero</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538492038;}}i:51;a:2:{i:1538499397;a:3:{s:7:\"user_id\";i:51;s:6:\"status\";s:771:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/kpoulos/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/kpoulos/\" title=\"View Profile\">kpoulos</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538499397;}i:1538597107;a:3:{s:7:\"user_id\";s:2:\"51\";s:6:\"status\";s:964:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/kpoulos/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/kpoulos/\" title=\"View Profile\">kpoulos</a><img class=\"userpro-profile-badge-right userpro-profile-badge-verified\" src=\"https://csroa.org/wp-content/plugins/userpro/img/badges/badge-verified.png\" alt=\"\" title=\"Verified Account\" /><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">is now a verified account.</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538597107;}}i:30;a:1:{i:1538597164;a:3:{s:7:\"user_id\";s:2:\"30\";s:6:\"status\";s:1016:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/nikesoccerislife/\"><img src=\"https://csroa.org/wp-content/uploads/bfi_thumb/5b85cc773d407-nvb25b9fxa8ekzced8tc0be1d4f635nxih4203jkz4.png\" width=\"50\" height=\"50\" alt=\"\" class=\"modified avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/nikesoccerislife/\" title=\"View Profile\">BBoyles</a><img class=\"userpro-profile-badge-right userpro-profile-badge-verified\" src=\"https://csroa.org/wp-content/plugins/userpro/img/badges/badge-verified.png\" alt=\"\" title=\"Verified Account\" /><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">is now a verified account.</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538597164;}}i:52;a:1:{i:1538641586;a:3:{s:7:\"user_id\";i:52;s:6:\"status\";s:779:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/amaggay/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/amaggay/\" title=\"View Profile\">Adreinne Maggay</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538641586;}}i:53;a:1:{i:1538643189;a:3:{s:7:\"user_id\";i:53;s:6:\"status\";s:823:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/christopher1/\"><img src=\"https://csroa.org/wp-content/uploads/bfi_thumb/5bb6367486b83-nx2zctt1gardbyilfb5tdjkwm5a2xhodrsz9ncmz8w.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"modified avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/christopher1/\" title=\"View Profile\">Christopher Day</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538643189;}}i:54;a:1:{i:1538647886;a:3:{s:7:\"user_id\";i:54;s:6:\"status\";s:778:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/zumbaking/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/zumbaking/\" title=\"View Profile\">Deputy Ellis</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538647886;}}i:55;a:1:{i:1538733703;a:3:{s:7:\"user_id\";i:55;s:6:\"status\";s:774:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/meltread/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/meltread/\" title=\"View Profile\">meltread</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538733703;}}i:56;a:1:{i:1538734795;a:3:{s:7:\"user_id\";i:56;s:6:\"status\";s:585:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/safetyfirst4/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/safetyfirst4/\" title=\"View Profile\">safetyfirst4</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538734795;}}i:57;a:1:{i:1538904433;a:3:{s:7:\"user_id\";i:57;s:6:\"status\";s:787:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/waffleiron636/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/waffleiron636/\" title=\"View Profile\">waffleiron636</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1538904433;}}i:58;a:1:{i:1539078331;a:3:{s:7:\"user_id\";i:58;s:6:\"status\";s:575:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/wariga70/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/wariga70/\" title=\"View Profile\">wariga70</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1539078331;}}i:59;a:1:{i:1539098240;a:3:{s:7:\"user_id\";i:59;s:6:\"status\";s:765:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/osaki85/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/osaki85/\" title=\"View Profile\">osaki85</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/afghanistan.png\" alt=\"\" title=\"Afghanistan\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1539098240;}}i:60;a:1:{i:1540213857;a:3:{s:7:\"user_id\";i:60;s:6:\"status\";s:783:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/dhansen4425/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/dhansen4425/\" title=\"View Profile\">Daniel Hansen</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1540213857;}}i:61;a:1:{i:1540217671;a:3:{s:7:\"user_id\";i:61;s:6:\"status\";s:591:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/meaganforsberg/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/meaganforsberg/\" title=\"View Profile\">meaganforsberg</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1540217671;}}i:62;a:1:{i:1540726878;a:3:{s:7:\"user_id\";i:62;s:6:\"status\";s:792:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/wheatcheckgeld44/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/wheatcheckgeld44/\" title=\"View Profile\">wheatcheckgeld44</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/afghanistan.png\" alt=\"\" title=\"Afghanistan\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1540726878;}}i:63;a:1:{i:1540804998;a:3:{s:7:\"user_id\";i:63;s:6:\"status\";s:773:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/bullock/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/bullock/\" title=\"View Profile\">Jim Bullock</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1540804998;}}i:64;a:1:{i:1541148554;a:3:{s:7:\"user_id\";i:64;s:6:\"status\";s:576:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/brmaberry/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/brmaberry/\" title=\"View Profile\">brmaberry</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1541148554;}}i:65;a:1:{i:1541589351;a:3:{s:7:\"user_id\";i:65;s:6:\"status\";s:781:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/humberto/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/humberto/\" title=\"View Profile\">Humberto Coronado</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1541589351;}}i:66;a:1:{i:1543918398;a:3:{s:7:\"user_id\";i:66;s:6:\"status\";s:773:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/srogreen/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/srogreen/\" title=\"View Profile\">SRO Green</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1543918398;}}i:67;a:1:{i:1544084365;a:3:{s:7:\"user_id\";i:67;s:6:\"status\";s:585:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/slotownrocks/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/slotownrocks/\" title=\"View Profile\">slotownrocks</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544084365;}}i:68;a:1:{i:1544084535;a:3:{s:7:\"user_id\";i:68;s:6:\"status\";s:579:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/erouanzoin/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/erouanzoin/\" title=\"View Profile\">erouanzoin</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544084535;}}i:69;a:1:{i:1544091534;a:3:{s:7:\"user_id\";i:69;s:6:\"status\";s:773:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/tminjares/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/tminjares/\" title=\"View Profile\">Traci</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544091534;}}i:70;a:1:{i:1544271565;a:3:{s:7:\"user_id\";i:70;s:6:\"status\";s:568:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/bcarr/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/bcarr/\" title=\"View Profile\">DrBCarr</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544271565;}}i:71;a:1:{i:1544272368;a:3:{s:7:\"user_id\";i:71;s:6:\"status\";s:763:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/aleon/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/aleon/\" title=\"View Profile\">ALEON</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544272368;}}i:72;a:1:{i:1544274403;a:3:{s:7:\"user_id\";i:72;s:6:\"status\";s:778:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/wallacek/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_female.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/wallacek/\" title=\"View Profile\">Katy Wallace</a><span class=\"userpro-badges\"><img class=\"userpro-profile-badge userpro-profile-badge-country userpro-flag-small\" src=\"https://csroa.org/wp-content/plugins/userpro/img/flags/mini/united-states.png\" alt=\"\" title=\"United States\" /></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544274403;}}i:73;a:1:{i:1544277090;a:3:{s:7:\"user_id\";i:73;s:6:\"status\";s:570:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/dmcphee/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/dmcphee/\" title=\"View Profile\">dmcphee</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544277090;}}i:74;a:1:{i:1544277565;a:3:{s:7:\"user_id\";i:74;s:6:\"status\";s:594:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/bommersbachpaul/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/bommersbachpaul/\" title=\"View Profile\">bommersbachpaul</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544277565;}}i:75;a:1:{i:1544451506;a:3:{s:7:\"user_id\";i:75;s:6:\"status\";s:573:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/jjrr2468/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/jjrr2468/\" title=\"View Profile\">jjrr2468</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544451506;}}i:76;a:1:{i:1544520583;a:3:{s:7:\"user_id\";i:76;s:6:\"status\";s:585:\"<div class=\"userpro-sc-img\" data-key=\"profilepicture\"><a href=\"https://csroa.org/profile/wallpaperbri/\"><img src=\"https://csroa.org/wp-content/plugins/userpro/img/default_avatar_male.jpg\" width=\"50\" height=\"50\" alt=\"\" class=\"default avatar\" /></a></div><div class=\"userpro-sc-i\"><div class=\"userpro-sc-i-name\"><a href=\"https://csroa.org/profile/wallpaperbri/\" title=\"View Profile\">wallpaperbri</a><span class=\"userpro-badges\"></span><span class=\"userpro-sc-i-info\">has just registered!</span></div><div class=\"userpro-sc-i-time\">{timestamp}</div></div><div class=\"userpro-clear\"></div>\";s:9:\"timestamp\";d:1544520583;}}}", "yes");
INSERT INTO wptz_options VALUES("16607", "aviaAsset_avia-merged-stylescss", "avia-merged-styles-3327900c3a798110a8414071c0cd4262", "yes");
INSERT INTO wptz_options VALUES("16608", "aviaAsset_avia-footer-scriptsjs", "avia-footer-scripts-9c1812a00b6b175ecb6479dd71a89a94", "yes");
INSERT INTO wptz_options VALUES("3170", "gadwp_options", "{\"client_id\":\"\",\"client_secret\":\"\",\"access_front\":[\"administrator\"],\"access_back\":[\"administrator\"],\"tableid_jail\":\"176690023\",\"theme_color\":\"#1e73be\",\"switch_profile\":0,\"tracking_type\":\"universal\",\"ga_anonymize_ip\":0,\"user_api\":0,\"ga_event_tracking\":0,\"ga_event_downloads\":\"zip|mp3*|mpe*g|pdf|docx*|pptx*|xlsx*|rar*\",\"track_exclude\":[],\"ga_target_geomap\":\"\",\"ga_realtime_pages\":10,\"token\":\"{\\\"access_token\\\":\\\"ya29.Gl2LBiTJHmNKtCprwZJhNZ1O5fDN1BWPvv0yVpbWbX2FzUz_QAoBiYI53LeVfx0RcTxObAURyXtUj-ab04vNTA4OARR_vAeAV4l1IltFV64EGpYPlkjDP9TtQj7vKF4\\\",\\\"expires_in\\\":3600,\\\"refresh_token\\\":\\\"1\\\\\\/3yct0tfutThwZtmZm3dz2af_kzzryFd3PhiPwIc1fgom9Jbz8mfz1tCqYvoBRw7K\\\",\\\"token_type\\\":\\\"Bearer\\\",\\\"created\\\":1546919823}\",\"ga_profiles_list\":[[\"www.wolfeinteractive.com\",\"18064289\",\"UA-8681493-2\",\"http:\\/\\/www.wolfeinteractive.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"114282516\",\"UA-8681493-8\",\"http:\\/\\/webdesignofhawaii.com\",-36000,\"Pacific\\/Honolulu\",null],[\"Temecula Valley Honey Company\",\"58746286\",\"UA-30949940-1\",\"http:\\/\\/www.temeculavalleyhoneycompany.com\",-25200,\"America\\/Los_Angeles\",\"index.html\"],[\"Stephanie Wolfe\",\"61407379\",\"UA-32929430-1\",\"http:\\/\\/www.stephaniemwolfe.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"122823275\",\"UA-32929430-2\",\"http:\\/\\/molokiniswim.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"72823170\",\"UA-41227974-1\",\"http:\\/\\/www.kekepania.net\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"112594494\",\"UA-41227974-3\",\"http:\\/\\/stephaniewolfedesign.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"78176983\",\"UA-45121215-1\",\"http:\\/\\/www.exploretemecula.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"81522190\",\"UA-47563532-1\",\"http:\\/\\/www.deluxemobiledetailservices.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"81933953\",\"UA-47867601-1\",\"http:\\/\\/www.iscbabies.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"83074779\",\"UA-48736611-1\",\"http:\\/\\/cityguide.exploretemecula.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"87190878\",\"UA-51807754-2\",\"http:\\/\\/dlmaesthetics.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"87184168\",\"UA-51807754-5\",\"http:\\/\\/expocci.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"106492478\",\"UA-51807754-9\",\"http:\\/\\/temeculavalleyhoneycompany.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"109293912\",\"UA-51807754-10\",\"http:\\/\\/temeculavalleyhairsolutions.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"117989300\",\"UA-51807754-11\",\"http:\\/\\/worldrenownedamericanbulldogs.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"118783819\",\"UA-51807754-12\",\"http:\\/\\/theofficefurnitureguy.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"130496395\",\"UA-51807754-14\",\"http:\\/\\/p-jhardys.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"141641500\",\"UA-51807754-15\",\"http:\\/\\/zebuhomes.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"163769094\",\"UA-51807754-17\",\"https:\\/\\/aliiwindows.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"174472445\",\"UA-51807754-18\",\"https:\\/\\/reversemortgagedata.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"176690023\",\"UA-51807754-19\",\"http:\\/\\/csroa.org\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"88288416\",\"UA-52632812-1\",\"http:\\/\\/www.garageexcell.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"98857310\",\"UA-60404108-1\",\"http:\\/\\/www.sketchcop.com\",-25200,\"America\\/Los_Angeles\",null],[\"Backup\",\"107542515\",\"UA-66882094-1\",\"http:\\/\\/www.dnewmanmd.org\",-25200,\"America\\/Los_Angeles\",null],[\"dnewmanmd.org\",\"124379880\",\"UA-66882094-1\",\"http:\\/\\/www.dnewmanmd.org\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"107538439\",\"UA-66882094-2\",\"http:\\/\\/m.dnewmanmd.org\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"108783497\",\"UA-67872789-1\",\"http:\\/\\/www.dnewmanmd.org\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"110004825\",\"UA-68836918-1\",\"http:\\/\\/www.thebarnstagecompany.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"110026647\",\"UA-68840333-1\",\"http:\\/\\/dlmaesthetics.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"114101735\",\"UA-71882607-1\",\"http:\\/\\/thebarnstagecompany.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"115888764\",\"UA-73208739-1\",\"http:\\/\\/everettpaintinginc.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"116202902\",\"UA-73401938-1\",\"http:\\/\\/manganphysicaltherapy.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"116200013\",\"UA-73405537-1\",\"http:\\/\\/wbaconsulting.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"116404123\",\"UA-73569680-1\",\"http:\\/\\/www.temecula-webdesign.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"116650029\",\"UA-73740941-1\",\"http:\\/\\/deluxemobiledetailservices.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"117574226\",\"UA-74405197-1\",\"http:\\/\\/temeculawigs.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"124755635\",\"UA-80047925-1\",\"http:\\/\\/tubelightingproducts.com\\/\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"130380663\",\"UA-84724445-1\",\"http:\\/\\/renegadehorseboot.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"130968710\",\"UA-84724445-2\",\"http:\\/\\/www.renegadehoofboots.com\",-25200,\"America\\/Los_Angeles\",\"index.html\"],[\"All Web Site Data\",\"131024701\",\"UA-84724445-3\",\"http:\\/\\/www.renegadehoofboot.com\",-25200,\"America\\/Los_Angeles\",null],[\"All Web Site Data\",\"171175776\",\"UA-115389447-1\",\"http:\\/\\/kauairx.com\",-36000,\"Pacific\\/Honolulu\",null],[\"All Web Site Data\",\"172070025\",\"UA-116207128-1\",\"https:\\/\\/www.airbnb.com\\/rooms\\/22109557\",-25200,\"America\\/Los_Angeles\",null]],\"ga_enhanced_links\":0,\"ga_remarketing\":0,\"network_mode\":0,\"ga_speed_samplerate\":1,\"ga_user_samplerate\":100,\"ga_event_bouncerate\":0,\"ga_crossdomain_tracking\":0,\"ga_crossdomain_list\":\"\",\"ga_author_dimindex\":0,\"ga_category_dimindex\":0,\"ga_tag_dimindex\":0,\"ga_user_dimindex\":0,\"ga_pubyear_dimindex\":0,\"ga_pubyearmonth_dimindex\":0,\"ga_aff_tracking\":0,\"ga_event_affiliates\":\"\\/out\\/\",\"automatic_updates_minorversion\":\"1\",\"backend_item_reports\":1,\"backend_realtime_report\":0,\"frontend_item_reports\":0,\"dashboard_widget\":1,\"api_backoff\":0,\"ga_cookiedomain\":\"\",\"ga_cookiename\":\"\",\"ga_cookieexpires\":\"\",\"pagetitle_404\":\"Page Not Found\",\"maps_api_key\":\"\",\"tm_author_var\":0,\"tm_category_var\":0,\"tm_tag_var\":0,\"tm_user_var\":0,\"tm_pubyear_var\":0,\"tm_pubyearmonth_var\":0,\"web_containerid\":\"\",\"amp_containerid\":\"\",\"amp_tracking_tagmanager\":0,\"amp_tracking_analytics\":0,\"amp_tracking_clientidapi\":0,\"trackingcode_infooter\":0,\"trackingevents_infooter\":0,\"ecommerce_mode\":\"disabled\",\"ga_formsubmit_tracking\":0,\"optimize_tracking\":0,\"optimize_containerid\":\"\",\"optimize_pagehiding\":0,\"superadmin_tracking\":0,\"ga_pagescrolldepth_tracking\":0,\"tm_pagescrolldepth_tracking\":0,\"ga_event_precision\":0,\"ga_force_ssl\":0,\"with_endpoint\":1,\"ga_optout\":0,\"ga_dnt_optout\":0,\"tm_optout\":0,\"tm_dnt_optout\":0,\"ga_with_gtag\":0,\"ga_enhanced_excludesa\":0,\"ga_hash_tracking\":0,\"gadwp_hidden\":\"Y\",\"usage_tracking\":0,\"hide_am_notices\":0,\"network_hide_am_notices\":0}", "yes");
INSERT INTO wptz_options VALUES("3171", "widget_gadwp-frontwidget-report", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("3172", "_amn_exact-metrics_last_checked", "1546905600", "yes");
INSERT INTO wptz_options VALUES("3173", "gadwp_redeemed_code", "4/AACU5p2L3Yu4ge_uriyTgNEPwv8HxvXBiuitLMJJiqGW97GIJQehjaA", "yes");
INSERT INTO wptz_options VALUES("37873", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1546963021", "no");
INSERT INTO wptz_options VALUES("37874", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1546919821", "no");
INSERT INTO wptz_options VALUES("37875", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1546963022", "no");
INSERT INTO wptz_options VALUES("37876", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WordPress Governance Project Flagged as Unsanctioned, First Meeting Set for January 15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86573\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/wordpress-governance-project-flagged-as-unsanctioned-first-meeting-set-for-january-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10550:\"<p>The WordPress Governance Project is a new community initiative, led by Rachel Cherry and Morten Rand-Hendriksen, that will <a href=\"https://wpgovernance.com/\">host its first meeting Tuesday, January 15 2019.</a></p>\n\n\n\n<p>The purpose of the project is to address two objectives:</p>\n\n\n\n<ol><li>The governance of the WordPress open source project and its various community components, and</li><li>WordPress’ role in the governance of the open web including representation in forums where decisions about the web platform and the Internet are made.</li></ol>\n\n\n\n<p>Hendriksen advocated for open governance when he introduced the project at WordCamp US in his presentation, <a href=\"https://wordpress.tv/2018/12/30/morten-rand-hendriksen-moving-the-web-forward-with-wordpress/\">Moving the Web forward with WordPress</a>. He discussed how the decisions made for WordPress&#8217; future affect a large portion the web. The project will first look at WordPress&#8217; internal governance structure and then move into the second aspect of getting WordPress a seat at the table in important discussions affecting the broader web.</p>\n\n\n\n<img />\n\n\n\n<p>Contributors on the project are aiming to propose a governance model for WordPress at or before WordCamp Europe 2019 or the Community Summit, if one is planned for 2019. The group plans to research existing governance models from corporations, government, and the open web community and submit their proposal to WordPress&#8217; current leadership for consideration.</p>\n\n\n\n<h3>WordPress Governance Project Seeks to Change Leadership Structure, Rand-Hendriksen Says Status Quo is &#8220;Not Tenable&#8221;</h3>\n\n\n\n<p>The governance project has piqued the public&#8217;s interest but some have found its objectives confusing. It is not clear what actions will be within the realm of possibility with the current benevolent dictator model WordPress has used. Part of the scope of the project is to &#8220;propose a leadership and governance model for the WordPress open source project and its communities.&#8221;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">That\'s part of the job: to figure out how it can and should work. The status quo is not tenable, and leaves us out of important conversations about where the web and the internet is headed.</p>&mdash; Morten i Norge <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f1f8-1f1ef.png\" alt=\"🇸🇯\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f328.png\" alt=\"🌨\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f976.png\" alt=\"🥶\" class=\"wp-smiley\" /> (@mor10) <a href=\"https://twitter.com/mor10/status/1075145343019302912?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 18, 2018</a></blockquote>\n</div>\n\n\n\n<p>The idea of governance means different things to audiences across cultures. The second aspect of the project that aims to get WordPress a seat at the table seems more feasible and more likely to be well-received by the project&#8217;s leadership. It might make more sense to split up the two objectives into different projects. WordPress&#8217; internal governance and its role in the greater web are very different topics, but the project&#8217;s creators seem to view them as inseparable.</p>\n\n\n\n<p>Matt Mullenweg hasn&#8217;t joined in the Twitter conversation about governance but he did address the topic on a recent <a href=\"https://poststatus.com/matt-mullenweg-on-gutenberg/\">Post Status podcast episode</a>.</p>\n\n\n\n<p>&#8220;When he was talking about open governance, my take was that he was talking about getting WordPress a seat at the table, and discussing these regulation changes and et cetera happening,&#8221; Mullenweg said. &#8220;I think the example last year was that there was this meeting at 10 Downing Street. Who was there? Was WordPress represented?</p>\n\n\n\n<p>&#8220;And he started talking about the Web Foundation, and I began thinking, “Wow, WordPress only represents a third of websites, and not even, really. It’s a third of the top 10 million. Another foundation like the Web Foundation actually might be a better vehicle to try to advocate on the open Web as a whole, versus just the people who happen to be using a single CMS.&#8221;</p>\n\n\n\n<p>When asked more about WordPress&#8217; leadership structure, Mullenweg reviewed the different approaches he has taken with the project. In 2018, the expression of his BDFL-style leadership was manifestly more overt than previous years, which may have influenced or even inspired the creation of the WordPress Governance Project.</p>\n\n\n\n<p>&#8220;There’s been a lot more leaders, but I would actually argue the point that WordPress has always been sort of my vision being set, or even my direct leadership,&#8221; Mullenweg said. &#8220;There was a good four or five years there where the leadership structure, because we’ve experimented with lots of different &#8211; we don’t call it governance &#8211; but essentially leadership structures in WordPress. For a while, we had kind of the … It wasn’t a committee approach, but essentially like the lead developers consensus approach. We did that for a few years.</p>\n\n\n\n<p>&#8220;Even from the beginning it wasn’t just me. It was me and Mike Little, so it’s never been solo. Then we went to where the release lead was the final decider, including over me, so that was probably, I don’t know, 3.9 to 4.7 maybe, that included overruling me as project lead for what was in the release or not, and that was to try to give a little more autonomy and flexibility to release leads. But the big change was a few years ago I said, &#8216;Okay, I’m going to take back over core WordPress development,&#8217; and that was to try to make some of these big changes happen. So right now it is much more of a benevolent dictator model, although both of those words are questionable. But, I don’t see that as the permanent forever structure.&#8221;</p>\n\n\n\n<p>Mullenweg may not be able to sustain this level of involvement in core leadership indefinitely, with all of his other responsibilities at Automattic. He said he is open to WordPress empowering other leaders in the future.</p>\n\n\n\n<p>&#8220;I’m not saying it always has to be me, but what I want is a strong, opinionated, thoughtful leader setting a bold direction, taking experiments and being willing to fail, comfortable with failure, is I think what you need to create great software,&#8221; he said.</p>\n\n\n\n<p>Brian DeConinck, a WordPress developer who has recently been a vocal critic of the project&#8217;s leadership, called for more transparency around the decision-making process in his <a href=\"http://www.briandeconinck.com/initial-thoughts-wordpress-governance/\">initial thoughts on the governance project.</a></p>\n\n\n\n<p>&#8220;Matt is the central figure of the WordPress project,&#8221; DeConinck said. &#8220;He’s been a guiding force since the beginning. Without a doubt, he’s an important and valued member of our community. I don’t imagine governance as a means of usurping him.</p>\n\n\n\n<p>&#8220;But should there be a single human face at the head of a project and a community at this scale? When people are critical of decision-making, having Matt at the center makes it easy to make criticism needlessly personal. This dynamic is hard on Matt and others in the project leadership, and ultimately toxic for the community.&#8221;</p>\n\n\n\n<p>DeConinck said in order for the governance project to be successful he thinks it needs to be international, multicultural, and multilingual, with diverse voices, as well as clear mechanisms for WordPress users to provide feedback. He outlined a detailed list of success criteria that hasn&#8217;t officially been embraced by governance project as it has yet to hold its first meeting.</p>\n\n\n\n<p>DeConinck&#8217;s suggestions are incompatible with the current BDFL-style leadership, as he claims that &#8220;feedback from a community of millions of users can’t adequately be processed and acted upon by a single individual listening and making decisions for the project.&#8221; WordPress has risen to become a dominant force on the web during the past 15 years under this style of leadership. Any meaningful proposal of change to the leadership structure will need to demonstrate how the new model can continue to enable WordPress to make rapid progress and maintain its relevance on the web.</p>\n\n\n\n<h3>WordPress Governance Project Flagged as Unofficial and Removed from WordPress.org</h3>\n\n\n\n<p>Earlier this morning, WordPress Community Team representative Francesca Marano <a href=\"https://make.wordpress.org/community/2019/01/07/wordpress-governance-project-change-of-venue/\">posted a notice</a> on behalf of the governance project&#8217;s leadership to announce that the project has been removed from WordPress.org.</p>\n\n\n\n<p>&#8220;Concerns have been raised about the posting of news about the WordPress Governance Project on make.wordpress.org and use of the <a href=\"https://make.wordpress.org/community/tag/community-team/\">#community-team</a> Slack channel giving the impression the project is sanctioned as an official WordPress project,&#8221; Marano said. &#8220;It has not received such sanctions from WordPress leadership.&#8221;</p>\n\n\n\n<p>&#8220;We went through what we believed were the appropriate channels for launching the project through the Community group (ie speaking to group members, asking for access to the Make blog, coordinating with the team and others to find a meeting time which didn’t collide with others, etc),&#8221; Morten Rand-Hendriksen said. &#8220;We were later informed the project was not sanctioned by WordPress leadership and therefore cannot use the Make blog or Slack.&#8221; He would not comment further on what transpired or the communication his team received.</p>\n\n\n\n<p>For the time being, it looks like the governance project will need to prove its worth independently before being officially adopted by WordPress. Many other community-led efforts and tools have followed this same process before coming under the umbrella of core. </p>\n\n\n\n<p>The project now has its own dedicated website at <a href=\"https://wpgovernance.com/\">wpgovernance.com</a> and a Slack instance at <a href=\"https://join.slack.com/t/twgp/signup?x=x-517030675360-517548723457\">twgp.slack.com</a>. The first meeting was set for January 8 but has been postponed to January, 15, 1600 UTC to allow participants to sign up at the new Slack workspace.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Jan 2019 19:49:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Beaver Builder Doubles Down on Serving Power Users in Response to Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86569\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/beaver-builder-doubles-down-on-serving-power-users-in-response-to-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3074:\"<p>At WordCamp US I had the opportunity to chat with <a href=\"https://www.wpbeaverbuilder.com/\">Beaver Builder</a> co-founder Robby McCullough about how the page builder is navigating the Gutenberg era. The proliferation of blocks for the new editor has made it easy for non-technical WordPress users to add things like pricing tables, maps, tabs, accordions, and other UI elements. Future iterations of Gutenberg will soon tackle layouts. These improvements to core will radically change how page builder products are marketed to WordPress users.</p>\n\n\n\n<p>&#8220;One of the decisions we made in response to the news of Gutenberg early on is that we wanted to double down on our professional power users,&#8221; McCullough said. &#8220;It took us a long time in our growth as a business to figure out who our customers were. We realized there were two distinct camps: one that was like a do-it-yourselfer type, someone who maybe had a small business or a hobby website who wanted to use WordPress but wasn&#8217;t familiar with writing code. The other was more of a freelancer &#8211; maybe a one or two person agency, people who were building lots of websites and had development and frontend skills. We see that as the space where we want to live now. We&#8217;re hoping to continue solving problems and making the experience better for folks with a few more skills in their tool belts.&#8221;</p>\n\n\n\n<p>Following up with McCullough later, he said that applying this new direction to Beaver Builder is already translating into the features they are prioritizing for the plugin.</p>\n\n\n\n<p>&#8220;For example, in our latest major release, we added percent, em, rem, and viewport-based units for things like font sizes, margins, and padding,&#8221; McCullough said. &#8220;Without a basic understanding of CSS, this feature wouldn&#8217;t be too helpful. We also added dozens of pre-built row templates. So, instead of creating single-page designs, our goal was to create a modular system of rows that can be mixed and matched to build out sites. We&#8217;re working to build features that better enable folks who build lots of websites.&#8221;</p>\n\n\n\n<p>In the interview below we discussed the current integration between Gutenberg and Beaver Builder. McCullough said his team is considering bringing blocks into Beaver Builder or bringing Beaver Builder content into Gutenberg; both are possibilities. His team has been waiting to see how quickly the community adopts Gutenberg before making any major decisions.</p>\n\n\n\n<p>&#8220;My hope is that there&#8217;s still going to be a place for page builders, Beaver Builder and everyone in this space, to have a little bit more agility,&#8221; McCullough said. &#8220;We can see Gutenberg kind of be like Instagram in that it&#8217;s going to appeal to a mass audience. We like to live in the Photoshop space where you&#8217;re going to get a lot of fine-tuned controls, solving problems and creating features that are going to help people build websites every day.&#8221;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Jan 2019 20:20:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: WP Storybook: A Handy Reference for WordPress React UI Components\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86604\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/wp-storybook-a-handy-reference-for-wordpress-react-ui-components\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1553:\"<p><a href=\"https://lubus.in/\">LUBUS</a>, a web design agency in Mumbai, has published a site called <a href=\"https://wp-storybook.netlify.com/\">WP Storybook</a> that offers an interactive way to explore various WordPress React components. It allows developers to browse and search UI components and see a live preview of the component next to example source code. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<a href=\"https://cloudup.com/cpA4-xaPukn\"><img src=\"https://i0.wp.com/cldup.com/yCZSRiLkVv.gif?resize=627{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2C297&ssl=1\" alt=\"Wp storybook\" width=\"627\" height=\"297\" /></a>\n</div>\n\n\n\n<p>WP Storybook lets you view different states for various UI components and even test them on different viewports. The development team at LUBUS is adding more as they discover them while building projects with Gutenberg using reusable components. Their goal in publishing the project is to help developers work faster by making components easier to discover and reference.</p>\n\n\n\n<p>LUBUS&#8217; roadmap for WP Storybook includes the following:</p>\n\n\n\n<ul><li>Add as many possible components and cases as possible</li><li>Capability to view and copy the example source</li><li>Playground to test out various props and options using knobs addon</li><li>Categorize components into groups for better discoverability</li><li>Recipe stories showcasing composing of various components</li></ul>\n\n\n\n<p>If you want to contribute to WP Storybook or log an issue, the code is open source (MIT license) on <a href=\"https://github.com/lubusIN/wp-storybook\">GitHub</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Jan 2019 23:51:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordPress.com Launches New “Do Anything” Marketing Campaign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86590\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wordpress-com-launches-new-do-anything-marketing-campaign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4698:\"<img />Hilde Lysiak reports on local news in her community on her WordPress.com-powered <a href=\"https://orangestreetnews.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Orange Street News</a> website\n\n\n\n<p>WordPress.com is kicking off 2019 with a new national marketing campaign that features 14 entrepreneurs, writers, and non-profit organizations who are using the platform to make a big difference for their communities. The campaign is focused around the question: &#8220;What Would You Do If You Could Do Anything?&#8221; </p>\n\n\n\n<p>WordPress.com published its inaugural <a href=\"https://en.blog.wordpress.com/2019/01/03/introducing-the-2019-anything-is-possible-list/\">‘Anything Is Possible’ List</a>, which includes 10 mini-documentaries ranging from 1 minute to 1:44. A few of the stories highlighted include Congolese-American sisters operating a successful hair salon in NYC, a 12-year-old journalist running her own online publication, a blogger who went viral and published her own book, and a non-profit fighting misinformation and extremist narratives. Each is presented more in depth on a new <a href=\"https://wordpress.com/do-anything/\">Do Anything</a> campaign site that was launched today.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Do Anything is WordPress.com&#8217;s first large-scale national brand campaign. It will debut TV, print, and digital advertising spots in The New Yorker and on TV networks, including The History Channel, CNN, and National Geographic. WordPress.com will also be running ads on podcasts, including The Daily and NPR. The new 30-second TV ad was created by <a href=\"http://interestingdevelopment.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Interesting Development</a>, an agency based in New York.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Much like gym memberships, WordPress.com tends to see more action at the beginning of a new year with 20{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} more sites are created in January than the average, according to Mark Armstrong at Automattic. The timing for the campaign is aimed at tapping into the motivation that millions of users have for starting a new business or blog at this time of year.</p>\n\n\n\n<p>In 2016, Automattic started <a href=\"https://ma.tt/2016/01/marketing-at-automattic/\">hiring for more marketing positions</a> as an answer to Wix, Weebly, Squarespace, Web.com, EIG, and Godaddy, competitors that Matt Mullenweg identified as having spent over $350M in advertising that year. In 2017, the company created <a href=\"https://design.blog/2017/05/18/how-a-detroit-hackathon-turned-into-wordpress-coms-first-ever-tv-spots/\">five commercials</a>, its first ever TV spots, as part of a series called &#8220;Free to be.&#8221; Many found the commercials to be confusing and the <a href=\"https://wptavern.com/wordpress-coms-tv-commercials-are-confusing\">messaging wasn&#8217;t clear</a>.</p>\n\n\n\n<p>By contrast, the 2019 &#8220;Do Anything&#8221; campaign is much better at demonstrating what people can do with WordPress.  &#8220;As we share new work with the world we realize that some things will hit and some things will miss,&#8221; Automattic’s SVP of Brand, Michelle Broderick said. The company has continued to evolve its marketing based on feedback. This particular campaign was directly inspired by the people who are making things happen with WordPress.</p>\n\n\n\n<p>&#8220;We were inspired by the people who use WordPress to imagine a better world,&#8221; Broderick said. &#8220;We saw everyone from bloggers to business owners to scientists to politicians using WordPress to share their story.&#8221;<br /></p>\n\n\n\n<p>The new TV spot is an improvement over previous campaigns in terms of communicating a clear message, but it doesn&#8217;t carry the same authenticity as the mini-documentaries. Each one is relatable and inspiring in telling the stories of people who have already answered the question &#8220;What would you do if you could do anything?&#8221; Many of those who were featured have carried on with their dreams through perseverance, despite tragedy and struggle along the way. The documentaries are more poignant than the TV spot, which has the added constraint of having to capture the viewer&#8217;s attention with a shorter amount of time. </p>\n\n\n\n<p>The &#8220;Do Anything&#8221; campaign as a whole is a good representation of the power of WordPress and should also help boost name recognition for the software in general. Broderick said Automattic is expecting tens of millions of impressions across TV, print, digital, and podcasts. The campaign is aimed at the American market but Armstrong said they hope to branch out into international markets in the future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Jan 2019 20:05:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"HeroPress: YOU Make The Difference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2672\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://heropress.com/essays/you-make-the-difference/#utm_source=rss&utm_medium=rss&utm_campaign=you-make-the-difference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10124:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2020/01/010219-min-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: WordPress still attracts the same types of people. Those who are brave, who are kind, who are looking to the future.\" /><blockquote><p>“A place is only as good as the people you know in it. It&#8217;s the people that make the place.”</p>\n<p>― Pittacus Lore, I Am Number Four</p></blockquote>\n<p>This quote is a large part of the space WordPress holds within me.</p>\n<p>Coming from a career in Civil Engineering and a background of Industrial Technology WordPress as a software drew me as a tool. It was a means to an end. I wasn’t blogging, I wasn’t looking to create an online voice, I was looking to build something and I needed a tool.</p>\n<p>I was good at learning software, had used over a dozen very complicated systems by that point in my life, so I found WordPress and started learning it too.</p>\n<p>A very melodramatic discovery story of WordPress for a HeroPress piece, I know.</p>\n<p>The truth is I probably wouldn’t have stuck around were it not for the people. The story has evolved for me over the years but that’s the beginning. The beginnings are usually far less romantic than the endings in any story.</p>\n<p>So why was I looking for a tool? Well, that’s a bit better of a story.</p>\n<h3>Looking For A Tool</h3>\n<p>I’ll prep you with the fact that I was driven, opinionated, blunt, and defensive. I had spent my college years and first years in my chosen career in a male-dominated industry. I learned how to navigate and thrive and took a job at a very large Engineering firm. About a year in I was granted a fantastic opportunity to work on a small startup team that was doing amazing work in 3D scanning.</p>\n<p>Being a startup team demanded that we produce more and more work to determine the viability of the investment the firm was making in my boss’s plans. As we worked on landing deals that required overnight travel and training that required days away it brought to the surface a reality that wasn’t so good for me. As the only woman on the team, I doubled the travel budget. They needed two of everything for me since I couldn’t bunk up with my male coworkers.</p>\n<p>The next months were a perfect storm of events. I made an opinionated comment to a division supervisor that was above my pay grade which enhanced my visibility as a problem. Then I got pregnant.</p>\n<blockquote><p>You can’t walk around 3D scanning a PVC manufacturing facility while with child. They also don’t make maternity coveralls.</p></blockquote>\n<p>I was officially dead weight. I lost the pregnancy and became depressed, anxious. It was easy for them to let me go then, I had stopped being productive. I found out a couple weeks after losing my job I was pregnant again. Talk about a whirlwind.</p>\n<p>My husband was in the process of changing careers from Retail to Healthcare and maternity leave is not something you like to bring up on an interview, so I decided to find something to do from home. I started a local family newsletter and decided to create an online marketplace for moms who craft out of their homes, like a local Etsy. This is where my search for a tool began.</p>\n<h3>Starting Again</h3>\n<p>A few months later, with no WordPress experience other than what I managed to rake together while I was learning and building, I got a job at WPMUDEV doing product support. I needed the extra cash so my other projects took a backseat and I was soon completely engulfed. Through that job, I came to learn about the ecosystem that was WordPress. I had no idea that there was a place that existed outside of the corporate universe that could exist without sexist politics, hierarchy, and status quo. It was mind-blowing.</p>\n<p>I was so hungry for people to interact with after being in such a team-oriented environment for so long. I loved working with others and I felt very alone until I found this great group of people. And oh what joy when I found it! I was a new mom at home with a baby trying to learn how to handle that new space in my life. My husband had completed a successful career change and we had moved. I had another baby. I met my friend Mason and we started a business together. I lost another pregnancy.</p>\n<blockquote><p>In the space of two short years, my life had completely turned upside down and landed me in the place that would help me survive it all.</p></blockquote>\n<p>You see, without the people, I wouldn’t have made it. I wouldn’t have been able to navigate the overwhelming waters that surrounded me outside of my day to day work. The people who befriended me, who were kind to me, who made jokes with me, who valued my contribution and intelligence without ever having set eyes on me, those were the people who kept me sane. They let me see I didn’t need to be defensive, that I didn’t have to be sorry about being opinionated, that I was different and that I should lean into that.</p>\n<p>When I left product support to work with Mason at, what was formerly called, WP Valet it was yet another major shift in my life. The product space was so different than the agency space and I quickly adapted to the new pace. There was a rush of excitement while learning new things and applying skills that had laid dormant for some time. My father was a Navy man and an entrepreneur and shaped so much of how I applied myself, now I was in a place to push myself even further and define my own path. I was spoiled by my first interactions at WP Valet with developers like Zé Fontainhas and Mario Peshev. The whole thing was thrilling!</p>\n<h3>And Then I Went To WordCamp</h3>\n<p>My first WordCamp was WordCamp Miami 2013. It was probably the first time I’d traveled alone in some time and I was meeting my work family for the first time. On top of that, I was in MIAMI, so it was bound to be a great trip. I got to meet David Bisset and Lisa Sabin Wilson that year, and so many other wonderful people. I was on cloud 9, each and every personality was inspiring to me, all so different than what my former colleagues and field specialists were like. To top it off I walked into my first talk at a WordCamp, Pippin Wilson was talking about how developers should share code. I was beside myself, sharing your code and supporting each other? Not cutthroat over projects and billable hours?! I was swooning over the idea of ‘community’ and what I had stumbled into.</p>\n<blockquote><p>Needless to say, I left 100{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} hooked on my path. WordPress was my life from that time on.</p></blockquote>\n<p>We as people have long-tailed stories that weave and zigzag and turn back on themselves. We are products of ALL the things going on in our lives at any given moment. Without the personal struggles and the professional push, I would not have been able to value the community as much as I do. The overlapping of personal and professional trials and successes are what gives depth to our experiences. Their overlapping is what colors the story of our lives.</p>\n<p>Fast forward a few years through a cross-state move, speaking selections, the birth of another child, a company expansion, another pregnancy loss, a company rebranding, a company restructuring, a return to school for Yoga training, and all the other things life throws in your path with family and work and here I sit typing my story at my counter while my middle child hums ‘Mamma Mia’ next to me. I am forever grateful for the life that I’ve been able to live through a whole new career in WordPress.</p>\n<h3>You Make The Difference</h3>\n<p>I am grateful for every soul I have met. I had the privilege to work with and become friendly with some of the nicest and most genuine people I will ever meet online and face to face. The ecosystem of WP has changed a lot over the years as most ecosystems do, but it still attracts the same types of people. Those who are brave, who are kind, who are looking to the future. My world is so much bigger because of all you. Thank You  <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: YOU Make The Difference\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=YOU{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20Make{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20The{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20Difference&via=heropress&url=https{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}3A{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fheropress.com{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fessays{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fyou-make-the-difference{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: YOU Make The Difference\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}3A{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fheropress.com{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fessays{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fyou-make-the-difference{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}3A{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fheropress.com{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fessays{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fyou-make-the-difference{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F&title=YOU+Make+The+Difference\" rel=\"nofollow\" target=\"_blank\" title=\"Share: YOU Make The Difference\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/you-make-the-difference/&media=https://heropress.com/wp-content/uploads/2020/01/010219-min-150x150.jpg&description=YOU Make The Difference\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: YOU Make The Difference\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/you-make-the-difference/\" title=\"YOU Make The Difference\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/you-make-the-difference/\">YOU Make The Difference</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Jan 2019 20:15:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Kimberly Lipari\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: Democratize Publishing, Revisited\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48797\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://ma.tt/2018/12/democratize-publishing-revisited/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1674:\"<p>During my <a href=\"https://www.youtube.com/watch?v=v2aNNlC8TUE\">State of the Word Q&amp;A</a> I received some blogging homework from <a href=\"https://torumiki.com/\">Toru Miki</a>, a WordPress contributor based in Tokyo. He asked me to revisit the WordPress mission, “Democratize Publishing,” and reflect on what that mission means to me today. So here you go, Toru: <br /></p>\n\n\n\n<p>For many years, my definition of “Democratize Publishing” has been simply to help make the web a more open place. That foundation begins with the software itself, as outlined by the <a href=\"https://ma.tt/2014/01/four-freedoms/\">Four Freedoms</a>: <br /></p>\n\n\n\n<p>0. The freedom to run the program, for any purpose.</p>\n\n\n\n<p>1. The freedom to study how the program works, and change it so it does your computing as you wish.</p>\n\n\n\n<p>2. The freedom to redistribute copies so you can help your neighbor.</p>\n\n\n\n<p>3. The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.<br /></p>\n\n\n\n<p>In 2018, the mission of “Democratize Publishing” to me means that people of all backgrounds, interests, and abilities should be able to access Free-as-in-speech software that empowers them to express themselves on the open web and to own their content.<br /></p>\n\n\n\n<p>But as Toru noted in the original question, “Democratize Publishing” has come to mean many things to many people in the WordPress community. That’s one reason I like it. The WordPress mission is not just for one person to define. <br /></p>\n\n\n\n<p>So I’d like to ask everyone: What does “Democratize Publishing” mean to you? &nbsp;<br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2018 00:06:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Sponcon Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48788\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2018/12/sponcon-posts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"<p>I found <a href=\"https://www.theatlantic.com/technology/archive/2018/12/influencers-are-faking-brand-deals/578401/\">this post by Taylor Lorenz</a> describing how aspiring influencers are posting fake, unpaid sponsored content to raise their status or hoping to nab a real sponsorship <a href=\"https://www.theatlantic.com/technology/archive/2018/12/influencers-are-faking-brand-deals/578401/\">is totally bananas</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Dec 2018 16:08:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Designers Explore Ideas for Moving Navigation to a Block Interface\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86518\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wordpress-designers-explore-ideas-for-moving-navigation-to-a-block-interface\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5176:\"<p>Creating a block for navigation menus is one of the <a href=\"https://make.wordpress.org/core/2018/12/08/9-priorities-for-2019/\">nine projects</a> Matt Mullenweg identified for 2019 that will make a big impact for WordPress users. It&#8217;s also one of the most challenging from a UI perspective. At WordCamp US&#8217; contributor day, the design team <a href=\"https://make.wordpress.org/design/2018/12/18/exploring-a-nav-block-at-wordcamp-us/\">explored ideas for what a navigation block might look like in the new editor</a>.</p>\n\n\n\n<img />\n\n\n\n<p>The team&#8217;s designs for a navigation block are still in the rough sketches stage, but it&#8217;s interesting to see different approaches as the project develops.</p>\n\n\n\n<p>&#8220;If the Nav block could live in a container block (columns perhaps), then the settings for it could be tweaked in the sidebar,&#8221; XWP designer Joshua Wold said. &#8220;A further problem comes up when you try to figure out how much of the design of the nav should be controlled by the theme vs the Gutenberg editor.&#8221;</p>\n\n\n\n<p>This is an important question  that will need to be answered in the near future &#8211; not only for navigation but also more broadly for the future of the role of themes in WordPress. We will be exploring this in more depth in future posts.</p>\n\n\n\n<p>Designer Mel Choyce and Riad Benguella (one of the leads for Gutenberg phase 2), are currently soliciting ideas from the wider WordPress community about how the project should tackle the upcoming customization focus.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">You care about WordPress and you don\'t have the time to contribute day to day, I\'d love to hear your thoughts to get some inspiration about Phase 2 of Gutenberg, Site building, Customization&#8230; A tweet, a blog post, whatever works best for you. <a href=\"https://twitter.com/hashtag/gutenideas?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#gutenideas</a> <a href=\"https://t.co/Y7tod5DoB2\">https://t.co/Y7tod5DoB2</a></p>&mdash; Riad Benguella (@riadbenguella) <a href=\"https://twitter.com/riadbenguella/status/1075458929579167745?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 19, 2018</a></blockquote>\n</div>\n\n\n\n<p>One of the chief complaints about the first phase of the Gutenberg project was the <a href=\"https://make.wordpress.org/core/2018/10/05/gutenberg-phase-2-leads/#comment-34092\">lack of public discussion</a> about the goals and the process of creating the editor. The Gutenberg team&#8217;s willingness to collate ideas across multiple mediums demonstrates a strong effort to seek out more diverse perspectives for phase 2. Ideas have already started rolling in.  </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Riffing on something <a href=\"https://twitter.com/photomatt?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">@photomatt</a> said at <a href=\"https://twitter.com/hashtag/SOTW?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#SOTW</a> <a href=\"https://twitter.com/hashtag/WCUS?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WCUS</a>: To map out the future of themes / <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#Gutenberg</a> 2.0 / <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WordPress</a> Next, maybe ship a Block Zen Garden type thing and asking designers / devs to create solutions, then work backwards to find a UI / UX to make that possible.</p>&mdash; Morten i Norge <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f1f8-1f1ef.png\" alt=\"🇸🇯\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f328.png\" alt=\"🌨\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f976.png\" alt=\"🥶\" class=\"wp-smiley\" /> (@mor10) <a href=\"https://twitter.com/mor10/status/1073664020471660544?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 14, 2018</a></blockquote>\n</div>\n\n\n\n<p>&#8220;Rather than starting with the back-end UI, we can start with the front-end result and build a UI to make the building of that front-end possible without messing up the accessibility and resilience of the root HTML document,&#8221; Morten Rand-Hendricksen said. &#8220;At the root of this would be CSS Grid as the main layout module to allow drag-and-drop style block layouts without making changes to the HTML source order.&#8221;</p>\n\n\n\n<p>Many of the ideas that are coming in so far relate more broadly to site customization. These include <a href=\"http://theme.tips/blog/2018/12/21/random-thoughts-about-gutenizer-phase-2/\">questions about what role the Customizer will play</a> and requests for features like creating <a href=\"https://twitter.com/alihs707/status/1075640228470243329\">custom widths on the fly</a> and the <a href=\"https://twitter.com/alihs707/status/1075640228470243329\">ability to drag content across columns.</a> If you have ideas about how navigation can be implemented in a block, take some time before the end of the year and drop your comments on the <a href=\"https://make.wordpress.org/design/2018/12/18/exploring-a-nav-block-at-wordcamp-us/\">make/design post</a> or write your own post and leave a link for others to share feedback.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Dec 2018 23:52:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Seneca on Friendship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48764\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2018/12/seneca-on-friendship/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:705:\"<blockquote class=\"wp-block-quote\"><p>But nothing delights the mind so much as fond and loyal friendship. What a blessing it is to have hearts that are ready and willing to receive all your secrets in safety, with whom you are less afraid to share knowledge of something than keep it to yourself, whose conversation soothes your distress, whose advice helps you make up your mind, whose cheerfulness dissolves your sorrow, whose very appearance cheers you up!</p></blockquote>\n\n\n\n<p>You can read <em>On Tranquility of Mind</em> <a href=\"https://en.wikisource.org/wiki/Of_Peace_of_Mind\">online for free here</a> or I enjoyed <a href=\"https://www.amazon.com/dp/B00BCU07LO\">this edition from Penguin</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Dec 2018 20:55:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: 9 Year Old Shares his Journey Learning React\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86488\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wptavern.com/9-year-old-shares-her-journey-learning-react\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:819:\"<p>If learning React is among your New Year&#8217;s goals, here&#8217;s some inspiration from nine-year-old Revel Carlberg West. The video below is a recording of his presentation at the <a href=\"https://www.meetup.com/ReactNYC/\">React NYC</a> meetup. West describes how he learned basic HTML, CSS, and JavaScript and then moved on to learn React using the <a href=\"https://codesandbox.io/\">CodeSandbox</a> online code editor. He also gives a live demo of <a href=\"https://reactjs.org/docs/hooks-intro.html\">React Hooks</a> in action, a new feature that Sophie Alpert and Dan Abramov introduced at React Conf 2018. The code for West&#8217;s traffic light demo is <a href=\"https://codesandbox.io/s/xlw615w7ow\">available on CodeSandbox</a> if you want to follow along.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Dec 2018 19:59:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: WordPress 5.0.2 Released with Performance Gains of 330{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} for Block-Heavy Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86510\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wordpress-5-0-2-released-with-performance-gains-of-330-for-block-heavy-posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1544:\"<p><a href=\"https://wordpress.org/news/2018/12/wordpress-5-0-2-maintenance-release/\">WordPress 5.0.2</a>, the of first of two rapid releases following 5.0, is now available. Sites with automatic background updates enabled should already be on the latest version. </p>\n\n\n\n<p>This release addresses performance issues, one of the chief complaints for users who have adopted the block editor. It brings 45 improvements to the editor, with 14 of those related to performance and 31 bug fixes. According to Gary Pendergast, &#8220;the cumulated performance gains make it 330{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} faster for a post with 200 blocks.&#8221;</p>\n\n\n\n<p>This maintenance release also fixes 17 editor-related bugs in the default WordPress themes as well as internationalization issues related to script loading.</p>\n\n\n\n<p>Overall, 5.0.2 updates have gone smoothly, with the exception of a few conflicts with a handful of plugins. Most notably, WooCommerce store administrators found that the <a href=\"https://github.com/woocommerce/woocommerce/issues/22271\">Orders tab had disappeared</a> after their sites updated. WooCommerce has fixed the issue in a quick patch release (version 3.5.3) that was pushed out this morning.</p>\n\n\n\n<p>NextGEN Gallery creator Erick Danzer also reported <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1545334477273500\">a minor issue with the Classic block</a> that prevents users from editing galleries via the placeholder the plugin had added. A fix for that issue should be forthcoming in an update to the plugin.<br /></p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Dec 2018 21:14:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Gutenberg-Inspired Jenga Game “Gutenblox” Now Available for Sale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86500\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/gutenberg-inspired-jenga-game-gutenblox-now-available-for-sale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1691:\"<div class=\"wp-block-image\"><img />photo credit: <a href=\"https://xwp.co/\">XWP</a></div>\n\n\n\n<p>XWP&#8217;s Gutenberg-inspired Jenga sets were arguably the most innovative swag at WordCamp US this year, but there weren&#8217;t enough to go around. Gutenblox, fondly dubbed &#8220;the Other Block Building Interface,&#8221; is now available on its own website where anyone can buy a set.</p>\n\n\n\n<p>The <a href=\"https://gutenblox.fun\">Gutenblox.fun</a> store is running on <a href=\"https://wordpress.org/plugins/bigcommerce/\">BigCommerce</a> with the new <a href=\"https://wordpress.org/themes/twentynineteen/\">Twenty Nineteen</a> theme active. It includes the rules of the game, cleverly adapted to the concept of Gutenblox:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Blocks treat Paragraphs, Headings, Media, etc. all as components that strung together make up the tower. Replacing the traditional concept of board games, Gutenblox is designed with progressive enhancement, meaning as new blocks are added to the top of the tower, they are backward compatible with all legacy content (although the legacy structure may become unstable as new blocks are added on).</p><p>We hope to offer rich value to players who will start with the foundation of a stable, accessible, and secure architecture, and then use a simple drag-and-drop method for modification.</p></blockquote>\n\n\n\n<p>If you&#8217;re looking for a last-minute holiday gift or birthday gift for a friend who loves WordPress, Gutenblox is fun option. It also helps support a good cause. XWP is donating all profits from the sales of the game to the <a href=\"https://wordpressfoundation.org/\">WordPress Foundation</a>. </p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Dec 2018 17:02:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Introduction to the WPGraphQL Project with Jason Bahl and Ryan Kanner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86483\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/introduction-to-the-wpgraphql-project-with-jason-bahl-and-ryan-kanner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1187:\"<p>At WordCamp US 2018 I had the chance to sit down with <a href=\"https://twitter.com/jasonbahl\">Jason Bahl</a> and <a href=\"https://twitter.com/CodeProKid\">Ryan Kanner</a>, both engineers at Digital First Media in Denver, Colorado, and contributors to the <a href=\"https://www.wpgraphql.com/\">WPGraphQL</a> project. WPGraphQL is an open source plugin that provides an extendable GraphQL schema and API for any WordPress site.</p>\n\n\n\n<p>Bahl, who created and maintains the project, also gave a lightning talk at WCUS on <a href=\"https://2018.us.wordcamp.org/session/gutenberg-graphql-and-building-blocks/\">using GraphQL with Gutenberg</a> to improve the performance of custom blocks, as well as the developer experience of building them.</p>\n\n\n\n<p>In our interview, Bahl and Kanner offer a general overview of the differences between GraphQL and REST. They explained how Digital First Media improved performance for the company&#8217;s publications by switching from REST to GraphQL. We also discussed how Gutenberg is a great use case for GraphQL and whether the project is something that could someday be included in WordPress core.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Dec 2018 04:00:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Dev Blog: WordPress 5.0.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/12/wordpress-5-0-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4589:\"<p>WordPress 5.0.2 is now available!</p>\n\n\n\n<p>5.0.2 is a maintenance release that addresses 73 bugs. The primary focus of this release was performance improvements in the block editor: the cumulated performance gains make it 330{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} faster for a post with 200 blocks.</p>\n\n\n\n<p>Here are a few of the additional highlights:</p>\n\n\n\n<ul><li>45 total Block Editor improvements are included (14 performance enhancements &amp; 31 bug fixes).</li><li><a href=\"https://core.trac.wordpress.org/query?component=Bundled+Theme&milestone=5.0.2&col=id&col=summary&col=milestone&col=owner&col=type&col=status&col=priority&order=priority\">17 Block Editor related bugs</a> have been fixed across all of the bundled themes.</li><li>Some <a href=\"https://core.trac.wordpress.org/query?component=I18N&milestone=5.0.2&col=id&col=summary&col=status&col=owner&col=type&col=priority&col=milestone&order=priority\">internationalization (i18n) issues</a> related to script loading have also been fixed.</li></ul>\n\n\n\n<p>For a full list of changes, please consult the <a href=\"https://core.trac.wordpress.org/query?status=closed&milestone=5.0.2&group=component\">list of tickets on Trac</a> or the <a href=\"https://core.trac.wordpress.org/log/branches/5.0?action=stop_on_copy&mode=stop_on_copy&rev=44339&stop_rev=44183&limit=100&sfp_email=&sfph_mail=\">changelog</a>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/download/\">download WordPress 5.0.2</a> or visit Dashboard → Updates and click <em>Update Now</em>. Sites that support automatic background updates have already started to update automatically.</p>\n\n\n\n<p>Thank you to everyone who contributed to WordPress 5.0.2:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/babaevan/\">Alexander Babaev</a>, <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/allancole/\">allancole</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/jdtrower/\">David Trower</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/edpittol/\">Eduardo Pittol</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/greg-raven/\">Greg Raven</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">gziolo</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">herregroen</a>, <a href=\"https://profiles.wordpress.org/icaleb/\">iCaleb</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/khleomix/\">khleomix</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff&nbsp;Paul</a>, <a href=\"https://profiles.wordpress.org/mihaivalentin/\">mihaivalentin</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/more/\"></a><a href=\"https://profiles.wordpress.org/mmaumio/\">Muntasir Mahmud</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik K. Yadav</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a>, <a href=\"https://profiles.wordpress.org/strategio/\">strategio</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/torontodigits/\">TorontoDigits</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/vaishalipanchal/\">Vaishali Panchal</a>, <a href=\"https://profiles.wordpress.org/volodymyrkolesnykov/\">volodymyrkolesnykov</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, <a href=\"https://profiles.wordpress.org/ze3kr/\">ze3kr</a>, and <a href=\"https://profiles.wordpress.org/mypacecreator/\">のむらけい</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Dec 2018 23:47:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: Happy Developers, Happy Ecosystem: The Intangible Impact of WordPress’ Minimum PHP Version Bump\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wptavern.com/happy-developers-happy-ecosystem-the-intangible-impact-of-wordpress-minimum-php-version-bump\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6401:\"<div class=\"wp-block-image\">\n<img />\n</div>\n<p>The following is a guest post by <a href=\"https://twitter.com/ChrisVanPatten\">Chris Van Patten</a>, founder of <a href=\"https://tomodomo.co\">Tomodomo</a>, a digital agency for magazine publishers. </p>\n<hr class=\"wp-block-separator\" />\n<p>For years, WordPress has been ever-so-slightly behind the times on PHP version support&#8230;to put it kindly.</p>\n<p>However, WordPress&#8217; legendary support for PHP versions back to 5.2 — versions long unsupported by the PHP project itself — wasn&#8217;t born out of a &#8220;we hate developers&#8221; strategy (although you&#8217;d be forgiven for thinking so given the reaction that policy often gets from developers). Instead, it was a genuinely noble and pragmatic effort to make WordPress, and thus publishing on the web, as widely available as possible.</p>\n<p>Despite the reaction from many developers (and security-minded sysadmins), that strategy worked: WordPress <a href=\"https://w3techs.com/technologies/overview/content_management/all\" rel=\"noopener\" target=\"_blank\">powers over 30{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of the web</a>, and a <a href=\"https://wordpress.org/about/stats/\" rel=\"noopener\" target=\"_blank\">significant chunk of those installations are on unsupported PHP versions</a>. For those users, it&#8217;s not that they don&#8217;t care that they are on an unsupported version of PHP; they just don&#8217;t know, or don&#8217;t know how to solve the problem.</p>\n<p>But the winds of progress are blowing, and in 2019 WordPress is planning to make a change. Assuming everything goes according to plan, PHP 5.6 will become the minimum supported version in the first half of the year, and the minimum version will be bumped again to PHP 7 in the second half of 2019.</p>\n<p>There are obvious benefits here from a security perspective. The oldest versions of PHP supported by WordPress today stopped receiving official security updates ages ago (PHP 5.2 hit EOL, or &#8220;end-of-life,&#8221; nearly 8 years ago). The speed improvements will be tremendous as well, particularly in PHP 7. Speaking from my own experience, I have several sites that once needed aggressive caching to prevent server overload. Since PHP 7, they run faster than ever, without caching of any kind.</p>\n<p>Speed and security are the two most-cited reasons (and the most measurable reasons) for bumping the minimum version, but there are also other less tangible benefits that will filter well beyond WordPress core development.</p>\n<h3>Simplified support</h3>\n<p>While plugin developers have never been obligated to support all the versions of PHP that WordPress core does, many still chose to do so. That&#8217;s understandable: it could be tough to explain to a user why they can install WordPress in a certain development environment but couldn&#8217;t install a certain plugin.</p>\n<p>For plugins that tried to match core&#8217;s backward compatibility support, that means testing and supporting up to nine versions of PHP: 5.2 through 5.6, and 7.0 through 7.3. (There was no PHP 6. I won&#8217;t bother explaining the <a href=\"https://ma.ttias.be/php6-missing-version-number/\" rel=\"noopener\" target=\"_blank\">boring reasons why</a>.)</p>\n<p>By pushing to 5.6, and eventually some version of PHP 7+, that cuts the number of versions that developers will feel compelled to support in half. In some way, Core will likely continue to support these old versions (through security backports to old versions of WordPress, for instance) but plugin developers can be assured that they don&#8217;t need to — and don&#8217;t need to feel any semblance of guilt about it either.</p>\n<h3>Happier developers</h3>\n<p>Even developers who are excited about the WordPress platform as a whole are likely to admit that it&#8217;s maybe not the most exciting code-base in the world. Over the past few years, I&#8217;ve seen a number of examples of developers who once limited themselves to WordPress now stretching into other frameworks and languages: Laravel, JavaScript, and Go are all popular new homes for WordPress expats.</p>\n<p>Bumping the minimum version won&#8217;t change that apathy or exodus overnight, but it will give developers something to feel excited about. Modern PHP versions (especially PHP 7) offer genuinely cool new language features that make it easy to write performant, well-designed, and interesting code. I would even argue that it makes it fun. Modern PHP contains plenty of <a href=\"https://en.wikipedia.org/wiki/Syntactic_sugar\" rel=\"noopener\" target=\"_blank\">syntactic sugar</a>, and while you shouldn&#8217;t base your diet on sugar it certainly makes for a nice treat.</p>\n<p>Again, it is unlikely that core will start adopting these new language features on day one. The real benefit is that developers will feel empowered and secure in their decisions to start using these new capabilities, and will start to build plugins and themes that can borrow ideas from best practices in the broader PHP community.</p>\n<h3>Celebrating the intangible</h3>\n<p>While the measurable justifications for changing the minimum PHP version are certainly compelling, I think it&#8217;s also important to acknowledge these intangibles and indeed celebrate them. Bumping these versions will create a ripple effect across the ecosystem that will make developers more comfortable with writing modern code. It will reduce support and QA loads for companies that no longer need to support 9 different versions of PHP. It will make WordPress core a more attractive place to contribute.</p>\n<p>Gutenberg, and all the modern tooling and architecture it brought, has already reinvigorated developers across the ecosystem and brought a huge number of new core contributors (<a href=\"https://wptavern.com/contributing-to-gutenberg-a-new-contributors-experience\" rel=\"noopener\" target=\"_blank\">myself among them</a>). Embracing modern PHP is another step forward, and with other changes on the horizon (such as a <a href=\"https://make.wordpress.org/core/2018/12/09/on-wordpress-git/\" rel=\"noopener\" target=\"_blank\">move from SVN to Git</a>, coding standards changes, and projects like <a href=\"https://www.wptide.org/\" rel=\"noopener\" target=\"_blank\">Tide</a> which embrace new languages and architectures) I hope that 2019 will be the year WordPress delivers not only a best-in-class user experience, but a best-in-class developer experience too.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Dec 2018 17:57:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Chris Van Patten\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Gutenberg for Writers: How to Configure the Editor for Fewer Distractions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86427\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/gutenberg-for-writers-how-to-configure-the-editor-for-fewer-distractions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4740:\"<img />photo credit: <a href=\"https://stocksnap.io/photo/8Y0EDX4VP9\">Green Chameleon</a>\n\n\n\n<p>For a long time I could not compose posts with the Gutenberg editor. I tested each release of the plugin throughout its journey into WordPress 5.0, but found it too distracting for my basic needs. It seemed better suited for building a brochure website, not for someone who uses WordPress primarily for writing. </p>\n\n\n\n<p>This is the first thing you see on a vanilla install of WordPress when you go to the &#8220;Add New&#8221; post page:</p>\n\n\n\n<div class=\"wp-block-image\"><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-12-17-at-10.14.35-AM.png?ssl=1\"><img /></a></div>\n\n\n\n<p>Although it may not be immediately evident, the new editor actually has some built-in controls for improving the writing experience. They are tucked away behind the vertical ellipsis menu at the top of the screen. Here&#8217;s how to configure Gutenberg for writing:</p>\n\n\n\n<h3>Step 1: Hide the Settings Sidebar</h3>\n\n\n\n<p>The first step towards a more distraction-free writing experience is to hide the settings. Click the X at the top right of the screen.  If you&#8217;re trying to stay in the flow of writing, it&#8217;s not necessary to keep the block and document settings in view at all times. You can always toggle them on later when you&#8217;re finished getting your thoughts onto the screen.</p>\n\n\n\n<h3>Step 2: Turn on &#8220;Fullscreen Mode&#8221;</h3>\n\n\n\n<p>Many new and experienced WordPress users are not aware of Gutenberg&#8217;s &#8220;Fullscreen mode&#8221; that places the writing area in the center of the page and hides WordPress&#8217; admin menu sidebar.  This setting is a must for keeping distractions at bay. You can find it at the top right corner in the vertical ellipsis menu:</p>\n\n\n\n<img />\n\n\n\n<p>Once Fullscreen Mode is enabled, the writing area is greatly improved, with distractions removed from both sides of the content area. </p>\n\n\n\n<img />\n\n\n\n<h3>Step 3: Fix the Toolbar to the Top (optional)</h3>\n\n\n\n<p>The block toolbar popping in and out of view was the bane of my Gutenberg experience until they developed the &#8220;Top Toolbar&#8221; setting. By default, the block-level toolbar obscures part of the content above it (as seen in the image below) and an obtrusive blue outline follows your mouse as you move over the paragraphs you have already written.</p>\n\n\n\n<img />\n\n\n\n<p>The psychological affect of all these boxes popping in and out of view may be more taxing for some writers, so this step is optional. The &#8220;Top Toolbar&#8221; setting to hide the block-level toolbar, as well as the blue block outlines, is also inside the vertical ellipsis menu at the top. The best way to see the difference in the experience is to experiment with turning it on and off.</p>\n\n\n\n<p>Spotlight mode takes it one step further and greys out all the content except the current block, allowing writers to focus on one block at a time. When it is enabled, the blocks that are not being edited will partially fade away and no block outlines will be visible. </p>\n\n\n\n<img />Spotlight mode\n\n\n\n<p>Gutenberg still has a way to go before it can provide a truly distraction-free editing experience. None of the modes highlighted above will hide the metaboxes at the bottom or the menu bar at the top. They do, however, allow you to compose in an area without the block-level toolbar and sidebars getting in the way.</p>\n\n\n\n<p>My thoughts don&#8217;t always come out in full sentences and paragraphs. Sometimes they are scattered throughout a document in half sentences, single words, quotes, and fragments of quotes that I&#8217;m not certain I will use. How do I reconcile this with Gutenberg? Sometimes the Classic Block is a good option for a first draft that looks more like a pile of messy notes than a document of well-formed thoughts. Here&#8217;s what that looks like if you have never used it:</p>\n\n\n\n<img />Classic Block\n\n\n\n<p>Even with these settings available, some writers may still prefer to use a dedicated writing app instead of the WordPress editor. Fortunately, Gutenberg has very good support for copying and pasting from other applications.</p>\n\n\n\n<p>Top Toolbar, Spotlight, and Fullscreen modes are not the easiest features to discover but they can make a significant impact on your experience writing in the new editor. WordPress core may never provide a truly distraction-free writing experience, but that&#8217;s where the beauty of the plugin system comes into play. It gives developers the opportunity to create new and interesting approaches towards a better default writing experience. I hope to see some of those popping up in the directory as more users adopt Gutenberg.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Dec 2018 03:17:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WordPress 5.0.2 to Bring Major Performance Improvements, Scheduled for December 19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86358\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/wordpress-5-0-2-to-bring-major-performance-improvements-scheduled-for-december-19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3081:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/12/stopwatch.jpg?ssl=1\"><img /></a>Processed with VSCOcam with c1 preset</p>\n<p><a href=\"https://wordpress.org/news/2018/12/wordpress-5-0-1-security-release/\" rel=\"noopener\" target=\"_blank\">WordPress 5.0.1</a> was released yesterday as a security release with fixes for seven vulnerabilities that were privately disclosed. It includes a few <a href=\"https://make.wordpress.org/core/2018/12/13/backwards-compatibility-breaks-in-5-0-1/\" rel=\"noopener\" target=\"_blank\">breaks in backwards compatibility</a> that plugin developers will want to review.</p>\n<p>WordPress 5.0.2 will be the first planned followup release to 5.0 and is now scheduled to be released December 19, 2018. Gary Pendergast posted a <a href=\"https://make.wordpress.org/core/2018/12/13/dev-chat-summary-december-12th/\" rel=\"noopener\" target=\"_blank\">summary</a> of this week&#8217;s dev chat that includes the schedule and scope for the upcoming release. It will include Gutenberg 4.7, Twenty Nineteen bug fixes, and a few PHP 7.3 compatibility fixes.</p>\n<p><a href=\"https://gschoppe.com/wordpress/benchmarking-gutenberg/\" rel=\"noopener\" target=\"_blank\">Slow performance</a> as compared to the classic editor has been a commonly-reported <a href=\"https://github.com/WordPress/gutenberg/issues/6466\" rel=\"noopener\" target=\"_blank\">issue</a> with Gutenberg. The project has a label for it on GitHub with <a href=\"https://github.com/WordPress/gutenberg/labels/{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5BType{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5D{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20Performance\" rel=\"noopener\" target=\"_blank\">26 open issues</a>. 140 performance-related issues have already been closed so the team is making progress on speeding it up. 5.0.2 will bring major performance improvements to the editor, particularly for content that includes hundreds of blocks. </p>\n<p>&#8220;The cumulated performance gains are around 330{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} faster for a post with 200 blocks,&#8221; Matias Ventura said in an <a href=\"https://make.wordpress.org/core/2018/12/13/5-0-2-editor-performance-and-bug-fixes/\" rel=\"noopener\" target=\"_blank\">update</a> on the editor. &#8220;This might be even bigger for certain setups and plugin configurations — seeing the same test post be 540{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} faster with Yoast, for example.&#8221;</p>\n<p>These changes are already in version 4.7 of the Gutenberg plugin, which users can run alongside WordPress 5.0.1 to test the latest. </p>\n<p>RC 1 for 5.0.2 is planned for today and RC 2 (if necessary) is targeted for December 17. The official release is scheduled for December 19.</p>\n<p>Gary Pendergast also outlined the scope and schedule for WordPress 5.1, which will be led by Matt Mullenweg. Pendergast proposed a relatively short release cycle with an official release February 21, since there are already more than <a href=\"https://core.trac.wordpress.org/query?status=closed&milestone=5.1\" rel=\"noopener\" target=\"_blank\">200 tickets fixed for 5.1</a>. Focuses for the release include the REST API (particularly authentication solutions), core JS, and core themes. Beta 1 is planned for January 10, with RC 1 following February 7. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Dec 2018 16:52:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: WPWeekly Episode 341 – Recap of WordCamp US 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=86395&preview=true&preview_id=86395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/wpweekly-episode-341-recap-of-wordcamp-us-2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1333:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I recap WordCamp US 2018. We discuss what&#8217;s new in WordPress 5.0.1 and when users can expect to see 5.0.2.</p>\n<p>We also chat about the new path that WordPress is on and where it may lead. John shares his perspective on what the atmosphere was like at the event and compares it to last year.</p>\n<p>Near the end of the show, we explain why the Question and Answer process at the end of the State of the Word will likely undergo changes.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wordpress.org/news/2018/12/wordpress-5-0-1-security-release/\">WordPress 5.0.1 Security Release</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 19th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #341:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Dec 2018 01:59:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WordCamp US 2019 to be Held November 1-3 in St. Louis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86379\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/wordcamp-us-2019-to-be-held-november-1-3-in-st-louis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4527:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/12/st-louis.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://commons.wikimedia.org/wiki/File:St_Louis_night_expblend.jpg\">Wikimedia Commons</a></p>\n<p>Dates for WordCamp US 2019 were <a href=\"https://wordpress.org/news/2018/12/wordcamp-us-2019-dates-announced/\" rel=\"noopener\" target=\"_blank\">announced</a> today, less than a week after wrapping up a successful camp in Nashville. Unlike all previous years held in December, next year&#8217;s event will take place November 1-3 in <a href=\"https://2018.us.wordcamp.org/2018/06/15/matt-mullenweg-announces-st-louis-as-wordcamp-us-2019-2020-host-city/\" rel=\"noopener\" target=\"_blank\">St. Louis, Missouri</a>. </p>\n<p>For the most part, community reactions to the new dates were positive. Early November dates place the event well ahead of the end of the year holidays that attendees had previously bemoaned.</p>\n<p>&#8220;I love this date set better than the previous one. It’s so much easier to attend/speak pre-Thanksgiving,&#8221; WordPress developer Mitch Cantor <a href=\"https://twitter.com/thatmitchcanter/status/1073307921851867136\" rel=\"noopener\" target=\"_blank\">said</a>.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/hashtag/WordCamp?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WordCamp</a> US, November 1-3, 2019. This is great news! December is always a mad dash to an arbitrary solstice-based finish line. Moving <a href=\"https://twitter.com/hashtag/WCUS?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WCUS</a> to November takes a huge load off! <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WordPress</a> <a href=\"https://t.co/WUToY3eiam\">https://t.co/WUToY3eiam</a></p>\n<p>&mdash; Morten Rand-Hendriksen (@mor10) <a href=\"https://twitter.com/mor10/status/1073308742488227840?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 13, 2018</a></p></blockquote>\n<p></p>\n<p>There is always a conflict for some demographic of attendees. This year the hardest hit are parents of small children who will likely miss taking their kids trick-or-treating due to traveling on or before Halloween in order to make it to the event. WordCamp US is a family-friendly event but bringing children to a WordCamp can be extraordinarily challenging, even when the event includes childcare. (This particular event doesn&#8217;t.) For a few attendees, missing Halloween with their children is a deal-breaker. </p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Exactly what I was thinking. I\'d have to fly in on Halloween, no way I\'m missing Halloween with my 2 year old.</p>\n<p>&mdash; Katie Thompson (@katietdesign) <a href=\"https://twitter.com/katietdesign/status/1073341329021775875?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 13, 2018</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">That’s a good point! <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f640.png\" alt=\"🙀\" class=\"wp-smiley\" /></p>\n<p>&mdash; Tessa Kriesel (@tessak22) <a href=\"https://twitter.com/tessak22/status/1073333517646467075?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 13, 2018</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Though this one is something a lot of parents really enjoy spending with their small children especially in the US. We\'re not talking about national hotdog day here.</p>\n<p>&mdash; Patrick Garman (@pmgarman) <a href=\"https://twitter.com/pmgarman/status/1073317197194428421?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 13, 2018</a></p></blockquote>\n<p></p>\n<p>One possible solution for the parents who feel they have to miss WordCamp US because of their kids, might be for the organizers to schedule the contributor day as the first day of the camp. That might enable people to fly in on an early morning flight and still get to experience part of the contributor day and all of the main event. </p>\n<p>In a community this large, with many other holidays and WordCamps already on the calendar, it&#8217;s difficult to find a date for WordCamp US that doesn&#8217;t have conflicts. This is a good problem for the community to have. Matt Mullenweg shared during the State of the Word that the community has experienced 50{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} year over year growth with more than 350K members in 687 meetup groups and more than 5,000 meetup events. With this rate of growth, the community can expect more regional and local camps to spring up in the coming years, which means more conflicts but also more options for getting together in the future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Dec 2018 00:43:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WordPress Plugin Directory Now Features a Curated Section for Block-Enabled Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86331\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/wordpress-plugin-directory-now-features-a-curated-section-for-block-enabled-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4065:\"<p>If you visit the <a href=\"https://wordpress.org/plugins/\" target=\"_blank\" rel=\"noopener\">plugin directory</a>, you will notice a new section at the top featuring block-enabled plugins. WordPress 5.0 has been downloaded more than 8 million times, just one week after its release, and users are looking for blocks to extend the new editing experience. WordPress.org is highlighting plugins to push the block ecosystem forward and will soon be doing the same for themes.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/12/Screen-Shot-2018-12-13-at-9.35.13-AM.png?ssl=1\"><img /></a></p>\n<p>There are currently 94 blocks in the featured section. In a <a href=\"https://make.wordpress.org/plugins/2018/12/07/blocks-plugins-and-you/\" target=\"_blank\" rel=\"noopener\">post</a> on make.wordpress.org/plugins, Samuel (Otto) Wood invited developers to email the plugins team at plugins@wordpress.org if they have a block-enabled plugin that they want to be included. The basic requirements are a plugin that introduces or improves blocks.</p>\n<p>I asked Otto how they select from submissions. He said the plugins team is curating the list manually and adding those they think are good or interesting.</p>\n<p>&#8220;It&#8217;s not a high bar; if it has a neat block, we&#8217;ll add it for now,&#8221; Otto said. &#8220;We may raise the bar depending on how big the section gets, and the section is not final by any means. We&#8217;ll change the inclusions according to how it works out. The goal is to promote neat and cool integrations, but there aren&#8217;t a lot of those yet. It&#8217;s new.&#8221;</p>\n<p>Assigning a tag to block-enabled plugins that authors could opt into would eliminate the need for manual approval on the section, but Otto said they are currently handling it more like a showcase.</p>\n<p>&#8220;Letting the plugin authors just add a tag would reduce the available tags (it&#8217;s already limited to 5) as well as reducing the value of curation,&#8221; Otto said. &#8220;We may change that as well in the future, somehow. Nothing is set in stone right now, we just want to see people making cool blocks and see what happens with that.&#8221;</p>\n<p>A directory devoted entirely to blocks may also be coming to WordPress.org next year. In a recent post, Matt Mullenweg identified <a href=\"https://make.wordpress.org/core/2018/12/08/9-priorities-for-2019/\" rel=\"noopener\" target=\"_blank\">9 Projects for 2019</a>, including &#8220;building a WordPress.org directory for discovering blocks, and a way to seamlessly install them.&#8221; This is a much larger task and requires WordPress to answer a few questions: Will plugins continue to be the primary delivery mechanism for blocks? Or will WordPress.org implement a system where users can download JS-only blocks, similar to the Gutenberg Cloud project? </p>\n<p>Three months ago, Otto <a href=\"https://wptavern.com/gutenberg-cloud-a-cross-platform-community-library-for-custom-gutenberg-blocks#comment-260894\" rel=\"noopener\" target=\"_blank\">commented</a> on a post about Gutenberg Cloud, saying that js-only blocks are likely only suited to frontend enhancements.</p>\n<p>&#8220;I remain unconvinced that js-only blocks have a place which is meaningful other than the trivial layout based things that blocks can do,&#8221; Otto said. &#8220;Yes, you can build great looking blocks with JavaScript only, and since it’s an editor, that is a really big deal. But without any actual support on the backend to &#8216;do stuff of substance,&#8217; it is just visual glitter.&#8221;</p>\n<p>Offering JS-only blocks through WordPress.org might also complicate block discovery if users don&#8217;t know whether to look for blocks in a plugin or via the JS-only block delivery system. There are a lot of unknowns in the block era that will require WordPress to make some decisions. Meanwhile, the ecosystem of block-enabled plugins will continue expanding as more users adopt the new editor and especially as widgets and menus are ported to blocks in phase 2 of the Gutenberg project.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Dec 2018 21:32:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Dev Blog: WordCamp US 2019 dates announced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6496\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/12/wordcamp-us-2019-dates-announced/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:705:\"<p>Save the date! <a href=\"https://2019.us.wordcamp.org/2018/12/12/wordcamp-us-2019-announcing-our-dates/\">The next WordCamp US</a> will be held on November 1-3, 2019, in beautiful <a href=\"https://2018.us.wordcamp.org/2018/06/15/matt-mullenweg-announces-st-louis-as-wordcamp-us-2019-2020-host-city/\">St Louis, Missouri</a>. One of our largest events of the year, WordCamp US is a great chance to connect with WordPress enthusiasts from around the world. This is also the event that features Matt Mullenweg&#8217;s annual <a href=\"https://www.youtube.com/watch?v=r5b-N2RmxS8\">State of the Word</a> address. </p>\n\n\n\n<p>We&#8217;d love to see you in St. Louis next year, so mark your calendar now!<br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Dec 2018 19:47:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"WPTavern: Interview with Rachel Cherry: Automattic Pledges to Fund WPCampus’ Accessibility Audit of Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86293\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/interview-with-rachel-cherry-automattic-pledges-to-fund-wpcampus-accessibility-audit-of-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2477:\"<p>While at WordCamp US, I had the opportunity to catch up with <a href=\"https://wpcampus.org/\" rel=\"noopener\" target=\"_blank\">WPCampus</a> director Rachel Cherry, who is coordinating an audit on Gutenberg for the organization she leads. WPCampus <a href=\"https://wptavern.com/wpcampus-seeks-to-raise-30k-for-gutenberg-accessibility-audit\" rel=\"noopener\" target=\"_blank\">launched its crowdfunding campaign</a> at the end of November and more than $10K has come in towards the <a href=\"https://wpcampus.org/2018/11/fundraising-for-wpcampus-gutenberg-accessibility-audit/\" rel=\"noopener\" target=\"_blank\">$30K goal</a>.</p>\n<p>The day before WordPress 5.0 was released, WPCampus announced that Automattic has pledged to ensure WPCampus&#8217; accessibility audit of Gutenberg is fully funded. </p>\n<p>&#8220;I think that they [Automattic] see that it is important,&#8221; Cherry said. &#8220;Even when they said they weren&#8217;t going to do it, I don&#8217;t think it was ever &#8216;We&#8217;re never going to;&#8217; it was just &#8216;Not right now.&#8217; For us, we couldn&#8217;t necessarily wait for &#8216;maybe we&#8217;ll do it later,&#8217; so that&#8217;s why we jumped on it and got the ball rolling. I think they saw an opportunity where they could step in and have the means to move this along even further. They see the value and I think that&#8217;s why they wanted to jump in. They also saw all the community effort going on.&#8221;</p>\n<p>In the interview below, Cherry discusses how leaders in the WPCampus community rallied to get the audit in motion. The organization has received seven responses from vendors and is currently in the selection process. She also shared a little bit about her conversation with Matt Mullenweg during his community office hours and their discussion about how WordPress is used in higher education.</p>\n<p>Cherry&#8217;s strategy in advocating for accessibility is to focus on slicing through the confusion surrounding accessibility problems with an emphasis on education and communication. Although WordPress has set accessibility standards, the project has fallen short on enforcing them. In addition to putting automated accessibility testing in place for core, Cherry said she would also like to get more support for helping theme and plugin authors meet accessibility standards. This would help ensure that the code WordPress.org puts on the web is more accessible for those who are creating customized sites.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Dec 2018 04:29:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Dev Blog: WordPress 5.0.1 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6498\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/12/wordpress-5-0-1-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4797:\"<p>WordPress 5.0.1 is now available. This is a <strong>security release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n\n\n<p>Plugin authors are encouraged to <a href=\"https://make.wordpress.org/core/2018/12/13/backwards-compatibility-breaks-in-5-0-1/\">read the 5.0.1 developer notes</a> for information on backwards-compatibility.</p>\n\n\n\n<p>WordPress versions 5.0 and earlier are affected by the following bugs, which are fixed in version 5.0.1. Updated versions of WordPress 4.9 and older releases are also available, for users who have not yet updated to 5.0.</p>\n\n\n\n<ul><li><a href=\"https://ripstech.com\">Karim El Ouerghemmi</a> discovered that authors could alter meta data to delete files that they weren&#8217;t authorized to.</li><li>Simon Scannell of <a href=\"https://blog.ripstech.com\">RIPS Technologies</a> discovered that authors could create posts of unauthorized post types with specially crafted input.</li><li><a href=\"https://twitter.com/_s_n_t\">Sam Thomas</a> discovered that contributors could craft meta data in a way that resulted in PHP object injection. </li><li><a href=\"https://security-consulting.icu\">Tim Coen</a> discovered that contributors could edit new comments from higher-privileged users, potentially leading to a cross-site scripting vulnerability.</li><li><a href=\"https://security-consulting.icu\">Tim Coen</a> also discovered that specially crafted URL inputs could lead to a cross-site scripting vulnerability in some circumstances. WordPress itself was not affected, but plugins could be in some situations. </li><li><a href=\"https://yoast.com/\">Team Yoast</a> discovered that the user activation screen could be indexed by search engines in some uncommon configurations, leading to exposure of email addresses, and in some rare cases, default generated passwords.</li><li><a href=\"https://security-consulting.icu\">Tim Coen</a> and <a href=\"https://medium.com/websec\">Slavco</a> discovered that authors on Apache-hosted sites could upload specifically crafted files that bypass MIME verification, leading to a cross-site scripting vulnerability. </li></ul>\n\n\n\n<p>Thank you to all of the reporters for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing the vulnerabilities</a>, which gave us time to fix them before WordPress sites could be attacked.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 5.0.1</a>, or venture over to <code>Dashboard → Updates</code> and click <code>Update Now</code>. Sites that support automatic background updates are already beginning to update automatically.</p>\n\n\n\n<p>In addition to the security researchers mentioned above, thank you to everyone who contributed to WordPress 5.0.1:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron Campbell</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/vortfu\">Ben Bidner</a>, <a href=\"https://profiles.wordpress.org/barry\">Barry Abrahamson</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/darthhexx/\">David Newman</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">Demitrious Kelly</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/hnotess/\">Hannah Notess</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/herregroen\">Herre Groen</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/chanthaboune\">Josepha Haden</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/batmoo/\">Mo Jangda</a>, <a href=\"https://profiles.wordpress.org/nickdaugherty\">Nick Daugherty</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, and <a href=\"https://twitter.com/p_valentyn\">Valentyn Pylypchuk</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Dec 2018 03:13:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Ian Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Post Status: Interview with Matt Mullenweg on Gutenberg, WordPress, and the future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=50403\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/matt-mullenweg-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101863:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Brian Krogsgard.</p>\n<p>In this episode, I am joined by <a href=\"https://ma.tt\">Matt Mullenweg</a>, the co-founder of WordPress and CEO of Automattic.</p>\n<p>Just after releasing WordPress 5.0, and on the heels of WordCamp US, Matt and I review the event, the release, and discuss how he thinks things went, what could have gone better, and what he sees ahead.</p>\n<p>We also dig into WooCommerce, various plans around core development processes, Automattic, and more. I hope you enjoy.</p>\n<p></p>\n<p>And an audio version.</p>\n<p></p>\n<p>Full transcript is coming soon.</p>\n<h3>Episode Links</h3>\n<ul>\n<li><a href=\"https://ma.tt/\">Matt&#8217;s blog</a></li>\n<li><a href=\"https://automattic.com\">Automattic</a></li>\n<li>WordCamp US <a href=\"https://ma.tt/2018/12/state-of-the-word-2018/\">State of the Word</a></li>\n<li>Post Status&#8217;s <a href=\"https://poststatus.com/state-of-the-word-2018/\">coverage of WCUS</a></li>\n<li><a href=\"https://grief.com/the-five-stages-of-grief/\">5 Stages of Grief</a></li>\n</ul>\n<h3>Sponsor: iThemes</h3>\n<p><a href=\"https://ithemes.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">iThemes</a> makes great WordPress plugins, themes and training to help take the guesswork out of building, maintaining and securing WordPress websites. I talk to iThemes CEO Cory Miller during the break to hear about what they are working on, and excited about for the coming year.</p>\n<p>Thanks to <a href=\"https://ithemes.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">iThemes</a> for being a Post Status partner.</p>\n<p>&nbsp;</p>\n<h3>Full Transcript</h3>\n<div class=\"transcript\">\n<p>Brian Krogsgard: Hello and welcome to Post Status Draft. I hope you enjoy this interview with Matt Mullenweg. It lasts for a while, but I think that it&#8217;s worth catching the whole thing. We cover a whole bunch of topics. I want to thank iThemes for being our partner for this episode. iThemes has been in the WordPress space for so, so long and they make many great products, whether you&#8217;re looking to secure your website, manage your plugins and themes and so much more. Go to iThemes.com to learn more and thanks so much to the team at iThemes for being a Post Status partner. Now here&#8217;s the show. So hello and welcome to Post Status Draft. Fresh off of the release of WordPress 5.0 and WordCamp US, I&#8217;m here with Matt Mullenweg, the co-founder of WordPress. Hey Matt.Matt Mullenweg: Howdy, howdy. It&#8217;s good to see everyone again.</p>\n<p>Brian Krogsgard: Yeah, it&#8217;s great to see you. You look comfortable. You must be somewhere that is something like home.</p>\n<p>Matt Mullenweg: Yeah, I&#8217;m in actually New York City this week. I had a few meetings after the WordCamp and it&#8217;s also just one of my favorite cities to be especially this time of year. The lights and everything around Christmas time are just gorgeous, so it&#8217;s fun.</p>\n<p>Brian Krogsgard: Yeah. I&#8217;ve never been to New York City in the Christmas season, but it&#8217;s one of those bucket list type of things. So let&#8217;s start off with just how are you feeling post-release, post-event? How do you feel like things went overall?</p>\n<p>Matt Mullenweg: Super energized. I&#8217;d say like day before the release was pretty nervewracking, but it went better than I think almost anyone hoped, including myself. There was a great energy at WordCamp of we were able to kind of &#8230; I think instead of arguing about whether we should do a release or not, should it be Thursday or Tuesday or next month or never, or all these sorts of different options, everyone would say, &#8220;Okay, it happens. The world didn&#8217;t end and what can we do next to make things better?&#8221; That kind of making things better conversation is where I find the WordPress community is most productive. It&#8217;s where you can really get all sorts of different ideas and you can really get to the point where it does make things better for our users.</p>\n<p>Brian Krogsgard: Yeah. And I tend to think generally people cool down when they&#8217;re in person versus when they&#8217;re online. So all the energy, the pent-up energy from working through all the things that have to do with the release over the course of two years and it finally comes on you, sometimes it just feels good to get it out at the end of the day. You let those bygones be bygones.</p>\n<p>Brian Krogsgard: I felt like it was actually a pretty drama-free release and event. I didn&#8217;t see any major bugs come across. I asked some of the big hosts and some of the big plugin companies, I was like, &#8220;What are you all seeing? Are you seeing a bunch of stuff come through?&#8221; And I didn&#8217;t get much. Have you heard much feedback in terms of, are there a lot of bugs coming up? Are there are a lot of issues or has it been fairly smooth?</p>\n<p>Matt Mullenweg: Well, what I&#8217;ve been telling you all year, that it would be anticlimactic, I was half right. The software was anticlimactic. Everything around the software was pretty intense.</p>\n<p>Brian Krogsgard: Very climactic, yeah.</p>\n<p>Matt Mullenweg: But yeah, I actually didn&#8217;t realize it before I got on for State of the Word, but host site GoDaddy, others have already upgraded over a million sites. They&#8217;re seeing normal support loads, things like that. It&#8217;s like I said, ultimately what drives a release day is, is the software ready? And the software was ready and all the inputs, all the data, all the sort of normal things we look at were there. It was just one of these things where the people, we didn&#8217;t seem ready and that&#8217;s much harder to navigate. Sometimes getting it out there helps a lot, but it&#8217;s one thing that I&#8217;ve seen throughout my entire professional software career is the longer you go between releases the harder they are. I&#8217;ve seen this in small teams, big teams, public, private, inside automatic, outside, whatever it is. If you can get to where you&#8217;re releasing more frequently, it just removes a ton of stress and burden on each individual release and I think makes for ultimately a much better process for everyone involved.</p>\n<p>Brian Krogsgard: Yeah, and I want to dig into more about the process. I was really surprised. I don&#8217;t think I saw a single person share your old blog post about the version 1.0 and the importance of shipping 1.0. Maybe we&#8217;re just getting really old. So referencing a blog post that&#8217;s that many years old is harder now. But yeah, I&#8217;ve been in the camp for a while now that it just seemed like you&#8217;ve got to get it out there. I felt like we always had an advantage in the WordPress landscape and this is one of the things I was worried about when you announced the big feature release style. Here are our three goals and we&#8217;re going to make the releases strategic to that. We had the benefit of iteration when we had the regular releases. So overall do you feel like the tradeoff of losing the regular major releases was worth it in order to get the big thing shipped?</p>\n<p>Brian Krogsgard: I think of like Drupal, the struggles and the boundaries they had going from 6.0 to 7.0 to 8.0 and it was almost like a whole new thing. This was really our first time, in a really long time at least, maybe ever, that you feel like you update and it&#8217;s in some ways a whole new thing, and it was a long release cycle that led up to that. So do you think that tradeoff was worth it or do you think there was a tradeoff? Is my assumption a poor one?</p>\n<p>Matt Mullenweg: Well, there was in that we didn&#8217;t do a major release for a year. We did slip some things that would previously be in major releases in the minor releases, in the 4.9.X kind of releases, so that helped. That&#8217;s a good question. I think that in 2019 we can do both. So we can keep some really super rapid public iteration and the feature plugins, and who knows, I&#8217;d actually love to see a few more kind of areas of WordPress that we want to innovate in or expand in, take more of this plugin approach. And then we also have a lot of great stuff in the hopper for some major releases. I think we&#8217;ll be able to do &#8230; there was a lot of talk at contributor day as we were looking at it.</p>\n<p>Matt Mullenweg: It actually slipped my mind that we did that whole code reformatting and JavaScript reorganization in trunk, and that&#8217;s not in 5.0, right? Because we branched off 4.9.8 to make it as stable and as few changes as possible. So we&#8217;ve got actually, I think there&#8217;s another 200 patches already in trunk that weren&#8217;t in 5.0. So we&#8217;ve just got a lot of good stuff already in there, including the whole reorganization that you kind of put that together plus maybe ServeHappy and the white screen protection and some really cool stuff that&#8217;s kind of more like small stuff. That could be a 5.1 right there. I could see that going in the beta January, RC in February.</p>\n<p>Brian Krogsgard: Yeah, talk about ServeHappy. I mean, for I don&#8217;t know, five, six, seven years, people have wanted, demanded PHP upgrades and it was a footnote in this state of the word.</p>\n<p>Matt Mullenweg: I should have done it as one more thing.</p>\n<p>Brian Krogsgard: One more thing, yeah. Had to really get all the developers on your team for that one. So you made a commitment to in 2019 have a staggered upgrade process to mandate certain versions of PHP. Remind me if I&#8217;m incorrect, 5.6 in the Spring and 7.0 next winter. Is that basically the timeline?</p>\n<p>Matt Mullenweg: Yeah, that&#8217;s the idea and we&#8217;re just going to go through. And again this is, just like with Gutenberg, it&#8217;s not about changing a version number or something. It&#8217;s really about bringing the whole community along for the ride, so we need to scan all the plugins. For 5.6, I think we&#8217;ll actually be able to update them or send patches to maintainers, even update and maintain plugins, because those changes are pretty easy. Seven is tougher and I think that is, we&#8217;re targeting December for that. I could see that slipping, just depending on whether host in the meantime and everyone else is able to get there, but even getting to 5.6 opens up a ton of possibilities, including with things like OAuth and GraphQL and namespaces, and there&#8217;s some pretty cool features. 5.6 is ancient at this point. It had a lot of improvements over 5.2.</p>\n<p>Brian Krogsgard: And a lot-</p>\n<p>Matt Mullenweg: And we still have a lot of folks on these older versions, so part of the reason we&#8217;re giving ourselves time as well is to, if we can run some analytics to figure out which host these old sites are on Ron and reach out to them, try to work with them.</p>\n<p>Brian Krogsgard: Do you think a part of the reason why you even think this is possible, for a long time, I mean, people were running WordPress across a huge spectrum of versions of PHP. Do you think part of the reason why you even think this possible is the hosting relationships that had been made between the community and the hosting companies over the past few years? Because that&#8217;s something that I&#8217;ve felt like has been quite significant. The efforts that, if you look at the big ones, the GoDaddy and the Bluehosts of the world, the amount of commitment they&#8217;re giving to the community, do you think that&#8217;s a big part of it? And how hard is the long tail going to be to capture, do you think?</p>\n<p>Matt Mullenweg: That&#8217;s a big question. First, I&#8217;ll say that the improvement of hosts, particularly the big ones in becoming kind of like WordPress first, providing a really first-class WordPress experience from security updates, everything, it&#8217;s probably been the biggest change in the WordPress ecosystem over the past five years. And I have huge admiration for them because they&#8217;re doing this for millions of sites, thousands of support folks. They&#8217;re really moving some really, steering some really large ships and the results have been fantastic. We got, I think it was up to 68{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of our WordPress was on 4.9 by the time 5.0 come out.</p>\n<p>Brian Krogsgard: Yeah, that&#8217;s great.</p>\n<p>Matt Mullenweg: But in terms of what&#8217;s going to make the PHP upgrading easier, it&#8217;s really a combination of everything, including time, including some of this white screen protection stuff that we&#8217;re doing. If we can back port that, you know we still backport to 3.7 all of our security updates?</p>\n<p>Brian Krogsgard: Mm-hmm (affirmative).</p>\n<p>Matt Mullenweg: Which is kind of wild.</p>\n<p>Brian Krogsgard: It is. It&#8217;s great for security of the Web broadly, but it&#8217;s quite something.</p>\n<p>Matt Mullenweg: Yeah, if we can do that for some of this, maybe we can put some of this white screen upgrade protection into those old versions, so that way we can kind of protect people who might be doing plugin and theme or core updates from breaking their site in programmatic way. Um, it&#8217;s also the work that&#8217;s gone into updates. We know we migrated to a new data center this year for WordPress.org It&#8217;s like, I forget the exact or something like five or 10 times more powerful than the old one.</p>\n<p>Brian Krogsgard: Wow.</p>\n<p>Matt Mullenweg: Almost no one noticed. But you notice that there&#8217;s no more 503s when we run the updates, and things can go faster. This means we can do auto updates better, which means that we&#8217;ll be able to do opt-in for core and plugin and theme auto updates and then maybe move that to opt-out 2020. These are all just things that have been going on that represent thousands of hours of work from hundreds of people that set the stage so we can do stuff. It&#8217;s part of the reason I think that we will be able to move a lot faster in 2019. We had to stop core ,essentially freeze it for Gutenberg, because we were building a new foundation and you can&#8217;t build the house on top while you&#8217;re also pouring the concrete, right? Things will sink. They&#8217;ll get off center. I&#8217;ve never built a house so I don&#8217;t know this analogy all the way, but now we&#8217;ve got the foundation. We&#8217;ve got this framework and things being built on top of that framework. We&#8217;re already starting to see the benefits to things like keyboard navigation and accessibility when they&#8217;re built using Gutenberg fields that already have this kind of baked in.</p>\n<p>Matt Mullenweg: So I think that we have the opportunity to do just a massive upgrade not just of the editor but of every single plugin, every single theme, every single person&#8217;s experience with WordPress because think about it. No one just runs core. Cool if we do Gutenberg in core? Ultimately it doesn&#8217;t matter. Everyone&#8217;s got five, 10, 20 different plugins. They&#8217;ve got their theme which might implement who knows how many additional features baked into the theme? Probably dozens, if you think about all the customization options, that&#8217;s all going to be able to be reimagined now and already is. We see some of this, over 100 themes in the plugin directory. You might have noticed we put the Gutenberg-ready plugins at the very top, even above featured. We&#8217;re really trying to get everyone on this train.</p>\n<p>Brian Krogsgard: Do you think there was a messaging gap in a trying to get across the idea that Gutenberg is a foundation rather than a window dressing or wallpaper or whatever other nonstructural housing component we want to compare it to?</p>\n<p>Matt Mullenweg: Well, I think it&#8217;s easy to say that there was a messaging gap and that communication could have been 10 times better or whatever, because there are obviously some people who wren&#8217;t on board and still aren&#8217;t on board. So now, is there anything that could have gotten everyone 100 percent?</p>\n<p>Brian Krogsgard: No.</p>\n<p>Matt Mullenweg: I don&#8217;t know, but I think we will always strive to do better. And ultimately, I mean, one of the things that made me pretty confident about the release wasn&#8217;t that Gutenberg is perfect. It&#8217;s not. By the way, it&#8217;s still not right for a ton of people, but that&#8217;s okay. You know WordPress, unlike almost every other SaaS service or software use gives you control. And the fact that we have classic editor as a first party supported official thing and that anyone for whatever reason, literally any reason, can still use the old experience instead. That&#8217;s what I meant when I said 5.0 was going to be anticlimactic, not that it meant Gutenberg was perfect or ready for everyone, but that forever was not wordy. They&#8217;re just a click or two away before or after the release from having the experience that they used to.</p>\n<p>Brian Krogsgard: Yeah, one of the things I like to remind myself of is that neither was TinyMCE perfect or right for everyone.</p>\n<p>Matt Mullenweg: Well, no.</p>\n<p>Brian Krogsgard: And that&#8217;s why it was being replaced. So I think sometimes we do have to look at what are we trying to replace and what do we have right now? Is that worth getting out into the world and iterating on?</p>\n<p>Matt Mullenweg: Did you see those user tests videos?</p>\n<p>Brian Krogsgard: I did. Unfortunately my wife said, &#8220;Do you want to go see the Harlem Globetrotters?&#8221; And I was like, &#8220;Absolutely.&#8221; And I didn&#8217;t have WordCamp US on my calendar yet.</p>\n<p>Matt Mullenweg: Oh, don&#8217;t worry, don&#8217;t worry.</p>\n<p>Brian Krogsgard: So we double booked, so I re-watched the whole State of the Word, including the user tests, the Q and A, the whole thing, and it was pretty amazing seeing those user tests. I&#8217;ve seen people do user tests before. They&#8217;re often really terrible.</p>\n<p>Matt Mullenweg: Painful.</p>\n<p>Brian Krogsgard: That&#8217;s why for years I&#8217;ve tried to make my own message that we need to continually support things that make WordPress easier to use, so I think that was a good thing to highlight in the State of the Word.</p>\n<p>Matt Mullenweg: And by the way, I probably would&#8217;ve picked the Harlem Globetrotters over me as well, so o need to apologize.</p>\n<p>Brian Krogsgard: It was the first one I&#8217;ve missed since like 2012.</p>\n<p>Matt Mullenweg: That&#8217;s awesome. That&#8217;s great. I&#8217;m an average live experience. The Harlem Globetrotters are amazing live.</p>\n<p>Brian Krogsgard: They are.</p>\n<p>Matt Mullenweg: You can always catch State of the Word on vide later.</p>\n<p>Brian Krogsgard: They are. I may as well use the opportunity too to thank [David Bisset 00:15:39], because he did a fantastic job with both tweeting things and just generally keeping people that follow along with Post Status up to date and it turned out to be a good outlet for him because twitter banned his personal account because they thought that he was tweeting so much.</p>\n<p>Matt Mullenweg: Wasn&#8217;t that wild?</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: I know. That guy is a national treasure of WordPress.</p>\n<p>Brian Krogsgard: He is. He is. If there was a community spirit award, he should win it.</p>\n<p>Matt Mullenweg: Absolutely.</p>\n<p>Brian Krogsgard: So he stood up to ask a question during the State of the Word and unfortunately ran out of time, so I would-</p>\n<p>Matt Mullenweg: Right, I felt so bad that we didn&#8217;t get to &#8230; There were a lot of people in line, but just some of those earlier questions were a bit longer and I could tell the room was starting to, like I think we were already like an hour 45. We were pretty far into it, so &#8230;</p>\n<p>Brian Krogsgard: Yeah, and maybe we&#8217;ve put a 30-second clock next year for people to ask a question.</p>\n<p>Matt Mullenweg: I&#8217;ve been thinking about that, like there were some definitely things in the room this year, like it was very dark in the audience so it was a little harder to see. I think that also subdued people. There was a little more distance between the stage and the people which looked a little more theatrical, but I think also made the audience a bit more disconnected. And even, there was a funny thing. You saw the spotlight on the question askers?</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: It was so bright and at an angle that it was shining in the eyes of everyone sitting next to them. So after the first or second question there, there was a huge hole in the audience next to the mic because we were just getting like it had this crazy spotlight on it. I think we can figure out some different ways of doing lighting or doing the questions in the future that might be a bit a bit easier.</p>\n<p>Brian Krogsgard: Well, you&#8217;ll have that opportunity in St Louis, right, for the next two years.</p>\n<p>Matt Mullenweg: Woo hoo, St. Louis. I&#8217;m very excited about that.</p>\n<p>Brian Krogsgard: Yeah, I&#8217;m excited about that too. I haven&#8217;t been there in a long time, and what David-</p>\n<p>Matt Mullenweg: I love that we&#8217;re doing the opposite of Amazon. They had the opportunity to pick any city in America and they go to D.C. and New York.</p>\n<p>Brian Krogsgard: I know.</p>\n<p>Matt Mullenweg: They&#8217;re both amazing places, but not really shining a light on places that don&#8217;t get as much love already.</p>\n<p>Brian Krogsgard: Yeah, I think my-</p>\n<p>Matt Mullenweg: And we&#8217;ve had Philly, Nashville and now St. Louis, I really dig the WordCamp US thing.</p>\n<p>Brian Krogsgard: Yeah. I have feeling that Amazon may have been including some political reasoning and in their strategy for that, but that&#8217;s okay. WordPress doesn&#8217;t have to do that. We can go wherever we want.</p>\n<p>Matt Mullenweg: We can go to Canada, which was one of the questions, which I thought was kind of cool.</p>\n<p>Brian Krogsgard: Including Canada, which was a good question. I actually had that brought up to me before WordCamp about the U.S./Europe thing and whether we can learn from that and have WordCamp Americas or something.</p>\n<p>Matt Mullenweg: Yeah, what&#8217;s your thought on Central America in that equation?</p>\n<p>Brian Krogsgard: Yeah, I mean I think that there&#8217;s a lot of cultural differences, but I think anything Americas, there&#8217;s some common themes of people that work hard, people that explored many centuries ago. So I don&#8217;t know, I&#8217;m probably not the best person to answer that type of question, but &#8230;</p>\n<p>Matt Mullenweg: I&#8217;ve been thinking about it a lot, like what are the logical divisions and because we do have some rules in the WordCamp world around like what could be &#8230; I&#8217;d love to see a WordCamp Asia, for example. Asia is obviously geographically, culturally and language-wise, incredibly diverse.</p>\n<p>Brian Krogsgard: Right, I think the lingual differentiation would be a challenge, so I don&#8217;t know what the best regions would be but perhaps-</p>\n<p>Matt Mullenweg: But then look in Europe.</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: It has a ton of languages [inaudible 00:19:08] English.</p>\n<p>Brian Krogsgard: I always envy friends in Europe because they all speak like five languages plus, and some of them speak better English than I do.</p>\n<p>Matt Mullenweg: Oh, for sure. Have you ever seen a map of the lower 48 overlaid over Europe?</p>\n<p>Brian Krogsgard: Yeah, it&#8217;s very, very similar in size, so-</p>\n<p>Matt Mullenweg: Yeah, it&#8217;s actually, you forget how large actually the lower 48 of the U.S. is that it covers kind of like into Europe, pretty far into Russia and Turkey and Middle East.</p>\n<p>Brian Krogsgard: Yeah. We think of Alabama and Houston or Birmingham, Alabama and Houston, Texas as pretty close, but that could be different countries if we were in Europe with different languages and culture. It&#8217;s a reminder of the diversity in our space and how serving different cultures and people from different backgrounds is extremely important. All right, so David&#8217;s question was, what are the dates for WordCamp next year? Do we have any idea?</p>\n<p>Matt Mullenweg: Oh, I think we know them. I&#8217;ll put them out later. They&#8217;ll be in a blog post or something.</p>\n<p>Brian Krogsgard: Okay, he will be disappointed again.</p>\n<p>Matt Mullenweg: Well just, I don&#8217;t know if I could tell you the day of the week of my birthday or something. I&#8217;m pretty bad at dates.</p>\n<p>Brian Krogsgard: No, that&#8217;s fine.</p>\n<p>Matt Mullenweg: As you might guess from-</p>\n<p>Brian Krogsgard: Is it going to be in December again, though?</p>\n<p>Matt Mullenweg: I believe so. Don&#8217;t hold me to anything there. I will officially find something.</p>\n<p>Brian Krogsgard: But late in the year still.</p>\n<p>Matt Mullenweg: Yeah, yeah, so I think that we&#8217;ll put up like a placeholder site for 2019, and there will definitely be some tweets and some official stuff saying the dates.</p>\n<p>Brian Krogsgard: Okay.</p>\n<p>Matt Mullenweg: But to your earlier point, I actually feel what you just described of going between countries in Europe, I feel that when I&#8217;m, excuse me, on the East Coast of America because I can actually drive eight or 10 hours and still be in Texas. I can drive two hours over here and cross through three different states. And that was one of the points that I tried to make. This was actually I think one of my weaker Q&amp;As. I had two answers that were two of the worst answers I&#8217;ve given probably the past few years, and one was what people heard me say, which I wasn&#8217;t trying to say, to Morton&#8217;s thing.</p>\n<p>Matt Mullenweg: Which I was trying to make the point that in a distributed organization or where we have people working across things, you can read into someone&#8217;s language and it might not be their first language, so it&#8217;s really good to give the benefit of the doubt and realize that we&#8217;re not all speaking our native tongue. And so things might come across as harsh or worse or rude or things, when it&#8217;s just not at all. It&#8217;s certainly not the intention of the person to communicate that way. And the other was the answer, I think it was Birgit&#8217;s question about being hired to work on things.</p>\n<p>Brian Krogsgard: Yeah, corporate sponsorship for WordPress work.</p>\n<p>Matt Mullenweg: Yeah, neither &#8230; I think my brain was just a little fried by the end of the day.</p>\n<p>Brian Krogsgard: So what would you adjust in terms of, I think that question was around how to &#8230; I was actually with you with Morton, that I didn&#8217;t notice the issue. It seemed like you were pretty clearly speaking about broader communication things, not specifically with his communication, which is-</p>\n<p>Matt Mullenweg: I would never make fun of Morton&#8217;s or anyone&#8217;s skills speaking another language.</p>\n<p>Brian Krogsgard: Yeah, and that one was pretty clear to me. But the one about corporate sponsorship, do you think there&#8217;s a place for &#8230; How do you encourage independent work on the WordPress community, nonprofit side of things? Is there a place or a way that that can be done without corporate sponsorship? Because I know, I mean I&#8217;m self-employed and I can personally understand if I suddenly gave 10 or 20 hours a week or whatever amount of time to the core project in a non-revenue generating way that would be felt. So is there a way that that can be done, or do you think corporate sponsorship of community work is really the only way to go about it right now?</p>\n<p>Matt Mullenweg: Well, let me take a second crack at this one. First and foremost, I never want to downplay the contributions of people doing it in their spare time.</p>\n<p>Brian Krogsgard: Yeah, and it is, I mean it&#8217;s astonishing and I could be that person, too. I don&#8217;t choose to be that person in this stage of my life, but yeah, it&#8217;s amazing what people are doing completely outside of work time.</p>\n<p>Matt Mullenweg: Yeah, and I also don&#8217;t want to understate how big an impact on the WordPress project, two to four hours a week out of the 168 can have a really huge impact on some big areas. Even a single hour a week, if put in the right place, can move mountains. And WordPress was largely built by volunteers and people doing it in their spare time, and I worry to say, to ever get to a point where we&#8217;re saying we only value people who are doing it full time, or it&#8217;s only possible to make a change if you&#8217;re doing it full time. So that&#8217;s one point I was trying to make, that let&#8217;s never downplay the value that people can do with just a little bit of contributions. Five for the Future is just two hours a week in a work week, right?</p>\n<p>Brian Krogsgard: Right, yeah, and that was the question [Daniel Bock Huber 00:24:12] had was if you had plans or iterations that you thought would be good for Five for the Future?</p>\n<p>Matt Mullenweg: Oh, for sure. The second is that the WordPress Foundation is not designed to be an employment entity. Now, there&#8217;s no employees. There&#8217;s no HR. There&#8217;s no benefits. There&#8217;s no payroll. There&#8217;s no anything, and going from zero to one there is actually a pretty big thing. It is designed to give grants. We can give money to other organizations. By the way, I think that there&#8217;s also a big opportunity for other nonprofits to be part of this. There&#8217;s no reason to say only for-profit corporations can sponsor people that work on WordPress. I would love to see more nonprofits that by the way have a lot more expertise in some of the areas that we want more contributions in, including design, accessibility, privacy, internationalization.</p>\n<p>Matt Mullenweg: These things, there&#8217;s full nonprofits dedicated to that have often sometimes very large staffs and pretty large budgets, journalism. These I think are really fruitful areas, and in fact one of the things that, I don&#8217;t know if you saw Morton&#8217;s talk, a lot of people I thought misread it. Maybe I misread it as well. When he was talking about open governance, my take was that he was talking about getting WordPress a seat at the table, and discussing these regulation changes and et cetera happening. I think the example last year was, there was this meeting at 10 Downing Street. Who was there? Was WordPress represented?</p>\n<p>Matt Mullenweg: And he started talking about the Web Foundation, and I began thinking. I was like, &#8220;Wow, well, WordPress only represents a third of Websites, and not even, really. It&#8217;s a third of the top 10 million. Another foundation like the Web Foundation actually might be a better vehicle to try to advocate on the open Web as a whole, versus just the people who happen to be using a single CMS.</p>\n<p>Brian Krogsgard: Yeah, and I don&#8217;t want to speak for him in terms of which audience he was trying to, or which group he was trying to represent in terms of within WordPress, or WordPress within the broader Web. I do think that there are often questions about governance of WordPress. You have long been the central vision of the project, and then delegated the execution of that vision to many other people who then lead this project, which is massive at this point. One of the things I&#8217;ve always asked you for several years now was, how many people do you have directly reporting to you?</p>\n<p>Brian Krogsgard: Because one of the things I find to be important is under this model, where your vision is required, then if you&#8217;re spread out so thin it requires these sprints to focus towards WordPress, rather than always being able to have kind of a constant flow, even if it&#8217;s a minority of your time, going towards that, establishing that vision for WordPress. So, how have you evolved in that regard? I know you&#8217;re-</p>\n<p>Matt Mullenweg: What was the number last time you asked me?</p>\n<p>Brian Krogsgard: It was high.</p>\n<p>Matt Mullenweg: What is high? There was one point it was like 26 or something.</p>\n<p>Brian Krogsgard: Yeah, it was in the 20s. It was in the 20s last year I think when we talked about it.</p>\n<p>Matt Mullenweg: Yeah, it&#8217;s under half that now.</p>\n<p>Brian Krogsgard: That&#8217;s great.</p>\n<p>Matt Mullenweg: So, that&#8217;s been really good. There&#8217;s been a lot more leaders, but I would actually argue the point that WordPress has always been sort of my vision being set, or even my direct leadership. There was a good four or five years there where the leadership structure, because we&#8217;ve experimented with lots of different, we don&#8217;t call it governance, but essentially leadership structures in WordPress. For a while, we had kind of the &#8230; It wasn&#8217;t a committee approach, but essentially like the lead developers consensus approach. We did that for a few years.</p>\n<p>Matt Mullenweg: Even from the beginning it wasn&#8217;t just me. It was me and Mike Little, so it&#8217;s never been solo. Then we went to where the release lead was the final decider, including over me, so that was probably, I don&#8217;t know, 3.9 to 4.7 maybe, that including could overrule me as project lead for what was in the release or not, and that was to try to give a little more autonomy and flexibility to release leads. But the big change was a few years ago I said, &#8220;Okay, I&#8217;m going to take back over core WordPress development,&#8221; and that was to try to provide a &#8230; Try to make some of these big changes happen. So right now it is much more of a benevolent dictator model, although both of those words are questionable. But, I don&#8217;t see that as the permanent forever structure, you know? [crosstalk 00:28:54]-</p>\n<p>Brian Krogsgard: One problem with that is-</p>\n<p>Matt Mullenweg: I don&#8217;t know if I can sustain this forever. I mean, this is a pretty intense period and we&#8217;re doing some pretty intense work, and I&#8217;ll need a break at some point, too.</p>\n<p>Brian Krogsgard: Yeah, and how do you, or do you think there&#8217;s merit in opening that up in some way to certainly have more community input, but sometimes that&#8217;s not good, you know? Sometimes the central vision idea can be more productive, but when you bring that into open source software versus running a company, maybe there&#8217;s different consequences. So have you given any thought to what does WordPress look like after this phase in terms of a governance structure?</p>\n<p>Matt Mullenweg: It&#8217;s hard, because I haven&#8217;t seen any models where anything resembling voting works, you know?</p>\n<p>Brian Krogsgard: Yeah, for running software, you mean.</p>\n<p>Matt Mullenweg: Yeah, and for choosing a direction. It&#8217;s not that many models for consumer-facing software. There&#8217;s some for server-facing software, where sort of like a committee approach works, you know? It seldom creates great user experiences. You kind of want, I&#8217;m not saying it always has to be me, but what I want is a strong, opinionated, thoughtful leader doing, setting a bold direction, taking experiments and being willing to fail, comfortable with failure, is I think what you need to create great software.</p>\n<p>Brian Krogsgard: So how do you-</p>\n<p>Matt Mullenweg: And that&#8217;s tough, and by the way, we&#8217;ve had lots of those leaders in the history of WordPress, and I think that&#8217;s been the success. It&#8217;s not just because I&#8217;m doing anything.</p>\n<p>Brian Krogsgard: Sure.</p>\n<p>Matt Mullenweg: It&#8217;s that we have lots of folks and we have, as a community including myself, invested that authority and power in them, and that trust. It doesn&#8217;t mean that it&#8217;s always been right, like we&#8217;ve definitely done things that we might undo later or that were mistakes, but the ability to make those mistakes is what you need for an innovative organization. When you look at any organization, private or public, it&#8217;s too afraid to fail, that&#8217;s when you get this kind of incrementalism. That&#8217;s when you get this kind of fear of change. That&#8217;s when you essentially stagnate, and if you were to point to any place that software goes poorly, whether that&#8217;s in government or companies that don&#8217;t innovate or get disrupted by smaller upstarts, anything, it&#8217;s because one of those happened or probably all of those things happened. They got too successful and then they were afraid to fail, because it was too embarrassing and they had too much to lose, and then they stagnate.</p>\n<p>Brian Krogsgard: All right, we&#8217;re here to take a quick break and I want to thank our partner, iThemes, long-time supporter of Post Status. I&#8217;ve got Cory Miller on with me to talk about what they&#8217;ve got going on. Hey, Cory.</p>\n<p>Cory Miller: Hey, Brian, thanks for having me on.</p>\n<p>Brian Krogsgard: Yeah, it&#8217;s my pleasure and I appreciate your support over the years. I was hoping that you could just tell me maybe what&#8217;s a big success iThemes had in 2018, and what you&#8217;re looking forward to next year?</p>\n<p>Cory Miller: Yeah, as you know in January of 2018 now we were acquired. iThemes was acquired by a great hosting company named Liquid Web, so this year has been spent integrating. We are almost done with the first round of integrations for our key product, iTheme Sync, which promotes site management for freelancers and agency WordPress Websites, BackupBuddy, our long-time popular plugin, and securities. So we&#8217;re almost done with the final round of that. You know in any transition there&#8217;s always bumps, but it&#8217;s been a really good ride so far.</p>\n<p>Brian Krogsgard: Yeah, have you been getting good feedback from LiquidWeb customers so far, or I guess are you looking forward to seeing iThemes products more integrated with LiquidWeb&#8217;s stuff?</p>\n<p>Cory Miller: Very much so. We saw hosting as the future for WordPress. All of the big hosting companies making significant investments in WordPress, and this was a way to join forces with a great hosting company and for our products, our team, to live on into the future doing really good things in WordPress.</p>\n<p>Brian Krogsgard: Cool, and iThemes products are still available outside of LiquidWeb as well. You can use them on any host that you choose, or a naked VPS if you want help managing a server that you want to pull all the lever, you can still do that but you can use all the iThemes tools to help you manage the day, and [inaudible 00:33:31] out of your WordPress Website. I&#8217;m really excited for you guys and what you have going on, and look forward to hearing more as next year comes along. Thanks for being on real quick, and if people want to learn more about what you&#8217;ve got going on, where do they go?</p>\n<p>Cory Miller: iThemes.com, best place to click some links and see if we are offering something that you&#8217;re in need of. We&#8217;d be happy to serve you.</p>\n<p>Brian Krogsgard: Awesome, well, thanks for being such a big part of the WordPress community these last 10 years plus, and a partner of Post Status for as long as Post Status has existed.</p>\n<p>Cory Miller: Yeah, we love Post Status. Keep doing what you&#8217;re doing, Brian. Thank you.</p>\n<p>Brian Krogsgard: Thanks, buddy. Bye. We&#8217;ve got another question from Ant in regards to giving people a seat at the table in a governance structure, which was seeking an update on the growth council, whether that was productive this last year, whether it happened. How can it happen going forward? I don&#8217;t know anything about what&#8217;s happened in the last year, so what have you learned there, and what&#8217;s happened?</p>\n<p>Matt Mullenweg: Yeah, so we created these two growth councils, one consumer one and one enterprise one, and we did these monthly meetings, video chats. And my goal with creating it was one, to bring some people together, so there are direct competitors in these meetings. It&#8217;s enterprise agencies that are bidding on the same clients. It&#8217;s Web posts that are advertising on the same key words and everything. And so you&#8217;d have like that as part of the discussion, and one of the goals also was to produce, improve essentially the WordPress experience.</p>\n<p>Matt Mullenweg: Some parts were successful, some parts weren&#8217;t, so I was amazed and humbled by how people came together. I think it really showed something I&#8217;ve tried to demonstrate with Automatic in the past, that you can both compete and work together for a greater good. People were both able, because it was a safe space, they were able to share things that were going on in their companies, things they were hearing from clients that they couldn&#8217;t talk about publicly, things they were seeing, experiences, in a safe space that generated some amazing discussions. I&#8217;ll also say selfishly that I learned a ton being part of these meetings, so it was really, really valuable for me.</p>\n<p>Brian Krogsgard: And that&#8217;s about how their organizations work and what&#8217;s important to them, or what kind of stuff?</p>\n<p>Matt Mullenweg: And the people they&#8217;re talking to, whether that&#8217;s consumers, kind of the more mass market side particularly with Web posts, but also with people doing trainings, people building small Websites, which is my kind of mental model was like, if it&#8217;s people spending under $100,000 a year for a site that&#8217;s the consumer group. If it&#8217;s over $100,000 a year, that&#8217;s the enterprise group. Not exact, but that was kind of like a rough mental model. And on the enterprise side, what are they seeing? It was so interesting as well, like most of the big agencies started building sites with Gutenberg kind of like February, March, and were launching them over the summer. Now at this point, they&#8217;re basically building everything. They&#8217;ve been building everything new with Gutenberg for the better part of a year.</p>\n<p>Brian Krogsgard: Yeah, I actually spoke with Tom Wilmot from Human Made and Jake Goldman from 10up both, and they&#8217;ve both expressed that they had an early embrace of Gutenberg and seen success with it. Somebody was telling me, I think it might have been Tom, that they showed off a demo of Gutenberg and instantly blew some Adobe experience manager style feature out of the water. Some company had spent gargantuan sums of money on the alternative experience, and they did a couple customizations with Gutenberg over the course of a couple weeks and showed them this as a prototype. It was already far superior to what their competition was putting forward, so from those-</p>\n<p>Matt Mullenweg: There&#8217;s got to be so much of that.</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: At Gutenberg, people have written bad versions of what Gutenberg is, including myself, for five years now. And now we&#8217;ve got this standard we can all build on. I actually had it right here. Human Made had this really cool white paper. I don&#8217;t know if you&#8217;ve seen this.</p>\n<p>Brian Krogsgard: Nice, yeah, they printed it.</p>\n<p>Matt Mullenweg: It&#8217;s glossy, it&#8217;s pretty &#8230; I mean, these are the types of things that for enterprises are really important. PDFs, white papers, case studies, and enterprise section of WordPress.org, important for that user group. For a consumer, a lot of things that that team talked about was the importance of talking about different use cases and allowing users to self-segment over the job they want to get done, and having some guides for that, some recommended plugins, essentially hand-holding them through the process of it.</p>\n<p>Matt Mullenweg: So I talked about what was successful about the councils. I&#8217;ll tell you what didn&#8217;t go as I hoped, producing things. I think because it was all often the CEOs of their companies or kind of the head folks, it was difficult for them to get time other than the meetings, in between the meetings, to just do work to produce for example a new enterprise section of WordPress.org. So actually on Saturday morning, I officially dissolved the councils.</p>\n<p>Brian Krogsgard: Okay.</p>\n<p>Matt Mullenweg: What I told the folks was, we&#8217;re not going to schedule out these meetings for the rest of the year. I left the Slack channels up so people could keep chatting if they want, and of course I said if anyone wants to keep meeting on their own, they&#8217;re happy to, or to continue the projects, and both groups said they would like to. The enterprise group wants to get the enterprise subsection of WordPress.org out. The consumer group wants to continue shipping some things, but it was a year and we didn&#8217;t ship these things, that honestly probably any &#8230; It could have happened within a month or two if it had had a lot of focus from any of the people involved. It illustrated to me actually the difficulty of a committee approach.</p>\n<p>Brian Krogsgard: Yeah, it makes me think of-</p>\n<p>Matt Mullenweg: One of the things that came up was the enterprise. We did drinks on Saturday as a kind of ending thing. It was a combined consumer and enterprise, and one of the things is they were like, &#8220;Hey, if you had just chosen one person to be in charge of this, that person could have said, &#8216;You do this, you do this, you do this,&#8217; it would have shipped probably pretty quickly.&#8221; But because no one knew who was in charge and who could tell other people to do things, I think it was Jake who said, &#8220;I&#8217;m not sure if I can tell Tom, &#8216;You need to finish this page,&#8217; or &#8216;You didn&#8217;t edit it.\'&#8221; Who&#8217;s in charge? And so that&#8217;s I think unintentionally illustrated an alternative group and management style that, because if it wasn&#8217;t adjusted and set up correctly, which is my responsibility, my fault, and not getting the results that we wanted. So, great experiment though, and I&#8217;m really, really glad we did it.</p>\n<p>Brian Krogsgard: Yeah, I wonder, you see movies or you see a senate hearing or something, and you have the primary people at the center table and then you have all their deputies on the outside. They&#8217;re still in a safe space, but they&#8217;re the people that actually go out and do things afterwards. It&#8217;s not like the senator or the CEO on that council necessarily that&#8217;s implementing, but they bring other people from their organization in to help the implementation component.</p>\n<p>Matt Mullenweg: I was kind of hoping more of that would happen. It&#8217;s true, some people on the councils were contributing individually, and some lead larger organizations so they can shepherd a lot of resources as well. So, I think there&#8217;s some of both that&#8217;s needed in the WordPress world. Yoast and myself are probably good examples, Yoast the person, not the company, of a leader who&#8217;s really passionate about areas, who also brings along a lot of their company to work on it.</p>\n<p>Brian Krogsgard: Yeah, they have a lot of manpower there.</p>\n<p>Matt Mullenweg: Oh, yeah.</p>\n<p>Brian Krogsgard: That they&#8217;ve got dedicated to core.</p>\n<p>Matt Mullenweg: Person power.</p>\n<p>Brian Krogsgard: Person power, thank you.</p>\n<p>Matt Mullenweg: Yoast had an incredible effect on Gutenberg and the 5.0 release, even though they&#8217;re smaller than all of the hosts, all of everything else. I think it&#8217;s a great example of Five for the Future.</p>\n<p>Brian Krogsgard: So I have one more process question, and then I want to dig into phases two through four, but Darren Ethier I think is how I pronounce his last name, he asked what were your thoughts process-wise on using GitHub for probably the most ambitious-sized project yet with WordPress from a feature plugin or feature point of view? Do you think it was encouraging enough to potentially start moving off track in SVN? I do know there was a make WordPress post that was about this, but I&#8217;m curious your personal experience, whether you liked being in GitHub day to day or using Git in the process, or if you missed track in terms of that development?</p>\n<p>Matt Mullenweg: I mean, I&#8217;m an early adopter of GitHub. My user name is literally the letter M, to show you how early it was, and I really like it. I think it&#8217;s a great product. Having kind of a parallel process, where I&#8217;ve now been involved pretty heavily in something on TRACK, involved pretty heavily on something on GitHub, there&#8217;s pluses and minuses. I wouldn&#8217;t say either is a panacea. The thing that actually makes the real difference is much more your engineering management. It&#8217;s your triage. It&#8217;s your process. It&#8217;s the testing. On both GitHub and TRACK, we made mistakes and had tickets that sat for weeks without anyone responding to them.</p>\n<p>Matt Mullenweg: That doesn&#8217;t have to do with the software. It has to do with the people, and I do worry the distraction of effort and time that switching source control and issue trackers and just also all the work that needs to be done to migrate all the tooling at the same time, if it would distract us from what&#8217;s actually most important in 2019, which is to tighten up some of our loose parts of the software. So that&#8217;s the only reason I&#8217;m hesitant to commit to saying that we&#8217;re going to do anything, particularly in 2019.</p>\n<p>Matt Mullenweg: Also, I am a big fan of GitLab, obviously. I see a lot of, I noticed a lot of comments on Helen&#8217;s post for actually advocating for GitLab. All of these things are getting better pretty rapidly. GitHub was slow for a while, and now they&#8217;re really picking it up. Time is kind of on our side if we switch later, because whatever we switch to will be six or 12 months better than it is today, and probably provide perhaps more of a compelling step function and user experience than is currently there, which is yes, I totally agree the interfaces are more modern and there&#8217;s better tools, and I do strongly prefer Git for branching and all these other things. There&#8217;s almost nothing you could tell me about either way that is an argument I haven&#8217;t heard or made myself. But it&#8217;s more just about a community focus thing, and what is the issues most urgently impacting WordPress users, both current and potential, today?</p>\n<p>Brian Krogsgard: I like what you say there in terms of the urgency factor, because I think I agree with you. Personally, if I were to do something to try to actually make code changes in SVN, I would always have to go remind myself, how do I patch something, and do I have the tools on my modern MacBook to do so? Whereas by &#8230; Go ahead.</p>\n<p>Matt Mullenweg: I was just going to say, we&#8217;ve built a lot of bridges between them as well. WordPress is synced to Git. You can do things both ways. We have tools for migrating patches between them. We&#8217;ve got official GitHub for WordPress. There&#8217;s a lot of stuff out there, but there is a point when I really want to focus on the developer experience and really invest some serious, serious time into that, but we&#8217;ve got to get the user experience right first.</p>\n<p>Brian Krogsgard: Yeah, I think I&#8217;m with you in terms of that priority, but long-term bringing on new people to be comfortable developing on the software, most people in their day to day are in GitHub or in Git more broadly, so even the self-hosted Git version or GitFlow I think in the long run would be good, but I like what you said there about the urgency component.</p>\n<p>Matt Mullenweg: Well, that&#8217;s one of the things I was looking at a lot, because that is one of the I think better arguments for using something centralized like GitHub, is that a lot of people have GitHub accounts.</p>\n<p>Brian Krogsgard: Mm-hmm (affirmative).</p>\n<p>Matt Mullenweg: Basically there was a while, I&#8217;ve reviewed probably over 10,000 engineering applications for Automatic. Every single one of them has a GitHub link. There&#8217;s definitely something to be said for that. I didn&#8217;t notice that big a difference in type or number of contributions, so it is a barrier to entry to make a WordPress.org account. It doesn&#8217;t appear to be the most salient factor in determining whether people submit patches or are active in TRACK or not-</p>\n<p>Brian Krogsgard: Interesting.</p>\n<p>Matt Mullenweg: Active in [inaudible 00:46:57] TRACK or not.</p>\n<p>Brian Krogsgard: I&#8217;d be curious how that ends up working if it was officially there, but nevertheless let&#8217;s move on to-</p>\n<p>Matt Mullenweg: Well, just look at the numbers, because Gutenberg was as official as anything, and the numbers of contributors to that versus the number of contributors that we have in any given core release, kind of similar. I think that the hard part is actually deciding that you&#8217;re going to dive into the code. The hard part is saying like, &#8220;I&#8217;m going to take this code. I&#8217;m going to figure out the problem and then submit the patch.&#8221; And once you&#8217;ve been through that, making an account one place or another, I think it&#8217;s probably something you&#8217;ll do one way or another.</p>\n<p>Brian Krogsgard: So phase one of Gutenberg mostly complete, or at least out the door, and you&#8217;re going to be iterating on this every two weeks like you told me before. Let&#8217;s talk about phase two through four, and let&#8217;s start with just why do you think that the order that you established things in is the right order? Why do you think this is the right direction, I guess, overall?</p>\n<p>Matt Mullenweg: Yeah, some of it is sequential and some of it is not. Are you familiar with the Kubler Ross Five Stages of Grief?</p>\n<p>Brian Krogsgard: No, I&#8217;m not.</p>\n<p>Matt Mullenweg: It&#8217;s like anger, denial, depression, acceptance. You&#8217;ve probably seen these before.</p>\n<p>Brian Krogsgard: Yeah, I&#8217;ve seen this in terms of markets. It&#8217;s the same stages of grief are identified in market cycles, so like in the stock market it&#8217;s a very similar thing, but I didn&#8217;t know it was called that.</p>\n<p>Matt Mullenweg: I don&#8217;t have one on my desk, but I actually have some glasses that I often use for drinks that have little markers on them, and it actually has the five stages.</p>\n<p>Brian Krogsgard: Nice.</p>\n<p>Matt Mullenweg: We could put that in the show notes for the podcast, a link to those.</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: A common misperception, I ended up actually reading one of her books called On Grief and Grieving, and it was actually finished posthumously, so she actually passed away in the process of it. This is I think Elizabeth Kubler Ross, or I forget the exact name, but amazing book. Good to read even if you&#8217;re not going to go through grief or grieving, because we all do at some point. One of the most fascinating things I took from that book was people think of those stages as sequential, and actually they can happen out of order, and they can happen simultaneously. In fact, you can go through anger and denial and acceptance and everything all in the same kind of 10-minute period.</p>\n<p>Matt Mullenweg: That was a really fascinating insight to me just of the human condition, because we are often more complex and less sequential than sometimes our simplified systems would like to say, or we&#8217;d like to think. Development is the same way. Phase one is not stopping where phase two is starting, and I think bits of phases one through four have already happened and will continue to happen as we go through it. It&#8217;s just more about priorities. We&#8217;ve gotten the editor experience to the point where I think it&#8217;s pretty darn decent, especially for new users. Now people, if you look at people who started using WordPress in a post-Gutenberg world, of which there are now hundreds of thousands, so they&#8217;ve only known Gutenberg. This is that example of the support person who said, &#8220;Bring me back the simple editor,&#8221; and they meant Gutenberg?</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: What is the new barrier that they&#8217;re running into? What&#8217;s the new wall they&#8217;re hitting? It&#8217;s the rest of the site. It&#8217;s customization. It&#8217;s widgets.</p>\n<p>Brian Krogsgard: So for those that don&#8217;t have these phases locked down in their brain, phase two is customizing outside of the post content itself as the next point of emphasis. So this could be widgets, menus and miscellaneous content. David posted a funny picture on Twitter where you looked like you were in deep thought during the State of the Word and he said, &#8220;I wonder what Matt&#8217;s thinking about right now?&#8221; You said it was probably the process of transporting menus to Gutenberg.</p>\n<p>Matt Mullenweg: Oh, yeah.</p>\n<p>Brian Krogsgard: Moving, I feel like this is something that&#8217;s happened every few years [crosstalk 00:51:12] in WordPress, it&#8217;s like the old menu system, then the new menu system, then the customizer menu system. Now we&#8217;re talking about menus here, and also not calling it menus but reshaping to navigation.</p>\n<p>Matt Mullenweg: And navigation block, I think is probably a good way to put it.</p>\n<p>Brian Krogsgard: Yeah, it seems like we&#8217;ve got some debt in regards to spending time on things that then we don&#8217;t use for a super long time, so how can we do the Gutenberg way of site customization and content and try to be efficient and long-lasting with that effort?</p>\n<p>Matt Mullenweg: Well, I mean first we&#8217;ll start doing it in plugins, in the Gutenberg plugin actually, just like we did for the editor. And so we can have, one of the reasons Gutenberg is where it is is because we did do a lot of user testing along the way, and it wasn&#8217;t just testing mock-ups or ideas. We had the actual working plugin on actual working WordPress sites so they could run. That makes a world of difference, so we&#8217;ll be able to do that for the customize, replacing widgets.PHP, piece of cake. That&#8217;s just taking over the page. The customizer is a little trickier, but we can do it because all of Gutenberg was designed to be responsive.</p>\n<p>Matt Mullenweg: Essentially, the customizer side bar is very similar to a mobile view, a narrow screen. It&#8217;s kind of like instead of a wide version, it&#8217;s a narrow version of that interface, so I think we can slip in there. Mainly it just requires a lot of rethinking, and there are some tough concepts that currently blocks don&#8217;t have, like the idea of widget visibility, which is [crosstalk 00:52:49].</p>\n<p>Brian Krogsgard: Yeah, I was about to say conditionality, or like show it here but not there. That&#8217;s one of the experiences that seems like it could get really confusing, because someone&#8217;s on a post and they change a sidebar, and therefore they think they changed it just there but they changed it everywhere, vice-versa. There&#8217;s a lot of UX things that seem like they could get complicated.</p>\n<p>Matt Mullenweg: Yeah, so we&#8217;ve got to figure that out, to be honest. I don&#8217;t have the answer right now. We&#8217;ve got to experiment and test our way into what works there, because there are some powerful and complex concepts that I think we can maintain, but just make a lot more intuitive and also make not so in people&#8217;s face. So if they don&#8217;t need to have widgets or blocks that only show up on the sidebar of search pages, it&#8217;s not kind of in their face and making them think about things. It&#8217;s that whole thing, making it more powerful and more intuitive at the same time.</p>\n<p>Matt Mullenweg: But currently, blocks don&#8217;t have a concept of that, but if we solve it for sidebars, widget areas, whatever you want to call it, perhaps we could solve that for blocks everywhere they&#8217;re used. Showing different headers on different pages is not something that is currently supported by most themes on different types of templates, but why not? That would actually be pretty cool, different footers on different types of pages. I could easily imagine different types of sites that would do this.</p>\n<p>Matt Mullenweg: It also raised a good point, which is kind of what has always been one of my bugaboos about front end editing, is that when I&#8217;m writing, I want to focus. I don&#8217;t want to see my header and footer and sidebar and all this other stuff, much less edit them. I think, I mean I&#8217;ve always talked about zooming in and zooming out, Gutenberg essentially being like a new 3D interface for WordPress. I think we want to make it very easy to kind of zoom in and out, including focus on one single area or even one single block, if you really want to work within that.</p>\n<p>Brian Krogsgard: And that means in some ways potentially front end editing too, right? When I think about Gutenberg, the one beef I have with writing in WordPress is all the other stuff beyond the editor. Whether it&#8217;s TinyMCE or Gutenberg, I write mostly text and a few images. I&#8217;m not doing a lot of page layout, and I love the tools that Gutenberg&#8217;s brought in. For instance, you brought up some of Nick Hamze&#8217;s blocks. I talk to Nick sometimes, and he&#8217;s got so much creativity and I love that it empowers that. But for 90{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of the things I&#8217;m going to do, I&#8217;m just writing. A clear, focused writing area is what I like, so I actually just don&#8217;t like the fact that I can go into the appearance editor and the plug in screen. Those are all one click away, rather than just saying, &#8220;Here&#8217;s the page.&#8221;</p>\n<p>Brian Krogsgard: The best Gutenberg interact I&#8217;ve had yet was actually WordPress.org/Gutenberg, because I was experiencing Gutenberg. It&#8217;s a live demo of Gutenberg. I was able to experience Gutenberg, and none of the other stuff was there. It was just a column of content, and I really enjoyed that, so is that a part, a way that you think we can focus on how to get to writing and not worrying about everything else?</p>\n<p>Matt Mullenweg: We can support both. I mean, you currently have a version of this in Gutenberg where it can show the menu or not, or you can go to the mode which is my preference mode, where Gutenberg takes over the whole screen so you don&#8217;t have a sidebar menu there, even minimized. I actually strongly prefer that.</p>\n<p>Brian Krogsgard: See, I didn&#8217;t even know that. I&#8217;ve missed that.</p>\n<p>Matt Mullenweg: Oh, yeah, yeah, so go in Gutenberg to the top right, the dots. I&#8217;m trying to think exactly where it is. Are you opening your WordPress as well?</p>\n<p>Brian Krogsgard: I am.</p>\n<p>Matt Mullenweg: We&#8217;ll go through this together.</p>\n<p>Brian Krogsgard: I might take over my screen share here, but that&#8217;s okay.</p>\n<p>Matt Mullenweg: Oh yeah, do you want me to screen share?</p>\n<p>Brian Krogsgard: No, I mean I&#8217;m recording us.</p>\n<p>Matt Mullenweg: Oh, got you, got you.</p>\n<p>Brian Krogsgard: So people, this might end up on YouTube or something.</p>\n<p>Matt Mullenweg: So in the three dots, there is three kind of options there.</p>\n<p>Brian Krogsgard: Oh, yeah.</p>\n<p>Matt Mullenweg: Tool bar, spotlight mode and full screen mode. I actually am in full screen mode. I strongly, strongly prefer it.</p>\n<p>Brian Krogsgard: Neat.</p>\n<p>Matt Mullenweg: Top tool bar I don&#8217;t think is that useful, but they know that. This was basically, there was a huge kind of fight earlier. If you look at Yoast&#8217;s original post about the plan for Gutenberg, there alternative UI is basically all about the top tool bar. Then spotlight mode I also don&#8217;t love, but some people really like it. It kind of grays out the other blocks and then makes the current block you&#8217;re in more visually prominent.</p>\n<p>Brian Krogsgard: Cool, and for anyone that happens to be watching this, I just popped it up onto the screen where you can see exactly where that is, so that&#8217;s really cool. I learn new things every day.</p>\n<p>Matt Mullenweg: Yeah, and so even this menu, like I&#8217;m looking at this menu right now. Do you have it open?</p>\n<p>Brian Krogsgard: I do.</p>\n<p>Matt Mullenweg: I want to talk through some things that could be really improved here. So for example, originally we didn&#8217;t have this descriptive text under each of these three views.</p>\n<p>Brian Krogsgard: Mm-hmm (affirmative).</p>\n<p>Matt Mullenweg: Well one, the text should be views, not view, and I think that there is, we can improve that text. Under editor, I don&#8217;t know if visual versus code is actually very intuitive, and two, under code editor, I think it&#8217;s a beautiful place to expose that you can actually go into the code editor on a per-block basis, so just a little bit of text there that says, &#8220;Hey, also per block you can go into this.&#8221; Manageable reusable blocks needs the square and the little pointy thing that shows that that&#8217;s going to take you out of Gutenberg, and I think it does open a new window.</p>\n<p>Matt Mullenweg: And I think that we should put some sort of star or cool icon next to keyboard shortcuts, because once you learn those, you are off to the races. So just a good example that as far as we&#8217;ve come with Gutenberg, you can look at a single screen and immediately think of four or five things that are very improvable and that are certainly worth testing and getting out there.</p>\n<p>Brian Krogsgard: Yeah, that&#8217;s neat.</p>\n<p>Matt Mullenweg: I always joke I&#8217;m the unhappiest WordPress user in the world. It&#8217;s hard for me to look at anything in WordPress and not see all the things that could be made better, and just be terribly impatient to get them better as soon as possible.</p>\n<p>Brian Krogsgard: So, speaking of impatient, you&#8217;re going to have to &#8230; Well, you might be able to work on some of these things at the same time but also there is a phase, a priority, and number three was about collaborative editing. For me, I think of this not even necessarily like me and you might collaborate on a post, but sometimes I want to collaborate with myself. My favorite tool from Automatic that you guys have built is probably Simplenote, because it&#8217;s like the only to-do app-ish thing, and it&#8217;s very unstructured, but it&#8217;s the only to-do app type of thing that I&#8217;ve ever really used in depth, because it&#8217;s really easy to open. It&#8217;s really easy to start writing, and it&#8217;s instantly on my phone. So for me, collaborative editing in some ways is just this simple process back and forth.</p>\n<p>Matt Mullenweg: Across devices.</p>\n<p>Brian Krogsgard: Yeah, across devices.</p>\n<p>Matt Mullenweg: Totally.</p>\n<p>Brian Krogsgard: Because I do a lot of stuff through my phone, but your collaborative editing is much more than just cross-device. It&#8217;s also cross-individual, and people building things together. Why do you think that&#8217;s an important thing to be in core WordPress experiences?</p>\n<p>Matt Mullenweg: Hmm, that&#8217;s a good example of something that there&#8217;s not a bajillion people asking for right now. But just like post revisions, which is one of my favorite things I&#8217;ve forced to be in WordPress that I think is really fundamental to have the entire system works, this-</p>\n<p>Brian Krogsgard: Yeah, a lot of people have been saved by revisions.</p>\n<p>Matt Mullenweg: Yeah, I think this idea that when you&#8217;re editing in a post, the post is almost like an object and people from different devices, different things, can all come and be simultaneously working on that same object, is a mental model that is technically extraordinarily difficult. But if you get it right, it&#8217;s just a magical user experience. Even simple stuff, like do you remember when Netflix started saving where you&#8217;d watched up to across devices?</p>\n<p>Brian Krogsgard: Mm-hmm (affirmative), yeah, that&#8217;s great.</p>\n<p>Matt Mullenweg: Magical, and it&#8217;s so simple.</p>\n<p>Brian Krogsgard: Yeah, I use that a good bit. We use that a good bit with our son, because the easiest way for him to be happy in a car is to have somebody&#8217;s phone. You can pull up Super Wings or whatever, right where he left off, so yeah, I do agree. And even when Google Docs came out with that, it was revolutionary in a way but people didn&#8217;t realize how much it would transform the way they write documents, so &#8230;</p>\n<p>Matt Mullenweg: Totally, and we&#8217;ve got, the Web now supports technologies like WebRTC, that will perhaps enable us to do this even without centralized service, which is super cool, too. Because before, I was &#8230; Conspiracy theorists won&#8217;t believe this but I was actually really disappointed that it looked like the only way we could do this was in Jetpack. Now, it looks like we&#8217;ll actually be able to do this in a much more distributed fashion.</p>\n<p>Brian Krogsgard: Interesting. Funny enough, I didn&#8217;t even think about that conspiracy theory and everything. As delightful as that sounds to think about, I didn&#8217;t consider the centralization aspect of it.</p>\n<p>Matt Mullenweg: Yeah, so it&#8217;s definitely, there&#8217;s some stuff out there that&#8217;s possible. By the way, there might still be something where Jetpack can enhance it, or maybe we use Simperium, which is the engine behind Simplenote, to do something even fancier, but we can do a lot without that. But this also requires us to rethink our user flows around what versions, what it means to edit something. Because right now, you and I can kind of be on different paths, and we can save each other and merge over each other. And what is the relationship between what&#8217;s on the edit screen versus what&#8217;s live? That also is going to apply now to the entire site, so maybe what you and I are working on together is the new version of Post Status, and you&#8217;re changing the typography and I&#8217;m moving the widgets around and things like that, and then we&#8217;re setting that to go live at 12:00 pm on a Tuesday.</p>\n<p>Brian Krogsgard: Yeah, that&#8217;s really cool. Another element of that that is a quirk in WordPress I guess, but you could publish a post and now I want to update it, but I don&#8217;t want to update it right now, but I want to save what I&#8217;ve updated.</p>\n<p>Matt Mullenweg: Mm-hmm (affirmative).</p>\n<p>Brian Krogsgard: Right now it&#8217;s either, it&#8217;s all about your current session. Once it&#8217;s published, you either update it or those changes are basically gone. You don&#8217;t kind of save a draft of an update, so a work flow like this would inherently basically have to solve a problem like that, so that would be nice.</p>\n<p>Matt Mullenweg: Basically, we&#8217;re going to reimplement Git in the post-content table, in the WP Post table.</p>\n<p>Brian Krogsgard: Yeah, that sounds like no problem.</p>\n<p>Matt Mullenweg: Piece of cake.</p>\n<p>Brian Krogsgard: Yeah, on that note, do you think there are underlying architectural changes that WordPress is going to have to go through to enable both this experience, because this is Gutenberg, but also I mean you&#8217;re probably faced with some of the problems that a tool like WooCommerce has in terms of scalability and being the right tool for the job for that next level of application. These aren&#8217;t blogs anymore, but we basically have the same data base, the same data base structure. You can extend it. You can change things, but do you think there&#8217;s rethinking that needs to be done in that regard?</p>\n<p>Matt Mullenweg: Sure, and I actually think that [inaudible 01:04:12] is I think we have the opportunity to readdress and in a very backwards compatible way provide a path for people to upgrade some data structures, some things that have been hanging around for a while. An obvious one is widgets are a serialized array. Now we can move that to being JSON. There&#8217;s the native structure, data structure that Gutenberg uses behind the scenes. For some reason, we have to store this as like HTML plus comments, we can just store it in the native data format, which is pretty cool.</p>\n<p>Matt Mullenweg: By the way, as we increase the MySQL version, we can actually query and get things out as JSON objects directly from MySQL. We don&#8217;t have to take them in and out of strings, so there&#8217;s just some clean-up, some fun stuff we can do. When we get higher PHP versions, we can name spacing doing different things. J-Trip&#8217;s been talking about doing some pretty cool composer stuff. All of this is, we&#8217;re getting the user part back on track and so that also means we can start to invest a lot more in that developer experience, which I think is crucial. Also I feel, I have a ton of empathy for, I actually for better or worse, I interact every day a lot more with developers than I do with users, so I really try to get out of my way to interact with users, but you can imagine the gripes and pains of developers is something that is more of my daily experience.</p>\n<p>Brian Krogsgard: So we&#8217;ll have time to talk about all these phases over the next few years, but quickly what do you see in terms of the number of sites where having a multilingual setup, and this is around the focus of phase four, how often are you encountering Websites like that, and how much do you think that this being a part of the WordPress experience would be empowering for people to actually support more languages and more language versions of their site?</p>\n<p>Matt Mullenweg: I think it would be a really big fundamental concept. The Web is global. English or single language is actually I think a small minority. People who speak one language is a small minority of the seven billion people in the world. This is obviously very prevalent in places like Quebec, where there&#8217;s officially French and English, and of course all over Europe. This is why I get the question every year for Camp Europe. I am monolingual, ashamedly so.</p>\n<p>Brian Krogsgard: Yeah.</p>\n<p>Matt Mullenweg: But the world is polyglots, and that&#8217;s why I named the mailing list WP Polyglots, not WP translate or WP anything, when I set that up almost 15 years ago now. Even for monolinguists like me, I got someone contacted me the other day saying, &#8220;Hey, can I translate this Gutenberg FAQ into Japanese? Do I have your permission to?&#8221; And they put it on a different site. How cool would it have been if I just could have said, &#8220;Hey, by the way, collaboration and work flow, here, you now have access to make this post into Japanese,&#8221; and now at the top it&#8217;ll have a little link to it, to the Japanese version, and there will be sort of a neural structure in a canonical place for the MA.TT version of the Gutenberg FAQ translated to Japanese by this volunteer, where anyone in the world could live. And by the way-</p>\n<p>Brian Krogsgard: I was about to say, what if it was permissionless, like just if someone wants to make something on my site in other languages, do it. As small as Post Status is, I&#8217;ve had people that want to recreate the members side in Dutch or something.</p>\n<p>Matt Mullenweg: Cool.</p>\n<p>Brian Krogsgard: I&#8217;m like, I can&#8217;t do that, but that sounds amazing if you want to do that. But I&#8217;d be totally down if the structure was there for it to say, translate this post, and it&#8217;s almost like forking software, or almost the way language packs and plugins work. You don&#8217;t have to be responsible for every language pack if you&#8217;re the plug in author. Someone can just come and do it, and I think that&#8217;d be really cool for posts.</p>\n<p>Matt Mullenweg: That would be so cool, and by the way, layer that in with other plugins. Layer that in with membership, so you only allow members to translate things, or layer that in with one I&#8217;d love to re-evaluate which is [Blickey 01:08:23]. So there is public revision history and sort of moderated submissions, so maybe I have, maybe my colleague [Nalco 01:08:34] can moderate Japanese translations, but maybe she doesn&#8217;t have time to translate every single one of my posts herself. But when people submit one, she could take a few minutes to just read it through and make sure they&#8217;re not having [crosstalk 01:08:47].</p>\n<p>Brian Krogsgard: Yeah, translate my post and make it sound completely different.</p>\n<p>Matt Mullenweg: Yeah, I think it&#8217;s actually WordPress.com.</p>\n<p>Brian Krogsgard: Assuming good intent is part of the thing there.</p>\n<p>Matt Mullenweg: Do you remember the Happy Birthday incident?</p>\n<p>Brian Krogsgard: I don&#8217;t.</p>\n<p>Matt Mullenweg: Someone, because when we opened up kind of like more totally community translations on WordPress.com and made it easy for anyone to do it, someone changed where it said comments, like leave a comment, into Happy Birthday! I forget what language it was, Italian, so all Italian sites under every single post would say Happy Birthday!</p>\n<p>Brian Krogsgard: Just Happy Birthday!</p>\n<p>Matt Mullenweg: Which I think is kind of like the most brilliant, if you&#8217;re going to troll or vandalize us, that was a really lovely way to do it.</p>\n<p>Brian Krogsgard: Yeah, we could probably learn some things from Wikipedia&#8217;s own editorial flows and how to implement something like that. I do think that would be really neat. Do you think that still leaves room for other plugins that are doing various multilingual things? Does it leave room for them, or do you think it kind of eats them up and makes that business model go away? Because there&#8217;s been some good-sized businesses in that realm.</p>\n<p>Matt Mullenweg: It leaves room for them 100{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}. In fact, I think it increases them a ton. Same thing with page builders. If you look at where the business model is for a lot of these translation plugins are going, they&#8217;re actually helping you do the translation. That makes total sense. If I&#8217;m a business, I might want my site in five languages. If I can click a button and just say, &#8220;Hey, I&#8217;ll pay you $1,000,&#8221; and by the way the plugins can be in the middle of that or there can sort of be an API for that. I mean, this is kind of incredible, but the downside of them is very similar to page builders, which is each kind of has its own way to do the data and the storage.</p>\n<p>Matt Mullenweg: Some put it all in post content. Some put it in custom post type. Some put it in meta fields. Some put it in separate tables, so you essentially have actually each of the possible ways you could kind of logically do this exists. So now, if I&#8217;m building a plugin that wants to work with multilingual versions of the site, how do I do it? There&#8217;s no common foundation. Exact same issue we had with blocks. There were blocks on WordPress for years now, but every single visual composer and Beaver Builder and Elementor and Avada and Divi, they all did blocks in a different way.</p>\n<p>Brian Krogsgard: Matt, there&#8217;s like 100 business questions I want to ask you but we&#8217;re over an hour already, so I will-</p>\n<p>Matt Mullenweg: Can we take a few more minutes, like maybe wrap it in like, say 10?</p>\n<p>Brian Krogsgard: Yeah, sure. If you&#8217;re down, I&#8217;m down.</p>\n<p>Matt Mullenweg: You&#8217;re one of my favorite people to talk to.</p>\n<p>Brian Krogsgard: Well, I appreciate it. I love talking to you as well, and I appreciate your openness.</p>\n<p>Matt Mullenweg: Between you all, honestly you all and the Tavern folks, these are so much fun. I actually listen to a lot of these podcasts. It&#8217;s really enjoyable for me, so I appreciate you doing it. My ask of you for 2019 is, I&#8217;d love to see a bit most Post Status on the scene, you know?</p>\n<p>Brian Krogsgard: Yeah, that&#8217;s a task for myself as well, so I did a relatively personal update recently.</p>\n<p>Matt Mullenweg: I saw that.</p>\n<p>Brian Krogsgard: One of the things that I&#8217;ve struggled with is I haven&#8217;t been in the thick of things in about four years, so I&#8217;m actually not spoiled, but I&#8217;m doing some part-time work actually being in WordPress, and back into doing stuff.</p>\n<p>Matt Mullenweg: Cool.</p>\n<p>Brian Krogsgard: It&#8217;s actually on the product side, not the service side. I&#8217;ve worked in an agency. This is going to give me a chance to do some part-time work on the product in SaaS side of things, so I&#8217;m excited about that. I know from history, when I&#8217;m working hard on something, whether it&#8217;s building my own site or working in the industry, it gives me much more to say, so I&#8217;m excited about being inspired by working within our space more, and within the experience more. Because it&#8217;s been four years of not doing that, and over those years I&#8217;ve tried to rely on other people to have a voice more as I felt like mine was fading. Kind of like what you were saying, you&#8217;re around developers all the time and not, like you want to be around more users. I was looking at the industry a lot, and not being in the industry I felt made it more difficult to have good things to say.</p>\n<p>Matt Mullenweg: Although I would say the outside perspective is really valuable as well.</p>\n<p>Brian Krogsgard: Yeah, I think at least for a season I need, it&#8217;ll be really beneficial for me.</p>\n<p>Matt Mullenweg: I can&#8217;t wait to see, and by the way, as a member of the Post Status community, include us along for the ride. I&#8217;m sure after that personal update you got a ton of people contacting you [crosstalk 01:13:14].</p>\n<p>Brian Krogsgard: I did, which I was very thankful for.</p>\n<p>Matt Mullenweg: It&#8217;s one of those things, I think what was beautiful about that is you opened up about the struggle, not just about the good stuff. It&#8217;s really scary to be vulnerable like that, publicly. It was scary of me to put the things we learned and did wrong in the State of the Word, right? I just wanted to talk about all the good stuff, but it&#8217;s like it&#8217;s important for us to talk about what I messed up on. People help when they see that.</p>\n<p>Brian Krogsgard: Yeah, that was very-</p>\n<p>Matt Mullenweg: And I think the most valuable thing you built is like overall a pretty positive community that cares about WordPress deeply, so that&#8217;s awesome.</p>\n<p>Brian Krogsgard: Yeah, and thank you, and I was very appreciative of the various responses that I got between feedback and ideas and job offers. But I&#8217;m excited to do some work within the space, and you know actually it did give me, it was beneficial because I got my head kind of out of the space a little bit, which I needed. I&#8217;ve been thinking about WordPress a whole lot since 2010, with basically no break, and I can&#8217;t imagine how you feel at times. But for me to still have a focus on WordPress but at least spend part of my week thinking about other things, doing other things, it gave me some personal benefits I think, and allowed me to look at WordPress things with a bigger picture. So I&#8217;m excited for 2019 and I think it&#8217;ll be a lot of fun. Now for you, just-</p>\n<p>Matt Mullenweg: Well, I often tell people if you&#8217;re ever feeling not inspired or burnt out, go to a museum. Watch a show. All of my best ideas for WordPress have always come from the intersection of different fields, different areas, and I think that&#8217;s true of most great art, most great software, most great anything. So if you can get out there and keep, the WordPress stuff or whatever you&#8217;re working on will be in the back of your mind anyway, so if you can kind of focus on something else for a little while, actually really it&#8217;s fun.</p>\n<p>Brian Krogsgard: It is.</p>\n<p>Matt Mullenweg: I can&#8217;t wait to see what you do. As always, let me know if I can ever be of help.</p>\n<p>Brian Krogsgard: Well, thank you very much. So a couple of business-y things. One is, what&#8217;s your biggest product right now, from an Automatic perspective? Are you guys seeing a lot of growth in the WooCommerce space, or is dot com still the main revenue driver? What are you seeing there?</p>\n<p>Matt Mullenweg: Sure, let me just think through what I can say publicly.</p>\n<p>Brian Krogsgard: When are you filing your S-1, Matt?</p>\n<p>Matt Mullenweg: Yeah, we make the same joke in Automatic that they made at Apple, which is we&#8217;re a ship that leaks from the top.</p>\n<p>Brian Krogsgard: Hey, I have to commend you, as someone who doesn&#8217;t like it but I can appreciate that this is the case. You guys are pretty good about being tight-lipped on the leaky boat side of things, so it&#8217;s a tight ship. I don&#8217;t get near as many of the leaks as I would like out of Automatic.</p>\n<p>Matt Mullenweg: Well, I think a big part of that is just most of what we do is in the open. If you want to see the pricing tests we&#8217;re running on the new blogger and e-commerce plan that we just launched on WordPress.com, it&#8217;s in the Calypso GitHub so you can see which prices we&#8217;re charging which people, and how the test is going, and what percentage it&#8217;s going out to. Kind of, it&#8217;s all out there. WordPress.com is still the largest, and it&#8217;s still growing like a weed. I think in 2018 WooCommerce will actually grow faster in a year over year percentage, which is kind of what I started saying. We&#8217;re starting to see what I predicted when we actually first brought WooCommerce in, which is that the e-commerce opportunity has the potential to be bigger than all of the rest of Automatic&#8217;s businesses combined.</p>\n<p>Brian Krogsgard: Yeah, what&#8217;s Shopify, like eight billion plus market cap, maybe 15? I don&#8217;t know. I think they doubled their size in 2018.</p>\n<p>Matt Mullenweg: Yeah, market cap is just vagaries of the market, but revenue, they&#8217;ll be about a billion dollars this year. So I think it&#8217;s always good to look at kind of, when sort of comparing companies, look at the revenue not just the market cap.</p>\n<p>Brian Krogsgard: Sure.</p>\n<p>Matt Mullenweg: So they&#8217;ll be at a billion dollars and still growing at a really, really good rate. Now, the other reality is that nothing that we do is completely disconnected. A lot of the WooCommerce growth and increasing user experience is sort of amplified, I think, because we&#8217;ve been doing it in Jetpack, which is also amplified by running Jetpack code on WordPress.com and having that sort of stream of new users that are coming there, and so we see the problems that they&#8217;re having, and the struggles, or we build the infrastructure.</p>\n<p>Matt Mullenweg: You asked about data structures earlier. I think one thing that we&#8217;ll start to see a lot more of in WordPress, and actually a very common feature of Jetpack that people don&#8217;t know about, that the Jetpack business plan, you can have full Elasticsearch version of your site. So there are certain use cases for which I don&#8217;t think MySQL is the best medium with which to address or query your data, and Elasticsearch is pretty much the cat&#8217;s meow. So the fact that we can in real time, create real time Elasticsearch indexes for every single Jetpack business site, which only costs $300 per year. Before that, it used to cost &#8230; Actually, I think VIP used to charge $5,000 or $10,000 a year for this, maybe even a couple grand a month, actually. Now we can do it for $300 per year.</p>\n<p>Brian Krogsgard: Wow.</p>\n<p>Matt Mullenweg: And that&#8217;s just one of the features in Jetpack Business. That&#8217;s in addition to the real time backup and the activity log and all the other things, the security restores. It just shows that we&#8217;re really surfing the outer edge of Moore&#8217;s Law, and I think that the stuff that we&#8217;re going to be able to do over the next few years is going to be pretty amazing, and I&#8217;m excited about Automatic. We also just moved DNS Perf, we moved back into second place for fastest DNS service, so by the way, way ahead of Amazon, way ahead of Google, and second only to Cloudflare, which Automatic&#8217;s network is tiny but mighty. Cloudflare invests I think over 100 million dollars per year in capex, building out their data centers in their kind of points of presence. We&#8217;ve reached a number two performance ranking with a fraction of that investment, so very proud of that team, very proud of all the folks at Automatic that are really building this out. By the way, then that benefits all the users of Jetpack Photon, the CDN, just so much cool stuff happening.</p>\n<p>Brian Krogsgard: That&#8217;s awesome. I heard recently that you all have also been able to lower some of your prices for VIP as you&#8217;re deploying like VIP Go and some of that stuff with scalable Websites. Back when I had my hands in a few VIP sites I think the lowest pricing back then was maybe $3,000 to $4,000 a month, and now you can do it as low as $1,000 a month and you all provide a lot for that, so that&#8217;s impressive.</p>\n<p>Matt Mullenweg: That sounds about right, yeah. I&#8217;m not up on the latest there, but fundamentally my business philosophy is to get the best stuff in the hands of as many users for as low a price as possible, and we&#8217;re just relentless in kind of cutting the costs, bringing things down, trying to leverage the best and newest technology to do so.</p>\n<p>Brian Krogsgard: How are you attacking the very high end, so that a store that may grow up on WooCommerce doesn&#8217;t feel like they have to leave WooCommerce once it hits a certain scale? One of the things that I feel like people have been, I&#8217;ve been hearing from consultants especially, is that they get to a certain size and then they&#8217;re really struggling with WooCommerce, and then something like Shopify ends up being the answer. How is WooCommerce going to compete in that realm to be the platform for Macy&#8217;s or who knows what? Some big company with lots of orders and lots of stuff, so that you can keep them throughout the life cycle?</p>\n<p>Matt Mullenweg: Yeah, I think my take on that problem, because ultimately what we want to do is be more scalable in Shopify and also a better user experience, and right now I would say they&#8217;re ahead in both. There hasn&#8217;t been as good a feedback loop. The thing that made WordPress so scalable was there was a tight feedback loop between the host, the agencies building the biggest sites, WordPress.com itself being a big site, and the core development. So that meant that when we had bottlenecks, we were able to solve them often in core in ways that were ultra scalable in Webscale.</p>\n<p>Matt Mullenweg: WordPress.com is on its own one of the largest sites on the Internet, so that&#8217;s the same software that you can download and use, which is kind of wild. For WooCommerce, that loop isn&#8217;t as strong so one of the things I&#8217;ve been encouraging the team to try to do myself is get a tighter loop between the host and the people building the big sites and the WooCommerce core team, so that they can figure out versus having five different plugins that try to address the scalability in different and often subpar ways, really get that built into core, with the sort of Web scale, knowing everything we&#8217;ve known in 15 years of building WordPress, what&#8217;s going to make it so it can scale to thousands of orders per second, hundreds of millions of rows.</p>\n<p>Brian Krogsgard: Two more questions, real quick.</p>\n<p>Matt Mullenweg: We can do so, by the way. It&#8217;s a very tractable problem. We will solve that. Solving that is something that will happen within the next six to 18 months. Solving the user experience to catch up with Shopify is also improving the user experience, or BigCommerce rather, I think will take longer. That&#8217;s more of a five to 10 year goal.</p>\n<p>Brian Krogsgard: I personally think that gives both the WordPress ecosystem, the WooCommerce ecosystem and Automatic directly a massive value proposition, if that can be accomplished. I think WordPress now people, you never feel like you have to leave WordPress because you got too big.</p>\n<p>Matt Mullenweg: Yeah.</p>\n<p>Brian Krogsgard: And as that can be accomplished, and that was a massive accomplishment for WordPress. For a long time that wasn&#8217;t true, and now that, if that can be done on the e-commerce side of things, or commerce broadly not just necessarily WooCommerce, I think that will be fantastic for everybody involved.</p>\n<p>Matt Mullenweg: By the way, I just want to point that out, just to pause. Think how little, how many other examples of software you can think of that the consumer version also works when you run it at an industrial global scale?</p>\n<p>Brian Krogsgard: I have no idea. I&#8217;m not very-</p>\n<p>Matt Mullenweg: It&#8217;s not very common. I think it&#8217;s one of the things the WordPress community should really be proud of, because that is highly unusual. And as we&#8217;re one of the only ultra-successful consumer open source startups, projects, communities, whatever, I think pointing to that sort of scalability is a big thing as well.</p>\n<p>Brian Krogsgard: So, one question is Automatic has investors. We just saw Slack, Lyft and Uber all file for becoming public companies. When I think, what&#8217;s the option for Automatic, one of however many successful startups where you have investors, they know you&#8217;re a successful startup. They know that there&#8217;s opportunity for them to succeed in that. That&#8217;s long-term revenue stream, remaining a private company. It&#8217;s private equity. It&#8217;s going public, or it&#8217;s acquisition. Do you have any thoughts in terms of what makes you happiest as a company and as a business owner, and what do you think is best for the way Automatic interfaces with the broader WordPress community?</p>\n<p>Matt Mullenweg: It&#8217;s hard for me to imagine being a public company CEO, any harder than leading an open source project.</p>\n<p>Brian Krogsgard: I&#8217;ve thought about that a great deal. I think you actually fit the mold for what Wall Street might like in terms of the leader of a public company. I will say, that&#8217;s my bet. My best is one day Automatic would go public, and we figure out how that works in terms of all the private, public components and the open source side of things. But yeah, I&#8217;m curious-</p>\n<p>Matt Mullenweg: I think it&#8217;s actually a possibility. By the way, I could see other WordPress companies going public, probably WPEngine is the closest to the gates there.</p>\n<p>Brian Krogsgard: Well good, GoDaddy and EIG are public.</p>\n<p>Matt Mullenweg: They are, yeah, so there will be other open source WordPress either based or WordPress will be a part of their business public companies, likely before Automatic as well. I think that&#8217;s a great path for us. Automatic has investors. They are minority investors, so the sort of existential future of the company is in the hand of myself and the other people who own the majority of the shares of Automatic. I think there&#8217;s lots of options. The people you point to, Uber or Lyft, Slack, et cetera, to varying degrees have built some pretty impressive things. I admire some more than others, but also have reached a scale that&#8217;s kind of far beyond where companies generally go public.</p>\n<p>Brian Krogsgard: Yeah, they really have. It&#8217;s been-</p>\n<p>Matt Mullenweg: What that illustrates is that the private market is actually a lot more liquid and has a lot more capital available for when and how that needs the company or the ecosystem or whatever to grow.</p>\n<p>Brian Krogsgard: So I could surmise from that that you don&#8217;t feel like there&#8217;s a rush?</p>\n<p>Matt Mullenweg: I won&#8217;t even speak to my own personal things, but say just in the industry there&#8217;s less of a rush, so that is the plus and minus of so much capital moving from the public markets into the private markets. So people like Fidelity, T. Rowe Price et cetera that used to only do public companies now invest in private companies. That&#8217;s great for the companies, because by the way as a private company, you don&#8217;t have the kind of quarterly scrutiny that you do when you&#8217;re public, and I think it&#8217;s actually easier to out-innovate and out-flank public companies when you are private, which is one thing I personally like. But that said, it does keep more of that growth in the hands of only sophisticated investors.</p>\n<p>Brian Krogsgard: I completely agree.</p>\n<p>Matt Mullenweg: So there is a lot more of that upside that is no longer in the hands of what is commonly referred to as the retail investor. I would love for anyone who loves Automatic&#8217;s products to be able to own a share of the company, even if it&#8217;s just one share. That&#8217;s not really possible under the current sort of regulatory frameworks, and for good reasons, by the way. As we saw with the kind of ICO craze, there&#8217;s a reason all these protections for consumers and public market, public company standards exist.</p>\n<p>Matt Mullenweg: But in the meantime, at Automatic we will continue to hold ourselves to public company standards, but really build in an extremely long-term way. If there&#8217;s an idol there, I&#8217;d say it&#8217;s Amazon, and try to make the best possible user experience, best possible products. If we continue to do that, I think from a business point of view we will have an array of options available to us and any number of choices.</p>\n<p>Brian Krogsgard: And as a leader yourself of the WordPress community and Automatic, what&#8217;s one big thing that you learned this year that you hope to improve upon in 2019?</p>\n<p>Matt Mullenweg: Hmm, I know you&#8217;re probably thinking about like a big thing, but I&#8217;m actually going to say a small thing.</p>\n<p>Brian Krogsgard: It can be small.</p>\n<p>Matt Mullenweg: It&#8217;s really important, which is how much you can &#8230; What is the one thing everyone listening to this is doing right now?</p>\n<p>Brian Krogsgard: Focusing, I hope?</p>\n<p>Matt Mullenweg: Breathing.</p>\n<p>Brian Krogsgard: Oh, okay.</p>\n<p>Matt Mullenweg: And you probably weren&#8217;t thinking about it, but now you are thinking about it. You&#8217;re breathing right now.</p>\n<p>Brian Krogsgard: I am.</p>\n<p>Matt Mullenweg: And it is amazing how much you can influence your mindset, your state of mind, your mood, your everything, through breath. Just as an exercise, where everyone puts their hand on their belly and takes a big breath and pushes your hand out as you take it in, Brian, are you doing it?</p>\n<p>Brian Krogsgard: Oh, sorry. I do. I feel good.</p>\n<p>Matt Mullenweg: It has an immediate effect on you.</p>\n<p>Brian Krogsgard: It does. You know, actually that&#8217;s how we discipline our son often. A three-year-old is a very emotional being, so if they&#8217;re upset one of the first things that you can do with them is just tell them, &#8220;Let&#8217;s take a deep breath together.&#8221; So you take that deep breath and the response is also very immediate, the way they calm down and settle down and think more clearly because they took that breath, so that&#8217;s interesting.</p>\n<p>Matt Mullenweg: That&#8217;s all of us, and also by the way, this is not something new. This goes back thousands of years.</p>\n<p>Brian Krogsgard: You didn&#8217;t just invent this?</p>\n<p>Matt Mullenweg: No, no, you know there&#8217;s so many, there&#8217;s so much prior art here, but I&#8217;d encourage people to check it out. Also check out, when the videos go up, the Joanna Barsh talk, and Alexis Lloyd both had sort of almost like guided meditations and exercises. I think this is one of the next big areas for people who aren&#8217;t familiar with to discover. They&#8217;re actually really, really powerful, and it&#8217;s been huge for me. In an extraordinarily busy and what might otherwise be seen as extremely stressful year, it was actually one of my best years of my life.</p>\n<p>Brian Krogsgard: Awesome.</p>\n<p>Matt Mullenweg: I do have to watch a clock, and I do have to run now.</p>\n<p>Brian Krogsgard: That&#8217;s fine. I&#8217;m happy to hear that. Thank you for spending so much time with me. It was great talking to you, and we&#8217;ll catch everybody next time.</p>\n<p>Matt Mullenweg: Thank you. I&#8217;ll see you all, and thank you to all Post Status readers.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Dec 2018 14:45:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: State of the Word 2018: WordPress Embraces the Block Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86291\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/state-of-the-word-2018-wordpress-embraces-the-block-editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13953:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/12/PIC_20181208_161427272.jpeg?ssl=1\"><img /></a>photo credit: WP Tavern</p>\n<p>WordCamp US kicked off in Nashville over the weekend, following the release of WordPress 5.0. In the first 48 hours, 5.0 had been downloaded more than 2.8 million times. It passed 3 million Saturday night.</p>\n<p>&#8220;There&#8217;s been a lot that&#8217;s been going on, so I&#8217;d like to allow WordPress the chance to re-introduce itself,&#8221; Matt Mullenweg said during the preamble of his <a href=\"https://www.youtube.com/watch?v=aWlfp-1Q19I\" rel=\"noopener\" target=\"_blank\">State of the Word</a> address. He invoked the four freedoms as the project&#8217;s constitution and called the community back to its roots. </p>\n<p>“It&#8217;s the reason we&#8217;re here,” Mullenweg said. “WordPress isn&#8217;t a physical thing; it&#8217;s not a set of code. It&#8217;s kind of an idea.  WordPress is backed by the full faith and credit of every person and company that depends on it.”  </p>\n<p>He reiterated the project’s mission to democratize publishing and recast his vision for advancing the open web.</p>\n<p>&#8220;Like I said a few years ago, we&#8217;re building a web operating system, an operating system for the open, independent web and a platform that others can truly build on,” Mullenweg said.</p>\n<p>WordPress’ 32.5{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} market share and its commercial ecosystem, which Mullenweg estimates at $10 billion/year,  give the project the resources to make a powerful impact on the future of the web. </p>\n<h3>Mullenweg Builds a Compelling Case for the Block Editor</h3>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/12/wcus-sotw.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://twitter.com/WordCampUS/status/1071531659579789313\">WCUS Photography Team</a></p>\n<p>Mullenweg drove home the necessity of Gutenberg by showing a selection of videos where new users struggled to accomplish simple tasks in the old editor.  Their experiences were accompanied by painful commentary:</p>\n<ul>\n<li>&#8220;This feels like writing a blog back in 2005.”</li>\n<li>&#8220;This was very finnicky; this does not work.”</li>\n<li>&#8220;How would I add a caption? I have no clue.”</li>\n</ul>\n<p>Mullenweg described how he used to effortlessly switch back and forth between the visual and HTML editors prior to WordPress 5.0 but realized that not all users are able to do this.  </p>\n<p>”This has been our editor experience for over a decade now and many of us have learned to deal with it,” he said.</p>\n<p>He followed up with a video demonstrating how much easier these tasks are in the new block editor and identified blocks as the way forward for WordPress.</p>\n<p>Some attendees commented after the fact on how the user testing videos, paired up against an expert using Gutenberg, seemed unbalanced and they would have liked to see videos of new users attempting the same tasks in the new editor. The goal of that segment, however, seemed to be more aimed at communicating the need for Gutenberg and the possibilities it opens up once users have had the chance to grow into it.</p>\n<h3>Mullenweg Urges Attendees to &#8220;Learn Blocks Deeply&#8221;</h3>\n<p>Millions of early adopters have already embraced the block editor during phase 1 of the Gutenberg project, which closed out with 1.2 million active installs and 1.2 million posts written. There have already been 277 WordCamp talks on Gutenberg, 555 meetup events focused on the new editor, and more than 1,000 blog posts discussing it.</p>\n<p>Blocks are taking over the world of WordPress. Version 5.0 shipped with 70 native blocks and there are already more than 100 third-party blocks in existence and 1,000 configurations related to that. </p>\n<p>“Blocks are predictable, tactile, and can be simple like a text block, or as rich as an e-commerce interface,” Mullenweg said. He described them as the new DNA of WordPress, from which users can create anything they can imagine. </p>\n<p>Mullenweg showcased two sites built using the block editor, the <a href=\"https://theindigomill.com/\" rel=\"noopener\" target=\"_blank\">Indigo Mill</a> and <a href=\"https://www.luminasolar.com/\" rel=\"noopener\" target=\"_blank\">Lumina Solar</a>. These beautiful sites open the imagination to what Gutenberg is capable of bringing to websites.</p>\n<p>WordPress.org will be highlighting plugins and themes to push the block ecosystem forward. There are also more than 100 Gutenberg-ready themes available to users on the directory and <a href=\"https://wordpress.org/plugins/browse/blocks/\" rel=\"noopener\" target=\"_blank\">a new Gutenberg block tag that is currently live for plugins</a>. It will also be available for themes soon. </p>\n<p>Mullenweg highlighted tools like the create-guten-block toolkit, Block Lab, and Lazy Blocks that are making it easy for developers to create their own blocks. Block collections and libraries are also emerging. He said one of the priorities for 2019 is to build a WordPress.org directory for discovering blocks and a way to seamlessly install them.</p>\n<p>Building on the homework he gave to WordPress developers in 2015, to “<a href=\"https://wptavern.com/state-of-the-word-2015-javascript-and-api-driven-interfaces-are-the-future-of-wordpress\" rel=\"noopener\" target=\"_blank\">Learn JavaScript Deeply</a>,” Mullenweg urged the community to “Learn Blocks Deeply.”  Blocks provide a host of opportunities to improve the user experience beyond what Gutenberg’s creators could have imagined in the beginning.</p>\n<h3>Gutenberg Phase 2: Navigation Menu Block, Widget blocks, Theme Content Areas</h3>\n<p>Mullenweg announced the next phases for the Gutenberg project. Phase 2 has already begun and focuses on site customization, expanding the block interface to other aspects of content management.  This includes creating a navigation menu block. Reimagining menus is will be challenging, and Mullenweg said they may even get renamed during the process.</p>\n<p>Phase 2 goals also include porting all widgets over to blocks and registering theme content areas in Gutenberg. An early version of phase 2 will be in the Gutenberg plugin so anyone wanting to be part of testing can reactivate it.</p>\n<p>During the Q&#038;A time, one attendee asked a question about how this phase seems to include very little about making layout capabilities more robust. He asked if Mullenweg plans to let those the marketplace handle those layout decision or if core will define a layout language. Mullenweg responded that it may be more prudent to see what others in the ecosystem are doing and cherry pick and adopt the best solutions. He also remarked that it would be exciting if users could switch between different page builders in the future and not lose their content. </p>\n<h3>Gutenberg Phases 3 and 4: Collaboration and Core Support for Multilingual Sites</h3>\n<p>Mullenweg announced that Gutenberg phase 3, targeted for 2020, will focus on collaboration, multi-user editing, and workflows. Phase 4 (2020+) is aimed at developing an official way for WordPress to support multilingual sites. When asked what that will look like from a technical standpoint, given the many existing solutions already available, Mullenweg said he didn’t want to prescribe anything yet, as it’s still in the experimental stage.</p>\n<p>Other major announcements included a highly anticipated bump in the minimum PHP version required for using WordPress. By April 2019, PHP 5.6 will be the minimum PHP version for WordPress, and by December 2019, the requirement will be updated to PHP 7.</p>\n<p>WordPress releases are going to come faster in the future, as Gutenberg development has set a new pace for iteration. Mullenweg said he would like WordPress to get to the point where users are not thinking about what version they are on but instead choose a channel where they can easily run betas or the stable version.</p>\n<h3>Mullenweg Acknowledges Mistakes Made and Lessons Learned in the 5.0 Release Process</h3>\n<p>WordPress 5.0 was one of the longest and most controversial release cycles in the project’s history. Those outside the inner circle of decision-making endured a great deal of uncertainty, as dates were announced and then missed, with secondary dates thrown out in favor of pushing 5.0 out with just three days’ notice. </p>\n<p>“We were scared to announce a new release date after missing our previous one,” Mullenweg said, acknowledging the controversial release date. He said this seemed to create a lot of fear and uncertainty until they announced a new date. The dates seemed to come out of the blue and were stressful for the community. </p>\n<p>Mullenweg highlighted the lessons they learned in the process of releasing 5.0: </p>\n<ul>\n<li>Need the various teams across WordPress working together better</li>\n<li>Need to keep learning JavaScript, even more deeply</li>\n<li>Importance of triage and code freezes</li>\n<li>Always announce release dates</li>\n</ul>\n<p>Mullenweg noted that WordPress 5.0’s beta releases were tested 100 times more than other releases, which he said contributed to Gutenberg becoming more robust before landing in 5.0. However, these positives seemed to be overshadowed by several critical breakdowns in communication that many feel betrayed the community’s trust.</p>\n<p>He noted that people used the plugin review system as a way to vote on Gutenberg and that perhaps the community needs a different medium for expressing those kinds of things. Users did this because they felt it was one of the only feedback mechanisms where they had a voice. Negative reviews piled on in the early days of the plugin’s development but they continued steadily throughout the feature plugin’s journey into core. After 5.0 was released, negative <a href=\"https://wordpress.org/support/plugin/gutenberg/reviews/\" rel=\"noopener\" target=\"_blank\">reviews on the Gutenberg plugin</a> have continued to pour in, and its rating has fallen to 2.2/5 stars.</p>\n<h3>Growing Pains and a Call for Transparency</h3>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/12/wcus2018.jpg?ssl=1\"><img /></a>photo credit: David Bisset for <a href=\"https://poststatus.com/\">Post Status</a></p>\n<p>Mullenweg said that Gutenberg development happened entirely in the public eye, surfacing many challenges associated with developing open source software in public. The code was public, but the most important decisions were made behind closed doors. This was compounded by the developer community voicing frustrations during core dev chats and on social media. </p>\n<p>During the Q&#038;A segment, several audience members called for more transparency in the release process, noting that most of the posts and announcements regarding 5.0 came from Automattic employees. Morten Rand-Hendriksen, who has become somewhat of a community firebrand at WordCamp Q&#038;A’s, received applause for his question regarding the use of the word “we” in connection to posts on the make blogs. He pressed Mullenweg for more insight into where these decisions are made. </p>\n<p>Mullenweg said the “we” he meant in regards to 5.0 release dates referred to a private channel where the release leads discussed it. He said with so many people showing up to the dev chats, the discussions became difficult.</p>\n<p>&#8220;I don&#8217;t just go in a cave and come up with these things,&#8221; Mullenweg said. “A lot of people were showing up [to dev chats] who had never contributed to WordPress before and were crowding out the discussion of the core team.” He also said the private conversations were “every bit as feisty as the public one,” except there weren’t any drive-by opinions. </p>\n<p>To those on the outside, these meetings appeared to be secret, as they were never referenced or summarized on the make blogs. This left the developer community wondering where these decisions were coming from and whether or not they had a voice.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Gutenberg was developed in public, but too many decisions were made in silos and not clearly communicated. This can be improved for 5.1 and beyond <a href=\"https://twitter.com/hashtag/WCUS?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WCUS</a></p>\n<p>&mdash; K. Adam White (@kadamwhite) <a href=\"https://twitter.com/kadamwhite/status/1071539824358764544?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">December 8, 2018</a></p></blockquote>\n<p></p>\n<p>During the Q&#038;A, Mulllenweg said he listened to vigorous discussion and diverse viewpoints from release leads coming from different companies, while gathering as much information as possible from reading reviews, blog posts, and comments from the community. He described this process as part of the art of trying to make sense of all the different things people are saying and balance that.</p>\n<p>Supporting a BDFL-led project requires a certain amount of trust that the leadership is listening. Over the past several weeks Mullenweg has made a strong effort to <a href=\"https://wptavern.com/mullenweg-ramps-up-communication-ahead-of-wordpress-5-0-release-rc2-now-available\" rel=\"noopener\" target=\"_blank\">keep the channels of communication open</a>.  </p>\n<p>The painful user testing videos Mullenweg shared demonstrated how desperately WordPress needed to grow out of its old editor. It isn’t often that core makes changes that affect nearly every corner of the WordPress ecosystem at the same time. This experience came with its fair share of growing pains. Despite communication missteps during the 5.0 release process, Mullenweg has successfully navigated the project through this rocky transition. Although WordCamp US attendees seemed road weary after 5.0, they were united by a shared desire to move forward and continue working together with the leadership that has kept WordPress on the course of growth and improvement for the past 15 years.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Dec 2018 16:23:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: State of the Word 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48685\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://ma.tt/2018/12/state-of-the-word-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1048:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Over the weekend I was in Nashville with over a thousand other WordPress enthusiasts. I met a ton of people, learned a lot, and was able to share the annual State of the Word address with the audience, which is a big summary of what WordPress has been up to and where it&#8217;s going. This year we covered user testing, Gutenberg, 5.0, the future phases of Gutenberg, all the latest and greatest blocks, new minimum PHP requirements, the adoption of 5.0, and some event and community updates. You can also <a href=\"https://www.slideshare.net/photomatt/wordpress-state-of-the-word-2018\">see just the slides</a>. The <a href=\"https://www.youtube.com/watch?v=v2aNNlC8TUE\">Q&amp;A is here in a separate video</a>.</p>\n\n\n\n<p>If you&#8217;d like a text summary and commentary on the speech, <a href=\"https://poststatus.com/state-of-the-word-2018/\">Post Status</a> and <a href=\"https://wptavern.com/state-of-the-word-2018-wordpress-embraces-the-block-editor\">WP Tavern</a> both have good write-ups.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Dec 2018 05:00:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Post Status: Matt Mullenweg’s State of The Word, 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://poststatus.com/?post_type=poststatus_notes&p=49929\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://poststatus.com/state-of-the-word-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8440:\"<p>Matt started by “reintroducing WordPress” and the four freedoms, stressing that “WordPress isn&#8217;t a physical thing or code, it&#8217;s an idea.” Additionally, a “robust commercial ecosystem” supports WordPress, and Matt noted that current estimates indicate WordPress generates about $10 Billion (USD) annually.</p>\n<p>After two years of development and just after WordPress 5.0 officially launched, it&#8217;s not surprising the focus of Matt&#8217;s talk was on Gutenberg. “We&#8217;ve gotten a lot of questions about why we are doing certain things&#8230; why we are working on Gutenberg. And it&#8217;s good to return to users to find that,” Matt acknowledged.</p>\n<h3>Enhancing editor usability</h3>\n<p>A video of new WordPress users testing the classic editor (WordPress 4.9) was shown projected on the big screens over the stage. These clips primarily showed people having difficulties with relatively simple tasks in the editor.</p>\n<p>Matt&#8217;s point was that we&#8217;ve become accustomed to the custom editor&#8217;s quirks, but blocks offer a better experience — from copying and pasting from Microsoft Word and Google Docs into WordPress to quickly creating a responsive website.</p>\n<h3>Community Gutenberg adoption</h3>\n<p>Matt continued with a summary of how Gutenberg has performed in Phase 1 of its release. Before the WordPress 5.0 release, 1.2 million active installs and 1.2 million posts were published, with about 39,000 posts written daily. Phase 1 had 8,684 commits and over 340 contributors. The &#8216;Gutenberg&#8217; tag is already available for plugins in the WordPress repo, and it will be “coming soon” for themes.</p>\n<p>Notably, over 100 Gutenberg themes are already present in the WordPress repo — including the new Twenty Nineteen theme. Matt highlighted two websites — <a href=\"http://theindigomill.com\">The Indigo Mill</a> and <a href=\"http://luminasolar.com\">Lumina Solar</a> — as examples where Gutenberg blocks have been used well to create effective layouts. Matt riffed on the &#8220;Learn JavaScript Deeply&#8221; mantra by repeating &#8220;Learn Blocks Deeply.&#8221; Blocks are the DNA of the new editor. Currently, 70 native blocks and over 100 third-party blocks exist for Gutenberg.</p>\n<h3>Community Gutenberg development</h3>\n<p>He highlighted some of the third party blocks in the wild:</p>\n<ul>\n<li><a href=\"https://yoast.com/yoast-seo-8-0-introducing-the-yoast-seo-gutenberg-sidebar-a-revamped-meta-box/\">Yoast SEO</a></li>\n<li><a href=\"https://github.com/kevinbazira/algori-360-image\">360 Image</a></li>\n<li><a href=\"https://www.ampproject.org/latest/blog/the-official-amp-plugin-for-wordpress/\">Google AMP w/ Gutenberg Integration</a></li>\n<li><a href=\"https://wordpress.org/plugins/dropit/\">Drop It</a></li>\n<li><a href=\"https://wordpress.org/plugins/ecwid-shopping-cart/\">Ecwid Ecommerce Shopping Cart</a></li>\n<li><a href=\"https://woocommerce.com/posts/making-it-easier-to-add-products-to-posts-and-pages-with-the-products-block-for-gutenberg/\">WooCommerce Products Block</a></li>\n<li><a href=\"https://www.bigcommerce.com/wordpress-ecommerce-plugin/\">BigCommerce</a></li>\n<li><a href=\"https://www.wpzoom.com/plugins/new-plugin-released-recipe-card-blocks-for-gutenberg/\">Recipe Card Blocks</a></li>\n<li><a href=\"https://wordpress.org/plugins/tarot/\">Tarot</a></li>\n<li><a href=\"https://twitter.com/dmsnell23/status/1063126946350096389\">Sketch Block</a></li>\n<li><a href=\"https://jetpack.com/support/jetpack-blocks/form-block/\">Jetpack Form Block</a></li>\n<li><a href=\"https://sortabrilliant.com/guidepost/\">Guidepost</a></li>\n<li><a href=\"https://sortabrilliant.com/ghostwriter/\">Ghost Writing</a></li>\n<li><a href=\"https://sortabrilliant.com/spoileralert/\">Spoiler Alert</a></li>\n<li><a href=\"https://wordpress.org/plugins/caxton/\">Caxton Shape Divider Block</a></li>\n</ul>\n<p>Matt mentioned several block libraries and frameworks that have appeared:</p>\n<ul>\n<li><a href=\"http://editorblockswp.com\">editorblockswp.com</a></li>\n<li><a href=\"http://gutenberghub.com\">gutenberghub.com</a></li>\n<li><a href=\"http://gutenbergcloud.org\">gutenbergcloud.org</a></li>\n<li><a href=\"https://getblocklab.com\">getblocklab.com</a></li>\n<li><a href=\"https://wordpress.org/plugins/lazy-blocks/\">Lazy Blocks</a></li>\n</ul>\n<h3>Mobile Apps</h3>\n<p>Matt gave the audience an update regarding the WordPress native mobile apps: In the past month, app users published 1.3M posts and uploaded 3.1M photos and videos. Gutenberg will be going into the mobile apps, with a beta release expected in February 2019; I heard February 22nd is the current target date for a beta release.</p>\n<h3>The Next Phases of Gutenberg</h3>\n<p>Matt highlighted the next phases of Gutenberg&#8217;s evolution, which included new information about Phases Three and Four:</p>\n<h4>Phase One</h4>\n<p>Fundamental blocks for writing and editing in the backend editor. These are complete now, although Matt later said that work on the editor would continue.</p>\n<h4>Phase Two</h4>\n<p>Customizing outside of the page/post content will be the next point of emphasis. It may include widgets, menus, and miscellaneous content. Matt notes that menus “will need a bit more experimentation”. &#8220;2019&#8221;.</p>\n<h4>Phase Three</h4>\n<p>Collaboration, multi-user editing in Gutenberg, and workflows. The target for this to phase to be complete is “2020+.”</p>\n<h4>Phase Four</h4>\n<p>&#8220;An official way&#8221; for WordPress to support multilingual sites. Also slated for “2020+.”</p>\n<h3>Other Announcements</h3>\n<p>There were several non-Gutenberg tidbits of note:</p>\n<h4>Auto updates on major versions of WordPress</h4>\n<p>On a list of items to work on in 2019, Matt said he wanted to make it a goal to add optional auto-updates for plugins, themes, and major versions of WordPress.</p>\n<h4>Updated minimum PHP versions</h4>\n<p><a href=\"https://make.wordpress.org/core/2018/12/08/updating-the-minimum-php-version/\">A proposal written</a> by Gary Pendergast makes a case for WordPress to start updating its minimum PHP versions. The proposed plan is to move to PHP 5.6 by April 2019 and to PHP 7.0 by &#8220;as early as&#8221; December 2019. Notably, security support for PHP 5.6 expires in a few days, and the &#8220;end of life&#8221; for PHP 7.0 <a href=\"http://php.net/supported-versions.php\">just passed</a>.</p>\n<p>After Matt mentioned this proposal, it received an enormous amount of applause — far more applause than most of the Gutenberg news that came earlier, and Matt noticed. It is definitely welcome news!</p>\n<h4>WordPress release adoption</h4>\n<p>During the life of the WordPress 4.9 branch, there were over 173 million downloads with 68.4{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of all known WordPress installs running 4.9.</p>\n<p>Matt notes that the early adoption numbers for WordPress 5.0 were very similar to WordPress 4.7, which was also a December release back in 2016.</p>\n<h4>Lessons learned in 2018</h4>\n<p>Matt took time to summarize the lessons he learned in 2018, starting with the need for teams to improve how they work together: “There should be no reason for accessibility, testing, and other teams not to be working together since these features should be a feature of everything we develop from the very beginning.” No doubt this came as a response to the concerns about accessibility in Gutenberg that surfaced before WordPress 5.0 was released.</p>\n<h3>Community Update</h3>\n<p>Matt offered some community-related data as well:</p>\n<ul>\n<li><strong>WordCamps:</strong> In 2018 there were 145 WordCamps in 48 countries, with over 45,000 tickets sold. A total of 1,300 organizers (a 33{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} increase!), 2,651 speakers, and 1,175 sponsors made it all possible.</li>\n<li><strong>Meetups:</strong> This year saw 50{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} member growth in meetup attendance, with over 687 meetup groups and 5,400 meetup events.</li>\n</ul>\n<p>And with that, he began Q&amp;A.</p>\n<p>You can view the <a href=\"https://www.youtube.com/watch?v=r5b-N2RmxS8\">State of the Word on YouTube</a> in full, and it should become available on WordPress TV very soon.</p>\n<div id=\"attachment_49969\" class=\"wp-caption aligncenter\"><img class=\"wp-image-49969 size-large\" src=\"https://cdn.poststatus.com/wp-content/uploads/2018/12/wcus-2018-sotw-5542-752x439.jpg\" alt=\"\" width=\"752\" height=\"439\" /><p class=\"wp-caption-text\">Photos by <a href=\"https://wpsessions.com\">Brian Richards</a>, for Post Status.</p></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Dec 2018 15:45:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: AMP Plugin for WordPress Version 1.0 Introduces Gutenberg-Integrated AMP Validation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86248\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/amp-plugin-for-wordpress-version-1-0-introduces-gutenberg-integrated-amp-validation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2620:\"<p><a href=\"https://amp-wp.org/amp-plugin-1-0-stable-release/\" rel=\"noopener\" target=\"_blank\">Version 1.0</a> of the official AMP plugin for WordPress was released on the eve of WordCamp US, after two years in development by contributors from Automattic, XWP, and Google. This first stable version has a massive <a href=\"https://wordpress.org/plugins/amp/#developers\" rel=\"noopener\" target=\"_blank\">changelog</a> with 30 people credited for their contributions. The plugin is now considered ready for production and is active on more than 300,000 sites.</p>\n<p>Version 1.0 interfaces with the new editor that landed in WordPress 5.0. It will display warnings for AMP-invalid markup on a per-block basis, so users don&#8217;t have to guess what content is generating an issue.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/12/notices-in-blocks-1024x736.png?ssl=1\"><img /></a></p>\n<p>This release also introduces a compatibility tool that offers detailed information on AMP validation errors. It functions like a debugging page where users can see which URLs are generating errors, along with the site component (plugin, theme, or core) where the markup originates.</p>\n<p>Version 1.0 includes granular controls for selecting which templates will be served as AMP. This allows for a more gradual adoption across a site. Users can also opt for Native mode to have the entire site served as AMP.</p>\n<p>The plugin has been updated to support four of WordPress&#8217; default themes, including Twenty Fifteen, Twenty Sixteen, Twenty Seventeen, and Twenty Nineteen. The documentation for <a href=\"https://github.com/xwp/wordpress-develop/pull/307\" rel=\"noopener\" target=\"_blank\">how AMP was added to these bundled themes</a> serves as an example for how theme developers can make their own themes AMP-compatible. </p>\n<p>WordPress users who opt to use AMP on their sites will have a more successful experience with this version, thanks to the improved UI for handling AMP validation errors and the new interface for limiting AMP-support to certain templates.</p>\n<p>The AMP for WordPress project is also sporting a new <a href=\"https://amp-wp.org/\" rel=\"noopener\" target=\"_blank\">website</a> that features a collection of AMP-ready plugins and themes and a showcase of sites using AMP. It also has extensive <a href=\"https://amp-wp.org/documentation/getting-started/\" rel=\"noopener\" target=\"_blank\">documentation</a> for implementors, site owners, and developers. The site provides a central place for news and resources related to the project and its expanding ecosystem of compatible extensions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Dec 2018 06:51:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: WordPress 5.0 “Bebo” Released, Lays A Foundation for the Platform’s Future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86229\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/wordpress-5-0-bebo-released-lays-a-foundation-for-the-platforms-future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9407:\"<p>In 2016 at WordCamp US in Philadelphia, PA, <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">Matt Mullenweg announced</a> to the world that a new post and page editor would be coming to WordPress. &#8220;The editor does not represent the core of WordPress publishing,&#8221; Mullenweg said.</p>\n\n\n\n<p>His <a href=\"https://ma.tt/2017/08/we-called-it-gutenberg-for-a-reason/\">vision of the editor</a> was geared towards a more block-based approach that unifies widgets, shortcodes, and other areas of WordPress. Today, that vision has become a reality with the <a href=\"https://wordpress.org/news/2018/12/bebo/\">release of WordPress 5.0</a> featuring <a href=\"https://matiasventura.com/post/gutenberg-or-the-ship-of-theseus/\">project Gutenberg</a>. <br /></p>\n\n\n\n<div class=\"wp-block-image\"><img />The New Editor in WordPress 5.0</div>\n\n\n\n<p>Instead of a large blank canvas, content is broken up into a series of individual blocks that are independent from the content as a whole. For example, you can edit the HTML of one block without it affecting other blocks. </p>\n\n\n\n<p>The editor comes with more than 16 blocks to add content. You can add more blocks by <a href=\"https://wptavern.com/gutenberg-block-library-provides-a-searchable-index-of-individual-blocks\">installing and activating plugins.</a><br /></p>\n\n\n\n<div class=\"wp-block-image\"><img />Some of the Blocks That Are Available in WordPress 5.0</div>\n\n\n\n<p>Each block typically has two areas where you can manipulate its content. The Toolbar, which displays when hovering over a block, and the Inspector located in the right-hand sidebar. The Inspector houses less-often used settings that require more screen space. <br /></p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>Between the top toolbar, block toolbar, inspector, block mover, and hidden elements that don&#8217;t appear unless hovered over, there are a lot of user interface buttons. I suggest spending time crafting a test post to get familiar with what each button does. </p>\n\n\n\n<p>To see the new editor in action, check out the following demo video. </p>\n\n\n\nA Short Demo of The New Editor in Action\n\n\n\n<p>If you&#8217;re not ready for the new editor or discover incompatibilities with themes or plugins, you can install the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor</a> plugin. This plugin will disable the new editor and replace it with the one in WordPress 4.9.8 and below. The WordPress development team <a href=\"https://make.wordpress.org/core/2018/11/07/classic-editor-plugin-support-window/\">has committed</a> to supporting the plugin until December 31st, 2021. </p>\n\n\n\n<p>Those who use assistive technology and experience accessibility issues with the new editor are encouraged to install the Classic Editor plugin until the issues are fixed. <br /></p>\n\n\n\n<h2>Twenty Nineteen: A Fully Compatible Default Theme<br /></h2>\n\n\n\n<p>WordPress 5.0 comes with a new default theme called <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">Twenty Nineteen</a> that is fully compatible with the new editor. It includes front-end and back-end styles to provide a What You See Is What You Get experience. It also supports the Wide and Full image alignment options. <br /></p>\n\n\n\n<div class=\"wp-block-image\"><img />Twenty Nineteen Front-End on the Left, Back-End on the Right</div>\n\n\n\n<p>You can see the theme in action on <a href=\"https://ma.tt/\">Matt Mullenweg&#8217;s site</a>.</p>\n\n\n\n<h2>What Happens to Existing Content?<br /></h2>\n\n\n\n<p>Content not created in the new editor is placed into a Classic block. This block mimics the old editor and provides users a choice to migrate it into blocks. However, migrating content into blocks is not required. Most content shouldn&#8217;t be affected by updating to WordPress 5.0. </p>\n\n\n\n<h2>Where to Get Help Using the New Editor</h2>\n\n\n\n<p>For new users, the editor might be an intuitive experience but for many WordPress veterans, it introduces a steep learning curve. After all, the previous editor has existed for more than 10 years. </p>\n\n\n\n<p>At the moment, there is a Gutenberg handbook for <a href=\"https://wordpress.org/gutenberg/handbook/designers-developers/\">Developers</a> and <a href=\"https://wordpress.org/gutenberg/handbook/contributors/\">Contributors</a> but not for Users. Work <a href=\"https://github.com/WordPress/gutenberg/issues/11252\">is underway</a> by the Docs team and other volunteer contributors to put together an initial document to release in 2019. </p>\n\n\n\n<p>Until the official handbook is published, you&#8217;ll need to seek help and education elsewhere.</p>\n\n\n\n<h3>WordPress 5.0 Essential Training</h3>\n\n\n\n<p>Morten Rand-Hendriksen, an educator for LinkedIn Learning has published <a href=\"https://www.linkedin.com/learning/wordpress-5-essential-training/?trk=insiders_23476852_learning\">a course</a> that walks users through the new editor. It&#8217;s available to view for free for the next three weeks. </p>\n\n\n\n<h3>Gutenberg Times<br /></h3>\n\n\n\n<p>Birgit Pauli-Haack has been keeping tabs on Gutenberg&#8217;s development for more than a year. <a href=\"https://gutenbergtimes.com\">Gutenberg Times</a> contains relevant information about the editor for <a href=\"https://gutenbergtimes.com/category/for-users/\">users</a> and <a href=\"https://gutenbergtimes.com/category/for-developers/\">developers</a>. </p>\n\n\n\n<h3>WordPress Support Forums<br /></h3>\n\n\n\n<p>Volunteers are standing by ready to answer your questions. If you think you&#8217;ve discovered a bug, incompatibility, or are experiencing trouble with the new editor, please post it in the <a href=\"https://wordpress.org/support/forum/how-to-and-troubleshooting/\">support forums</a>. </p>\n\n\n\n<h3>WordPress 5.0 Field Guide</h3>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2018/12/06/wordpress-5-0-field-guide/\">WordPress 5.0 field guide</a> provides important links and information for developers and users related to this release. <br /></p>\n\n\n\n<h2>WordPress 5.0 Is the Beginning of A New Journey</h2>\n\n\n\n<p>While WordPress 5.0 introduces a new editor, it also lays the foundation for what&#8217;s to come. The first phase of project Gutenberg was the editor. The second phase is the Customizer with a focus on full-site layouts. The third and fourth phases will be shared and discussed by Mullenweg at this year&#8217;s WordCamp US.</p>\n\n\n\n<p>The new editor is part of a long process to reinvent WordPress. Matías Ventura, Co-lead of the Gutenberg project succinctly explains why the need for Gutenberg exists. <br /></p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>WordPress has always been about the user experience, and that needs to continue to evolve under newer demands. Gutenberg is an attempt at fundamentally addressing those needs, based on the idea of content blocks. It’s an attempt to improve how users interact with their content in a fundamentally visual way, while at the same time giving developers the tools to create more fulfilling experiences for the people they are helping.</p><p>How can such a vision happen without dismantling, rebuilding, fragmenting, or breaking the WordPress ship that for over a decade has been carrying the thoughts, joys, and livelihoods of millions of people and more than a quarter of the web?</p><p>The ship, like Theseus’, needs to continue sailing while we upgrade the materials that make it. It needs to adapt to welcome new people, those that find it too rough to climb on board, too slippery a surface, too unwelcoming a sight, while retaining its essence of liberty. This is not an easy challenge—not in the slightest. </p><p>Indeed, <a href=\"https://ma.tt/2017/08/we-called-it-gutenberg-for-a-reason/\">we called it Gutenberg for a reason</a>, for both its challenges and opportunities, for what it can represent in terms of continuity and change. It is an ambitious project and it needs the whole WordPress community to succeed.</p><cite><a href=\"https://matiasventura.com/post/gutenberg-or-the-ship-of-theseus/\">Matías Ventura, Co-lead of the Gutenberg project.<br /></a></cite></blockquote>\n\n\n\n<p>As the new editor <a href=\"https://wordpress.org/download/counter/\">makes its way</a> across the world, it will be interesting to see what the reactions are from users who experience it for the first time. It will also be interesting to see what the <a href=\"https://twitter.com/photomatt/status/1069327043618320385\">developer community builds</a> that takes the editor to new heights. </p>\n\n\n\n<p>WordPress 5.0 is the <a href=\"https://www.linkedin.com/pulse/gutenberg-morten-rand-hendriksen\">beginning of a new journey</a> for the project. One that will have bumpy roads, new discoveries, and plenty of opportunities to learn. So saddle up and keep your hands and arms inside the vehicle until it makes a complete stop. <br /></p>\n\n\n\n<p>WordPress 5.0 is named after <a href=\"https://en.wikipedia.org/wiki/Bebo_Vald{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}C3{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}A9s\">Bebo Valdés</a> who was a Cuban pianist, bandleader, composer and arranger. The release was led by Matt Mullenweg with Allan Cole, Anthony Burchell, Gary Pendergast, Josepha Haden Chomphosy, Laurel Fulford, Omar Reiss, Daniel Bachhuber, Matías Ventura, Miguel Fonseca, Tammie Lister, Matthew Riley MacPherson as co-leads. At least 423 people contributed to the release. <br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Dec 2018 21:38:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Dev Blog: WordPress 5.0 “Bebo”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6328\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/news/2018/12/bebo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:42540:\"<h2>Say Hello to the New Editor</h2>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>We’ve made some big upgrades to the editor. Our new block-based editor is the first step toward an exciting new future with a streamlined editing experience across your site. You’ll have more flexibility with how content is displayed, whether you are building your first site, revamping your blog, or write code for a living.</p>\n\n\n\n<div class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Gutenberg.jpg?fit=2400{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2C1200&ssl=1\" alt=\"\" class=\"wp-image-6331\" /></div>\n\n\n\n<h2>Building with Blocks</h2>\n\n\n\n<p>The new block-based editor won’t change the way any of your content looks to your visitors. What it will do is let you insert any type of multimedia in a snap and rearrange to your heart’s content. Each piece of content will be in its own block; a distinct wrapper for easy maneuvering. If you’re more of an HTML and CSS sort of person, then the blocks won’t stand in your way. WordPress is here to simplify the process, not the outcome.</p>\n\n\n\n\n\n\n\n<p>We have tons of blocks available by default, and more get added by the community every day. Here are a few of the blocks to help you get started:</p>\n\n\n\n<ul class=\"wp-block-gallery columns-4 is-cropped\"><li class=\"blocks-gallery-item\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Paragraph.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6340\" />Paragraph</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Heading.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6341\" />Heading</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Preformatted.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6342\" />Preformatted</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Quote.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6343\" />Quote</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Image.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6344\" />Image</li><li class=\"blocks-gallery-item\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Gallery.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6345\" />Gallery</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Cover-Image.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6346\" />Cover</li><li class=\"blocks-gallery-item\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Video.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6347\" />Video</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Audio.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6348\" />Audio</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Column.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6349\" />Columns</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-File.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6350\" />File</li><li class=\"blocks-gallery-item\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Code.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6351\" />Code</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-List.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6352\" />List</li><li class=\"blocks-gallery-item\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Button.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6353\" />Button</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-Embeds.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6354\" />Embeds</li><li class=\"blocks-gallery-item\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Block-Icon-More.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6355\" />More</li></ul>\n\n\n\n<h2>Freedom to Build, Freedom to Write</h2>\n\n\n\n<p>This new editing experience provides a more consistent treatment of design as well as content. If you’re building client sites, you can create reusable blocks. This lets your clients add new content anytime, while still maintaining a consistent look and feel.</p>\n\n\n\n\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>A Stunning New Default Theme</h2>\n\n\n\n<div class=\"wp-block-image\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/12/twenty-nineteen.jpg?fit=2400{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2C1600&ssl=1\" alt=\"\" class=\"wp-image-6358\" /></div>\n\n\n\n<p>Introducing Twenty Nineteen, a new default theme that shows off the power of the new editor.</p>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2018/12/block-editor-1024x683.jpg?resize=632{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2C422&ssl=1\" alt=\"\" class=\"wp-image-6359\" /><div class=\"wp-block-media-text__content\">\n<h3 id=\"mce_9\">Designed for the block editor</h3>\n\n\n\n<p>Twenty Nineteen features custom styles for the blocks available by default in 5.0. It makes extensive use of editor styles throughout the theme. That way, what you create in your content editor is what you see on the front of your site.<br /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/typography-1.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6427\" /><div class=\"wp-block-media-text__content\">\n<h3 id=\"mce_18\">Simple, type-driven layout</h3>\n\n\n\n<p>Featuring ample whitespace, and modern sans-serif headlines paired with classic serif body text, Twenty Nineteen is built to be beautiful on the go. It uses system fonts to increase loading speed. No more long waits on slow networks!</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2018/12/twenty-nineteen-versatile.gif?w=632&ssl=1\" alt=\"\" class=\"wp-image-6361\" /><div class=\"wp-block-media-text__content\">\n<h3 id=\"mce_24\">Versatile design for all sites</h3>\n\n\n\n<p>Twenty Nineteen is designed to work for a wide variety of use cases. Whether you’re running a photo blog, launching a new business, or supporting a non-profit, Twenty Nineteen is flexible enough to fit your needs.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link has-text-color\" href=\"https://wordpress.org/themes/twentynineteen/\">Give Twenty Nineteen a try</a></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Developer Happiness</h2>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Protect.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6362\" /><div class=\"wp-block-media-text__content\">\n<h3 id=\"mce_34\">Protect</h3>\n\n\n\n<p>Blocks provide a comfortable way for users to change content directly, while also ensuring the content structure cannot be easily disturbed by accidental code edits. This allows the developer to control the output, building polished and semantic markup that is preserved through edits and not easily broken.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2018/12/Compose.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6363\" /><div class=\"wp-block-media-text__content\">\n<h3 id=\"mce_39\">Compose</h3>\n\n\n\n<p>Take advantage of a wide collection of APIs and interface components to easily create blocks with intuitive controls for your clients. Utilizing these components not only speeds up development work but also provide a more consistent, usable, and accessible interface to all users.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Create.jpg?w=632&ssl=1\" alt=\"\" class=\"wp-image-6364\" /><div class=\"wp-block-media-text__content\">\n<h3 id=\"mce_45\">Create</h3>\n\n\n\n<p>The new block paradigm opens up a path of exploration and imagination when it comes to solving user needs. With the unified block insertion flow, it’s easier for your clients and customers to find and use blocks for all types of content. Developers can focus on executing their vision and providing rich editing experiences, rather than fussing with difficult APIs.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link has-text-color\" href=\"https://wordpress.org/gutenberg/handbook/\">Learn how to get started</a></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Keep it Classic</h2>\n\n\n\n<div class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/12/Classic.jpg?fit=2400{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2C1130&ssl=1\" alt=\"\" class=\"wp-image-6365\" /></div>\n\n\n\n<p>Prefer to stick with the familiar Classic Editor? No problem! Support for the Classic Editor plugin will remain in WordPress through 2021.</p>\n\n\n\n<p>The Classic Editor plugin restores the previous WordPress editor and the Edit Post screen. It lets you keep using plugins that extend it, add old-style meta boxes, or otherwise depend on the previous editor. To install, visit your plugins page and click the “Install Now” button next to “Classic Editor”. After the plugin finishes installing, click “Activate”. That’s it!</p>\n\n\n\n<p>Note to users of assistive technology: if you experience usability issues with the block editor, we recommend you continue to use the Classic Editor.</p>\n\n\n\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link has-text-color\" href=\"https://wordpress.org/plugins/classic-editor/\">Check out the Classic Editor</a></div>\n\n\n\n<p>This release is named in homage to the pioneering Cuban jazz musician <a href=\"https://en.wikipedia.org/wiki/Bebo_Vald{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}C3{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}A9s\">Bebo Valdés</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>The Squad</h2>\n\n\n\n<p>This release was led by <a href=\"http://ma.tt/\">Matt Mullenweg</a>, along with co-leads <a href=\"https://www.allancole.com/\">Allan Cole</a>, <a href=\"http://antpb.com/\">Anthony Burchell</a>, <a href=\"https://pento.net/\">Gary Pendergast</a>, <a href=\"https://josepha.blog/\">Josepha Haden Chomphosy</a>, <a href=\"https://laurel.blog/\">Laurel Fulford</a>, <a href=\"https://yoast.com/about-us/team/omar-reiss/\">Omar Reiss</a>, <a href=\"https://danielbachhuber.com/\">Daniel Bachhuber</a>, <a href=\"https://matiasventura.com/\">Matías Ventura</a>, <a href=\"https://lamda.blog/\">Miguel Fonseca</a>, <a href=\"https://tam.blog/\">Tammie Lister</a>, <a href=\"https://tofumatt.com/\">Matthew Riley MacPherson</a>. They were ably assisted by the following fabulous folks. There were 423 contributors with props in this release. Pull up some Bebo Valdés on your music service of choice, and check out some of their profiles:</p>\n\n\n<a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdulwahab610\">Abdul Wahab</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/abhijitrakas\">Abhijit Rakas</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afraithe\">afraithe</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airathalitov\">Airat Halitov</a>, <a href=\"https://profiles.wordpress.org/ajitbohra\">Ajit Bohra</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/albertomedina\">albertomedina</a>, <a href=\"https://profiles.wordpress.org/aldavigdis\">aldavigdis</a>, <a href=\"https://profiles.wordpress.org/alexsanford1\">Alex Sanford</a>, <a href=\"https://profiles.wordpress.org/xyfi\">Alexander Botteram</a>, <a href=\"https://profiles.wordpress.org/alexis\">alexis</a>, <a href=\"https://profiles.wordpress.org/alexislloyd\">Alexis Lloyd</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/amedina\">amedina</a>, <a href=\"https://profiles.wordpress.org/nosolosw\">Andr&#233;s</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/euthelup\">Andrei Lupu</a>, <a href=\"https://profiles.wordpress.org/andreiglingeanu\">andreiglingeanu</a>, <a href=\"https://profiles.wordpress.org/aduth\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/sumobi\">Andrew Munro</a>, <a href=\"https://profiles.wordpress.org/anevins\">Andrew Nevins</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/androb\">Andrew Roberts</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/andrewserong\">andrewserong</a>, <a href=\"https://profiles.wordpress.org/apeatling\">Andy Peatling</a>, <a href=\"https://profiles.wordpress.org/ameeker\">Angie Meeker</a>, <a href=\"https://profiles.wordpress.org/annaharrison\">Anna Harrison</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/arnaudban\">ArnaudBan</a>, <a href=\"https://profiles.wordpress.org/arshidkv12\">Arshid</a>, <a href=\"https://profiles.wordpress.org/aprakasa\">Arya Prakasa</a>, <a href=\"https://profiles.wordpress.org/artisticasad\">Asad</a>, <a href=\"https://profiles.wordpress.org/mrasharirfan\">Ashar Irfan</a>, <a href=\"https://profiles.wordpress.org/asvinballoo\">Asvin Balloo</a>, <a href=\"https://profiles.wordpress.org/atanasangelovdev\">Atanas Angelov</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcolumbia\">bcolumbia</a>, <a href=\"https://profiles.wordpress.org/belcherj\">belcherj</a>, <a href=\"https://profiles.wordpress.org/blowery\">Ben Lowery</a>, <a href=\"https://profiles.wordpress.org/caxco93\">Benjamin Eyzaguirre</a>, <a href=\"https://profiles.wordpress.org/benjamin_zekavica\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/benlk\">benlk</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter\">Bernhard Reiter</a>, <a href=\"https://profiles.wordpress.org/betsela\">betsela</a>, <a href=\"https://profiles.wordpress.org/bhargavmehta\">Bhargav Mehta</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/bpayton\">Brandon Payton</a>, <a href=\"https://profiles.wordpress.org/brentswisher\">Brent Swisher</a>, <a href=\"https://profiles.wordpress.org/technosiren\">Brianna Privett</a>, <a href=\"https://profiles.wordpress.org/briannaorg\">briannaorg</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/bandonrandon\">Brooke.</a>, <a href=\"https://profiles.wordpress.org/burhandodhy\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/cantothemes\">CantoThemes</a>, <a href=\"https://profiles.wordpress.org/cathibosco\">cathibosco</a>, <a href=\"https://profiles.wordpress.org/chetan200891\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chetansatasiya\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrisl27\">Chris Lloyd</a>, <a href=\"https://profiles.wordpress.org/crunnells\">Chris Runnells</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriskmnds\">chriskmnds</a>, <a href=\"https://profiles.wordpress.org/pixelverbieger\">Christian Sabo</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/copons\">Copons</a>, <a href=\"https://profiles.wordpress.org/courtney0burton\">courtney0burton</a>, <a href=\"https://profiles.wordpress.org/mitogh\">Crisoforo Gaspar Hernandez</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">Csaba (LittleBigThings)</a>, <a href=\"https://profiles.wordpress.org/csabotta\">csabotta</a>, <a href=\"https://profiles.wordpress.org/danieltj\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/danielhw\">danielhw</a>, <a href=\"https://profiles.wordpress.org/daniloercoli\">daniloercoli</a>, <a href=\"https://profiles.wordpress.org/dannycooper\">DannyCooper</a>, <a href=\"https://profiles.wordpress.org/nerrad\">Darren Ethier (nerrad)</a>, <a href=\"https://profiles.wordpress.org/davemoran118\">davemoran118</a>, <a href=\"https://profiles.wordpress.org/dcavins\">David Cavins</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David Kennedy</a>, <a href=\"https://profiles.wordpress.org/dryanpress\">David Ryan</a>, <a href=\"https://profiles.wordpress.org/davidsword\">David Sword</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/davidherrera\">davidherrera</a>, <a href=\"https://profiles.wordpress.org/davisshaver\">Davis</a>, <a href=\"https://profiles.wordpress.org/dciso\">dciso</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dsmart\">Derek Smart</a>, <a href=\"https://profiles.wordpress.org/designsimply\">designsimply</a>, <a href=\"https://profiles.wordpress.org/dlocc\">Devin Walker</a>, <a href=\"https://profiles.wordpress.org/deviodigital\">Devio Digital</a>, <a href=\"https://profiles.wordpress.org/dfangstrom\">dfangstrom</a>, <a href=\"https://profiles.wordpress.org/dhanendran\">Dhanendran</a>, <a href=\"https://profiles.wordpress.org/diegoliv\">Diego de Oliveira</a>, <a href=\"https://profiles.wordpress.org/diegoreymendez\">diegoreymendez</a>, <a href=\"https://profiles.wordpress.org/dingo_bastard\">dingo-d</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dency\">Dixita Dusara</a>, <a href=\"https://profiles.wordpress.org/dixitadusara\">Dixita Dusara Gohil</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donnapep\">Donna Peplinskie</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dsawardekar\">dsawardekar</a>, <a href=\"https://profiles.wordpress.org/dsifford\">dsifford</a>, <a href=\"https://profiles.wordpress.org/duanestorey\">Duane Storey</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/ehg\">ehg</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/epointal\">Elisabeth Pointal</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elrae\">elrae</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/ephoxjames\">ephoxjames</a>, <a href=\"https://profiles.wordpress.org/ephoxmogran\">ephoxmogran</a>, <a href=\"https://profiles.wordpress.org/sewmyheadon\">Eric Amundson</a>, <a href=\"https://profiles.wordpress.org/ericnmurphy\">ericnmurphy</a>, <a href=\"https://profiles.wordpress.org/etoledom\">etoledom</a>, <a href=\"https://profiles.wordpress.org/circlecube\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">fabiankaegy</a>, <a href=\"https://profiles.wordpress.org/fabs_pim\">fabs_pim</a>, <a href=\"https://profiles.wordpress.org/faishal\">Faishal</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/floriansimeth\">Florian Simeth</a>, <a href=\"https://profiles.wordpress.org/foobar4u\">foobar4u</a>, <a href=\"https://profiles.wordpress.org/foreverpinetree\">foreverpinetree</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fuyuko\">fuyuko</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/doomwaxer\">Gary Thayer</a>, <a href=\"https://profiles.wordpress.org/garyjones\">garyjones</a>, <a href=\"https://profiles.wordpress.org/soulseekah\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/babbardel\">George Olaru</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/georgeh\">georgeh</a>, <a href=\"https://profiles.wordpress.org/gnif\">gnif</a>, <a href=\"https://profiles.wordpress.org/goldsounds\">goldsounds</a>, <a href=\"https://profiles.wordpress.org/grappler\">Grappler</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Grzegorz Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/gwwar\">gwwar</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/hblackett\">hblackett</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/luehrsen\">Hendrik Luehrsen</a>, <a href=\"https://profiles.wordpress.org/herbmiller\">herbmiller</a>, <a href=\"https://profiles.wordpress.org/herregroen\">Herre Groen</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/hypest\">hypest</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianstewart\">ianstewart</a>, <a href=\"https://profiles.wordpress.org/ianbelanger\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/icaleb\">iCaleb</a>, <a href=\"https://profiles.wordpress.org/idpokute\">idpokute</a>, <a href=\"https://profiles.wordpress.org/igorsch\">Igor</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imonly_ik\">Imran Khalid</a>, <a href=\"https://profiles.wordpress.org/intronic\">intronic</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/ireneyoast\">Irene Strikkers</a>, <a href=\"https://profiles.wordpress.org/ismailelkorchi\">Ismail El Korchi</a>, <a href=\"https://profiles.wordpress.org/israelshmueli\">israelshmueli</a>, <a href=\"https://profiles.wordpress.org/jd55\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/jagnew\">jagnew</a>, <a href=\"https://profiles.wordpress.org/jahvi\">jahvi</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamestryon\">jamestryon</a>, <a href=\"https://profiles.wordpress.org/jamiehalvorson\">jamiehalvorson</a>, <a href=\"https://profiles.wordpress.org/jdembowski\">Jan Dembowski</a>, <a href=\"https://profiles.wordpress.org/janalwin\">janalwin</a>, <a href=\"https://profiles.wordpress.org/jaswrks\">Jason Caldwell</a>, <a href=\"https://profiles.wordpress.org/octalmage\">Jason Stallings</a>, <a href=\"https://profiles.wordpress.org/yingling017\">Jason Yingling</a>, <a href=\"https://profiles.wordpress.org/vengisss\">Javier Villanueva</a>, <a href=\"https://profiles.wordpress.org/jhoffm34\">Jay Hoffmann</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeffpaul\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">JJJ</a>, <a href=\"https://profiles.wordpress.org/sephsekla\">Joe Bailey-Roberts</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joemaller\">joemaller</a>, <a href=\"https://profiles.wordpress.org/joen\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/j-falk\">Johan Falk</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnny5\">John Godley</a>, <a href=\"https://profiles.wordpress.org/johndyer\">johndyer</a>, <a href=\"https://profiles.wordpress.org/johnpixle\">JohnPixle</a>, <a href=\"https://profiles.wordpress.org/johnwatkins0\">johnwatkins0</a>, <a href=\"https://profiles.wordpress.org/jomurgel\">jomurgel</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/koke\">Jorge Bernal</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/ieatwebsites\">Jose Fremaint</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/jvisick77\">Josh Visick</a>, <a href=\"https://profiles.wordpress.org/joshuawold\">Joshua Wold</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jryancard\">jryancard</a>, <a href=\"https://profiles.wordpress.org/jsnajdr\">jsnajdr</a>, <a href=\"https://profiles.wordpress.org/julienmelissas\">JulienMelissas</a>, <a href=\"https://profiles.wordpress.org/kopepasah\">Justin Kopepasah</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kallehauge\">Kallehauge</a>, <a href=\"https://profiles.wordpress.org/kalpshit\">KalpShit Akabari</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinwhoffman\">Kevin Hoffman</a>, <a href=\"https://profiles.wordpress.org/khleomix\">khleomix</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjellr\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/kluny\">kluny</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/xkon\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/krutidugade\">krutidugade</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/notlaura\">Lara Schenck</a>, <a href=\"https://profiles.wordpress.org/leahkoerper\">leahkoerper</a>, <a href=\"https://profiles.wordpress.org/lloyd\">lloyd</a>, <a href=\"https://profiles.wordpress.org/loicblascos\">Lo&#239;c Blascos</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lucasrolff\">LucasRolff</a>, <a href=\"https://profiles.wordpress.org/luigipulcini\">luigipulcini</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lucaskowalski\">Luke Kowalski</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">Luke Pettway</a>, <a href=\"https://profiles.wordpress.org/luminus\">Luminus</a>, <a href=\"https://profiles.wordpress.org/lynneux\">lynneux</a>, <a href=\"https://profiles.wordpress.org/macbookandrew\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/maedahbatool\">Maedah Batool</a>, <a href=\"https://profiles.wordpress.org/mahdiyazdani\">Mahdi Yazdani</a>, <a href=\"https://profiles.wordpress.org/mahmoudsaeed\">mahmoudsaeed</a>, <a href=\"https://profiles.wordpress.org/travel_girl\">Maja Benke</a>, <a href=\"https://profiles.wordpress.org/mkaz\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/marina_wp\">marina_wp</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mariusvw\">mariusvw</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/vindl\">Marko Andrijasevic</a>, <a href=\"https://profiles.wordpress.org/martinlugton\">martinlugton</a>, <a href=\"https://profiles.wordpress.org/m-e-h\">Marty Helmick</a>, <a href=\"https://profiles.wordpress.org/mathiu\">mathiu</a>, <a href=\"https://profiles.wordpress.org/webdevmattcrom\">Matt Cromwell</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattgeri\">MattGeri</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/maurobringolf\">maurobringolf</a>, <a href=\"https://profiles.wordpress.org/maximebj\">Maxime BERNARD-JACQUET</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/meetjey\">meetjey</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mendezcode\">mendezcode</a>, <a href=\"https://profiles.wordpress.org/woodent\">Micah Wood</a>, <a href=\"https://profiles.wordpress.org/wpscholar\">Micah Wood</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michaelhull\">Michael Hull</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/mizejewski\">Michele Mizejewski</a>, <a href=\"https://profiles.wordpress.org/jbpaul17\">Migrated to @jeffpaul</a>, <a href=\"https://profiles.wordpress.org/stubgo\">Miina Sikk</a>, <a href=\"https://profiles.wordpress.org/simison\">Mikael Korpela</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mike-haydon-swo\">Mike Haydon</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeselander\">Mike Selander</a>, <a href=\"https://profiles.wordpress.org/mikehaydon\">mikehaydon</a>, <a href=\"https://profiles.wordpress.org/mikeyarce\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/milana_cap\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/gonzomir\">Milen Petrinski - Gonzo</a>, <a href=\"https://profiles.wordpress.org/milesdelliott\">milesdelliott</a>, <a href=\"https://profiles.wordpress.org/mimo84\">mimo84</a>, <a href=\"https://profiles.wordpress.org/0mirka00\">mirka</a>, <a href=\"https://profiles.wordpress.org/mmtr86\">mmtr86</a>, <a href=\"https://profiles.wordpress.org/boemedia\">Monique Dubbelman</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mostafas1990\">Mostafa Soufi</a>, <a href=\"https://profiles.wordpress.org/motleydev\">motleydev</a>, <a href=\"https://profiles.wordpress.org/mpheasant\">mpheasant</a>, <a href=\"https://profiles.wordpress.org/mrmadhat\">mrmadhat</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">mrwweb</a>, <a href=\"https://profiles.wordpress.org/msdesign21\">msdesign21</a>, <a href=\"https://profiles.wordpress.org/mtias\">mtias</a>, <a href=\"https://profiles.wordpress.org/desideveloper\">Muhammad Irfan</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/munirkamal\">munirkamal</a>, <a href=\"https://profiles.wordpress.org/mmaumio\">Muntasir Mahmud</a>, <a href=\"https://profiles.wordpress.org/mzorz\">mzorz</a>, <a href=\"https://profiles.wordpress.org/nagayama\">nagayama</a>, <a href=\"https://profiles.wordpress.org/nfmohit\">Nahid F. Mohit</a>, <a href=\"https://profiles.wordpress.org/nao\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/napy84\">napy84</a>, <a href=\"https://profiles.wordpress.org/nateconley\">nateconley</a>, <a href=\"https://profiles.wordpress.org/nativeinside\">Native Inside</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/buzztone\">Neil Murray</a>, <a href=\"https://profiles.wordpress.org/nicbertino\">nic.bertino</a>, <a href=\"https://profiles.wordpress.org/notnownikki\">Nicola Heald</a>, <a href=\"https://profiles.wordpress.org/nielslange\">Niels Lange</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/nitrajka\">nitrajka</a>, <a href=\"https://profiles.wordpress.org/njpanderson\">njpanderson</a>, <a href=\"https://profiles.wordpress.org/nshki\">nshki</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/pareshradadiya-1\">Paresh Radadiya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pauldechov\">Paul Dechov</a>, <a href=\"https://profiles.wordpress.org/paulstonier\">Paul Stonier</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pedromendonca\">Pedro Mendon&#231;a</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pglewis\">pglewis</a>, <a href=\"https://profiles.wordpress.org/tyrannous\">Philipp Bammes</a>, <a href=\"https://profiles.wordpress.org/piersb\">piersb</a>, <a href=\"https://profiles.wordpress.org/wizzard_\">Pieter Daalder</a>, <a href=\"https://profiles.wordpress.org/pilou69\">pilou69</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/poena\">poena</a>, <a href=\"https://profiles.wordpress.org/postphotos\">postphotos</a>, <a href=\"https://profiles.wordpress.org/potbot\">potbot</a>, <a href=\"https://profiles.wordpress.org/prtksxna\">Prateek Saxena</a>, <a href=\"https://profiles.wordpress.org/pratikthink\">Pratik K. Yadav</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/psealock\">psealock</a>, <a href=\"https://profiles.wordpress.org/ptasker\">ptasker</a>, <a href=\"https://profiles.wordpress.org/rachelmcr\">Rachel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahmohn\">Rahmohn</a>, <a href=\"https://profiles.wordpress.org/rahmon\">Rahmon</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/rakshans1\">rakshans1</a>, <a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/revgeorge\">revgeorge</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/richsalvucci\">richsalvucci</a>, <a href=\"https://profiles.wordpress.org/riddhiehta02\">Riddhi Mehta</a>, <a href=\"https://profiles.wordpress.org/rileybrook\">rileybrook</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/sanchothefat\">Robert O\'Rourke</a>, <a href=\"https://profiles.wordpress.org/robertsky\">robertsky</a>, <a href=\"https://profiles.wordpress.org/_dorsvenabili\">Rocio Valdivia</a>, <a href=\"https://profiles.wordpress.org/rohittm\">Rohit Motwani</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/ryo511\">ryo511</a>, <a href=\"https://profiles.wordpress.org/sagarprajapati\">Sagar Prajapati</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/tinkerbelly\">sarah semark</a>, <a href=\"https://profiles.wordpress.org/scottmweaver\">Scott Weaver</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sergioestevao\">SergioEstevao</a>, <a href=\"https://profiles.wordpress.org/azchughtai\">Shahjehan Ali</a>, <a href=\"https://profiles.wordpress.org/shaileesheth\">Shailee Sheth</a>, <a href=\"https://profiles.wordpress.org/sharaz\">Sharaz Shahid</a>, <a href=\"https://profiles.wordpress.org/giventofly76\">Shaun sc</a>, <a href=\"https://profiles.wordpress.org/shaunandrews\">shaunandrews</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/shenkj\">shenkj</a>, <a href=\"https://profiles.wordpress.org/sikander\">sikander</a>, <a href=\"https://profiles.wordpress.org/pross\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/siriokun\">siriokun</a>, <a href=\"https://profiles.wordpress.org/sirjonathan\">sirjonathan</a>, <a href=\"https://profiles.wordpress.org/sirreal\">sirreal</a>, <a href=\"https://profiles.wordpress.org/sisanu\">Sisanu</a>, <a href=\"https://profiles.wordpress.org/skorasaurus\">skorasaurus</a>, <a href=\"https://profiles.wordpress.org/butimnoexpert\">Slushman</a>, <a href=\"https://profiles.wordpress.org/ssousa\">Sofia Sousa</a>, <a href=\"https://profiles.wordpress.org/somtijds\">SOMTIJDS</a>, <a href=\"https://profiles.wordpress.org/soean\">Soren Wrede</a>, <a href=\"https://profiles.wordpress.org/spocke\">spocke</a>, <a href=\"https://profiles.wordpress.org/stagger-lee\">Stagger Lee</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stevehenty\">Steve Henty</a>, <a href=\"https://profiles.wordpress.org/charlestonsw\">Store Locator Plus</a>, <a href=\"https://profiles.wordpress.org/strategio\">strategio</a>, <a href=\"https://profiles.wordpress.org/stuartfeldt\">stuartfeldt</a>, <a href=\"https://profiles.wordpress.org/tacrapo\">tacrapo</a>, <a href=\"https://profiles.wordpress.org/talldan\">talldan</a>, <a href=\"https://profiles.wordpress.org/tammie_l\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/themeroots\">ThemeRoots</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/thrijith\">Thrijith Thankachan</a>, <a href=\"https://profiles.wordpress.org/hedgefield\">Tim Hengeveld</a>, <a href=\"https://profiles.wordpress.org/timgardner\">timgardner</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tlxo\">Toni Laakso</a>, <a href=\"https://profiles.wordpress.org/skithund\">Toni Viemer&#246;</a>, <a href=\"https://profiles.wordpress.org/tobifjellner\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/mirucon\">Toshihiro Kanai</a>, <a href=\"https://profiles.wordpress.org/itowhid06\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/travislopes\">Travis Lopes</a>, <a href=\"https://profiles.wordpress.org/truongwp\">truongwp</a>, <a href=\"https://profiles.wordpress.org/tjfunke001\">Tunji Ayoola</a>, <a href=\"https://profiles.wordpress.org/twoelevenjay\">twoelevenjay</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/vtrpldn\">Vitor Paladini</a>, <a href=\"https://profiles.wordpress.org/walterebert\">Walter Ebert</a>, <a href=\"https://profiles.wordpress.org/warmarks\">warmarks</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/willybahuaud\">Willy Bahuaud</a>, <a href=\"https://profiles.wordpress.org/yahil\">Yahil Madakiya</a>, <a href=\"https://profiles.wordpress.org/yingles\">yingles</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/youthkee\">Yusuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/zebulan\">zebulan</a>, and <a href=\"https://profiles.wordpress.org/ziyaddin\">Ziyaddin Sadigov</a>.\n\n\n\n<p>Finally, thanks to all the community translators who worked on WordPress 5.0. Their efforts bring WordPress 5.0 fully translated to 37 languages at release time, with more on the way.</p>\n\n\n\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\n\n\n<p>Thanks for choosing WordPress!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Dec 2018 19:28:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Post Status: WordPress 5.0 marks a new era for the world’s most popular CMS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=49548\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://poststatus.com/wordpress-5-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5170:\"<p>WordPress 5.0, &#8220;<a href=\"https://wordpress.org/news/2018/12/bebo/\">Bebo</a>,&#8221; is a shift of the highest order for the platform. Block-based editing, under the name of &#8220;Gutenberg,&#8221; is an entirely new way to publish content. It adds a world of flexibility when writing, and it opens the gates for transforming much of the broader WordPress experience moving forward.</p>\n<p></p>\n<p>TinyMCE has been the core of the WordPress writing experience for, well, forever. Users will be able to continue using TinyMCE with the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor</a> plugin, which will be especially useful for those web applications with significant amounts of structured content that will take time and reprogramming to fit the new editing experience.</p>\n<p>The need for a new editor has been a wide-held concern in the WordPress community for a long time. Gutenberg has been more than two years in the making, and it involved dozens of full-time or near full-time contributors at times. Automattic, the company behind WordPress.com and other popular WordPress products, has invested a great deal in Gutenberg&#8217;s development, as have many other companies and individuals — but the bulk of development and decision-making has been by Automattic employees.</p>\n<p>There have been critiques that the process for decision making has been too closed off and rushed toward the end of the development cycle for the purpose of delivery by WordCamp US despite ongoing concerns, particularly around accessibility.</p>\n<p>5.0 had to ship eventually, and the process has been a long one. It was a complete shift from the traditional development cycles, which <a href=\"https://poststatus.com/interview-matt-mullenweg-new-wordpress-release-cycle/\">I discussed with Matt Mullenweg</a> at WordCamp US two years ago.</p>\n<p>I have personally held the view that now is as good a time as any to release 5.0, though the exact timing is a burden on folks traveling to WCUS, particularly considering that it was just a few days notice; it is putting a kink in the plans of many.</p>\n<p>Timing aside, Gutenberg is, I believe, an important step and a big test for WordPress. It is imperative that the platform evolves to be both more powerful and easier to use — an enormously difficult dual challenge that I have advocated as an important feat to accomplish for several years now.</p>\n<p>WordPress is the easiest full-featured content management system to use. But it is more difficult than many alternative publishing platforms — particularly hosted ones. Drastic changes, like Gutenberg, are necessary to continue being a preferred platform for end users. Being easy to use and customize got WordPress to the dominant position it is in today, and I believe it is extremely important to continue in that trajectory to maintain that position.</p>\n<p>At the same time, as WordPress is being used in ever more advanced applications, developers need powerful, scalable solutions. WordPress has made great strides over the years to accommodate this use case, from various APIs to assist in new data structure creation, to the REST API. Gutenberg offers much promise to continue this trend, as it is quite extendable and also flexible for deployment on the web, in native apps, and on both front-ends and backends.</p>\n<p>I believe 5.0 is a huge step forward for the platform. The journey is not without its issues, and there is much work to do, but WordPress needed and continues to need big changes and advancements to maintain its position at the top of the content management food chain.</p>\n<p>People are using WordPress for all sorts of things, whether traditional publishing, eCommerce, application frameworks, and much more. I’m excited to see what Gutenberg brings to further these applications. Strictly as an editor, it’s far from perfect, but it’s an important step in the right direction.</p>\n<h2>Get familiar with WordPress 5.0</h2>\n<p>Here are some links to places to learn more about the new editing experience and WordPress 5.0.</p>\n<ul>\n<li><a href=\"https://wordpress.org/news/2018/12/bebo/\">WordPress 5.0 release post</a></li>\n<li><a href=\"https://wordpress.org/gutenberg/handbook/\">Gutenberg designer and developer handbook</a></li>\n<li><a href=\"https://wordpress.org/gutenberg/\">WordPress.org/Gutenberg</a> teaser, where you can use it live.</li>\n<li><a href=\"https://make.wordpress.org/core/2018/12/06/wordpress-5-0-field-guide/\">WordPress 5.0 Field Guide</a></li>\n<li>Gutenberg <a href=\"https://github.com/WordPress/gutenberg\">on GitHub</a> (This will be deprecated but offers a nice history.)</li>\n<li><a href=\"https://make.wordpress.org/core/2018/12/06/the-rest-api-in-wordpress-5-0/\">Changes to the REST API</a></li>\n<li><a href=\"https://make.wordpress.org/core/2018/12/06/media-5-0-guide/\">Media in 5.0</a></li>\n<li>The <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">Twenty Nineteen</a> default theme and Gutenberg support <a href=\"https://make.wordpress.org/core/2018/12/06/block-editor-support-in-existing-default-themes/\">in other default themes</a>.</li>\n</ul>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Dec 2018 17:31:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: WPWeekly Episode 340 – Twas the Night Before 5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=86219&preview=true&preview_id=86219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/wpweekly-episode-340-twas-the-night-before-5-0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1802:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by Matt Mullenweg, co-creator of the WordPress project. We discussed a number of topics that have been making the rounds across the community such as:</p>\n<ul>\n<li>The WordPress 5.0 release strategy and how it will evolve once it&#8217;s released.</li>\n<li>Whether or not Gutenberg is ready and what ready means.</li>\n<li>Having Automatticians in project leadership roles and what roles WordPress core contributors can or will have going forward.</li>\n<li>ClassicPress, Publicious, and other forks.</li>\n<li>Gutenberg and Accessibility.</li>\n<li>Communication, feedback mechanisms, and trying to make sure everybody can participate in the conversation.</li>\n</ul>\n<p>We also talked about the long-term vision of Gutenberg. Near the end of the interview, Matt described some of the innovative things he&#8217;s seen built with the new editor.</p>\n<p>To round out the show, we sent shoutouts to Alex Mills who <a href=\"https://alex.blog/2018/11/30/my-cancer-just-wont-give-up/\">recently discovered</a> that he will need to battle through leukemia again.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Thursday, December 13th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #340:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Dec 2018 03:32:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"BuddyPress: BuddyPress 4.1.0 maintenance release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=282488\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://buddypress.org/2018/12/buddypress-4-1-0-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:332:\"<p>Immediately available is BuddyPress 4.1.0. This maintenance release fixes 3 bugs related to last week&#8217;s 4.0.0 release, and is a recommended upgrade for all BuddyPress installations.</p>\n<p>For complete details on the release, visit the <a href=\"https://codex.buddypress.org/releases/version-4-1-0/\">4.1.0 changelog</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2018 16:18:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Boone Gorges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Matt: Interview on Gutenberg and Future of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48667\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://ma.tt/2018/12/interview-on-gutenberg-and-future-of-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:863:\"<p>Yesterday I was able to have a great conversation with Adam from WP Crafter, a popular Youtube channel with over five million views. Adam said it was his first interview but you can&#8217;t tell, we had an excellent conversation that covered Gutenberg, the 5.0 release, why WordPress has done well so far, and what&#8217;s coming in the future. If you&#8217;d like more context than text or tweets can give for what&#8217;s happening in WordPress today, check it out.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Of course Friday and Saturday are <a href=\"https://2018.us.wordcamp.org\">WordCamp US</a>, which returns to Nashville this year. Everything will be live-streamed for free, including my State of the Word presentation on Saturday, you just need to <a href=\"https://2018.us.wordcamp.org/tickets/\">pick up a free streaming ticket</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2018 14:16:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: WordPress 5.0 Targeted for December 6, Prompting Widespread Outcry Ahead of WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://wptavern.com/wordpress-5-0-targeted-for-december-6-prompting-widespread-outcry-ahead-of-wordcamp-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7290:\"<p>During last week&#8217;s core dev chat, Matt Mullenweg urged developers to consider WordPress 5.0 as &#8220;coming as soon as possible.&#8221; Nevertheless, his decision to set Thursday, December 6, for the <a href=\"https://make.wordpress.org/core/2018/12/04/new-5-0-target-date/\" rel=\"noopener\" target=\"_blank\">new release date</a> has taken many by surprise. </p>\n<p>Official feedback channels and social media erupted with largely negative feedback on the decision, as the new release date has 5.0 landing the day before WordCamp US begins. This is a travel day for many attending the conference. It also means both of the planned follow-up releases will be expected during the upcoming weeks when many have scheduled time off for major world holidays.</p>\n<p>Yoast CEO Joost de Valk, one of the most vocal critics of the 5.0 timelime, <a href=\"https://twitter.com/yoast/status/1069880401055895553\" rel=\"noopener\" target=\"_blank\">posted a public message of dissent</a> that resonated with many on Twitter:</p>\n<blockquote><p>We vehemently disagree with the decision to release WordPress 5.0 on December 6th, and think it&#8217;s irresponsible and disrespectful towards the community. </p>\n<p>However, we&#8217;re now going to try and support the community as well as possible and we hope to show everyone that Gutenberg is indeed a huge step forward.</p></blockquote>\n<p>Although Gutenberg as a project has strong support from many large companies in the WordPress ecosystem, much of the current uproar is rooted in a communication published in early October that indicated <a href=\"https://make.wordpress.org/core/2018/10/03/proposed-wordpress-5-0-scope-and-schedule/\" rel=\"noopener\" target=\"_blank\">5.0 would be pushed to January</a> if it missed the first set of planned release dates:</p>\n<blockquote><p>We know there is a chance that 5.0 will need additional time, so these dates can slip by up to 8 days if needed. If additional time beyond that is required, we will instead aim for the following dates:</p>\n<p>Secondary RC 1: January 8, 2019</p>\n<p>Secondary Release: January 22, 2019</p>\n<p>Should we need to switch to the secondary dates, this will be communicated as soon as we’re aware.</p></blockquote>\n<p>Companies made plans based on this schedule, but after those dates passed Mullenweg was unwilling to commit to honoring the previous communication. The plan from the outset may have been to &#8220;play it by ear&#8221; and incorporate new information as it became available, but the developer community had been counting on the published deadlines to be definitive.</p>\n<p>&#8220;This decision was made in disregard to earlier specific timelines and promises, and does not take the realities on the ground into account,&#8221; Morten Rand-Hendricksen <a href=\"https://twitter.com/mor10/status/1070013237205204992?s=19\" rel=\"noopener\" target=\"_blank\">said</a>. &#8220;I agree with @yoast it is both irresponsible and disrespectful.&#8221;</p>\n<p>Although reactions on Twitter run the gamut from unbridled optimism to full on outrage, many of those commenting on the schedule have fallen into resignation, convinced that community feedback never really mattered when it came to scheduling the release.</p>\n<p>Mullenweg&#8217;s rationale behind announcing the release date with three days notice is that Gutenberg and/or the Classic Editor are already active on more than 1.3 million sites. Users do not have to upgrade to WordPress 5.0 until they are ready. If they opt for the Classic Editor, the editing experience &#8220;will be indistinguishable from 4.9.8.&#8221; </p>\n<p>Users who are informed enough to make this choice will be well-prepared when they see that 5.0 update in their dashboards. However, one of the chief concerns is that millions of WordPress users will update without testing. Plugin developers are scrambling to ship compatibility updates and support staff will need to be on hand to help users navigate any incompatibilities or bugs in the new editing experience. Hundreds of WordPress professionals will be traveling to WordCamp US when 5.0 is expected to ship, which poses challenges for supporting users who experience problems with the update.</p>\n<p>&#8220;I do not think the attendees of WCUS are more important than much larger portion of the WordPress community who does not (and cannot) attend, and there are numerous ways to deal with 5.0 before or after the 6th if that particular day is inconvenient for someone, regardless of the reason,&#8221; Mullenweg <a href=\"https://make.wordpress.org/core/2018/12/04/new-5-0-target-date/#comment-34686\" rel=\"noopener\" target=\"_blank\">said</a> in response to comments regarding the date conflicting with travel plans.</p>\n<p>The release date <a href=\"https://make.wordpress.org/core/2018/12/04/new-5-0-target-date/\" rel=\"noopener\" target=\"_blank\">announcement</a> has well over 100 comments from frustrated contributors and developers expressing concerns, and Mullenweg has been responsive in the comments. He has recently <a href=\"https://wptavern.com/mullenweg-ramps-up-communication-ahead-of-wordpress-5-0-release-rc2-now-available\" rel=\"noopener\" target=\"_blank\">ramped up communication</a> ahead of the release, regularly attending core dev chats, adding dedicated office hours to connect with the community one-on-one, and answering some of the most pressing Gutenberg questions on his blog in a lengthy but inspiring <a href=\"https://ma.tt/2018/11/a-gutenberg-faq/\" rel=\"noopener\" target=\"_blank\">FAQ post</a>. </p>\n<p>Despite these communication efforts, contributors who are not employed by Automattic have said they feel this release has been plagued by a lack of transparency regarding decision-making. Many WordPress core committers, core contributors, and former release leads have <a href=\"https://wptavern.com/wordpress-5-0-rc-expected-on-u-s-thanksgiving-holiday-despite-last-minute-pushback-from-contributors\" rel=\"noopener\" target=\"_blank\">pushed back</a> on releasing before January to no avail. Their concerns and disappointments during the process hang like a dark cloud over what should be an exciting time for the future of WordPress.</p>\n<p>&#8220;No matter how bad the process around WordPress 5.0 might have been, finally setting a release date was the only right step following the RCs,&#8221; WordPress core developer Dominik Schilling <a href=\"https://twitter.com/ocean90/status/1069874387870978048\" rel=\"noopener\" target=\"_blank\">said</a>. &#8220;Let&#8217;s see if it&#8217;s also the beginning for doing it better to get back on releases which everyone will love.&#8221;</p>\n<p><a href=\"https://gemservers.com/\" rel=\"noopener\" target=\"_blank\">John Teague</a>, who runs an 11-person operation, managing 210 enterprise hosting clients, summarized how many are feeling ahead of WordPress 5.0 shipping out this week.</p>\n<p>&#8220;I so want to be supportive of this release,&#8221; Teague said. &#8220;But between the top down, heavily Automattic managed process, poor release communication, super short RC2, RC3, punting on accessibility, and now this two-day notice to 5.0 release &#8211; it reminds me of an old Air Force saying when instructors sent barely trained pilots up for their first solo:  </p>\n<p>&#8216;Send em up and let God grade em.\'&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2018 07:37:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"HeroPress: WordPress made me walk 700km to Berlin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2658\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"https://heropress.com/essays/wordpress-made-me-walk-700km-to-berlin/#utm_source=rss&utm_medium=rss&utm_campaign=wordpress-made-me-walk-700km-to-berlin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9479:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2018/12/120518-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Nothing happens in your comfort zone. Go beyond and find the magic.\" /><p>Since the year 2000 I was employed at a big IT hardware/software/services firm. After about 9 years I was not feeling quite happy about how things went. Let’s say that the plans the company had with me did not really line up with the monthly reward. So, I quit and started my own company, <a href=\"https://nostromo.nl/\">nostromo.nl</a> in June 2009 (<a href=\"https://twitter.com/mbootsman/status/2090725144\">Tweetproof</a>). The goal was to serve customers by designing/developing and maintaining websites.</p>\n<h3>A new beginning</h3>\n<p>Now the challenge begins. Where do I start, who do I call? “Hello, do you need a new website? I just started my company and I can help you”. Why would I be the right person to help this company with their new website? The first thing I learned was to be sure of myself. I know what I can do and the customer needs help, probably because they are not so skillful in building websites.</p>\n<p>After a month I was talking with a potential customer, my first one (!), and I got the quotation signed. I was going to build my own CMS, and I soon realized (the hard way) that was not the way to go. I had to do a CMS comparison and WordPress won.</p>\n<h3>Here comes WordPress</h3>\n<p>The ease of use and the extensive documentation for developers convinced me. After having built numerous websites, and offering maintenance services to customers, I wanted  to know who the people were that built WordPress. Why? Well, because I was using free software and I was making money with it. That didn’t feel right, I wanted to give something back.</p>\n<p>Browsing support forums and IRC (that&#8217;s something like Slack, but without the GIFs) I quickly became aware of the WordPress community and felt I wanted to get to know these great people.</p>\n<h3>WordCamp &#8211; how it changed me</h3>\n<p>It was 2010 when I learned about a thing called WordCamp in The Netherlands. The entrance ticket was cheap and I could attend talks by inspiring people. On November 6th 2010, I was waiting in line at the registration desk. It was my turn, and someone from behind the desk said; “Hey, nostromo!”. It was <a href=\"https://twitter.com/remkusdevries\">Remkus de Vries</a>, he recognized me from my avatar on Twitter and those two words made me feel welcome immediately. This moment I remember very vividly and it marks the point where my enthusiasm for the WordPress community was sparked to life.</p>\n<h3>I volunteer &#8211; a lot</h3>\n<p>Giving back to the community got defined. Translating, helping out in the Dutch official WordPress support forum, organizing meetups/WordCamps (The Netherlands, the first WordCamp Europe, and WordCamp Rotterdam) and helping others join and be active in the WordPress community. These were some of the things I did, and yes, I had to push the brake on voluntary jobs sometimes, because I also needed to be productive and profitable in my business. Since that first WordCamp I have met amazing, inspiring and skillful people (in random order). I haven’t met new people, I met new friends.</p>\n<h3>Volunteering &#8211; taking it to the next level</h3>\n<p>It was June 4th 2018 when I got a weird idea. Yeah, that sometimes happens. Impulsive as I am, I tweeted it:</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">I&#039;m thinking about walking to the next <a href=\"https://twitter.com/hashtag/WCEU?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WCEU</a>. Needs some planning of course, and funding / sponsoring. Will launch a separate website after this years edition.</p>\n<p>&mdash; <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f6b6-1f3fc-200d-2642-fe0f.png\" alt=\"🚶🏼‍♂️\" class=\"wp-smiley\" /> Marcel Bootsman (@mbootsman) <a href=\"https://twitter.com/mbootsman/status/1003666255994376192?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">June 4, 2018</a></p></blockquote>\n<p></p>\n<p>Little did I know, there was a body part that had a big objection. While planning to go to Belgrade for WordCamp Europe 2018 this happened:</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Good morning. Going to see doctor later, I have a sore knee and walking is merely possible. Great timing, body&#8230; <a href=\"https://twitter.com/hashtag/WCEU?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#WCEU</a></p>\n<p>&mdash; <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f6b6-1f3fc-200d-2642-fe0f.png\" alt=\"🚶🏼‍♂️\" class=\"wp-smiley\" /> Marcel Bootsman (@mbootsman) <a href=\"https://twitter.com/mbootsman/status/1006400794617352192?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">June 12, 2018</a></p></blockquote>\n<p></p>\n<p>And yes, I had to cancel our trip (my wife was going to join) and ended up laying in bed for about a week with an inflamed knee. I received antibiotics from the doctor and gladly the pain and inflammation disappeared. That aside, at the end of WCEU 2018 it was announced that WCEU 2019 was going to be in Berlin. I was happy, since that’s really close (about 700 km) to where I live.</p>\n<p>Currently I am training, I’ve planned my route and I am looking for places to sleep in Germany. Please see this website <a href=\"http://walktowc.eu\">walktowc.eu</a> for more information. Since this hike is probably going to gain some attention in the community, I had another idea. Why not use this as a means to raise money, for a good cause. Walking 700 km in about 30 days is a challenge, and if I can get enough attention, raising money might work out. Now I just had to find a good cause to raise money for&#8230;</p>\n<h3>Raising funds for DonateWC</h3>\n<p>I have known <a href=\"https://twitter.com/motherofcode\">Ines van Essen</a> for a few years now and in September 2017 she started a thing called <a href=\"https://donatewc.org/\">DonateWC</a>. After a successful initial funding campaign they sent their first recipient to <a href=\"https://donatewc.org/sponsorship-recipients/were-sending-a-speaker-to-wordcamp-cape-town/\">WordCamp Capetown</a> in October 2017. Seeing this made me believe this is another sign of how friendly and supporting the WordPress community is, to make sure that people are able to attend WordCamps, while they do not have the financial means to do so. The community supports community members, and that’s the reason why I chose DonateWC as the cause I’m going to raise funds for. And as a side effect also raise awareness of the existence of DonateWC.</p>\n<h3>My message to you</h3>\n<p>Don’t feel obliged to do things you don’t like.</p>\n<p>Do things you like.</p>\n<p>Start volunteering.</p>\n<p>Build your network.</p>\n<p>Enjoy the community.</p>\n<p>Step (or walk) out of your comfort zone.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Nothing happens in your comfort zone. Go beyond and find the magic. <a href=\"https://t.co/Rm4zDtT5JL\">pic.twitter.com/Rm4zDtT5JL</a></p>\n<p>&mdash; <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f6b6-1f3fc-200d-2642-fe0f.png\" alt=\"🚶🏼‍♂️\" class=\"wp-smiley\" /> Marcel Bootsman (@mbootsman) <a href=\"https://twitter.com/mbootsman/status/971276691447386120?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">March 7, 2018</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: WordPress made me walk 700km to Berlin\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=WordPress{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20made{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20me{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20walk{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20700km{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20to{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}20Berlin&via=heropress&url=https{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}3A{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fheropress.com{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fessays{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fwordpress-made-me-walk-700km-to-berlin{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: WordPress made me walk 700km to Berlin\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}3A{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fheropress.com{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fessays{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fwordpress-made-me-walk-700km-to-berlin{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}3A{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fheropress.com{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fessays{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2Fwordpress-made-me-walk-700km-to-berlin{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2F&title=WordPress+made+me+walk+700km+to+Berlin\" rel=\"nofollow\" target=\"_blank\" title=\"Share: WordPress made me walk 700km to Berlin\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/wordpress-made-me-walk-700km-to-berlin/&media=https://heropress.com/wp-content/uploads/2018/12/120518-150x150.jpg&description=WordPress made me walk 700km to Berlin\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: WordPress made me walk 700km to Berlin\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/wordpress-made-me-walk-700km-to-berlin/\" title=\"WordPress made me walk 700km to Berlin\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/wordpress-made-me-walk-700km-to-berlin/\">WordPress made me walk 700km to Berlin</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2018 07:00:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcel Bootsman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Dev Blog: WordPress 5.0 RC3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6322\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2018/12/wordpress-5-0-rc3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2755:\"<p>The third release candidate for WordPress 5.0 is now available!</p>\n\n\n\n<p><strong>WordPress 5.0 will be released on </strong><a href=\"https://make.wordpress.org/core/2018/12/04/new-5-0-target-date/\"><strong>December 6, 2018</strong></a>. This is a big release and needs&nbsp;<em>your</em>&nbsp;help—if you haven’t tried 5.0 yet, now is the time!</p>\n\n\n\n<p>To test WordPress 5.0, you can use the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-RC3.zip\">download the release candidate here</a>&nbsp;(zip).</p>\n\n\n\n<p>For details about what to expect in WordPress 5.0, please see the&nbsp;<a href=\"https://wordpress.org/news/2018/11/wordpress-5-0-release-candidate/\">first release candidate post</a>.</p>\n\n\n\n<p>This release candidate includes a fix for some scripts not loading on subdirectory installs (<a href=\"https://core.trac.wordpress.org/ticket/45469\">#45469</a>), and user locale settings not being loaded in the block editor (<a href=\"https://core.trac.wordpress.org/ticket/45465\">#45465</a>). Twenty Nineteen has also had a couple of minor tweaks.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.0 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme to 5.0. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>&nbsp;so we can figure those out before the final release. An in-depth field guide to developer-focused changes is coming soon on the&nbsp;<a href=\"https://make.wordpress.org/core/\">core development blog</a>. In the meantime, you can review the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5.0+dev-notes/\">developer notes for 5.0</a>.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;</p>\n\n\n\n<p>If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>WordPress Five Point Oh<br />Is just a few days away!<br />Nearly party time!</em> <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Dec 2018 07:07:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: New Block Gallery Plugin Offers a Suite of Photo Gallery Blocks for Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85195\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/new-block-gallery-plugin-offers-a-suite-of-photo-gallery-blocks-for-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3116:\"<p>The new Gutenberg editor has basic support for galleries with a few nice features, such as the ability to set the number of columns and automatically crop thumbnails for a more uniform appearance. If you need more control over your galleries, Rich Tabor&#8217;s <a href=\"https://wordpress.org/plugins/block-gallery/\" rel=\"noopener\" target=\"_blank\">Block Gallery</a> plugin is currently the best option made specifically for use with Gutenberg and WordPress 5.0+. It offers a suite of photo gallery blocks with minimal, tasteful styling that fits unobtrusively into virtually any site design. </p>\n<p>Block Gallery currently offers three different blocks, including masonry, fullscreen stacked, and a carousel slider. Each block has its own settings that offer more customization for the specific gallery type.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-12-03-at-3.19.46-PM.png?ssl=1\"><img /></a></p>\n<p>The plugin also makes use of Gutenberg&#8217;s block transform utility to allow users to seamlessly transform galleries from one style to another with one click, as demonstrated in the video below.</p>\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>A demo of the new <a href=\"https://wordpress.org/plugins/block-gallery/\">Block Gallery WordPress Plugin</a>\n<p>&#8220;I built the Block Gallery plugin originally as a proving ground for exploring how my portfolio WordPress themes at ThemeBeans will interface with Gutenberg,&#8221; <a href=\"https://themebeans.com/\" rel=\"noopener\" target=\"_blank\">ThemeBeans</a> founder Rich Tabor said. &#8220;I do not particularly like the idea of disabling the block editor on portfolio custom post types, so I wanted to find a clever way for folks to use different sorts of galleries to showcase their art, illustrations, photos, etc. Block Gallery was born out of that exploration.&#8221;  </p>\n<p>Tabor said that although the core gallery block is much more robust than the classic editor’s gallery system, he wanted to give users more flexibility in how they display media. His favorite feature of the project is the ability to morph gallery blocks into different types.</p>\n<p>&#8220;That means every image, settings, display option, and color selection are each migrated instantly — if a user swaps out a selected gallery for a different type,&#8221; Tabor said. &#8220;For instance, folks can morph from a masonry gallery to a carousel slider in a single click, without having to re-upload/assign images or select any options. It’s all done behind the scenes, automagically.&#8221;</p>\n<p>Tabor&#8217;s Block Gallery plugin is a major leap forward for galleries in terms of usability. It offers a beautiful implementation of features that would have been difficult to imagine before the block editor. <a href=\"https://wordpress.org/plugins/block-gallery/\" rel=\"noopener\" target=\"_blank\">Block Gallery</a> currently has more than 400 active installs after a little more than month in the official directory. Watch for that number to jump as more people begin using the new editor when WordPress 5.0 is released. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Dec 2018 22:29:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Dev Blog: The Month in WordPress: November 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6318\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/12/the-month-in-wordpress-november-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6607:\"<p>WordPress 5.0 is almost ready for release, including an all-new content editing experience. Volunteers all across the project are gearing up for the launch and making sure everything is ready. Read on to find out what&#8217;s been happening and how you can get involved.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.0 Close to Launch</h2>\n\n\n\n<p>The release date for WordPress 5.0 has not yet been set, but the second release candidate (RC) <a href=\"https://wordpress.org/news/2018/11/wordpress-5-0-rc2/\">is now available</a>. The final release date will be determined based on feedback and testing of this RC. The Core development team has been posting <a href=\"https://make.wordpress.org/core/2018/12/03/5-0-gutenberg-status-update-dec-3/\">daily updates</a> on the progress of their work on v5.0, with the number of open issues for this release decreasing every day.<br /></p>\n\n\n\n<p>The primary feature of this release is <a href=\"https://wordpress.org/gutenberg/\">the new editor</a> that will become the default WordPress experience going forward. A number of people have been seeking more direct feedback from the release leads about the progress of this release, which <a href=\"https://profiles.wordpress.org/matt/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matt</a> has facilitated by hosting <a href=\"https://make.wordpress.org/core/2018/11/29/gutenberg-5-0-listening-office-hours/\">one-to-one discussions</a> with anyone in the community who wanted to talk with him about it. He has also published <a href=\"https://ma.tt/2018/11/a-gutenberg-faq/\">an extended FAQ</a> covering many of the questions people have been asking.<br /></p>\n\n\n\n<p>Alongside the development of the new editor, the Mobile team has been working hard to bring the WordPress mobile apps up to speed. They plan to make a beta version available <a href=\"https://make.wordpress.org/mobile/2018/11/15/gutenberg-in-the-apps-what-to-expect/\">in February 2019</a>.<br /></p>\n\n\n\n<p>Want to get involved in developing WordPress Core in 5.0 and beyond? Follow <a href=\"https://make.wordpress.org/core\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New WordPress Support Platform Goes Live</h2>\n\n\n\n<p>WordPress user documentation has long been hosted on the <a href=\"https://codex.wordpress.org/\">WordPress Codex</a>, but for the past couple of years an ambitious project has been underway to move that content to a freshly-built WordPress-based platform. This project, named “HelpHub,” is now live and <a href=\"https://wordpress.org/support/\">the official home of WordPress Support</a>.<br /></p>\n\n\n\n<p>There is still plenty of content that needs to be migrated from the Codex to HelpHub, but the initial move is done and the platform is ready to have all WordPress’ user documentation moved across. HelpHub will be the first place for support, encouraging users to find solutions for themselves before posting in the <a href=\"https://wordpress.org/support/forums/\">forums</a>.<br /></p>\n\n\n\n<p>Want to get involved in populating HelpHub with content, or with its future development? Follow <a href=\"https://make.wordpress.org/docs/\">the Documentation team blog</a> and join the #docs channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Spanish WordPress Community Pushes Translations Forward</h2>\n\n\n\n<p>The WordPress community in Spain has been hard at work making sure as much of the WordPress project as possible is available in Spanish. <a href=\"https://es.wordpress.org/2018/11/07/logros-equipo-traducciones-wordpress-espana/\">They have recently translated more of the project than ever</a> — including WordPress Core, WordPress.org, the mobile apps and the top 120 plugins in the Directory.<br /></p>\n\n\n\n<p>This achievement has largely been possible due to the fact that <a href=\"https://make.wordpress.org/polyglots/teams/?locale=es_ES\">the Spanish translation team</a> has over 2,500 individuals contributing to it, making it the largest translation team across the whole project. <br /></p>\n\n\n\n<p>Want to get involved in translating WordPress into your local language? You can <a href=\"https://translate.wordpress.org/\">jump straight into translations</a>, follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>All volunteer teams have checked in with their <a href=\"https://wordpress.org/news/2018/11/quarterly-updates-q3-2018/\">latest quarterly updates</a>.</li><li>The WordPress Support Team <a href=\"https://make.wordpress.org/support/2018/11/new-volunteer-orientation-for-wp-support-contributors-dec-9/\">is hosting an orientation</a> for new Support volunteers on December 9.</li><li><a href=\"https://2018.us.wordcamp.org/tickets/\">Tickets are now available</a> to watch the WordCamp US livestream for free.</li><li>WordPress Core <a href=\"https://core.trac.wordpress.org/ticket/45287\">has switched to a WP-CLI command</a> for generating localization files.</li><li>WordPress Coding Standards v1.2.0 <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/1.2.0\">has been released</a> with some really useful improvements.</li><li>The first ever <a href=\"https://2019.nordic.wordcamp.org/\">WordCamp Nordic</a> is taking place on March 7-8, 2019 with ticket sales now open.</li><li>The WordCamp Incubator program is going very well this year — <a href=\"https://make.wordpress.org/community/2018/11/27/wordcamp-incubator-2018-update-thread-november-edition/\">you can see the latest updates here</a>.</li><li>The Mobile Team is looking for testers for the upcoming v11.3 release of the WordPress mobile apps on <a href=\"https://make.wordpress.org/mobile/2018/11/21/call-for-testing-wordpress-for-android-11-3/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/11/21/call-for-testing-wordpress-for-ios-11-3/\">iOS</a>.</li><li>The WordCamp Europe team is looking for local communities to <a href=\"https://2019.europe.wordcamp.org/2018/11/29/call-for-host-city/\">apply to be the host city</a> for the 2020 event.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Dec 2018 17:43:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: WordCamp Europe Opens the Call for Host City 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86110\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wptavern.com/wordcamp-europe-opens-the-call-for-host-city-2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2379:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/11/wordcamp-eurpoe-2019.png?ssl=1\"><img /></a></p>\n<p>WordCamp Europe has opened the <a href=\"https://2019.europe.wordcamp.org/2018/11/29/call-for-host-city/\" rel=\"noopener\" target=\"_blank\">call for a host city for 2020</a>. Previous editions of the event have been held in Leiden, Sofia, Seville, Vienna, Paris, and Belgrade, and the next on deck is Berlin in 2019. Organizers are always working ahead for an event this size. In fact, the team plans together for the better part of a year before attendees arrive for the three-day event. The upcoming WCEU is currently being planned by a team of 66 organizers from 15 countries. </p>\n<p>Teams applying to host WordCamp Europe are required to have organized at least one or more successful WordCamps in a European city, with at least one recent one held in 2017 or 2018. The core organizing team will work with all applicants in the open to help them prepare the best applications possible, as detailed in the announcement:  </p>\n<blockquote><p>To guarantee total transparency during the process, all applicants receive the same help in the appropriate public channel of the WCEU Slack workspace. No question is considered or answered in a private message.</p></blockquote>\n<p>Three weekends in June 2020 are available to applicants as potential dates. Teams interested to apply are encouraged to begin filling out the <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSfPd5InsSfaGXA1zRu_PJ435AGXXPlUYMuCqCBkEOKRNSrd7w/viewform\" rel=\"noopener\" target=\"_blank\">7-page survey</a> (which can be started and completed as information becomes available). It includes questions about the local community, previous WordCamps, possible venue(s), cost of living in the city, and other data that will be important to the selection committee. </p>\n<p>A preliminary online AMA session will be held December 13, 2018, to assist teams in answering questions about the application process. The deadline to apply to host the event is February 28, 2019. Applicants will receive a decision by March 15, 2019, and the final selection will be announced during the closing remarks in Berlin next June. Check out the call for host cities <a href=\"https://2019.europe.wordcamp.org/2018/11/29/call-for-host-city/\" rel=\"noopener\" target=\"_blank\">announcement</a> for more information.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Dec 2018 16:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Mullenweg Ramps Up Communication Ahead of WordPress 5.0 Release, RC2 Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/mullenweg-ramps-up-communication-ahead-of-wordpress-5-0-release-rc2-now-available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5209:\"<p><a href=\"https://wordpress.org/news/2018/11/wordpress-5-0-rc2/\" rel=\"noopener\" target=\"_blank\">WordPress 5.0 RC2</a> was released today with 15 notable updates, including improvements to block preview styling, browser-specific bug fixes, and other changes. RC2 was released simultaneously with <a href=\"https://make.wordpress.org/core/2018/11/30/whats-new-in-gutenberg-30th-november/\" rel=\"noopener\" target=\"_blank\">Gutenberg version 4.6</a>. </p>\n<p>The official release date for WordPress 5.0 has not yet been announced, because it depends on feedback from RC2 testing. Contributors&#8217; uneasiness with not having an official release date seemed to reach a critical tipping point during this week&#8217;s WordPress dev chat, as many participants pressured Matt Mullenweg, who is leading the release, to give more information on when they can expect 5.0. </p>\n<p>&#8220;It is very important that we have a release date to aim for,&#8221; ACF founder Elliot Condon said. &#8220;I’m finding the current &#8216;waiting game&#8217; quite stressful, and I suspect a few other developers will share the same feeling.&#8221;</p>\n<p>Tensions were high as contributors cited various reasons for wanting a date, including companies needing support staff on hand, upcoming holidays, documentation planning, and the importance of user trust.</p>\n<p>&#8220;We&#8217;re determining the release date based on the open issues,&#8221; Mullenweg said. &#8220;Please consider it as coming as soon as possible, when everything is resolved.&#8221;</p>\n<p>&#8220;I hope it&#8217;s clear we&#8217;re trying to get this out as soon as possible, but don&#8217;t yet have enough data to announce an official date. As mentioned last week we have done a number of December releases in the past, and may this time, but don&#8217;t have enough data to announce a new date yet.&#8221;</p>\n<p>Mullenweg also urged dev chat attendees to keep in mind that any site administrators can install the Classic Editor plugin to keep the current editing experience, regardless of the 5.0 release date. He said the date will be announced via a P2 post, not during a dev chat.</p>\n<p>&#8220;If you want to know what to plan on, please don&#8217;t hold anything back based on expected dates, please test or deploy the RCs, that&#8217;s what they&#8217;re for,&#8221; Mullenweg said. </p>\n<p>In the meantime, Mullenweg is spending the weekend taking questions from the community during <a href=\"https://make.wordpress.org/core/2018/11/29/gutenberg-5-0-listening-office-hours/\" rel=\"noopener\" target=\"_blank\">24 office hours slots</a>. He also published a lengthy post titled &#8220;<a href=\"https://ma.tt/2018/11/a-gutenberg-faq/\" rel=\"noopener\" target=\"_blank\">WordPress 5.0: A Gutenberg FAQ</a>,&#8221; which reaffirms WordPress&#8217; mission in the context of Gutenberg. It answers questions like &#8220;Why do we need Gutenberg at all?&#8221; and &#8220;Why blocks?&#8221;</p>\n<p>&#8220;I knew we would be taking a big leap,&#8221; Mullenweg said. &#8220;But it’s a leap we need to take, and I think the end result is going to open up many new opportunities for everyone in the ecosystem, and for those being introduced to WordPress for the first time. It brings us closer to our mission of democratizing publishing for everyone.&#8221;</p>\n<p>The stats Mullenweg cited about previously having 9 major WordPress releases in December (34{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of all releases in the last decade) indicate that a December release may still be on the table. His post addresses the perceived urgency behind getting Gutenberg out the door and into the hands of users. In evaluating WordPress 5.0&#8217;s readiness, he said it&#8217;s important to differentiate between the code being ready and the community being ready.</p>\n<p>&#8220;In the recent debate over Gutenberg readiness, I think it’s important to understand the difference between Gutenberg being ready code-wise (it is now), and whether the entire community is ready for Gutenberg,&#8221; Mullenweg said.</p>\n<p>&#8220;It will take some time — we’ve had 15 years to polish and perfect core, after all — but the global WordPress community has some of the world’s most talented contributors and we can make it as good as we want to make it.&#8221;</p>\n<p>The post also offers a preview of where Gutenberg is going in the next site customization phase and how it will change the way users build their sites.</p>\n<p>&#8220;The Editor is just the start,&#8221; he said. &#8220;In upcoming phases blocks will become a fundamental part of entire site templates and designs. It’s currently a struggle to use the Customizer and figure out how to edit sections like menus, headers, and footers. With blocks, people will be able to edit and manipulate everything on their site without having to understand where WordPress hides everything behind the scenes.&#8221;</p>\n<p>Mullenweg said he plans to talk more about the next phases following site customization during the State of the Word address at WordCamp US. If you have questions about Gutenberg and where it&#8217;s headed, the comments are open on his <a href=\"https://ma.tt/2018/11/a-gutenberg-faq/\" rel=\"noopener\" target=\"_blank\">post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Dec 2018 03:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Let Us Know If You’re Hosting a WordCamp US Watch Party\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86150\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wptavern.com/let-us-know-if-youre-hosting-a-wordcamp-us-watch-party\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:505:\"<p>WordCamp US is next weekend and if you&#8217;re unable to attend, you can watch from home via the <a href=\"https://wptavern.com/wordcamp-us-2018-livestream-tickets-now-available\">free livestream</a>. However, some WordPress meetup groups host watch parties. These parties generally include food, beverages, and a large projection screen. </p>\n\n\n\n<p>If you&#8217;re hosting one of these parties, please let us know about it in the comments. Tell us the location and what attendees can expect. <br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Dec 2018 01:11:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Dev Blog: WordPress 5.0 RC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6287\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2018/11/wordpress-5-0-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3298:\"<p>The second release candidate for WordPress 5.0 is now available!</p>\n\n\n\n<p>This is an important milestone, as we near the release of WordPress 5.0. A final release date will be announced soon, based on feedback from this release candidate. Things are appearing very stable and we hope to announce a date soon. This is a big release and needs <em>your</em> help—if you haven’t tried 5.0 yet, now is the time! </p>\n\n\n\n<p>To test WordPress 5.0, you can use the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-RC2.zip\">download the release candidate here</a>&nbsp;(zip).</p>\n\n\n\n<p>For details about what to expect in WordPress 5.0, please see the <a href=\"https://wordpress.org/news/2018/11/wordpress-5-0-release-candidate/\">previous release candidate post</a>.</p>\n\n\n\n<h2>Significant changes</h2>\n\n\n\n<ul><li>We stopped rendering&nbsp;<em>AdminNotices</em>&nbsp;compatibility component, as this previous attempt at backward compatibility was bringing in numerous incompatible banners and notices from plugins.</li><li>An update to the parser to better deal with malformed HTML that could cause a loop. We&#8217;re only aware of this in the wild being triggered once in the <a href=\"https://gutenstats.blog/\">over a million posts</a> made with Gutenberg, but it caused a loop so we wanted to fix for RC2.</li></ul>\n\n\n\n<h2>Cosmetic and minor changes in RC2</h2>\n\n\n\n<ul><li>Accessibility: Simplify sidebar tabs&nbsp;aria-labels.</li><li>Make the&nbsp;Image&nbsp;Link URL field readonly.</li><li>Internationalization: Merge&nbsp;similar text strings that differed only in capitalization.</li><li>CSS: Improve block preview&nbsp;styling.</li><li>CSS: Fix&nbsp;visual issues&nbsp;with&nbsp;Button&nbsp;block text wrap.</li><li>Fix&nbsp;getSelectedBlockClientId selector.</li><li>Fix&nbsp;Classic&nbsp;block&nbsp;not showing galleries on a grid.</li><li>Fix an issue where the block toolbar&nbsp;would cause an image to jump&nbsp;downwards when the&nbsp;<em>wide</em>&nbsp;or&nbsp;<em>full</em>&nbsp;alignments were activated.</li><li>Move editor specific styles&nbsp;from style.scss to editor.scss in&nbsp;Cover&nbsp;block.</li><li>Fix modals&nbsp;in Microsoft Edge browser.</li><li>Fix Microsoft IE11 focus loss&nbsp;after TinyMCE init.&nbsp;Add&nbsp;IE check.</li><li>Fix Microsoft IE11 input when mounting TinyMCE.</li><li>Change @package names&nbsp;to WordPress.</li></ul>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;</p>\n\n\n\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<pre class=\"wp-block-verse\"><em>RC bittersweet.<br />We welcome in Gutenberg,<br />Vale Gutenbeard.</em></pre>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Nov 2018 23:16:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Gutenberg Times to Host Live Q&amp;A with Gutenberg Leads on Friday, November 30\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85908\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/gutenberg-times-to-host-live-qa-with-gutenberg-leads-on-friday-november-30\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1224:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/11/creating-gutenberg-q-and-a.jpg?ssl=1\"><img /></a></p>\n<p>Birgit Pauli-Haack, curator of the <a href=\"https://gutenbergtimes.com/\" rel=\"noopener\" target=\"_blank\">Gutenberg Times</a> website, is hosting a Q&#038;A session with Gutenberg&#8217;s phase 1 design and development leads on Friday, November 30, at 2pm ET (19:00 UTC). Matias Ventura, Tammie Lister, and Joen Asmussen will join Pauli-Haack to discuss their journey &#8220;Creating Gutenberg&#8221; over the past two years.</p>\n<p>If you have any pressing questions about Gutenberg&#8217;s architecture, design, or the future of the project, this event is a good opportunity to speak to members of the team who have been building it full-time. The Q&#038;A is free to watch but attendees who want to participate with questions will need to <a href=\"https://zoom.us/webinar/register/6915430666443/WN_d_ejr1e0T0Se1YpyoU0Ojg\" rel=\"noopener\" target=\"_blank\">register</a>. There are 100 seats available. Pauli-Haack will also be live-streaming the session to the <a href=\"https://www.youtube.com/channel/UCSD3LG2kSHdr7llRSHaylxw\" rel=\"noopener\" target=\"_blank\">Gutenberg Times YouTube channel</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Nov 2018 00:48:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: WordPress 5.0: A Gutenberg FAQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2018/11/a-gutenberg-faq/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18327:\"<p><em>Update: </em><a href=\"https://wordpress.org/news/2018/12/bebo/\"><em>On December 6th we released WordPress 5.0</em></a><em>. It was definitely the most controversial release in a while, but the usage and adoption metrics are looking similar to previous releases. I&#8217;m looking forward to continuing to iterate on the new block editor!</em></p>\n\n\n\n<p>We are nearing the release date for WordPress 5.0 and Gutenberg, one of the most important and exciting projects I’ve worked on in my <a href=\"https://ma.tt/2018/05/wordpress-at-15/\">15 years</a> with this community. <br /></p>\n\n\n\n<p>I knew we would be taking a big leap. But it’s a leap we need to take, and I think the end result is going to open up many new opportunities for everyone in the ecosystem, and for those being introduced to WordPress for the first time. It brings us closer to our mission of democratizing publishing for everyone.<br /></p>\n\n\n\n<p>I recently visited WordCamp Portland to talk about Gutenberg and WordPress 5.0, which will also include the new default theme <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">Twenty Nineteen</a>, which you’re seeing me test out on this very site. There were some great questions and testimonials about Gutenberg, so I’d urge you to watch the <a href=\"https://wordpress.tv/2018/11/08/matt-mullenweg-qa-at-wordcamp-portland-2018/\">full video</a> and <a href=\"https://wptavern.com/matt-mullenweg-addresses-controversies-surrounding-gutenberg-at-wordcamp-portland-qa\">read the WP Tavern recap</a>. I&#8217;ve also visited meetups, responded to review threads, kept an eye on support, and I&#8217;m in the middle of <a href=\"https://make.wordpress.org/core/2018/11/29/gutenberg-5-0-listening-office-hours/\">office hours with the core community</a>.<br /></p>\n\n\n\n<p>As we head toward the release date and <a href=\"https://2018.us.wordcamp.org/\">WordCamp US</a>, I&#8217;ve put many questions and answers into a Gutenberg FAQ below. For those who have other questions, I will be checking the comments here. <br /></p>\n\n\n\n<p>It’s an exciting time, and I’m thrilled to be working with y’all on this project. </p>\n\n\n\n<img />Not the ship of Theseus\n\n\n\n<h2>What is Gutenberg? </h2>\n\n\n\n<p>Gutenberg, for those who aren&#8217;t actively following along, is a brand new Editor for WordPress &#8212; contributors have been working on it since January 2017 and it&#8217;s one of the most significant changes to WordPress in years. It&#8217;s built on the idea of using &#8220;blocks&#8221; to write and design posts and pages. <br /></p>\n\n\n\n<p>This will serve as the foundation for future improvements to WordPress, including blocks as a way not just to design posts and pages, but also entire sites. <br /></p>\n\n\n\n<p>The overall goal is to simplify the first-time user experience of WordPress &#8212; for those who are writing, editing, publishing, and designing web pages. The editing experience is intended to give users a better visual representation of what their post or page will look like when they hit publish. As I wrote in <a href=\"https://ma.tt/2017/08/we-called-it-gutenberg-for-a-reason/\">my post last year</a>, &#8220;Users will finally be able to build the sites they see in their imaginations.&#8221; <br /></p>\n\n\n\n<p>Matías Ventura, team lead for Gutenberg, <a href=\"https://matiasventura.com/post/gutenberg-or-the-ship-of-theseus/\">wrote an excellent post</a> about the vision for Gutenberg, saying, “It’s an attempt to improve how users interact with their content in a fundamentally visual way, while at the same time giving developers the tools to create more fulfilling experiences for the people they are helping.”</p>\n\n\n\n<h2>Why do we need Gutenberg at all? </h2>\n\n\n\n<p>For many of us already in the WordPress community, it can be easy to forget the learning curve that exists for people being introduced to WordPress for the first time. Customizing themes, adding shortcodes, editing widgets and menus &#8212; there’s an entire language that one must learn behind the scenes in order to make a site or a post look like you want it to look. <br /></p>\n\n\n\n<p>Over the past several years, JavaScript-based applications have created opportunities to simplify the user experience in consumer apps and software. Users’ expectations have changed, and the bar has been raised for simplicity. It is my deep belief that WordPress must evolve to improve and simplify its own user experience for first-time users. <br /></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">What can you do in 137 lines in <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">#Gutenberg</a>? <a href=\"https://t.co/zLINZGMXMe\">pic.twitter.com/zLINZGMXMe</a></p>&mdash; Dennis Snell (@dmsnell23) <a href=\"https://twitter.com/dmsnell23/status/1063126946350096389?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">November 15, 2018</a></blockquote>\n</div>\n\n\n\n<h2>Why blocks? </h2>\n\n\n\n<p>The idea with blocks was to create a new common language across WordPress, a new way to connect users to plugins, and replace a number of older content types &#8212; things like shortcodes and widgets &#8212; that one had to be well-versed in the idiosyncrasies of WordPress to understand. <br /></p>\n\n\n\n<p>The block paradigm is not a new one &#8212; in fact many great plugins have already shown the promise of blocks with page design in WordPress. Elementor, one of the pioneers in this space, has now introduced <a href=\"https://elementor.com/blog/blocks-for-gutenberg/\">a new collection of Gutenberg blocks</a> to showcase what’s possible: <br /></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h2>Why change the Editor? </h2>\n\n\n\n<p>The Editor is where most of the action happens in WordPress’s daily use, and it was a place where we could polish and perfect the block experience in a contained environment. <br /></p>\n\n\n\n<p>Additionally, the classic Editor was built primarily for text &#8212; articles have become increasingly multimedia, with social media embeds, maps, contact forms, photo collages, videos, and GIFs. It was time for a design paradigm that allowed us to move past the messy patchwork of shortcodes and text. <br /></p>\n\n\n\n<p>The Editor is just the start. In upcoming phases blocks will become a fundamental part of entire site templates and designs. It’s currently a struggle to use the Customizer and figure out how to edit sections like menus, headers, and footers. With blocks, people will be able to edit and manipulate everything on their site without having to understand where WordPress hides everything behind the scenes. <br /></p>\n\n\n\n<h2>What does Automattic get out of this? </h2>\n\n\n\n<p>There have been posts recently asking questions about Automattic’s involvement in Gutenberg compared to other contributors and companies. There is no secret conspiracy here &#8212; as project lead I was able to enlist the help of dozens of my colleagues to contribute to this project, and I knew that a project of this size would require it. Automattic aims to have 5{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of its people dedicated to WordPress community projects, which at its current size would be about 42 people full-time. The company is a bit behind that now (~35 full-time), and the company is growing a lot next year, so look for 10-15 additional people working on core and community projects.&nbsp;<br /></p>\n\n\n\n<p>In the end, Gutenberg is similar to many other open source projects &#8212; Automattic will benefit from it, but so will everyone else in the WordPress community (and even <a href=\"https://drupalgutenberg.org/\">the Drupal community</a>). It’s available for everyone under the GPL. If the goal was purely to benefit Automattic it would have been faster, easier, and created an advantage for Automattic to have Gutenberg just on WP.com. That wasn&#8217;t, and isn&#8217;t, the point.</p>\n\n\n\n<h2>Is Gutenberg ready? </h2>\n\n\n\n<p>Absolutely. Our original goal with Gutenberg was to get it on 100,000 sites to begin testing &#8212; it’s now already on <a href=\"https://gutenstats.blog/\">more than 1 million sites</a>, and it’s the fastest-growing plugin in WordPress history. There is a lot of user demand.<br /></p>\n\n\n\n<p>The goal was to both test Gutenberg on as many sites as possible before the 5.0 release, and also to encourage plugin developers to make sure their plugins and services will be ready. With everyone pitching in, we can make this the most <em>anti-climactic</em> release in WordPress history. &nbsp;<br /></p>\n\n\n\n<p>In the recent debate over Gutenberg readiness, I think it&#8217;s important to understand the difference between Gutenberg being ready code-wise (it is now), and whether the entire community is ready for Gutenberg.<br /></p>\n\n\n\n<p>It will take some time &#8212; we&#8217;ve had 15 years to polish and perfect core, after all &#8212; but the global WordPress community has some of the world&#8217;s most talented contributors and we can make it as good as we want to make it. <br /></p>\n\n\n\n<p>There is also a new opportunity to dramatically expand the WordPress contributor community to include more designers and JavaScript engineers. With JavaScript apps there are also new opportunities for designing documentation and support right on the page, so that help arrives right where you need it. <br /></p>\n\n\n\n<p>Someone described Gutenberg to me as “WordPress in 3D.” I like the sound of that. Blocks are like layers you can zoom in and out of. The question now is: What are we going to build with this new dimension? </p>\n\n\n\n<h2>Do I have to switch to Gutenberg when WordPress 5.0 is released? </h2>\n\n\n\n<p>Not at all. When it’s released, you get to choose what happens. You can install the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor plugin</a> today and when 5.0 is released, nothing will change. We&#8217;ve commited to supporting and updating Classic Editor until 2022. If you’d like to <a href=\"https://wordpress.org/plugins/gutenberg/\">install Gutenberg early</a>, you can do that now too. The Classic Editor plugin has been available for 13 months now, and Gutenberg has been available for 18 months. Both have been heavily promoted since August 2018, and more than 1.3 million .org sites have opted-in already to either experience, so nothing will change for them when they update to 5.0.</p>\n\n\n\n<h2>How can I make sure I’m ready? </h2>\n\n\n\n<p>Before updating to 5.0, try out the <a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg plugin</a> with your site to ensure it works with your existing plugins, and also to get comfortable with the new experience. Developers across the entire ecosystem are working hard to update their plugins, but your mileage and plugins may vary. And you can always use the Classic Editor to address any gaps.<br /></p>\n\n\n\n<p>As with every new thing, things might feel strange and new for a bit, but I’m confident once you start using it you’ll get comfy quickly and you won’t want to go back.</p>\n\n\n\n<p>The release candidate of 5.0 is stable and fine to develop against and test.</p>\n\n\n\n<h2>When will 5.0 be released?</h2>\n\n\n\n<p>We have had a stable RC1, which stands for first release candidate, and about to do our second one. There is only currently one known blocker and it&#8217;s cosmetic. The stability and open issues in the release candidates thus far makes me optimistic we can release soon, but as before the primary driver will be the stability and quality of the underlying software. We made the mistake prior of announcing dates when lots of code was still changing, and had to delay because of regressions and bugs. Now that things aren&#8217;t changing, we&#8217;re approaching a time we can commit to a date soon.</p>\n\n\n\n<h2>Is it terrible to do a release in December?</h2>\n\n\n\n<p>Some people think so, some don&#8217;t. There have been <a href=\"https://wordpress.org/about/roadmap/\">9 major WordPress releases</a> in previous Decembers. December releases actually comprise 34{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} of our major releases in the past decade.</p>\n\n\n\n<h2>Can I set it up so only certain users get to use Gutenberg? </h2>\n\n\n\n<p>Yes, and soon. We’re going to be doing another update to the Classic Editor before the 5.0 release to give it a bit more fine-grained user control &#8212; we’ve heard requests for options that allow certain users or certain roles and post types to have Gutenberg while others have Classic Editor. </p>\n\n\n\n<h2>What happens after 5.0? </h2>\n\n\n\n<p>We’ve been doing a release of Gutenberg every two weeks, and 5.0 isn’t going to stop that. We’ll do minor release to 5.0 (5.0.1, 5.0.2) fortnightly, with occasional breaks, so if there’s feedback that comes in, we can address it quickly. Many of the previous bugs in updates were from juggling between updates in the plugin and core, now that Gutenberg is in core it&#8217;s much easier and safer to incrementally update.</p>\n\n\n\n<h2>What about Gutenberg and accessibility? </h2>\n\n\n\n<p>We’ve had some important discussions about accessibility over the past few weeks and I am grateful for those who have helped raise these questions in the community. <br /></p>\n\n\n\n<p>Accessibility has been core to WordPress from the very beginning. It’s part of why we started – the adoption of web standards and accessibility.<br /></p>\n\n\n\n<p>But where I think we fell down was with project management &#8212; specifically, we had a team of volunteers that felt like they were disconnected from the rapid development that was happening with Gutenberg. We need to improve that. In the future I don’t know if it makes sense to have accessibility as a separate kind of process from the core development. It needs to be integrated at every single stage. <br /></p>\n\n\n\n<p>Still, we’ve accomplished a lot, as Matías <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\">has written about</a>. There have been more than 200 closed issues related to accessibility since the very beginning. <br /></p>\n\n\n\n<p>We’re also taking the opportunity to fix some things that have had poor accessibility in WordPress from the beginning. <a href=\"https://codemirror.net/6/\">CodeMirror</a>, which is a code editor for templates, is not accessible, so we have some parts of WordPress that we really need to work on to make better. <br /></p>\n\n\n\n<p>Speaking of which, CodeMirror was seeking funding for their next version &#8212; Automattic has now <a href=\"https://codemirror.net/6/\">sponsored that funding</a> and in return it will be made available under the GPL, and that the next version of CodeMirror will be fully accessible. <br /></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Great news ? Due to a substantial donation from <a href=\"https://twitter.com/automattic?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">@automattic</a> our crowdfunding goal has been reached, and CodeMirror 6 is definitely happening!</p>&mdash; CodeMirror (@codemirror) <a href=\"https://twitter.com/codemirror/status/1054759532990218242?ref_src=twsrc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}5Etfw\">October 23, 2018</a></blockquote>\n</div>\n\n\n\n<p>Finally, Automattic will be funding an accessibility study of WordPress, Gutenberg, and an evaluation of best practices across the web, to ensure WordPress is fully accessible and setting new standards for the web overall. </p>\n\n\n\n<h2>After WordPress 5.0, is the Gutenberg name going to stick around?</h2>\n\n\n\n<p>Sometimes code names can take on a life of their own. I think Gutenberg is still what we’ll call this project &#8212; it’s <a href=\"https://github.com/WordPress/gutenberg\">called that on GitHub</a>, and you’re also seeing it <a href=\"https://drupalgutenberg.org/\">adopted by other CMSes beyond WordPress</a> &#8212; but for those outside the community I can see it simply being known as “the new WordPress editor.” </p>\n\n\n\n<h2>With the adoption of React for Gutenberg, what do you see as the future for React and WordPress? </h2>\n\n\n\n<p>In 2015 I said <a href=\"https://wordpress.tv/2015/12/07/matt-mullenweg-state-of-the-word-2015/\">“Learn JavaScript deeply”</a> &#8212; then in 2016 we brought the <a href=\"https://developer.wordpress.org/rest-api/\">REST API</a> into Core. Gutenberg is the first major feature built entirely on the REST API, so if you are learning things today, learn JavaScript, and I can imagine a future wp-admin that’s 100{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} JavaScript talking to APIs. I’m excited to see that happen. <br /></p>\n\n\n\n<p>Now, switching to a pure JavaScript interface could break some backward compatibility, but a nice thing about Gutenberg is that it provides an avenue for all plugins to work through &#8212; it gives them a way to plug in to that. It can eliminate the need for what’s currently done in custom admin screens. &nbsp;<br /></p>\n\n\n\n<p>The other beautiful thing is that because Gutenberg essentially allows for translation into many different formats &#8212; it can publish to your web page, it can publish your RSS feed, AMP, it can publish blocks that can be translated into email for newsletters &#8212; there’s so much in the structured nature of Gutenberg and the semantic HTML that it creates and the grammar that’s used to parse it, can enable for other applications. <br /></p>\n\n\n\n<p>It becomes a little bit like a <em>lingua franca</em> that even crosses CMSes. There’s now these new cross-CMS Gutenberg blocks that will be possible. It’s not just WordPress anymore &#8212; it might be a JavaScript block that was written for Drupal that you install on your WordPress site. How would that have ever happened before? That’s why we took two years off &#8212; it’s why we’ve had everyone in the world working on this thing. It’s because we want it to be #WorthIt. <br /></p>\n\n\n\n<p>And WordPress 5.0 is just the starting line. We want to get it to that place where it’s not just better than what we have today, but a world-class, web-defining experience. It’s what we want to create and what everyone deserves. </p>\n\n\n\n<h2>Was this post published with Gutenberg?</h2>\n\n\n\n<p>Of course. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f604.png\" alt=\"😄\" class=\"wp-smiley\" /> No bugs, but I do see lots of areas we can continue to improve and I&#8217;m excited to get to work on future iterations.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Nov 2018 23:56:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: WPCampus Seeks to Raise $30K for Gutenberg Accessibility Audit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=86032\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/wpcampus-seeks-to-raise-30k-for-gutenberg-accessibility-audit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4364:\"<p>WPCampus is <a href=\"https://wpcampus.org/2018/11/fundraising-for-wpcampus-gutenberg-accessibility-audit/\" rel=\"noopener\" target=\"_blank\">seeking funding</a> to conduct an accessibility audit of WordPress&#8217; Gutenberg editor. The non-profit organization is dedicated to helping web professionals, educators, and others who work with WordPress in higher education. Educational institutions often have stricter legal obligations that require software to be WCAG 2.0 level AA compliant and many European institutions set the bar even higher at WCAG 2.1.</p>\n<p><a href=\"https://wptavern.com/wpcampus-is-pursuing-an-independent-accessibility-audit-of-gutenberg\" rel=\"noopener\" target=\"_blank\">WPCampus moved to spearhead an audit</a> after Automattic decided to forego Matt MacPherson&#8217;s <a href=\"https://wptavern.com/gutenberg-accessibility-audit-postponed-indefinitely\" rel=\"noopener\" target=\"_blank\">proposal</a> for Gutenberg to undergo an accessibility audit. Results of the audit will help WPCampus determine any potential legal risk for institutions upgrading to WordPress 5.0 and will also identify specific challenges that Gutenberg introduces for assistive technology users and others with accessibility needs.</p>\n<p>&#8220;A professional accessibility audit is a large expense for a small nonprofit like WPCampus,&#8221; WPCampus director Rachel Cherry said. &#8220;Accessibility is important to all of us in the WordPress community. We’re asking for your help to fund the audit and ensure this important research is completed.&#8221;</p>\n<p>WPCampus is still evaluating proposals from vendors and will announce its selection soon, along with an updated timeline for completing the audit. The organization has set its funding goal at $30,000, an amount that falls in the mid-range of the proposals the selection committee has received. If the campaign raises more than the amount required, WPCampus plans to designate the funds for other accessibility-related efforts, such as future audits and live captioning at conferences.</p>\n<p>Two days after launching the campaign, WPCampus has received $3,692 (12{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}) towards its funding goal. The organization plans to share the results of the audit and any supporting documents on its website.</p>\n<p>The comments published on the donations page demonstrate how strongly supporters feel about getting an audit and using that information to make Gutenberg a tool that anyone can use. The topic of accessibility is close to the heart for many donating to the campaign.</p>\n<p>&#8220;When I was navigating stores with three small children, stores which helped me with automatic doors, wide aisles, and shopping carts for a crowd often made the decision for me as to whether I could shop at all,&#8221; WordPress developer <a href=\"https://robincornett.com/\" rel=\"noopener\" target=\"_blank\">Robin Cornett</a> said. &#8220;As we create content and build tools for the internet, we should be doing all we can to ensure the best online experience we can for everyone.&#8221;</p>\n<p>WordPress co-founder <a href=\"https://mikelittle.org/\" rel=\"noopener\" target=\"_blank\">Mike Little</a> also donated to the campaign, with comments on how important accessibility is to fulfilling the project&#8217;s mission.</p>\n<p>&#8220;As the platform that democratizes publishing, we can&#8217;t allow new features in WordPress to take that away from users with accessibility needs,&#8221; Little said.</p>\n<p>&#8220;Accessibility matters to everyone — injured, encumbered, distracted, disabled, everyone,&#8221; WordPress consultant <a href=\"http://adrianroselli.com\" rel=\"noopener\" target=\"_blank\">Adrian Roselli</a> said. Accessibility in WordPress matters to my clients because some of their people require it in order to use the tool and therefore stay gainfully employed.&#8221;</p>\n<p>The audit proposed months ago has evolved to become a community effort funded by passionate supporters working in various capacities throughout the WordPress ecosystem. If WPCampus is successful in funding its campaign, this particular approach has the benefit of making it a more cooperative effort with more people invested in the process than if it were funded by a single company. WPCampus aims to release the audit report to the community by January 17, 2019 but the dates will depend on the arrangement with the vendor. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Nov 2018 22:03:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Drupal 8.7 to Introduce Layout Builder, Contributors Face Accessibility Challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/drupal-8-7-to-introduce-layout-builder-contributors-face-accessibility-challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6649:\"<p>WordPress 5.0 will soon replace the editor with the new Gutenberg editor as part of a multi-phase project to improve the experience of authoring rich content. Phase 2 will shift focus to tackle site customization, bringing more complex layout and page builder capabilities to Gutenberg.</p>\n<p>As this phase kicks off soon, it&#8217;s valuable to see what other platforms are doing on this front. Drupal has traditionally appealed to a more technical audience, and probably wouldn&#8217;t count Squarespace, Wix, and Tumblr among their competitors, but the project is getting more friendly towards site builders and content editors. Drupal has brought improvements to its usability, media, and layout experiences over the past few years in support of users who have demanded a more modern, simplified admin UI. The project is currently testing a visual design tool for building layouts.</p>\n<p>Two weeks ago, Drupal founder and project lead Dries Buytaert <a href=\"https://dri.es/why-drupal-layout-builder-is-so-unique-and-powerful\" rel=\"noopener noreferrer\" target=\"_blank\">previewed the new Layout Builder</a>, an experimental feature that is stabilizing and expected to land in Drupal 8.7 in May 2019. Layout Builder offers layouts for templated content, customizations to templated layouts, and custom pages. These uses are especially important when building sites with large amounts of content that occasionally require template overrides and one-off landing pages.</p>\n<p>Buytaert described how Layout Builder approaches the creation of one-off dynamic pages, which he said is similar to the capabilities found in services such as Squarespace and projects like Gutenberg for WordPress and Drupal: </p>\n<blockquote><p>A content author can start with a blank page, design a layout, and start adding blocks. These blocks can contain videos, maps, text, a hero image, or custom-built widgets (e.g. a Drupal View showing a list of the ten most popular gift baskets). Blocks can expose configuration options to the content author. For instance, a hero block with an image and text may offer a setting to align the text left, right, or center. These settings can be configured directly from a sidebar.</p></blockquote>\n<p>Buytaert&#8217;s demo video shows the Layout Builder in action. Its capabilities are similar to many of WordPress&#8217; third-party page builders, such as <a href=\"https://elementor.com/theme-builder/\" rel=\"noopener noreferrer\" target=\"_blank\">Elementor</a> and <a href=\"https://www.wpbeaverbuilder.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Beaver Builder</a>.</p>\n<p></p>\n<h3>Layout Builder Poses Accessibility Challenges</h3>\n<p>Layout Builder is anchored on one of Drupal&#8217;s stronger features &#8211; the ability to create structured content, but it faces some of the same accessibility challenges that WordPress&#8217; Gutenberg editor has encountered. </p>\n<p>In his post introducing Layout Builder, Buytaert made some pointed remarks about Drupal&#8217;s commitment to accessibility:</p>\n<blockquote><p>Accessibility is one of Drupal&#8217;s core tenets, and building software that everyone can use is part of our core values and principles. A key part of bringing Layout Builder functionality to a &#8220;stable&#8221; state for production use will be ensuring that it passes our accessibility gate (Level AA conformance with WCAG and ATAG). This holds for both the authoring tool itself, as well as the markup that it generates. We take our commitment to accessibility seriously.</p></blockquote>\n<p>Some contributors are not as optimistic about Drupal being able to fulfill these bold claims in time to ship the feature in 8.7.0. Andrew Macpherson, one of the accessibility topic maintainers for Drupal 8 core, has <a href=\"https://www.drupal.org/project/drupal/issues/3007978#comment-12853731\" rel=\"noopener\" target=\"_blank\">proposed Layout Builder offer an alternative UI</a> that users can access without the visual preview UI.</p>\n<p>&#8220;Dries&#8217; blog post about layout builder yesterday says we&#8217;re on track to mark this as stable for D8.7.0,&#8221; Macpherson said. &#8220;I&#8217;m not at all optimistic about that, because as yet there is no feasible plan for how it can be made accessible.</p>\n<p>&#8220;A minimum viable product for Layout Builder accessibility would be at least one method which works, for each user task, for each input/output method. I don&#8217;t think we can say we have found a feasible approach. We&#8217;re in deeply experimental territory here &#8211; there isn&#8217;t a well-established, reliable pattern we can just copy to make the current layout builder accessible. Essentially, we&#8217;re making stuff up in a hurry, for a novel UI, with limited opportunity for design validation. There&#8217;s no guarantee that users are going to understand it, or find it easy to use. That&#8217;s why I&#8217;m not optimistic about it getting past the accessibility gate in time for D8.7.0.&#8221;</p>\n<p>Macpherson said that WCAG strongly advises against providing alternate versions but allows for them in instances where the main version cannot be made accessible.</p>\n<p>&#8220;I think we are effectively in this situation now, although we are still exploring ideas,&#8221; he said. </p>\n<p>Macpherson also recommended they continue striving to make the drag-and-drop, visual-preview layout builder UI accessible at the same time. He referenced emerging <a href=\"https://inclusivedesignprinciples.org/#offer-choice\" rel=\"noopener\" target=\"_blank\">principles of Inclusive Design</a> for application developers, which recommend &#8220;offering choice,&#8221; giving users different ways of completing tasks, especially those that may be complex or non-standard.</p>\n<p>&#8220;Eventually, I&#8217;d like to see BOTH layout builder UIs being accessible, and offer genuinely useful choices for everyone,&#8221; Macpherson said. &#8220;But let&#8217;s take the time to do it well, instead of hastily bolting on fixes for one type of interaction method at a time, in a rush to ship a single layout builder UI. &#8221;</p>\n<p>Macpherson&#8217;s proposal is still under consideration, but it provides an interesting perspective on similar challenges WordPress contributors are facing with Gutenberg. Modernizing UIs to make the site building experience more accessible for those who don&#8217;t know how to code has to be balanced with considerations for those who may not be able see very well or use a mouse. Drupal contributors are exploring providing an alternative accessible UI as a solution to empower more users to take advantage of the new Layout Builder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Nov 2018 04:31:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WPTavern: WPWeekly Episode 339 – Interview With Pippin Williamson, Founder of Sandhills Development, LLC\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=86062&preview=true&preview_id=86062\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://wptavern.com/wpweekly-episode-339-interview-with-pippin-williamson-founder-of-sandhills-development-llc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1455:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"http://pippin.com/\">Pippin Williamson</a>, founder of <a href=\"http://sandhillsdev.com/\">Sandhills Development</a>, LLC. Pippin describes what he&#8217;s learned going through the process of opening a brick and mortar business.</p>\n<p>He also describes the emotional process of firing employees, making business decisions as a team, and how he wants to create a life-long company where employees stick around for decades.</p>\n<p>Near the end of the episode, Pippin expresses his opinions on Gutenberg the product and Gutenberg the process. You might be surprised by what he has to say.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://pippinsplugins.com/2017-in-review/\">2017 in review</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 5th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #339:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Nov 2018 19:54:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: SyntaxHighlighter Evolved Plugin Adds Gutenberg Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85968\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/syntaxhighlighter-evolved-plugin-adds-gutenberg-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4743:\"<p>WordPress 5.0 will ship with a code block in the new editor but it doesn&#8217;t include syntax highlighting. The code is currently wrapped in pre tags. During the earlier days of Gutenberg&#8217;s development, the HTML block had syntax highlighting but the team was not satisfied with its implementation and decided to pull it until they could <a href=\"https://github.com/WordPress/gutenberg/issues/10423\" rel=\"noopener\" target=\"_blank\">provide more consistent behavior across blocks</a>. </p>\n<p>For now, users will have to depend on a plugin to get syntax highlighting. <a href=\"https://wordpress.org/plugins/syntaxhighlighter/\" rel=\"noopener\" target=\"_blank\">SyntaxHighlighter Evolved</a> is one of the first plugins of its kind to add Gutenberg support via its own block. </p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/11/Screen-Shot-2018-11-28-at-10.08.36-AM.png?ssl=1\"><img /></a></p>\n<p>The plugin currently adds syntax highlighting to source code on the frontend only. Nevertheless, it&#8217;s a great use case for Gutenberg, as the plugin previously required you to remember how to structure the shortcode in a particular way in order to use it. </p>\n<p>Ian Dunn <a href=\"https://github.com/Viper007Bond/syntaxhighlighter/pull/78\" rel=\"noopener\" target=\"_blank\">contributed the Gutenberg support</a> for SyntaxHighlighter Evolved. In the PR for this feature, Dunn said he wanted to give existing users a way to continue using the plugin after WordPress 5.0 is released:</p>\n<blockquote><p>\nThe syntax highlighting only works on the front end, due to the nature of SyntaxHighlighter. Details are documented in the edit() function&#8217;s docblock.</p>\n<p>Because of that, this isn&#8217;t the ideal syntax highlighting block[1], but this provides a way for existing users to continue using the plugin without having to migrate old posts to a different plugin.</p>\n<p>Another limitation is that this PR only supports the language attribute of the shortcode, because I ran out of time/energy. This lays the groundwork, though, so the rest of them can easily be added in a future iteration.</p></blockquote>\n<p>SyntaxHighlighter Evolved is active on more than 40,000 installations and is also used on WordPress.com, so this update to the plugin should help those who rely on it to be able to use the new Gutenberg editor without having to switch back to the old editor when they need to add code to their content.</p>\n<p>There is still some debate about the best way to provide syntax highlighting in Gutenberg. Another implementation called <a href=\"https://github.com/mkaz/code-syntax-block\" rel=\"noopener\" target=\"_blank\">Code Syntax Block</a> by Marcus Kazmierczak, extends Gutenberg&#8217;s existing code block to offer syntax highlighting, instead of creating a new block for it. It also uses <a href=\"http://prismjs.com/\" rel=\"noopener\" target=\"_blank\">PrismJS syntax highlighter</a>.</p>\n<p><a href=\"https://github.com/cedaro/shiny-code\" rel=\"noopener\" target=\"_blank\">Shiny Code</a> is another approach that adds a new block for code and provides a preview inside the Gutenberg editor. </p>\n<p><a href=\"https://cloudup.com/cAjq1AKskL8\"><img src=\"https://i1.wp.com/cldup.com/2MLWW0oXx3.gif?resize=627{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}2C308&ssl=1\" alt=\"Shiny code\" width=\"627\" height=\"308\" /></a></p>\n<p>In the official plugin directory, the <a href=\"https://wordpress.org/plugins/enlighter/\" rel=\"noopener\" target=\"_blank\">Enlighter</a> plugin, which has 10,000 active installs, offers experimental support for Gutenberg that is being <a href=\"https://github.com/EnlighterJS/Plugin.Gutenberg\" rel=\"noopener\" target=\"_blank\">actively developed on GitHub</a>. <a href=\"https://wordpress.org/plugins/kebo-code/\" rel=\"noopener\" target=\"_blank\">Kebo Code</a>, a relatively new plugin with fewer than 10 installs, was created to offer syntax highlighting for Gutenberg and currently supports 121 languages and two themes. Users will have to switch to the frontend to see the code rendered with the theme selected. </p>\n<p>SyntaxHighlighter Evolved does not yet provide a way for highlighting existing code blocks or transforming a core code block to use the plugin&#8217;s syntax highlighting. Converting all existing code blocks might take some time for those who have been using it extensively. Alex Mills, the plugin&#8217;s author, said he is considering all of these issues and welcomes patches on the <a href=\"https://github.com/Viper007Bond/syntaxhighlighter\" rel=\"noopener\" target=\"_blank\">GitHub repository for the plugin</a>. Plugin authors may change their approaches over time, depending on where Gutenberg goes in the future, so users will want to evaluate available plugins periodically to see which ones suit their needs.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Nov 2018 17:10:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: WordCamp US 2018 Livestream Tickets Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85848\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wptavern.com/wordcamp-us-2018-livestream-tickets-now-available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1360:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/11/nashville.jpg?ssl=1\"><img /></a>photo credit: Viv Lynch <a href=\"http://www.flickr.com/photos/68894626@N00/30070498810\">Westward</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-nd/2.0/\">(license)</a></p>\n<p>The countdown has started for <a href=\"https://2018.us.wordcamp.org\" rel=\"noopener\" target=\"_blank\">WordCamp US 2018</a> in Nashville. The event is just 10 days away. If you cannot attend, watching via the livestream is the next best option. Anyone can join the livestream for free, but viewers will need to <a href=\"https://2018.us.wordcamp.org/tickets/\" rel=\"noopener\" target=\"_blank\">sign up for a ticket</a> on the event website. </p>\n<p>This year&#8217;s <a href=\"https://2018.us.wordcamp.org/schedule/\" rel=\"noopener\" target=\"_blank\">schedule</a> includes sessions in two tracks: Banjo and Guitar. Matt Mullenweg&#8217;s annual <a href=\"https://2018.us.wordcamp.org/2018/11/27/state-of-the-word-2018/\" rel=\"noopener\" target=\"_blank\">State of the Word</a> address is scheduled for Saturday, December 8, at 4:00 p.m. CST. Livestream ticket holders can tune in to any of the sessions and may also want to participate in the conversations on Twitter using the <a href=\"https://twitter.com/hashtag/WCUS?src=hash\" rel=\"noopener\" target=\"_blank\">#WCUS hashtag</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Nov 2018 22:09:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 08 Jan 2019 03:57:01 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 08 Jan 2019 03:45:29 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911163210\";}", "no");
INSERT INTO wptz_options VALUES("771", "photocrati_auto_update_admin_update_list", "", "yes");
INSERT INTO wptz_options VALUES("772", "photocrati_auto_update_admin_check_date", "", "yes");
INSERT INTO wptz_options VALUES("161", "current_theme", "Enfold", "yes");
INSERT INTO wptz_options VALUES("162", "theme_mods_enfold", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:4:\"avia\";i:14;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO wptz_options VALUES("163", "theme_switched", "", "yes");
INSERT INTO wptz_options VALUES("164", "widget_newsbox", "a:2:{i:2;a:4:{s:5:\"title\";s:11:\"Latest News\";s:5:\"count\";s:1:\"1\";s:7:\"excerpt\";s:15:\"show title only\";s:3:\"cat\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("165", "widget_portfoliobox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("166", "widget_avia_socialcount", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("167", "widget_avia_combo_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("168", "widget_avia_partner_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("169", "widget_avia_google_maps", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("170", "widget_avia_fb_likebox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("171", "widget_avia-instagram-feed", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("172", "widget_avia_mailchimp_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("173", "ls-plugin-version", "6.6.8", "yes");
INSERT INTO wptz_options VALUES("174", "ls-db-version", "6.5.5", "yes");
INSERT INTO wptz_options VALUES("175", "ls-installed", "1", "yes");
INSERT INTO wptz_options VALUES("176", "ls-google-fonts", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("177", "enfold_layerslider_state", "activated", "yes");
INSERT INTO wptz_options VALUES("178", "ls-date-installed", "1523562171", "yes");
INSERT INTO wptz_options VALUES("179", "enfold_layerslider_activated", "1", "yes");
INSERT INTO wptz_options VALUES("180", "enfold_layerslider_data_erased", "no", "yes");
INSERT INTO wptz_options VALUES("181", "ls-show-support-notice", "0", "yes");
INSERT INTO wptz_options VALUES("182", "enfold_initial_version", "4.2.6", "yes");
INSERT INTO wptz_options VALUES("183", "enfold_fixed_random", "4", "yes");
INSERT INTO wptz_options VALUES("184", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}", "yes");
INSERT INTO wptz_options VALUES("185", "shop_single_image_size", "a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}", "yes");
INSERT INTO wptz_options VALUES("186", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}", "yes");
INSERT INTO wptz_options VALUES("187", "avia_woocommerce_column_count", "3", "yes");
INSERT INTO wptz_options VALUES("188", "avia_woocommerce_product_count", "15", "yes");
INSERT INTO wptz_options VALUES("189", "woocommerce_single_image_crop", "no", "yes");
INSERT INTO wptz_options VALUES("190", "avia_permalink_settings", "a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}", "yes");
INSERT INTO wptz_options VALUES("191", "avia_options_enfold", "a:1:{s:4:\"avia\";a:167:{s:9:\"frontpage\";s:0:\"\";s:9:\"undefined\";s:16:\"lock_alb::{true}\";s:8:\"blogpage\";s:0:\"\";s:4:\"logo\";s:52:\"http://csroa.org/wp-content/uploads/2018/04/logo.png\";s:7:\"favicon\";s:0:\"\";s:9:\"preloader\";s:8:\"disabled\";s:21:\"preloader_transitions\";s:21:\"preloader_transitions\";s:14:\"preloader_logo\";s:0:\"\";s:15:\"lightbox_active\";s:15:\"lightbox_active\";s:16:\"color-body_style\";s:9:\"stretched\";s:17:\"color-frame_width\";s:2:\"20\";s:15:\"header_position\";s:26:\"header_left header_sidebar\";s:20:\"layout_align_content\";s:20:\"content_align_center\";s:18:\"sidebarmenu_sticky\";s:18:\"conditional_sticky\";s:19:\"sidebarmenu_widgets\";s:0:\"\";s:18:\"sidebarmenu_social\";s:18:\"sidebarmenu_social\";s:17:\"responsive_active\";s:17:\"responsive_active\";s:15:\"responsive_size\";s:6:\"1310px\";s:13:\"content_width\";s:2:\"73\";s:14:\"combined_width\";s:3:\"100\";s:12:\"color_scheme\";s:11:\"Blue-Yellow\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#efbb20\";s:31:\"colorset-header_color-secondary\";s:7:\"#444444\";s:27:\"colorset-header_color-color\";s:7:\"#333333\";s:26:\"colorset-header_color-meta\";s:7:\"#808080\";s:29:\"colorset-header_color-heading\";s:7:\"#000000\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#efbb20\";s:29:\"colorset-main_color-secondary\";s:7:\"#db9d00\";s:25:\"colorset-main_color-color\";s:7:\"#9c9c9c\";s:24:\"colorset-main_color-meta\";s:7:\"#919191\";s:27:\"colorset-main_color-heading\";s:7:\"#2c353d\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#2c353d\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#454e57\";s:32:\"colorset-alternate_color-primary\";s:7:\"#ffffff\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#efbb20\";s:30:\"colorset-alternate_color-color\";s:7:\"#ffffff\";s:29:\"colorset-alternate_color-meta\";s:7:\"#e1e1e1\";s:32:\"colorset-alternate_color-heading\";s:7:\"#ffffff\";s:31:\"colorset-alternate_color-border\";s:7:\"#5b646b\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:10:\"top center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#2c353d\";s:25:\"colorset-footer_color-bg2\";s:7:\"#454e57\";s:29:\"colorset-footer_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-footer_color-secondary\";s:7:\"#2139eb\";s:27:\"colorset-footer_color-color\";s:7:\"#ffffff\";s:26:\"colorset-footer_color-meta\";s:7:\"#e1e1e1\";s:29:\"colorset-footer_color-heading\";s:7:\"#ffffff\";s:28:\"colorset-footer_color-border\";s:7:\"#5b646b\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:10:\"top center\";s:28:\"colorset-footer_color-repeat\";s:6:\"repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#5b646b\";s:25:\"colorset-socket_color-bg2\";s:7:\"#454e57\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#efbb20\";s:27:\"colorset-socket_color-color\";s:7:\"#ffffff\";s:26:\"colorset-socket_color-meta\";s:7:\"#e1e1e1\";s:29:\"colorset-socket_color-heading\";s:7:\"#ffffff\";s:28:\"colorset-socket_color-border\";s:7:\"#5b646b\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:10:\"top center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:16:\"color-body_color\";s:7:\"#ffffff\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:8:\"top left\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:14:\"google_webfont\";s:11:\"Metrophobic\";s:12:\"default_font\";s:32:\"Helvetica-Neue,Helvetica-websave\";s:23:\"color-default_font_size\";s:0:\"\";s:9:\"quick_css\";s:0:\"\";s:12:\"menu_display\";s:0:\"\";s:24:\"header_mobile_activation\";s:17:\"mobile_menu_phone\";s:18:\"header_menu_border\";s:0:\"\";s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:18:\"submenu_visibility\";s:0:\"\";s:13:\"submenu_clone\";s:18:\"av-submenu-noclone\";s:11:\"burger_size\";s:0:\"\";s:13:\"overlay_style\";s:39:\"av-overlay-side av-overlay-side-classic\";s:12:\"burger_color\";s:0:\"\";s:19:\"burger_flyout_width\";s:5:\"350px\";s:13:\"header_layout\";s:36:\"logo_left main_nav_header menu_right\";s:11:\"header_size\";s:4:\"slim\";s:18:\"header_custom_size\";s:3:\"150\";s:12:\"header_style\";s:0:\"\";s:16:\"header_title_bar\";s:20:\"title_bar_breadcrumb\";s:13:\"header_sticky\";s:13:\"header_sticky\";s:16:\"header_shrinking\";s:16:\"header_shrinking\";s:18:\"header_unstick_top\";s:8:\"disabled\";s:14:\"header_stretch\";s:8:\"disabled\";s:13:\"header_social\";s:0:\"\";s:21:\"header_secondary_menu\";s:0:\"\";s:19:\"header_phone_active\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:23:\"header_replacement_logo\";s:0:\"\";s:23:\"header_replacement_menu\";s:0:\"\";s:14:\"archive_layout\";s:13:\"sidebar_right\";s:11:\"blog_layout\";s:13:\"sidebar_right\";s:13:\"single_layout\";s:13:\"sidebar_right\";s:11:\"page_layout\";s:13:\"sidebar_right\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:16:\"page_nesting_nav\";s:15:\"sidebar_styling\";s:0:\"\";s:22:\"display_widgets_socket\";s:3:\"all\";s:14:\"footer_columns\";s:1:\"4\";s:9:\"copyright\";s:95:\"&copy; Copyright California School Resource Officers Association.  All rights reserved.[nolink]\";s:13:\"footer_social\";s:8:\"disabled\";s:15:\"preview_disable\";s:8:\"disabled\";s:17:\"developer_options\";s:8:\"disabled\";s:8:\"lock_alb\";s:8:\"disabled\";s:19:\"lock_alb_for_admins\";s:8:\"disabled\";s:6:\"markup\";s:0:\"\";s:17:\"layerslider_activ\";s:0:\"\";s:17:\"blog_global_style\";s:0:\"\";s:10:\"blog_style\";s:12:\"single-small\";s:16:\"disable_post_nav\";s:8:\"disabled\";s:17:\"single_post_style\";s:10:\"single-big\";s:27:\"single_post_related_entries\";s:24:\"av-related-style-tooltip\";s:16:\"blog-meta-author\";s:16:\"blog-meta-author\";s:18:\"blog-meta-comments\";s:18:\"blog-meta-comments\";s:18:\"blog-meta-category\";s:18:\"blog-meta-category\";s:14:\"blog-meta-date\";s:14:\"blog-meta-date\";s:19:\"blog-meta-html-info\";s:19:\"blog-meta-html-info\";s:13:\"blog-meta-tag\";s:13:\"blog-meta-tag\";s:14:\"share_facebook\";s:14:\"share_facebook\";s:13:\"share_twitter\";s:13:\"share_twitter\";s:15:\"share_pinterest\";s:15:\"share_pinterest\";s:11:\"share_gplus\";s:11:\"share_gplus\";s:12:\"share_reddit\";s:12:\"share_reddit\";s:14:\"share_linkedin\";s:14:\"share_linkedin\";s:12:\"share_tumblr\";s:12:\"share_tumblr\";s:8:\"share_vk\";s:8:\"share_vk\";s:10:\"share_mail\";s:10:\"share_mail\";s:12:\"social_icons\";a:2:{i:0;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:0:\"\";}i:1;a:2:{s:11:\"social_icon\";s:8:\"dribbble\";s:16:\"social_icon_link\";s:0:\"\";}}s:13:\"mailchimp_api\";s:0:\"\";s:9:\"analytics\";s:0:\"\";s:8:\"gmap_api\";s:0:\"\";s:17:\"avia-nonce-import\";s:10:\"63c144ac93\";s:18:\"config_file_upload\";s:0:\"\";s:15:\"iconfont_upload\";s:0:\"\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";}}", "yes");
INSERT INTO wptz_options VALUES("197", "avia_rewrite_flush", "1", "yes");
INSERT INTO wptz_options VALUES("208", "shop_order_status_children", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("206", "portfolio_entries_children", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("207", "product_cat_children", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("209", "av_demo_content_imported", "1", "yes");
INSERT INTO wptz_options VALUES("220", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO wptz_options VALUES("222", "layerslider_update_info", "O:8:\"stdClass\":4:{s:5:\"basic\";O:8:\"stdClass\":10:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:94:\"home/csroa/public_html/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:7:\"version\";s:5:\"6.7.6\";s:5:\"icons\";a:3:{s:2:\"1x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png\";s:2:\"2x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";s:7:\"default\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";}s:7:\"banners\";a:3:{s:3:\"low\";s:84:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png\";s:4:\"high\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";s:7:\"default\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";}s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:3:\"5.0\";s:14:\"upgrade_notice\";s:62:\"This update contains new privacy settings for GDPR compliance.\";s:11:\"new_version\";s:5:\"6.7.6\";}s:4:\"full\";O:8:\"stdClass\":19:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:72:\"http://kreaturamedia.com/layerslider-responsive-wordpress-slider-plugin/\";s:7:\"version\";s:5:\"6.7.6\";s:12:\"last_updated\";s:10:\"2018-05-22\";s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:3:\"5.0\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:2806;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:62:\"This update contains new privacy settings for GDPR compliance.\";s:4:\"beta\";s:62:\"This update contains new privacy settings for GDPR compliance.\";s:4:\"edge\";s:62:\"This update contains new privacy settings for GDPR compliance.\";}s:6:\"author\";s:80:\"<a href=\"http://codecanyon.net/user/kreatura\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png\";s:2:\"2x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";s:7:\"default\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";}s:7:\"banners\";a:3:{s:3:\"low\";s:84:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png\";s:4:\"high\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";s:7:\"default\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:130:\"<p style=\"text-align: justify;\">\n	See the release log in the \'LayerSlider News\' section at the bottom of its main admin page.\n</p>\";s:12:\"installation\";s:456:\"<p style=\"text-align: justify;\">\n	Updating the plugin won\'t touch your sliders and settings and the new version always has backward compatibility,\n	so you don\'t have to worry about losing your work. Depending of the default settings, you may\n	have to adjust some options to get the new features. If you are experience unwanted behavior changes, it is always a\n	good idea to check your settings, there are probably new options to control these changes.\n</p>\";s:3:\"faq\";s:595:\"<p style=\"text-align: justify;\">\n	Before contacting us, please read our <a href=\"http://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/\" target=\"_blank\">online FAQs</a>, or check the built-in documentation in the contextual Help menu on the top-right corner of the page. Please note, these Help menus are contextual, they will show you different content on different pages.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you couldn\'t find an answer for your question, you can write us a comment at the Item\'s page on CodeCanyon, or send us an email from our CodeCanyon profile page.\n</p>\n\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:5:\"6.7.6\";s:7:\"checked\";i:1546919825;}", "yes");
INSERT INTO wptz_options VALUES("225", "recently_activated", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("231", "ls-latest-version", "6.7.6", "yes");
INSERT INTO wptz_options VALUES("773", "ngg_db_version", "1.8.1", "yes");
INSERT INTO wptz_options VALUES("776", "pope_module_list", "a:37:{i:0;s:19:\"photocrati-fs|3.0.0\";i:1;s:21:\"photocrati-i18n|3.0.0\";i:2;s:27:\"photocrati-validation|3.0.0\";i:3;s:23:\"photocrati-router|3.0.0\";i:4;s:34:\"photocrati-wordpress_routing|3.1.0\";i:5;s:25:\"photocrati-security|3.0.0\";i:6;s:35:\"photocrati-nextgen_settings|3.0.0.2\";i:7;s:20:\"photocrati-mvc|3.1.0\";i:8;s:21:\"photocrati-ajax|3.0.0\";i:9;s:27:\"photocrati-datamapper|3.0.0\";i:10;s:31:\"photocrati-nextgen-legacy|3.1.2\";i:11;s:32:\"photocrati-simple_html_dom|3.0.0\";i:12;s:29:\"photocrati-nextgen-data|3.1.0\";i:13;s:30:\"photocrati-nextgen_block|3.1.1\";i:14;s:35:\"photocrati-dynamic_thumbnails|3.0.0\";i:15;s:30:\"photocrati-nextgen_admin|3.1.0\";i:16;s:42:\"photocrati-nextgen_gallery_display|3.1.0.0\";i:17;s:36:\"photocrati-frame_communication|3.0.0\";i:18;s:31:\"photocrati-attach_to_post|3.1.4\";i:19;s:40:\"photocrati-nextgen_addgallery_page|3.0.0\";i:20;s:38:\"photocrati-nextgen_other_options|3.1.0\";i:21;s:37:\"photocrati-nextgen_pagination|3.0.0.2\";i:22;s:35:\"photocrati-dynamic_stylesheet|3.0.0\";i:23;s:36:\"photocrati-nextgen_pro_upgrade|3.0.0\";i:24;s:22:\"photocrati-cache|3.0.0\";i:25;s:25:\"photocrati-lightbox|3.0.0\";i:26;s:42:\"photocrati-nextgen_basic_templates|3.0.0.2\";i:27;s:39:\"photocrati-nextgen_basic_gallery|3.0.13\";i:28;s:45:\"photocrati-nextgen_basic_imagebrowser|3.0.0.4\";i:29;s:40:\"photocrati-nextgen_basic_singlepic|3.1.0\";i:30;s:41:\"photocrati-nextgen_basic_tagcloud|3.0.0.1\";i:31;s:38:\"photocrati-nextgen_basic_album|3.0.0.5\";i:32;s:23:\"photocrati-widget|3.0.0\";i:33;s:35:\"photocrati-third_party_compat|3.1.0\";i:34;s:31:\"photocrati-nextgen_xmlrpc|3.0.0\";i:35;s:22:\"photocrati-wpcli|3.0.0\";i:36;s:24:\"photocrati-imagify|3.1.0\";}", "yes");
INSERT INTO wptz_options VALUES("233", "duplicate_page_options", "a:3:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";}", "yes");
INSERT INTO wptz_options VALUES("246", "calendarjsupdated", "1", "no");
INSERT INTO wptz_options VALUES("247", "jswidgetupdated", "0", "no");
INSERT INTO wptz_options VALUES("248", "ai1ec_force_flush_rewrite_rules", "", "yes");
INSERT INTO wptz_options VALUES("259", "ai1ec_admin", "a:4:{s:9:\"_messages\";a:0:{}s:3:\"all\";a:0:{}s:21:\"network_admin_notices\";a:0:{}s:13:\"admin_notices\";a:0:{}}", "no");
INSERT INTO wptz_options VALUES("250", "ai1ec_clean_twig_cache", "", "yes");
INSERT INTO wptz_options VALUES("251", "ai1ec_version", "2.5.36", "no");
INSERT INTO wptz_options VALUES("252", "ai1ec_db_version", "7e32c016be9f58f5f779946ce4e48a6ce36534c2", "no");
INSERT INTO wptz_options VALUES("253", "ai1ec_category_meta_ported", "1", "no");
INSERT INTO wptz_options VALUES("254", "ai1ec_current_theme", "a:5:{s:9:\"theme_dir\";s:105:\"/home/wolfedemo/public_html/CSROA/wp-content/plugins/all-in-one-event-calendar/public/themes-ai1ec/vortex\";s:10:\"theme_root\";s:98:\"/home/wolfedemo/public_html/CSROA/wp-content/plugins/all-in-one-event-calendar/public/themes-ai1ec\";s:9:\"theme_url\";s:88:\"http://csroa.org/wp-content/plugins/all-in-one-event-calendar/public/themes-ai1ec/vortex\";s:10:\"stylesheet\";s:6:\"vortex\";s:6:\"legacy\";b:0;}", "yes");
INSERT INTO wptz_options VALUES("255", "ai1ec_less_variables", "a:43:{s:14:\"bodyBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:15:\"Body background\";}s:9:\"textColor\";a:4:{s:5:\"value\";s:7:\"#333333\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:10:\"Text color\";}s:10:\"textEmboss\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:11:\"Text emboss\";}s:9:\"linkColor\";a:4:{s:5:\"value\";s:7:\"#3d6b99\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:4:\"Link\";}s:14:\"linkColorHover\";a:4:{s:5:\"value\";s:7:\"#335980\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:12:\"Link (hover)\";}s:14:\"baseFontFamily\";a:4:{s:5:\"value\";s:46:\"\"Helvetica Neue\", Helvetica, Arial, sans-serif\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:4:\"font\";s:11:\"description\";s:9:\"Base font\";}s:12:\"baseFontSize\";a:4:{s:5:\"value\";s:4:\"16px\";s:3:\"tab\";s:7:\"general\";s:4:\"type\";s:4:\"size\";s:11:\"description\";s:14:\"Base font size\";}s:15:\"tableBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:5:\"table\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:16:\"Table background\";}s:20:\"tableLabelBackground\";a:4:{s:5:\"value\";s:7:\"#f5f5f5\";s:3:\"tab\";s:5:\"table\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:23:\"Table header background\";}s:14:\"tableLabelText\";a:4:{s:5:\"value\";s:7:\"#9e9e9e\";s:3:\"tab\";s:5:\"table\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:17:\"Table header text\";}s:20:\"btnPrimaryBackground\";a:4:{s:5:\"value\";s:7:\"#6dbb4f\";s:3:\"tab\";s:7:\"buttons\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:19:\"Primary brand color\";}s:13:\"btnBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:7:\"buttons\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:17:\"Button background\";}s:9:\"btnBorder\";a:4:{s:5:\"value\";s:7:\"#cccccc\";s:3:\"tab\";s:7:\"buttons\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:13:\"Button border\";}s:12:\"btnTextColor\";a:4:{s:5:\"value\";s:7:\"#333333\";s:3:\"tab\";s:7:\"buttons\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:11:\"Button text\";}s:9:\"inputText\";a:4:{s:5:\"value\";s:4:\"#555\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:16:\"Input field text\";}s:15:\"inputBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:22:\"Input field background\";}s:11:\"inputBorder\";a:4:{s:5:\"value\";s:7:\"#cccccc\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:18:\"Input field border\";}s:16:\"inputBorderFocus\";a:4:{s:5:\"value\";s:20:\"rgba(82,168,236,0.8)\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:26:\"Input field border (focus)\";}s:23:\"inputDisabledBackground\";a:4:{s:5:\"value\";s:7:\"#eeeeee\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:33:\"Input field background (disabled)\";}s:10:\"labelColor\";a:4:{s:5:\"value\";s:7:\"#aaaaaa\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:11:\"Field label\";}s:18:\"dropdownBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:24:\"Dropdown list background\";}s:14:\"dropdownBorder\";a:4:{s:5:\"value\";s:16:\"rgba(0,0,0,0.15)\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:20:\"Dropdown list border\";}s:17:\"dropdownLinkColor\";a:4:{s:5:\"value\";s:7:\"#333333\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:14:\"List item text\";}s:22:\"dropdownLinkColorHover\";a:4:{s:5:\"value\";s:7:\"#262626\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:29:\"List item text (active/hover)\";}s:27:\"dropdownLinkBackgroundHover\";a:4:{s:5:\"value\";s:7:\"#f5f5f5\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:35:\"List item background (active/hover)\";}s:15:\"placeholderText\";a:4:{s:5:\"value\";s:7:\"#999999\";s:3:\"tab\";s:5:\"forms\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:28:\"Input field placeholder text\";}s:10:\"todayColor\";a:4:{s:5:\"value\";s:7:\"#ffffdd\";s:3:\"tab\";s:8:\"calendar\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:11:\"Today color\";}s:25:\"alldayBadgeGradientMiddle\";a:4:{s:5:\"value\";s:7:\"#3d6b99\";s:3:\"tab\";s:8:\"calendar\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:19:\"All-day badge color\";}s:16:\"eventImageShadow\";a:4:{s:5:\"value\";s:15:\"rgba(0,0,0,0.4)\";s:3:\"tab\";s:8:\"calendar\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:18:\"Event image shadow\";}s:17:\"eventDefaultColor\";a:4:{s:5:\"value\";s:7:\"#3d6b99\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:19:\"Event default color\";}s:22:\"eventDefaultColorHover\";a:4:{s:5:\"value\";s:7:\"#335980\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:27:\"Event default color (hover)\";}s:19:\"eventStubAllDayText\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:33:\"All-day/multi-day event stub text\";}s:25:\"eventStubAllDayTextShadow\";a:4:{s:5:\"value\";s:15:\"rgba(0,0,0,0.4)\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:40:\"All-day/multi-day event stub text shadow\";}s:11:\"eventBorder\";a:4:{s:5:\"value\";s:7:\"#cccccc\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:12:\"Event border\";}s:15:\"eventBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:16:\"Event background\";}s:19:\"eventTimeBackground\";a:4:{s:5:\"value\";s:7:\"#eeeeee\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:21:\"Event time background\";}s:9:\"eventText\";a:4:{s:5:\"value\";s:7:\"#333333\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:10:\"Event text\";}s:23:\"monthViewDateBackground\";a:4:{s:5:\"value\";s:7:\"#eaf4ff\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:26:\"Month view date background\";}s:21:\"dayViewNowMarkerColor\";a:4:{s:5:\"value\";s:7:\"#f2c539\";s:3:\"tab\";s:5:\"month\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:24:\"Week/day view now marker\";}s:21:\"agendaDateTitleBorder\";a:4:{s:5:\"value\";s:7:\"#6689AC\";s:3:\"tab\";s:6:\"agenda\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:23:\"Date label accent color\";}s:25:\"agendaDateTitleBackground\";a:4:{s:5:\"value\";s:7:\"#ffffff\";s:3:\"tab\";s:6:\"agenda\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:21:\"Date label background\";}s:20:\"agendaDateBackground\";a:4:{s:5:\"value\";s:7:\"#f2f2f2\";s:3:\"tab\";s:6:\"agenda\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:15:\"Date background\";}s:21:\"agendaTodayBackground\";a:4:{s:5:\"value\";s:7:\"#f4f4bf\";s:3:\"tab\";s:6:\"agenda\";s:4:\"type\";s:5:\"color\";s:11:\"description\";s:16:\"Today background\";}}", "yes");
INSERT INTO wptz_options VALUES("238", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.1.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1523568852;s:7:\"version\";s:5:\"5.0.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO wptz_options VALUES("256", "ai1ec_settings", "a:55:{s:31:\"enabling_ticket_invitation_page\";a:4:{s:5:\"value\";b:0;s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:9:\"ai1ec_api\";a:4:{s:5:\"value\";b:0;s:4:\"type\";s:7:\"boolean\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:16:\"ai1ec_db_version\";a:4:{s:5:\"value\";b:0;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:10:\"feeds_page\";a:4:{s:5:\"value\";s:48:\"ai1ec_event_page_all-in-one-event-calendar-feeds\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:13:\"settings_page\";a:4:{s:5:\"value\";s:51:\"ai1ec_event_page_all-in-one-event-calendar-settings\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:19:\"less_variables_page\";a:4:{s:5:\"value\";s:51:\"ai1ec_event_page_all-in-one-event-calendar-edit-css\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:17:\"input_date_format\";a:5:{s:5:\"value\";s:3:\"def\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:6:\"select\";s:3:\"tab\";s:14:\"editing-events\";s:5:\"label\";s:26:\"Input dates in this format\";s:7:\"options\";a:4:{i:0;a:2:{s:4:\"text\";s:18:\"Default (d/m/yyyy)\";s:5:\"value\";s:3:\"def\";}i:1;a:2:{s:4:\"text\";s:13:\"US (m/d/yyyy)\";s:5:\"value\";s:2:\"us\";}i:2;a:2:{s:4:\"text\";s:19:\"ISO 8601 (yyyy-m-d)\";s:5:\"value\";s:3:\"iso\";}i:3;a:2:{s:4:\"text\";s:17:\"Dotted (m.d.yyyy)\";s:5:\"value\";s:3:\"dot\";}}}}s:15:\"plugins_options\";a:4:{s:5:\"value\";a:0:{}s:4:\"type\";s:5:\"array\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:17:\"ticketing_message\";a:4:{s:5:\"value\";b:0;s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:15:\"ticketing_token\";a:4:{s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:17:\"ticketing_enabled\";a:4:{s:5:\"value\";b:0;s:4:\"type\";s:7:\"boolean\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:21:\"ticketing_calendar_id\";a:4:{s:5:\"value\";N;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:16:\"calendar_page_id\";a:5:{s:5:\"value\";i:219;s:4:\"type\";s:5:\"mixed\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:22:\"calendar-page-selector\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:13:\"Calendar page\";}}s:14:\"week_start_day\";a:5:{s:5:\"value\";i:0;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:6:\"select\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:14:\"Week starts on\";s:7:\"options\";s:12:\"get_weekdays\";}}s:13:\"enabled_views\";a:5:{s:5:\"value\";a:4:{s:6:\"agenda\";a:5:{s:7:\"enabled\";b:1;s:7:\"default\";b:1;s:14:\"enabled_mobile\";b:1;s:14:\"default_mobile\";b:1;s:8:\"longname\";a:6:{i:0;s:6:\"Agenda\";i:1;s:6:\"Agenda\";s:8:\"singular\";s:6:\"Agenda\";s:6:\"plural\";s:6:\"Agenda\";s:7:\"context\";N;s:6:\"domain\";s:25:\"all-in-one-event-calendar\";}}s:6:\"oneday\";a:5:{s:7:\"enabled\";b:1;s:7:\"default\";b:0;s:14:\"enabled_mobile\";b:1;s:14:\"default_mobile\";b:0;s:8:\"longname\";a:6:{i:0;s:3:\"Day\";i:1;s:3:\"Day\";s:8:\"singular\";s:3:\"Day\";s:6:\"plural\";s:3:\"Day\";s:7:\"context\";N;s:6:\"domain\";s:25:\"all-in-one-event-calendar\";}}s:5:\"month\";a:5:{s:7:\"enabled\";b:1;s:7:\"default\";b:0;s:14:\"enabled_mobile\";b:1;s:14:\"default_mobile\";b:0;s:8:\"longname\";a:6:{i:0;s:5:\"Month\";i:1;s:5:\"Month\";s:8:\"singular\";s:5:\"Month\";s:6:\"plural\";s:5:\"Month\";s:7:\"context\";N;s:6:\"domain\";s:25:\"all-in-one-event-calendar\";}}s:4:\"week\";a:5:{s:7:\"enabled\";b:1;s:7:\"default\";b:0;s:14:\"enabled_mobile\";b:1;s:14:\"default_mobile\";b:0;s:8:\"longname\";a:6:{i:0;s:4:\"Week\";i:1;s:4:\"Week\";s:8:\"singular\";s:4:\"Week\";s:6:\"plural\";s:4:\"Week\";s:7:\"context\";N;s:6:\"domain\";s:25:\"all-in-one-event-calendar\";}}}s:4:\"type\";s:5:\"array\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:13:\"enabled-views\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:15:\"Available views\";}}s:15:\"timezone_string\";a:5:{s:5:\"value\";s:19:\"America/Los_Angeles\";s:4:\"type\";s:9:\"wp_option\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:6:\"select\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:8:\"Timezone\";s:7:\"options\";s:33:\"Ai1ec_Date_Timezone:get_timezones\";}}s:23:\"default_tags_categories\";a:5:{s:5:\"value\";a:2:{s:10:\"categories\";a:0:{}s:4:\"tags\";a:0:{}}s:4:\"type\";s:5:\"array\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:15:\"tags-categories\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:28:\"Preselected calendar filters\";s:4:\"help\";s:80:\"To clear, hold &#8984;/<abbr class=\"initialism\">CTRL</abbr> and click selection.\";}}s:10:\"exact_date\";a:5:{s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:38:\"Default calendar start date (optional)\";s:4:\"type\";s:4:\"date\";}}s:22:\"agenda_events_per_page\";a:5:{s:5:\"value\";i:10;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:25:\"Agenda pages show at most\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:6:\"events\";s:9:\"validator\";s:7:\"numeric\";}}s:19:\"week_view_starts_at\";a:5:{s:5:\"value\";i:8;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:23:\"Week/Day view starts at\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:3:\"hrs\";s:9:\"validator\";s:7:\"numeric\";}}s:17:\"week_view_ends_at\";a:5:{s:5:\"value\";i:24;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:21:\"Week/Day view ends at\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:3:\"hrs\";s:9:\"validator\";s:7:\"numeric\";}}s:19:\"google_maps_api_key\";a:5:{s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:349:\"<span class=\"ai1ec-tooltip-toggle\"\n                                    data-original-title=\"Google may request for an API key in order to show the map\">\n                                    Google Maps API Key</span> (<a target=\"_blank\" href=\"https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key\">Get an API key</a>)\";s:4:\"type\";s:6:\"normal\";}}s:15:\"month_word_wrap\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:52:\"<strong>Word-wrap event stubs</strong> in Month view\";s:4:\"help\";s:46:\"Only applies to events that span a single day.\";}}s:30:\"agenda_include_entire_last_day\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:318:\"In <span class=\"ai1ec-tooltip-toggle\"\n                        data-original-title=\"These include Agenda view,\n                        the Upcoming Events widget, and some extended views.\">\n                        Agenda-like views</span>, <strong>include all events\n                        from last day shown</strong>\";}}s:22:\"agenda_events_expanded\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:56:\"Keep all events <strong>expanded</strong> in Agenda view\";}}s:25:\"show_year_in_agenda_dates\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:50:\"<strong>Show year</strong> in calendar date labels\";}}s:22:\"show_location_in_title\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:64:\"<strong>Show location in event titles</strong> in calendar views\";}}s:19:\"exclude_from_search\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:51:\"<strong>Exclude</strong> events from search results\";}}s:29:\"turn_off_subscription_buttons\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:108:\"Hide <strong>Subscribe</strong>/<strong>Add to Calendar</strong> buttons in calendar and single event views \";}}s:27:\"disable_get_calendar_button\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:50:\"Hide <strong>Get a Timely Calendar</strong> button\";}}s:23:\"hide_maps_until_clicked\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:48:\" Hide <strong>Google Maps</strong> until clicked\";}}s:17:\"affix_filter_menu\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:80:\" <strong>Affix filter menu</strong> to top of window when it scrolls out of view\";s:4:\"help\";s:57:\"Only applies to first visible calendar found on the page.\";}}s:24:\"affix_vertical_offset_md\";a:5:{s:5:\"value\";i:0;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:39:\"Offset affixed filter bar vertically by\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:6:\"pixels\";s:9:\"validator\";s:7:\"numeric\";}}s:24:\"affix_vertical_offset_lg\";a:5:{s:5:\"value\";i:0;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:100:\"<i class=\"ai1ec-fa ai1ec-fa-lg ai1ec-fa-fw ai1ec-fa-desktop\"></i> Wide screens only (&#8805; 1200px)\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:6:\"pixels\";s:9:\"validator\";s:7:\"numeric\";}}s:24:\"affix_vertical_offset_sm\";a:5:{s:5:\"value\";i:0;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:87:\"<i class=\"ai1ec-fa ai1ec-fa-lg ai1ec-fa-fw ai1ec-fa-tablet\"></i> Tablets only (< 980px)\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:6:\"pixels\";s:9:\"validator\";s:7:\"numeric\";}}s:24:\"affix_vertical_offset_xs\";a:5:{s:5:\"value\";i:0;s:4:\"type\";s:3:\"int\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:7:{s:5:\"class\";s:5:\"input\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:86:\"<i class=\"ai1ec-fa ai1ec-fa-lg ai1ec-fa-fw ai1ec-fa-mobile\"></i> Phones only (< 768px)\";s:4:\"type\";s:6:\"append\";s:6:\"append\";s:6:\"pixels\";s:9:\"validator\";s:7:\"numeric\";}}s:38:\"strict_compatibility_content_filtering\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:38:\"Strict compatibility content filtering\";}}s:19:\"hide_featured_image\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:61:\" <strong>Hide featured image</strong> from event details page\";s:4:\"help\";s:77:\"Select this option if your theme already displays each post\'s featured image.\";}}s:14:\"input_24h_time\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:3:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"editing-events\";s:5:\"label\";s:46:\" Use <strong>24h time</strong> in time pickers\";}}s:22:\"disable_autocompletion\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:3:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"editing-events\";s:5:\"label\";s:54:\"<strong>Disable address autocomplete</strong> function\";}}s:18:\"geo_region_biasing\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:3:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"editing-events\";s:5:\"label\";s:104:\"Use the configured <strong>region</strong> (WordPress locale) to bias the address autocomplete function \";}}s:24:\"show_create_event_button\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:10:\"extensions\";s:5:\"label\";s:92:\" Show the old <strong>Post Your Event</strong> button above the calendar to privileged users\";s:4:\"help\";s:145:\"Install the <a target=\"_blank\" href=\"https://time.ly/\">Interactive Frontend Extension</a> for the <strong>frontend Post Your Event form</strong>.\";}}s:11:\"twitterinfo\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:10:\"extensions\";s:4:\"item\";s:10:\"twittertab\";s:5:\"label\";s:0:\"\";s:4:\"help\";s:485:\"<div class=\"ai1ec-twitterinfo-wrap\"><b>Twitter</b><br>This feature allows your events to be automatically tweeted before they happen. Great way to add regular content to your twitter roll and keep your audience informed of all your great events. This feature is not yet enabled in your product. Please purchase it as a standalone for a low annual subscription or inside the Core+ bundle. <a target=\"_blank\" href=\"https://time.ly/wordpress-calendar-plugin/addons/\">Click here.</a></div>\";}}s:9:\"embedding\";a:5:{s:5:\"value\";N;s:4:\"type\";s:4:\"html\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:3:{s:5:\"class\";s:4:\"html\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:14:\"embedded-views\";}}s:22:\"skip_in_the_loop_check\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:98:\"<strong>Skip <tt>in_the_loop()</tt> check </strong> that protects against multiple calendar output\";s:4:\"help\";s:225:\"Try enabling this option if your calendar does not appear on the calendar page. It is needed for compatibility with a small number of themes that call <tt>the_content()</tt> from outside of The Loop. Leave disabled otherwise.\";}}s:24:\"disable_gzip_compression\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:42:\"Disable <strong>gzip</strong> compression.\";s:4:\"help\";s:262:\"Use this option if calendar is unresponsive. <a target=\"_blank\" href=\"https://time.ly/document/user-guide/troubleshooting/disable-gzip-compression/\">Read more</a> about the issue. (From version 2.1 onwards, gzip is disabled by default for maximum compatibility.)\";}}s:28:\"ai1ec_use_frontend_rendering\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:23:\"Use frontend rendering.\";s:4:\"help\";s:85:\"Renders calendar views on the client rather than the server; can improve performance.\";}}s:16:\"cache_dynamic_js\";a:5:{s:5:\"value\";b:1;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:22:\"Use advanced JS cache.\";s:4:\"help\";s:59:\"Cache dynamically generated JS files. Improves performance.\";}}s:18:\"render_css_as_link\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:94:\"<strong>Link CSS</strong> in <code>&lt;head&gt;</code> section when file cache is unavailable.\";s:4:\"help\";s:123:\"Use this option if file cache is unavailable and you would prefer to serve CSS as a link rather than have it output inline.\";}}s:15:\"edit_robots_txt\";a:5:{s:5:\"value\";s:957:\"User-agent: *\r\nDisallow: /calendar/action~posterboard/\r\nDisallow: /calendar/action~agenda/\r\nDisallow: /calendar/action~oneday/\r\nDisallow: /calendar/action~month/\r\nDisallow: /calendar/action~week/\r\nDisallow: /calendar/action~stream/\r\nDisallow: /calendar/action~undefined/\r\nDisallow: /calendar/action~http:/\r\nDisallow: /calendar/action~default/\r\nDisallow: /calendar/action~poster/\r\nDisallow: /calendar/action~*/\r\nDisallow: /*controller=ai1ec_exporter_controller*\r\nDisallow: /*/action~*/\r\nDisallow: /events-calendar/action~posterboard/\r\nDisallow: /events-calendar/action~agenda/\r\nDisallow: /events-calendar/action~oneday/\r\nDisallow: /events-calendar/action~month/\r\nDisallow: /events-calendar/action~week/\r\nDisallow: /events-calendar/action~stream/\r\nDisallow: /events-calendar/action~undefined/\r\nDisallow: /events-calendar/action~http:/\r\nDisallow: /events-calendar/action~default/\r\nDisallow: /events-calendar/action~poster/\r\nDisallow: /events-calendar/action~*/\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:8:{s:5:\"class\";s:8:\"textarea\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:48:\"Current <strong>robots.txt</strong> on this site\";s:4:\"type\";s:6:\"normal\";s:4:\"rows\";i:6;s:8:\"readonly\";s:8:\"readonly\";s:4:\"help\";s:517:\"The Robot Exclusion Standard, also known as the Robots Exclusion Protocol or\n                        <code><a href=\"https://en.wikipedia.org/wiki/Robots.txt\" target=\"_blank\">robots.txt</a></code>\n                        protocol, is a convention for cooperating web crawlers and other web robots\n                        about accessing all or part of a website that is otherwise publicly viewable.\n                        You can change it manually by editing <code>robots.txt</code> in your root WordPress directory.\";}}s:16:\"allow_statistics\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:8:\"advanced\";s:5:\"label\";s:184:\"<strong>Publicize, promote, and share my events</strong> marked as public on the Timely network. (<a href=\"https://time.ly/event-search-calendar\" target=\"_blank\">Learn more &#187;</a>)\";}}s:14:\"legacy_options\";a:4:{s:5:\"value\";N;s:4:\"type\";s:14:\"legacy_options\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:13:\"ics_cron_freq\";a:4:{s:5:\"value\";s:6:\"hourly\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";}s:10:\"twig_cache\";a:5:{s:5:\"value\";s:23:\"AI1EC_CACHE_UNAVAILABLE\";s:4:\"type\";s:6:\"string\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:4:{s:5:\"class\";s:5:\"cache\";s:3:\"tab\";s:8:\"advanced\";s:4:\"item\";s:5:\"cache\";s:5:\"label\";s:41:\"Templates cache improves site performance\";}}s:28:\"always_use_calendar_timezone\";a:5:{s:5:\"value\";b:0;s:4:\"type\";s:4:\"bool\";s:6:\"legacy\";b:0;s:7:\"version\";s:6:\"2.5.36\";s:8:\"renderer\";a:5:{s:5:\"class\";s:8:\"checkbox\";s:3:\"tab\";s:14:\"viewing-events\";s:4:\"item\";s:14:\"viewing-events\";s:5:\"label\";s:53:\"Display events in <strong>calendar time zone</strong>\";s:4:\"help\";s:131:\"If this box is checked events will appear in the calendar time zone with time zone information displayed on the event details page.\";}}}", "yes");
INSERT INTO wptz_options VALUES("192", "Enfold_version", "4.2.6", "yes");
INSERT INTO wptz_options VALUES("193", "avia_stylesheet_dir_writableenfold", "true", "yes");
INSERT INTO wptz_options VALUES("194", "avia_stylesheet_existsenfold", "true", "yes");
INSERT INTO wptz_options VALUES("195", "avia_stylesheet_dynamic_versionenfold", "5b8776c19beb6", "yes");
INSERT INTO wptz_options VALUES("196", "enfold_woo_settings_enabled", "1", "yes");
INSERT INTO wptz_options VALUES("257", "ai1ec_scheduler_hooks", "a:3:{s:5:\"hooks\";a:1:{s:24:\"ai1ec_purge_events_cache\";a:5:{s:4:\"hook\";s:24:\"ai1ec_purge_events_cache\";s:9:\"timestamp\";i:1523596771;s:7:\"version\";s:1:\"0\";s:10:\"recurrence\";s:11:\"every_10800\";s:4:\"freq\";s:2:\"3h\";}}s:5:\"freqs\";a:1:{i:10800;a:3:{s:4:\"hash\";s:11:\"every_10800\";s:4:\"name\";N;s:7:\"seconds\";i:10800;}}s:7:\"version\";s:6:\"2.5.30\";}", "yes");
INSERT INTO wptz_options VALUES("258", "widget_ai1ec_agenda_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("260", "ai1ec_api_settings", "a:5:{s:7:\"enabled\";b:0;s:7:\"message\";s:0:\"\";s:5:\"token\";s:0:\"\";s:11:\"calendar_id\";i:0;s:16:\"payment_settings\";a:5:{s:14:\"payment_method\";s:6:\"paypal\";s:12:\"paypal_email\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:8:\"currency\";s:3:\"USD\";}}", "yes");
INSERT INTO wptz_options VALUES("500", "_ai1ec_review", "a:1:{s:12:\"release_date\";s:10:\"1525375745\";}", "no");
INSERT INTO wptz_options VALUES("759", "ngg_run_freemius", "1", "yes");
INSERT INTO wptz_options VALUES("760", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:24:\"nextgen-gallery/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.1.3\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1545517923;s:11:\"plugin_path\";s:29:\"nextgen-gallery/nggallery.php\";}}s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:29:\"nextgen-gallery/nggallery.php\";s:8:\"sdk_path\";s:24:\"nextgen-gallery/freemius\";s:7:\"version\";s:5:\"2.1.3\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1545517923;}s:7:\"abspath\";s:24:\"/home/csroa/public_html/\";}", "yes");
INSERT INTO wptz_options VALUES("761", "fs_debug_mode", "", "yes");
INSERT INTO wptz_options VALUES("762", "fs_accounts", "a:5:{s:11:\"plugin_data\";a:1:{s:15:\"nextgen-gallery\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:29:\"nextgen-gallery/nggallery.php\";}s:17:\"install_timestamp\";i:1526669721;s:16:\"sdk_last_version\";s:7:\"1.2.1.5\";s:11:\"sdk_version\";s:5:\"2.1.3\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"3.0.8\";s:14:\"plugin_version\";s:5:\"3.1.4\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:21:\"is_plugin_new_install\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:24:\"wolfeinteractivedemo.com\";s:9:\"server_ip\";s:14:\"47.144.202.100\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1526669721;s:7:\"version\";s:5:\"3.0.1\";}s:17:\"was_plugin_loaded\";b:1;s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1526669731;s:7:\"version\";s:5:\"3.0.1\";}s:24:\"handle_gdpr_admin_notice\";b:1;}}s:13:\"file_slug_map\";a:1:{s:29:\"nextgen-gallery/nggallery.php\";s:15:\"nextgen-gallery\";}s:7:\"plugins\";a:1:{s:15:\"nextgen-gallery\";O:9:\"FS_Plugin\":18:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:15:\"NextGEN Gallery\";s:4:\"slug\";s:15:\"nextgen-gallery\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:4:\"file\";s:29:\"nextgen-gallery/nggallery.php\";s:7:\"version\";s:5:\"3.1.4\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:7:\"is_live\";b:1;s:10:\"public_key\";s:32:\"pk_009356711cd548837f074e1ef60a4\";s:10:\"secret_key\";N;s:2:\"id\";s:3:\"266\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"c7d85b2f75562e5d4ee0b84deabf3b8d\";s:21:\"id_slug_type_path_map\";a:1:{i:266;a:3:{s:4:\"slug\";s:15:\"nextgen-gallery\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:29:\"nextgen-gallery/nggallery.php\";}}}", "yes");
INSERT INTO wptz_options VALUES("763", "fs_api_cache", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("765", "widget_ngg-images", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("766", "widget_ngg-mrssw", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("767", "widget_slideshow", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("768", "ngg_transient_groups", "a:7:{s:9:\"__counter\";i:7;s:3:\"MVC\";a:2:{s:2:\"id\";i:2;s:7:\"enabled\";b:1;}s:17:\"col_in_wptz_posts\";a:2:{s:2:\"id\";i:3;s:7:\"enabled\";b:1;}s:23:\"col_in_wptz_ngg_gallery\";a:2:{s:2:\"id\";i:4;s:7:\"enabled\";b:1;}s:24:\"col_in_wptz_ngg_pictures\";a:2:{s:2:\"id\";i:5;s:7:\"enabled\";b:1;}s:27:\"displayed_gallery_rendering\";a:2:{s:2:\"id\";i:6;s:7:\"enabled\";b:1;}s:21:\"col_in_wptz_ngg_album\";a:2:{s:2:\"id\";i:7;s:7:\"enabled\";b:1;}}", "yes");
INSERT INTO wptz_options VALUES("769", "ngg_options", "a:66:{s:11:\"gallerypath\";s:37:\"wp-content/uploads/sites/1/nggallery/\";s:11:\"wpmuCSSfile\";s:13:\"nggallery.css\";s:9:\"wpmuStyle\";b:0;s:9:\"wpmuRoles\";b:0;s:16:\"wpmuImportFolder\";b:0;s:13:\"wpmuZipUpload\";b:0;s:14:\"wpmuQuotaCheck\";b:0;s:17:\"datamapper_driver\";s:23:\"custom_table_datamapper\";s:21:\"gallerystorage_driver\";s:25:\"ngglegacy_gallery_storage\";s:20:\"maximum_entity_count\";i:500;s:17:\"router_param_slug\";s:9:\"nggallery\";s:13:\"gallery_count\";i:1;s:11:\"installDate\";i:1535569238;s:9:\"deleteImg\";b:1;s:13:\"usePermalinks\";b:0;s:13:\"permalinkSlug\";s:9:\"nggallery\";s:14:\"graphicLibrary\";s:2:\"gd\";s:14:\"imageMagickDir\";s:15:\"/usr/local/bin/\";s:11:\"useMediaRSS\";b:0;s:18:\"galleries_in_feeds\";b:0;s:12:\"activateTags\";i:0;s:10:\"appendType\";s:4:\"tags\";s:9:\"maxImages\";i:7;s:14:\"relatedHeading\";s:24:\"<h3>Related Images:</h3>\";s:10:\"thumbwidth\";i:240;s:11:\"thumbheight\";i:160;s:8:\"thumbfix\";b:1;s:12:\"thumbquality\";i:100;s:8:\"imgWidth\";i:1800;s:9:\"imgHeight\";i:1200;s:10:\"imgQuality\";i:100;s:9:\"imgBackup\";b:1;s:13:\"imgAutoResize\";b:1;s:9:\"galImages\";s:2:\"24\";s:17:\"galPagedGalleries\";i:0;s:10:\"galColumns\";i:0;s:12:\"galShowSlide\";b:0;s:12:\"galTextSlide\";s:14:\"View Slideshow\";s:14:\"galTextGallery\";s:15:\"View Thumbnails\";s:12:\"galShowOrder\";s:7:\"gallery\";s:7:\"galSort\";s:9:\"sortorder\";s:10:\"galSortDir\";s:3:\"ASC\";s:10:\"galNoPages\";b:1;s:13:\"galImgBrowser\";i:0;s:12:\"galHiddenImg\";i:0;s:10:\"galAjaxNav\";i:1;s:11:\"thumbEffect\";s:14:\"simplelightbox\";s:9:\"thumbCode\";s:47:\"class=\"ngg-simplelightbox\" rel=\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}GALLERY_NAME{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\"\";s:18:\"thumbEffectContext\";s:14:\"nextgen_images\";s:5:\"wmPos\";s:9:\"midCenter\";s:6:\"wmXpos\";i:15;s:6:\"wmYpos\";i:5;s:6:\"wmType\";s:4:\"text\";s:6:\"wmPath\";s:0:\"\";s:6:\"wmFont\";s:9:\"arial.ttf\";s:6:\"wmSize\";i:30;s:6:\"wmText\";s:47:\"California School Resource Officers Association\";s:7:\"wmColor\";s:6:\"ffffff\";s:8:\"wmOpaque\";s:2:\"33\";s:7:\"slideFX\";s:4:\"fade\";s:7:\"irWidth\";i:750;s:8:\"irHeight\";i:500;s:12:\"irRotatetime\";i:5;s:11:\"activateCSS\";i:1;s:7:\"CSSfile\";s:13:\"nggallery.css\";s:28:\"always_enable_frontend_logic\";b:0;}", "yes");
INSERT INTO wptz_options VALUES("505", "ai1ec_robots_txt", "a:2:{s:12:\"is_installed\";b:1;s:7:\"page_id\";i:219;}", "no");
INSERT INTO wptz_options VALUES("521", "ai1ec_render_css", "https://csroa.org/wp-content/plugins/all-in-one-event-calendar/cache/1f56403e_ai1ec_parsed_css.css", "yes");
INSERT INTO wptz_options VALUES("522", "ai1ec_filename_css", "1f56403e_ai1ec_parsed_css.css", "yes");
INSERT INTO wptz_options VALUES("734", "events_categories_children", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("2016", "userpro_fields_groups_default", "a:5:{s:8:\"register\";a:1:{s:7:\"default\";a:16:{s:11:\"accountinfo\";a:3:{s:7:\"heading\";s:15:\"Account Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:10:\"user_login\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:8:\"Username\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";s:15:\"username_exists\";}s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:1;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";s:12:\"email_exists\";}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";N;}s:17:\"user_pass_confirm\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:16:\"passwordstrength\";a:13:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"profile\";a:3:{s:7:\"heading\";s:15:\"Profile Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:1;}s:12:\"display_name\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:14:\"profilepicture\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"gender\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"country\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"social\";a:3:{s:7:\"heading\";s:15:\"Social Profiles\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:1;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}}s:5:\"login\";a:1:{s:7:\"default\";a:2:{s:17:\"username_or_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:18:\"Username or E-mail\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";N;}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";N;}}}s:4:\"edit\";a:1:{s:7:\"default\";a:18:{s:7:\"profile\";a:3:{s:7:\"heading\";s:15:\"Profile Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:12:\"display_name\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:14:\"profilepicture\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:10:\"first_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:9:\"last_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"description\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:9:\"Biography\";s:4:\"help\";s:18:\"Describe yourself.\";s:4:\"html\";i:1;s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"gender\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"country\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"social\";a:3:{s:7:\"heading\";s:15:\"Social Profiles\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"accountinfo\";a:3:{s:7:\"heading\";s:15:\"Account Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:1;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";s:18:\"email_domain_check\";}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:17:\"user_pass_confirm\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:16:\"passwordstrength\";a:13:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}}s:4:\"view\";a:1:{s:7:\"default\";a:18:{s:7:\"profile\";a:3:{s:7:\"heading\";s:15:\"Profile Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:12:\"display_name\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:14:\"profilepicture\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:10:\"first_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:9:\"last_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"description\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:9:\"Biography\";s:4:\"help\";s:18:\"Describe yourself.\";s:4:\"html\";i:1;s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"gender\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"country\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"social\";a:3:{s:7:\"heading\";s:15:\"Social Profiles\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"accountinfo\";a:3:{s:7:\"heading\";s:15:\"Account Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:1;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";s:18:\"email_domain_check\";}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:17:\"user_pass_confirm\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:16:\"passwordstrength\";a:13:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}}s:6:\"social\";a:1:{s:7:\"default\";a:5:{s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}}}", "yes");
INSERT INTO wptz_options VALUES("2017", "userpro_fields_groups_default_register", "a:16:{s:11:\"accountinfo\";a:3:{s:7:\"heading\";s:15:\"Account Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:10:\"user_login\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:8:\"Username\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";s:15:\"username_exists\";}s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:1;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";s:12:\"email_exists\";}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";N;}s:17:\"user_pass_confirm\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:16:\"passwordstrength\";a:13:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"profile\";a:3:{s:7:\"heading\";s:15:\"Profile Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:1;}s:12:\"display_name\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:14:\"profilepicture\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"gender\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"country\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"social\";a:3:{s:7:\"heading\";s:15:\"Social Profiles\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:1;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}", "yes");
INSERT INTO wptz_options VALUES("2018", "userpro_fields_groups_default_login", "a:2:{s:17:\"username_or_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:18:\"Username or E-mail\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";N;}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:1;s:9:\"ajaxcheck\";N;}}", "yes");
INSERT INTO wptz_options VALUES("2019", "userpro_fields_groups_default_edit", "a:18:{s:7:\"profile\";a:3:{s:7:\"heading\";s:15:\"Profile Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:12:\"display_name\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:14:\"profilepicture\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:10:\"first_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:9:\"last_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"description\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:9:\"Biography\";s:4:\"help\";s:18:\"Describe yourself.\";s:4:\"html\";i:1;s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"gender\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"country\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"social\";a:3:{s:7:\"heading\";s:15:\"Social Profiles\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"accountinfo\";a:3:{s:7:\"heading\";s:15:\"Account Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:1;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";s:18:\"email_domain_check\";}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:17:\"user_pass_confirm\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:16:\"passwordstrength\";a:13:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}", "yes");
INSERT INTO wptz_options VALUES("2020", "userpro_fields_groups_default_view", "a:18:{s:7:\"profile\";a:3:{s:7:\"heading\";s:15:\"Profile Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:12:\"display_name\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:20:\"Profile Display Name\";s:4:\"help\";s:55:\"Your profile name/nickname that is displayed to public.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:14:\"profilepicture\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:7:\"picture\";s:5:\"label\";s:15:\"Profile Picture\";s:11:\"button_text\";s:24:\"Upload a profile picture\";s:4:\"help\";s:51:\"Upload a picture that presents you across the site.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:10:\"first_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:9:\"last_name\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"description\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:9:\"Biography\";s:4:\"help\";s:18:\"Describe yourself.\";s:4:\"html\";i:1;s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"gender\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:5:\"radio\";s:5:\"label\";s:6:\"Gender\";s:7:\"options\";a:2:{s:4:\"male\";s:4:\"Male\";s:6:\"female\";s:6:\"Female\";}s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"country\";a:9:{s:8:\"_builtin\";i:1;s:4:\"type\";s:6:\"select\";s:5:\"label\";s:14:\"Country/Region\";s:7:\"options\";a:251:{s:0:\"\";s:0:\"\";s:2:\"AF\";s:11:\"Afghanistan\";s:2:\"AX\";s:14:\"Åland Islands\";s:2:\"AL\";s:7:\"Albania\";s:2:\"DZ\";s:7:\"Algeria\";s:2:\"AS\";s:14:\"American Samoa\";s:2:\"AD\";s:7:\"Andorra\";s:2:\"AO\";s:6:\"Angola\";s:2:\"AI\";s:8:\"Anguilla\";s:2:\"AQ\";s:10:\"Antarctica\";s:2:\"AG\";s:19:\"Antigua and Barbuda\";s:2:\"AR\";s:9:\"Argentina\";s:2:\"AM\";s:7:\"Armenia\";s:2:\"AW\";s:5:\"Aruba\";s:2:\"AU\";s:9:\"Australia\";s:2:\"AT\";s:7:\"Austria\";s:2:\"AZ\";s:10:\"Azerbaijan\";s:2:\"BS\";s:7:\"Bahamas\";s:2:\"BH\";s:7:\"Bahrain\";s:2:\"BD\";s:10:\"Bangladesh\";s:2:\"BB\";s:8:\"Barbados\";s:2:\"BY\";s:7:\"Belarus\";s:2:\"BE\";s:7:\"Belgium\";s:2:\"BZ\";s:6:\"Belize\";s:2:\"BJ\";s:5:\"Benin\";s:2:\"BM\";s:7:\"Bermuda\";s:2:\"BT\";s:6:\"Bhutan\";s:2:\"BO\";s:31:\"Bolivia, Plurinational State of\";s:2:\"BQ\";s:32:\"Bonaire, Sint Eustatius and Saba\";s:2:\"BA\";s:22:\"Bosnia and Herzegovina\";s:2:\"BW\";s:8:\"Botswana\";s:2:\"BV\";s:13:\"Bouvet Island\";s:2:\"BR\";s:6:\"Brazil\";s:2:\"IO\";s:30:\"British Indian Ocean Territory\";s:2:\"BN\";s:17:\"Brunei Darussalam\";s:2:\"BG\";s:8:\"Bulgaria\";s:2:\"BF\";s:12:\"Burkina Faso\";s:2:\"BI\";s:7:\"Burundi\";s:2:\"KH\";s:8:\"Cambodia\";s:2:\"CM\";s:8:\"Cameroon\";s:2:\"CA\";s:6:\"Canada\";s:2:\"CV\";s:10:\"Cape Verde\";s:2:\"KY\";s:14:\"Cayman Islands\";s:2:\"CF\";s:24:\"Central African Republic\";s:2:\"TD\";s:4:\"Chad\";s:2:\"CL\";s:5:\"Chile\";s:2:\"CN\";s:5:\"China\";s:2:\"CX\";s:16:\"Christmas Island\";s:2:\"CC\";s:23:\"Cocos (Keeling) Islands\";s:2:\"CO\";s:8:\"Colombia\";s:2:\"KM\";s:7:\"Comoros\";s:2:\"CG\";s:5:\"Congo\";s:2:\"CD\";s:37:\"Congo, the Democratic Republic of the\";s:2:\"CK\";s:12:\"Cook Islands\";s:2:\"CR\";s:10:\"Costa Rica\";s:2:\"CI\";s:14:\"Côte d\'Ivoire\";s:2:\"HR\";s:7:\"Croatia\";s:2:\"CU\";s:4:\"Cuba\";s:2:\"CW\";s:8:\"Curaçao\";s:2:\"CY\";s:6:\"Cyprus\";s:2:\"CZ\";s:14:\"Czech Republic\";s:2:\"DK\";s:7:\"Denmark\";s:2:\"DJ\";s:8:\"Djibouti\";s:2:\"DM\";s:8:\"Dominica\";s:2:\"DO\";s:18:\"Dominican Republic\";s:2:\"EC\";s:7:\"Ecuador\";s:2:\"EG\";s:5:\"Egypt\";s:2:\"SV\";s:11:\"El Salvador\";s:2:\"GQ\";s:17:\"Equatorial Guinea\";s:2:\"ER\";s:7:\"Eritrea\";s:2:\"EE\";s:7:\"Estonia\";s:2:\"ET\";s:8:\"Ethiopia\";s:2:\"FK\";s:27:\"Falkland Islands (Malvinas)\";s:2:\"FO\";s:13:\"Faroe Islands\";s:2:\"FJ\";s:4:\"Fiji\";s:2:\"FI\";s:7:\"Finland\";s:2:\"FR\";s:6:\"France\";s:2:\"GF\";s:13:\"French Guiana\";s:2:\"PF\";s:16:\"French Polynesia\";s:2:\"TF\";s:27:\"French Southern Territories\";s:2:\"GA\";s:5:\"Gabon\";s:2:\"GM\";s:6:\"Gambia\";s:2:\"GE\";s:7:\"Georgia\";s:2:\"DE\";s:7:\"Germany\";s:2:\"GH\";s:5:\"Ghana\";s:2:\"GI\";s:9:\"Gibraltar\";s:2:\"GR\";s:6:\"Greece\";s:2:\"GL\";s:9:\"Greenland\";s:2:\"GD\";s:7:\"Grenada\";s:2:\"GP\";s:10:\"Guadeloupe\";s:2:\"GU\";s:4:\"Guam\";s:2:\"GT\";s:9:\"Guatemala\";s:2:\"GG\";s:8:\"Guernsey\";s:2:\"GN\";s:6:\"Guinea\";s:2:\"GW\";s:13:\"Guinea-Bissau\";s:2:\"GY\";s:6:\"Guyana\";s:2:\"HT\";s:5:\"Haiti\";s:2:\"HM\";s:33:\"Heard Island and McDonald Islands\";s:2:\"VA\";s:29:\"Holy See (Vatican City State)\";s:2:\"HN\";s:8:\"Honduras\";s:2:\"HK\";s:9:\"Hong Kong\";s:2:\"HU\";s:7:\"Hungary\";s:2:\"IS\";s:7:\"Iceland\";s:2:\"IN\";s:5:\"India\";s:2:\"ID\";s:9:\"Indonesia\";s:2:\"IR\";s:25:\"Iran, Islamic Republic of\";s:2:\"IQ\";s:4:\"Iraq\";s:2:\"IE\";s:7:\"Ireland\";s:2:\"IM\";s:11:\"Isle of Man\";s:2:\"IL\";s:6:\"Israel\";s:2:\"IT\";s:5:\"Italy\";s:2:\"JM\";s:7:\"Jamaica\";s:2:\"JP\";s:5:\"Japan\";s:2:\"JE\";s:6:\"Jersey\";s:2:\"JO\";s:6:\"Jordan\";s:2:\"KZ\";s:10:\"Kazakhstan\";s:2:\"KE\";s:5:\"Kenya\";s:2:\"KI\";s:8:\"Kiribati\";s:2:\"KP\";s:38:\"Korea, Democratic People\'s Republic of\";s:2:\"KR\";s:18:\"Korea, Republic of\";s:2:\"KW\";s:6:\"Kuwait\";s:2:\"KG\";s:10:\"Kyrgyzstan\";s:2:\"LA\";s:32:\"Lao People\'s Democratic Republic\";s:2:\"LV\";s:6:\"Latvia\";s:2:\"LB\";s:7:\"Lebanon\";s:2:\"LS\";s:7:\"Lesotho\";s:2:\"LR\";s:7:\"Liberia\";s:2:\"LY\";s:5:\"Libya\";s:2:\"LI\";s:13:\"Liechtenstein\";s:2:\"LT\";s:9:\"Lithuania\";s:2:\"LU\";s:10:\"Luxembourg\";s:2:\"MO\";s:5:\"Macao\";s:2:\"MK\";s:42:\"Macedonia, The Former Yugoslav Republic of\";s:2:\"MG\";s:10:\"Madagascar\";s:2:\"MW\";s:6:\"Malawi\";s:2:\"MY\";s:8:\"Malaysia\";s:2:\"MV\";s:8:\"Maldives\";s:2:\"ML\";s:4:\"Mali\";s:2:\"MT\";s:5:\"Malta\";s:2:\"MH\";s:16:\"Marshall Islands\";s:2:\"MQ\";s:10:\"Martinique\";s:2:\"MR\";s:10:\"Mauritania\";s:2:\"MU\";s:9:\"Mauritius\";s:2:\"YT\";s:7:\"Mayotte\";s:2:\"MX\";s:6:\"Mexico\";s:2:\"FM\";s:31:\"Micronesia, Federated States of\";s:2:\"MD\";s:20:\"Moldova, Republic of\";s:2:\"MC\";s:6:\"Monaco\";s:2:\"MN\";s:8:\"Mongolia\";s:2:\"ME\";s:10:\"Montenegro\";s:2:\"MS\";s:10:\"Montserrat\";s:2:\"MA\";s:7:\"Morocco\";s:2:\"MZ\";s:10:\"Mozambique\";s:2:\"MM\";s:7:\"Myanmar\";s:2:\"NA\";s:7:\"Namibia\";s:2:\"NR\";s:5:\"Nauru\";s:2:\"NP\";s:5:\"Nepal\";s:2:\"NL\";s:11:\"Netherlands\";s:2:\"NC\";s:13:\"New Caledonia\";s:2:\"NZ\";s:11:\"New Zealand\";s:2:\"NI\";s:9:\"Nicaragua\";s:2:\"NE\";s:5:\"Niger\";s:2:\"NG\";s:7:\"Nigeria\";s:2:\"NU\";s:4:\"Niue\";s:2:\"NF\";s:14:\"Norfolk Island\";s:2:\"MP\";s:24:\"Northern Mariana Islands\";s:2:\"NO\";s:6:\"Norway\";s:2:\"OM\";s:4:\"Oman\";s:2:\"PK\";s:8:\"Pakistan\";s:2:\"PW\";s:5:\"Palau\";s:2:\"PS\";s:21:\"Palestinian Territory\";s:2:\"PA\";s:6:\"Panama\";s:2:\"PG\";s:16:\"Papua New Guinea\";s:2:\"PY\";s:8:\"Paraguay\";s:2:\"PE\";s:4:\"Peru\";s:2:\"PH\";s:11:\"Philippines\";s:2:\"PN\";s:8:\"Pitcairn\";s:2:\"PL\";s:6:\"Poland\";s:2:\"PT\";s:8:\"Portugal\";s:2:\"PR\";s:11:\"Puerto Rico\";s:2:\"QA\";s:5:\"Qatar\";s:2:\"RE\";s:8:\"Réunion\";s:2:\"RO\";s:7:\"Romania\";s:2:\"RU\";s:18:\"Russian Federation\";s:2:\"RW\";s:6:\"Rwanda\";s:2:\"BL\";s:17:\"Saint Barthélemy\";s:2:\"SH\";s:44:\"Saint Helena, Ascension and Tristan da Cunha\";s:2:\"KN\";s:21:\"Saint Kitts and Nevis\";s:2:\"LC\";s:11:\"Saint Lucia\";s:2:\"MF\";s:26:\"Saint Martin (French part)\";s:2:\"PM\";s:25:\"Saint Pierre and Miquelon\";s:2:\"VC\";s:32:\"Saint Vincent and the Grenadines\";s:2:\"WS\";s:5:\"Samoa\";s:2:\"SM\";s:10:\"San Marino\";s:2:\"ST\";s:21:\"Sao Tome and Principe\";s:2:\"SA\";s:12:\"Saudi Arabia\";s:8:\"scotland\";s:8:\"Scotland\";s:2:\"SN\";s:7:\"Senegal\";s:2:\"RS\";s:6:\"Serbia\";s:2:\"SC\";s:10:\"Seychelles\";s:2:\"SL\";s:12:\"Sierra Leone\";s:2:\"SG\";s:9:\"Singapore\";s:2:\"SX\";s:25:\"Sint Maarten (Dutch part)\";s:2:\"SK\";s:8:\"Slovakia\";s:2:\"SI\";s:8:\"Slovenia\";s:2:\"SB\";s:15:\"Solomon Islands\";s:2:\"SO\";s:7:\"Somalia\";s:2:\"ZA\";s:12:\"South Africa\";s:2:\"GS\";s:44:\"South Georgia and the South Sandwich Islands\";s:2:\"SS\";s:11:\"South Sudan\";s:2:\"ES\";s:5:\"Spain\";s:2:\"LK\";s:9:\"Sri Lanka\";s:2:\"SD\";s:5:\"Sudan\";s:2:\"SR\";s:8:\"Suriname\";s:2:\"SJ\";s:22:\"Svalbard and Jan Mayen\";s:2:\"SZ\";s:9:\"Swaziland\";s:2:\"SE\";s:6:\"Sweden\";s:2:\"CH\";s:11:\"Switzerland\";s:2:\"SY\";s:20:\"Syrian Arab Republic\";s:2:\"TW\";s:25:\"Taiwan, Province of China\";s:2:\"TJ\";s:10:\"Tajikistan\";s:2:\"TZ\";s:28:\"Tanzania, United Republic of\";s:2:\"TH\";s:8:\"Thailand\";s:2:\"TL\";s:11:\"Timor-Leste\";s:2:\"TG\";s:4:\"Togo\";s:2:\"TK\";s:7:\"Tokelau\";s:2:\"TO\";s:5:\"Tonga\";s:2:\"TT\";s:19:\"Trinidad and Tobago\";s:2:\"TN\";s:7:\"Tunisia\";s:2:\"TR\";s:6:\"Turkey\";s:2:\"TM\";s:12:\"Turkmenistan\";s:2:\"TC\";s:24:\"Turks and Caicos Islands\";s:2:\"TV\";s:6:\"Tuvalu\";s:2:\"UG\";s:6:\"Uganda\";s:2:\"UA\";s:7:\"Ukraine\";s:2:\"AE\";s:20:\"United Arab Emirates\";s:2:\"UK\";s:14:\"United Kingdom\";s:2:\"US\";s:13:\"United States\";s:2:\"UM\";s:36:\"United States Minor Outlying Islands\";s:2:\"UY\";s:7:\"Uruguay\";s:2:\"UZ\";s:10:\"Uzbekistan\";s:2:\"VU\";s:7:\"Vanuatu\";s:2:\"VE\";s:33:\"Venezuela, Bolivarian Republic of\";s:2:\"VN\";s:8:\"Viet Nam\";s:2:\"VG\";s:23:\"Virgin Islands, British\";s:2:\"VI\";s:20:\"Virgin Islands, U.S.\";s:2:\"WF\";s:17:\"Wallis and Futuna\";s:2:\"EH\";s:14:\"Western Sahara\";s:2:\"YE\";s:5:\"Yemen\";s:2:\"ZM\";s:6:\"Zambia\";s:2:\"ZW\";s:8:\"Zimbabwe\";}s:11:\"placeholder\";s:19:\"Select your Country\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:6:\"social\";a:3:{s:7:\"heading\";s:15:\"Social Profiles\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"accountinfo\";a:3:{s:7:\"heading\";s:15:\"Account Details\";s:11:\"collapsible\";i:1;s:9:\"collapsed\";i:0;}s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:1;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";s:18:\"email_domain_check\";}s:9:\"user_pass\";a:8:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:4:\"help\";s:49:\"Your password must be 8 characters long at least.\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:17:\"user_pass_confirm\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:8:\"password\";s:5:\"label\";s:21:\"Confirm your Password\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:16:\"passwordstrength\";a:13:{s:8:\"_builtin\";i:1;s:4:\"type\";s:16:\"passwordstrength\";s:5:\"label\";s:23:\"Password Strength Meter\";s:9:\"too_short\";s:18:\"Password too short\";s:11:\"very_strong\";s:11:\"Very Strong\";s:6:\"strong\";s:6:\"Strong\";s:4:\"good\";s:4:\"Good\";s:4:\"weak\";s:4:\"Weak\";s:9:\"very_weak\";s:9:\"Very Weak\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}", "yes");
INSERT INTO wptz_options VALUES("2021", "userpro_fields_groups_default_social", "a:5:{s:10:\"user_email\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"facebook\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Facebook Page\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:7:\"twitter\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Twitter\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:11:\"google_plus\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Google+\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}s:8:\"user_url\";a:7:{s:8:\"_builtin\";i:1;s:4:\"type\";s:4:\"text\";s:5:\"label\";s:13:\"Website (URL)\";s:8:\"hideable\";i:0;s:6:\"hidden\";i:0;s:8:\"required\";i:0;s:9:\"ajaxcheck\";N;}}", "yes");
INSERT INTO wptz_options VALUES("2022", "userpro_update_1006", "1", "yes");
INSERT INTO wptz_options VALUES("2023", "userpro_update_1036", "1", "yes");
INSERT INTO wptz_options VALUES("2024", "userpro_update_1046", "1", "yes");
INSERT INTO wptz_options VALUES("2025", "userpro_update_1048", "1", "yes");
INSERT INTO wptz_options VALUES("2026", "userpro_update_1050", "1", "yes");
INSERT INTO wptz_options VALUES("2027", "userpro_update_1051", "1", "yes");
INSERT INTO wptz_options VALUES("2028", "userpro_update_214", "1", "yes");
INSERT INTO wptz_options VALUES("2029", "userpro_update_1052", "1", "yes");
INSERT INTO wptz_options VALUES("2030", "userpro_update_1053", "1", "yes");
INSERT INTO wptz_options VALUES("2031", "userpro_update_1054", "1", "yes");
INSERT INTO wptz_options VALUES("2032", "userpro_update_1055", "1", "yes");
INSERT INTO wptz_options VALUES("2033", "userpro_update_494", "1", "yes");
INSERT INTO wptz_options VALUES("2036", "userpro_sc", "a:2:{s:14:\"slug_following\";s:9:\"following\";s:14:\"slug_followers\";s:9:\"followers\";}", "yes");
INSERT INTO wptz_options VALUES("2037", "userpro_sc_pages", "a:2:{s:9:\"following\";i:391;s:9:\"followers\";i:392;}", "yes");
INSERT INTO wptz_options VALUES("2047", "userpro_activated", "1", "yes");
INSERT INTO wptz_options VALUES("2038", "userpro_mu", "a:2:{s:11:\"multi_forms\";s:0:\"\";s:19:\"multi_forms_default\";s:0:\"\";}", "yes");
INSERT INTO wptz_options VALUES("2039", "userpro_dg", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("2040", "userpro_ed", "a:4:{s:12:\"emd_per_page\";i:20;s:10:\"emd_layout\";s:7:\"masonry\";s:13:\"emd_col_width\";s:3:\"22{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:14:\"emd_col_margin\";s:2:\"2{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";}", "yes");
INSERT INTO wptz_options VALUES("2041", "userpro_rd", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("2042", "userpro_gmap", "a:5:{s:24:\"userpro_gmap_envato_code\";s:0:\"\";s:11:\"enable_gmap\";i:0;s:16:\"userpro_gmap_key\";s:0:\"\";s:14:\"contact_mail_s\";s:28:\"Received Mail via Contact Me\";s:14:\"contact_mail_c\";s:77:\"Hello,\r\n\r\nThanks and Regards,\r\n\r\n<a href=\"{USERPRO_REPLY_URL}\">Click here</a>\";}", "yes");
INSERT INTO wptz_options VALUES("2043", "userpro_timeline", "a:1:{s:15:\"enable_timeline\";i:0;}", "yes");
INSERT INTO wptz_options VALUES("2044", "userpro_pre_icons_setup", "1", "yes");
INSERT INTO wptz_options VALUES("29547", "cf7sr_key", "6Lff4XoUAAAAAL5Ze5sIvcwS3sTmulagDuzmDnhj", "yes");
INSERT INTO wptz_options VALUES("29548", "cf7sr_secret", "6Lff4XoUAAAAAMW-PiW35TUqFABtuBODjkhuYU6x", "yes");
INSERT INTO wptz_options VALUES("29549", "cf7sr_message", "", "yes");
INSERT INTO wptz_options VALUES("29585", "wpseo_sitemap_1_cache_validator", "6QbpG", "no");
INSERT INTO wptz_options VALUES("29586", "wpseo_sitemap_display_type_cache_validator", "2HPZS", "no");
INSERT INTO wptz_options VALUES("3179", "wpseo", "a:20:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:3:\"9.3\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1528317018;s:18:\"recalibration_beta\";b:0;}", "yes");
INSERT INTO wptz_options VALUES("3180", "wpseo_titles", "a:106:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitedesc{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:18:\"title-author-wpseo\";s:41:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}name{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}, Author at {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:19:\"title-archive-wpseo\";s:38:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}date{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:18:\"title-search-wpseo\";s:63:\"You searched for {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}searchphrase{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:15:\"title-404-wpseo\";s:35:\"Page not found {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}POSTLINK{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} appeared first on {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}BLOGLINK{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:52:\"http://csroa.org/wp-content/uploads/2018/04/logo.png\";s:12:\"company_name\";s:47:\"California School Resource Officers Association\";s:17:\"company_or_person\";s:7:\"company\";s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:10:\"title-page\";s:39:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:16:\"title-attachment\";s:39:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:18:\"title-tax-category\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:23:\"post_types-post-maintax\";i:0;s:17:\"title-ai1ec_event\";s:39:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:20:\"metadesc-ai1ec_event\";s:0:\"\";s:19:\"noindex-ai1ec_event\";b:0;s:20:\"showdate-ai1ec_event\";b:0;s:30:\"display-metabox-pt-ai1ec_event\";b:1;s:25:\"title-avia_framework_post\";s:39:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:28:\"metadesc-avia_framework_post\";s:0:\"\";s:27:\"noindex-avia_framework_post\";b:0;s:28:\"showdate-avia_framework_post\";b:0;s:38:\"display-metabox-pt-avia_framework_post\";b:1;s:15:\"title-portfolio\";s:39:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:0;s:18:\"showdate-portfolio\";b:0;s:28:\"display-metabox-pt-portfolio\";b:1;s:27:\"title-ptarchive-ai1ec_event\";s:51:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}pt_plural{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archive {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:30:\"metadesc-ptarchive-ai1ec_event\";s:0:\"\";s:29:\"bctitle-ptarchive-ai1ec_event\";s:0:\"\";s:29:\"noindex-ptarchive-ai1ec_event\";b:0;s:17:\"title-tax-ngg_tag\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:20:\"metadesc-tax-ngg_tag\";s:0:\"\";s:27:\"display-metabox-tax-ngg_tag\";b:1;s:19:\"noindex-tax-ngg_tag\";b:0;s:27:\"title-tax-events_categories\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:30:\"metadesc-tax-events_categories\";s:0:\"\";s:37:\"display-metabox-tax-events_categories\";b:1;s:29:\"noindex-tax-events_categories\";b:0;s:21:\"title-tax-events_tags\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:24:\"metadesc-tax-events_tags\";s:0:\"\";s:31:\"display-metabox-tax-events_tags\";b:1;s:23:\"noindex-tax-events_tags\";b:0;s:27:\"title-tax-portfolio_entries\";s:53:\"{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}term_title{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} Archives {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}page{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sep{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0} {8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}sitename{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}{8df541cf95f9cf207dc57e21b2293dd7fd6c544765e4eb45ff80c07161fc23c0}\";s:30:\"metadesc-tax-portfolio_entries\";s:0:\"\";s:37:\"display-metabox-tax-portfolio_entries\";b:1;s:29:\"noindex-tax-portfolio_entries\";b:0;s:30:\"post_types-ai1ec_event-maintax\";i:0;s:28:\"post_types-portfolio-maintax\";i:0;s:25:\"taxonomy-ngg_tag-ptparent\";i:0;s:35:\"taxonomy-events_categories-ptparent\";i:0;s:29:\"taxonomy-events_tags-ptparent\";i:0;s:35:\"taxonomy-portfolio_entries-ptparent\";i:0;}", "yes");
INSERT INTO wptz_options VALUES("3181", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO wptz_options VALUES("3182", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO wptz_options VALUES("3123", "userpro_invited_users", "", "yes");
INSERT INTO wptz_options VALUES("3126", "userpro_verify_requests", "a:20:{i:1;i:7;i:2;i:10;i:3;i:12;i:4;i:14;i:5;i:16;i:6;i:19;i:7;i:20;i:8;i:24;i:9;i:26;i:11;i:34;i:13;i:47;i:14;i:53;i:15;i:54;i:16;i:55;i:17;i:56;i:18;i:63;i:19;i:65;i:20;i:72;i:21;i:73;i:22;i:74;}", "yes");
INSERT INTO wptz_options VALUES("19172", "widget_bbp_search_widget", "a:2:{i:2;a:1:{s:5:\"title\";s:13:\"Search Forums\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("19173", "widget_bbp_forums_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("19174", "widget_bbp_topics_widget", "a:2:{i:2;a:6:{s:5:\"title\";s:13:\"Recent Topics\";s:8:\"order_by\";s:7:\"newness\";s:12:\"parent_forum\";s:3:\"any\";s:9:\"max_shown\";i:5;s:9:\"show_date\";b:0;s:9:\"show_user\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("19175", "widget_bbp_replies_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("19176", "widget_bbp_stats_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("12930", "adminhash", "a:2:{s:4:\"hash\";s:32:\"e5d0e714b0dd53b81223c271fd9d0d80\";s:8:\"newemail\";s:14:\"info@csroa.org\";}", "yes");
INSERT INTO wptz_options VALUES("7704", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:26:\"linda@wolfeinteractive.com\";s:7:\"version\";s:5:\"4.9.9\";s:9:\"timestamp\";i:1544673615;}", "no");
INSERT INTO wptz_options VALUES("37877", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1546963022", "no");
INSERT INTO wptz_options VALUES("37878", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1546919822", "no");
INSERT INTO wptz_options VALUES("37879", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1546963022", "no");
INSERT INTO wptz_options VALUES("37880", "_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/12/wordpress-5-0-2-maintenance-release/\'>WordPress 5.0.2 Maintenance Release</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-governance-project-flagged-as-unsanctioned-first-meeting-set-for-january-15\'>WPTavern: WordPress Governance Project Flagged as Unsanctioned, First Meeting Set for January 15</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/beaver-builder-doubles-down-on-serving-power-users-in-response-to-gutenberg\'>WPTavern: Beaver Builder Doubles Down on Serving Power Users in Response to Gutenberg</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wp-storybook-a-handy-reference-for-wordpress-react-ui-components\'>WPTavern: WP Storybook: A Handy Reference for WordPress React UI Components</a></li></ul></div>", "no");
INSERT INTO wptz_options VALUES("37885", "_transient_timeout_plugin_slugs", "1547006226", "no");
INSERT INTO wptz_options VALUES("37886", "_transient_plugin_slugs", "a:17:{i:0;s:19:\"akismet/akismet.php\";i:1;s:55:\"all-in-one-event-calendar/all-in-one-event-calendar.php\";i:2;s:19:\"bbpress/bbpress.php\";i:3;s:47:\"better-search-replace/better-search-replace.php\";i:4;s:33:\"classic-editor/classic-editor.php\";i:5;s:36:\"contact-form-7/wp-contact-form-7.php\";i:6;s:42:\"contact-form-cfdb7/contact-form-cfdb-7.php\";i:7;s:32:\"duplicate-page/duplicatepage.php\";i:8;s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";i:9;s:29:\"nextgen-gallery/nggallery.php\";i:10;s:29:\"pdf-embedder/pdf_embedder.php\";i:11;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:12;s:49:\"acurax-social-media-widget/acurax-social-icon.php\";i:13;s:17:\"userpro/index.php\";i:14;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:15;s:17:\"wp-ceo/wp-ceo.php\";i:16;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO wptz_options VALUES("37887", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1546930650", "no");
INSERT INTO wptz_options VALUES("37888", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4538;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:3206;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2605;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2463;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1897;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1707;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1693;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1462;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1419;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1419;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1417;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1347;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1288;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1275;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1128;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1084;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1069;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1044;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:967;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:911;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:840;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:827;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:815;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:752;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:720;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:709;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:704;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:701;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:692;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:682;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:674;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:672;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:654;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:648;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:635;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:630;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:622;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:611;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:611;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:607;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:575;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:560;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:554;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:551;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:551;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:543;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:528;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:521;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:521;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:520;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:515;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:506;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:500;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:491;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:490;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:486;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:468;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:468;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:462;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:454;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:451;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:449;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:448;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:429;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:429;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:423;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:419;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:417;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:412;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:398;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:392;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:392;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:382;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:376;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:375;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:374;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:373;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:373;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:360;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:357;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:356;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:353;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:348;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:346;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:343;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:340;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:339;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:335;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:322;}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";i:318;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:317;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:315;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:314;}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";i:310;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:309;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:305;}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";i:305;}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";i:304;}s:6:\"author\";a:3:{s:4:\"name\";s:6:\"author\";s:4:\"slug\";s:6:\"author\";s:5:\"count\";i:303;}s:7:\"adsense\";a:3:{s:4:\"name\";s:7:\"adsense\";s:4:\"slug\";s:7:\"adsense\";s:5:\"count\";i:303;}}", "no");
INSERT INTO wptz_options VALUES("35463", "db_upgraded", "", "yes");
INSERT INTO wptz_options VALUES("37804", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1546890500;s:7:\"checked\";a:5:{s:6:\"enfold\";s:5:\"4.2.6\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:14:\"twentynineteen\";s:3:\"1.1\";s:15:\"twentyseventeen\";s:3:\"1.6\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:3:{s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.2.2.zip\";}s:15:\"twentyseventeen\";a:4:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.1.9.zip\";}s:13:\"twentysixteen\";a:4:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.1.7.zip\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wptz_options VALUES("37805", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1546919824;s:8:\"response\";a:2:{s:32:\"duplicate-page/duplicatepage.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-page\";s:4:\"slug\";s:14:\"duplicate-page\";s:6:\"plugin\";s:32:\"duplicate-page/duplicatepage.php\";s:11:\"new_version\";s:3:\"3.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-page/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/duplicate-page.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-page/assets/icon-128x128.jpg?rev=1412874\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-page/assets/banner-772x250.jpg?rev=1410328\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.0.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:94:\"home/csroa/public_html/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";O:8:\"stdClass\":10:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:94:\"home/csroa/public_html/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:7:\"version\";s:5:\"6.7.6\";s:5:\"icons\";a:3:{s:2:\"1x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png\";s:2:\"2x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";s:7:\"default\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";}s:7:\"banners\";a:3:{s:3:\"low\";s:84:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png\";s:4:\"high\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";s:7:\"default\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";}s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:3:\"5.0\";s:14:\"upgrade_notice\";s:62:\"This update contains new privacy settings for GDPR compliance.\";s:11:\"new_version\";s:5:\"6.7.6\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:14:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"4.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.4.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:55:\"all-in-one-event-calendar/all-in-one-event-calendar.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:39:\"w.org/plugins/all-in-one-event-calendar\";s:4:\"slug\";s:25:\"all-in-one-event-calendar\";s:6:\"plugin\";s:55:\"all-in-one-event-calendar/all-in-one-event-calendar.php\";s:11:\"new_version\";s:6:\"2.5.36\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/all-in-one-event-calendar/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/all-in-one-event-calendar.2.5.36.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/all-in-one-event-calendar/assets/icon-256x256.png?rev=1995598\";s:2:\"1x\";s:78:\"https://ps.w.org/all-in-one-event-calendar/assets/icon-128x128.png?rev=1995598\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:80:\"https://ps.w.org/all-in-one-event-calendar/assets/banner-772x250.png?rev=1995601\";}s:11:\"banners_rtl\";a:0:{}}s:19:\"bbpress/bbpress.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/bbpress\";s:4:\"slug\";s:7:\"bbpress\";s:6:\"plugin\";s:19:\"bbpress/bbpress.php\";s:11:\"new_version\";s:6:\"2.5.14\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/bbpress/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:60:\"https://ps.w.org/bbpress/assets/icon-256x256.png?rev=1534011\";s:2:\"1x\";s:51:\"https://ps.w.org/bbpress/assets/icon.svg?rev=978290\";s:3:\"svg\";s:51:\"https://ps.w.org/bbpress/assets/icon.svg?rev=978290\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/bbpress/assets/banner-1544x500.png?rev=567403\";s:2:\"1x\";s:61:\"https://ps.w.org/bbpress/assets/banner-772x250.png?rev=478663\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/bbpress/assets/banner-1544x500-rtl.png?rev=1534011\";s:2:\"1x\";s:66:\"https://ps.w.org/bbpress/assets/banner-772x250-rtl.png?rev=1534011\";}}s:47:\"better-search-replace/better-search-replace.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:35:\"w.org/plugins/better-search-replace\";s:4:\"slug\";s:21:\"better-search-replace\";s:6:\"plugin\";s:47:\"better-search-replace/better-search-replace.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/better-search-replace/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/better-search-replace.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-256x256.png?rev=1238934\";s:2:\"1x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-128x128.png?rev=1238934\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/better-search-replace/assets/banner-1544x500.png?rev=1238934\";s:2:\"1x\";s:76:\"https://ps.w.org/better-search-replace/assets/banner-772x250.png?rev=1238934\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/classic-editor.1.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.1.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}}s:42:\"contact-form-cfdb7/contact-form-cfdb-7.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/contact-form-cfdb7\";s:4:\"slug\";s:18:\"contact-form-cfdb7\";s:6:\"plugin\";s:42:\"contact-form-cfdb7/contact-form-cfdb-7.php\";s:11:\"new_version\";s:7:\"1.2.4.5\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/contact-form-cfdb7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-cfdb7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/contact-form-cfdb7/assets/icon-256x256.png?rev=1619878\";s:2:\"1x\";s:71:\"https://ps.w.org/contact-form-cfdb7/assets/icon-128x128.png?rev=1619878\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/contact-form-cfdb7/assets/banner-772x250.png?rev=1619902\";}s:11:\"banners_rtl\";a:0:{}}s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:47:\"w.org/plugins/google-analytics-dashboard-for-wp\";s:4:\"slug\";s:33:\"google-analytics-dashboard-for-wp\";s:6:\"plugin\";s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";s:11:\"new_version\";s:5:\"5.3.7\";s:3:\"url\";s:64:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\";s:7:\"package\";s:82:\"https://downloads.wordpress.org/plugin/google-analytics-dashboard-for-wp.5.3.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:85:\"https://ps.w.org/google-analytics-dashboard-for-wp/assets/icon-256x256.png?rev=970326\";s:2:\"1x\";s:85:\"https://ps.w.org/google-analytics-dashboard-for-wp/assets/icon-128x128.png?rev=970326\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:88:\"https://ps.w.org/google-analytics-dashboard-for-wp/assets/banner-772x250.png?rev=1064664\";}s:11:\"banners_rtl\";a:0:{}}s:29:\"nextgen-gallery/nggallery.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:29:\"w.org/plugins/nextgen-gallery\";s:4:\"slug\";s:15:\"nextgen-gallery\";s:6:\"plugin\";s:29:\"nextgen-gallery/nggallery.php\";s:11:\"new_version\";s:5:\"3.1.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/nextgen-gallery/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/nextgen-gallery.3.1.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/nextgen-gallery/assets/icon-256x256.png?rev=1875408\";s:2:\"1x\";s:68:\"https://ps.w.org/nextgen-gallery/assets/icon-128x128.png?rev=1875408\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/nextgen-gallery/assets/banner-1544x500.png?rev=1962188\";s:2:\"1x\";s:70:\"https://ps.w.org/nextgen-gallery/assets/banner-772x250.png?rev=1962188\";}s:11:\"banners_rtl\";a:0:{}}s:29:\"pdf-embedder/pdf_embedder.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:26:\"w.org/plugins/pdf-embedder\";s:4:\"slug\";s:12:\"pdf-embedder\";s:6:\"plugin\";s:29:\"pdf-embedder/pdf_embedder.php\";s:11:\"new_version\";s:3:\"4.0\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/pdf-embedder/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/pdf-embedder.4.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/pdf-embedder/assets/icon-256x256.png?rev=1072588\";s:2:\"1x\";s:65:\"https://ps.w.org/pdf-embedder/assets/icon-128x128.png?rev=1072588\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/pdf-embedder/assets/banner-1544x500.png?rev=1629344\";s:2:\"1x\";s:67:\"https://ps.w.org/pdf-embedder/assets/banner-772x250.png?rev=1629344\";}s:11:\"banners_rtl\";a:0:{}}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"3.1.3\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.3.1.3.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=1782452\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.jpg?rev=1881345\";}s:11:\"banners_rtl\";a:0:{}}s:49:\"acurax-social-media-widget/acurax-social-icon.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:40:\"w.org/plugins/acurax-social-media-widget\";s:4:\"slug\";s:26:\"acurax-social-media-widget\";s:6:\"plugin\";s:49:\"acurax-social-media-widget/acurax-social-icon.php\";s:11:\"new_version\";s:5:\"3.2.7\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/acurax-social-media-widget/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/acurax-social-media-widget.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/acurax-social-media-widget/assets/icon-128x128.jpg?rev=1564775\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:81:\"https://ps.w.org/acurax-social-media-widget/assets/banner-772x250.jpg?rev=1564775\";}s:11:\"banners_rtl\";a:0:{}}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/wp-clone-by-wp-academy\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:5:\"2.2.4\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.2.4.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:73:\"https://s.w.org/plugins/geopattern-icon/wp-clone-by-wp-academy_e6cd21.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/wp-clone-by-wp-academy/assets/banner-772x250.jpg?rev=706555\";}s:11:\"banners_rtl\";a:0:{}}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:3:\"9.3\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.3.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=1834347\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1843435\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1843435\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1843435\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=1843435\";}}}}", "no");
INSERT INTO wptz_options VALUES("3233", "WPLANG", "", "yes");
INSERT INTO wptz_options VALUES("3234", "new_admin_email", "info@csroa.org", "yes");
INSERT INTO wptz_options VALUES("29541", "anr_admin_options", "a:8:{s:8:\"site_key\";s:40:\"6Lc23HoUAAAAANxPzKiUHQzdsS8_1V8Rq0GuwnZD\";s:10:\"secret_key\";s:40:\"6Lc23HoUAAAAAMdAMfc9RTMxH4unrvIiq0wFF6nG\";s:8:\"language\";s:0:\"\";s:5:\"theme\";s:5:\"light\";s:4:\"size\";s:6:\"normal\";s:5:\"badge\";s:11:\"bottomright\";s:13:\"error_message\";s:55:\"<strong>ERROR</strong>: Please solve Captcha correctly.\";s:18:\"failed_login_allow\";s:1:\"0\";}", "yes");
INSERT INTO wptz_options VALUES("16522", "pdfemb_poweredby", "1", "no");
INSERT INTO wptz_options VALUES("19170", "widget_bbp_login_widget", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:8:\"register\";s:0:\"\";s:8:\"lostpass\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wptz_options VALUES("35483", "_transient_timeout_wpseo_link_table_inaccessible", "1577054457", "no");
INSERT INTO wptz_options VALUES("35484", "_transient_wpseo_link_table_inaccessible", "0", "no");
INSERT INTO wptz_options VALUES("35485", "_transient_timeout_wpseo_meta_table_inaccessible", "1577054457", "no");
INSERT INTO wptz_options VALUES("35486", "_transient_wpseo_meta_table_inaccessible", "0", "no");
INSERT INTO wptz_options VALUES("29776", "wpseo_sitemap_category_cache_validator", "48Ypc", "no");
INSERT INTO wptz_options VALUES("19178", "_bbp_private_forums", "a:1:{i:0;i:496;}", "yes");
INSERT INTO wptz_options VALUES("19179", "_bbp_hidden_forums", "a:0:{}", "yes");
INSERT INTO wptz_options VALUES("19180", "_bbp_db_version", "250", "yes");
INSERT INTO wptz_options VALUES("30761", "wpseo_sitemap_ai1ec_event_cache_validator", "6cFdq", "no");
INSERT INTO wptz_options VALUES("35503", "userpro_cached_results", "a:22:{i:0;b:0;s:460:\"a:6:{s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:10:\"meta_query\";a:3:{s:8:\"relation\";s:3:\"AND\";i:0;a:2:{s:3:\"key\";s:15:\"profile_privacy\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:8:\"relation\";s:2:\"OR\";i:0;a:2:{s:3:\"key\";s:22:\"userpro_account_status\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:3:\"key\";s:22:\"userpro_account_status\";s:5:\"value\";s:1:\"1\";s:7:\"compare\";s:2:\"!=\";}}}s:7:\"orderby\";s:10:\"registered\";s:5:\"order\";s:4:\"DESC\";s:6:\"number\";i:12;s:6:\"offset\";i:0;}\";O:13:\"WP_User_Query\":11:{s:10:\"query_vars\";a:27:{s:7:\"blog_id\";i:1;s:4:\"role\";s:0:\"\";s:8:\"role__in\";a:0:{}s:12:\"role__not_in\";a:0:{}s:8:\"meta_key\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:12:\"meta_compare\";s:0:\"\";s:7:\"include\";a:0:{}s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:6:\"search\";s:0:\"\";s:14:\"search_columns\";a:0:{}s:7:\"orderby\";s:10:\"registered\";s:5:\"order\";s:4:\"DESC\";s:6:\"offset\";i:0;s:6:\"number\";i:12;s:5:\"paged\";i:1;s:11:\"count_total\";b:1;s:6:\"fields\";s:3:\"all\";s:3:\"who\";s:0:\"\";s:19:\"has_published_posts\";N;s:8:\"nicename\";s:0:\"\";s:12:\"nicename__in\";a:0:{}s:16:\"nicename__not_in\";a:0:{}s:5:\"login\";s:0:\"\";s:9:\"login__in\";a:0:{}s:13:\"login__not_in\";a:0:{}s:10:\"meta_query\";a:3:{s:8:\"relation\";s:3:\"AND\";i:0;a:2:{s:3:\"key\";s:15:\"profile_privacy\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:8:\"relation\";s:2:\"OR\";i:0;a:2:{s:3:\"key\";s:22:\"userpro_account_status\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:3:\"key\";s:22:\"userpro_account_status\";s:5:\"value\";s:1:\"1\";s:7:\"compare\";s:2:\"!=\";}}}}s:22:\"\0WP_User_Query\0results\";a:12:{i:0;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"76\";s:10:\"user_login\";s:12:\"wallpaperbri\";s:9:\"user_pass\";s:34:\"$P$BbRK/SDB2ZKa4xX6GEG6JqvDfrMboz.\";s:13:\"user_nicename\";s:12:\"wallpaperbri\";s:10:\"user_email\";s:21:\"murphy.brian@lusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-11 17:29:42\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"wallpaperbri\";}s:2:\"ID\";i:76;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:1;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"75\";s:10:\"user_login\";s:8:\"jjrr2468\";s:9:\"user_pass\";s:34:\"$P$BVj7.Km0jW.jtxeEvBYDWG.6HBap58.\";s:13:\"user_nicename\";s:8:\"jjrr2468\";s:10:\"user_email\";s:23:\"rivera_joseph@lacoe.edu\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-10 22:18:25\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:8:\"jjrr2468\";}s:2:\"ID\";i:75;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:2;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"74\";s:10:\"user_login\";s:15:\"bommersbachpaul\";s:9:\"user_pass\";s:34:\"$P$BAmXbQuaXU.Rr5Ng/LkI7ij4LkcHSb0\";s:13:\"user_nicename\";s:15:\"bommersbachpaul\";s:10:\"user_email\";s:25:\"bommersbach.paul@lusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 21:59:22\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:15:\"bommersbachpaul\";}s:2:\"ID\";i:74;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:3;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"73\";s:10:\"user_login\";s:7:\"dmcphee\";s:9:\"user_pass\";s:34:\"$P$Bk5cSP6mpjkgzcdTuGcDPJVCys/FzM.\";s:13:\"user_nicename\";s:7:\"dmcphee\";s:10:\"user_email\";s:20:\"dmcphee@valverde.edu\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 21:51:29\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"dmcphee\";}s:2:\"ID\";i:73;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:4;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"72\";s:10:\"user_login\";s:8:\"wallacek\";s:9:\"user_pass\";s:34:\"$P$BLs8NgsbATL0YfvQF8aNvsfKvSm8wS0\";s:13:\"user_nicename\";s:8:\"wallacek\";s:10:\"user_email\";s:26:\"Wallace.katherine@lusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 21:06:42\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"Katy Wallace\";}s:2:\"ID\";i:72;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:5;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"71\";s:10:\"user_login\";s:5:\"aleon\";s:9:\"user_pass\";s:34:\"$P$Bsau4xt6k2g3XqUSMvuSEHVVf0sc9R.\";s:13:\"user_nicename\";s:5:\"aleon\";s:10:\"user_email\";s:25:\"Alejandro.leon@emuhsd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 20:32:47\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:5:\"ALEON\";}s:2:\"ID\";i:71;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:6;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"70\";s:10:\"user_login\";s:5:\"bcarr\";s:9:\"user_pass\";s:34:\"$P$Bm7WCp4IUa0GJO6xd9FqiDoAIGMOxj1\";s:13:\"user_nicename\";s:5:\"bcarr\";s:10:\"user_email\";s:16:\"bcarr@vvuhsd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 20:19:25\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"DrBCarr\";}s:2:\"ID\";i:70;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:7;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"69\";s:10:\"user_login\";s:9:\"tminjares\";s:9:\"user_pass\";s:34:\"$P$Bcg7h6uKJiggS0o9Mq8p4ZsTAG/q26.\";s:13:\"user_nicename\";s:9:\"tminjares\";s:10:\"user_email\";s:23:\"tminjares@teh.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-06 18:18:53\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:5:\"Traci\";}s:2:\"ID\";i:69;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:8;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"68\";s:10:\"user_login\";s:10:\"erouanzoin\";s:9:\"user_pass\";s:34:\"$P$Bx5ug3PAiBTYS82ricF9j5xoQAHnfP/\";s:13:\"user_nicename\";s:10:\"erouanzoin\";s:10:\"user_email\";s:25:\"errouanzoin@fruitvale.net\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-06 16:22:14\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:10:\"erouanzoin\";}s:2:\"ID\";i:68;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:9;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"67\";s:10:\"user_login\";s:12:\"slotownrocks\";s:9:\"user_pass\";s:34:\"$P$BQ5MQ.bK9uSuf1/3XCwlPpIrYKdJeC/\";s:13:\"user_nicename\";s:12:\"slotownrocks\";s:10:\"user_email\";s:19:\"dmorrison@ssusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-06 16:19:24\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"slotownrocks\";}s:2:\"ID\";i:67;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:10;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"66\";s:10:\"user_login\";s:8:\"srogreen\";s:9:\"user_pass\";s:34:\"$P$BPYcn5FGKPDcC6KOQdkLbPJZmCnmU0.\";s:13:\"user_nicename\";s:8:\"srogreen\";s:10:\"user_email\";s:19:\"green@ci.weed.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-04 18:13:17\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:9:\"SRO Green\";}s:2:\"ID\";i:66;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:11;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"65\";s:10:\"user_login\";s:8:\"humberto\";s:9:\"user_pass\";s:34:\"$P$B3OQ5T.qDszlY/bVymKhA8xOJA0Isa0\";s:13:\"user_nicename\";s:8:\"humberto\";s:10:\"user_email\";s:28:\"humberto_coronado@nmcusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-11-07 19:15:49\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:17:\"Humberto Coronado\";}s:2:\"ID\";i:65;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}}s:26:\"\0WP_User_Query\0total_users\";i:75;s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:3:{i:0;a:2:{s:3:\"key\";s:15:\"profile_privacy\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{i:0;a:2:{s:3:\"key\";s:22:\"userpro_account_status\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:3:\"key\";s:22:\"userpro_account_status\";s:5:\"value\";s:1:\"1\";s:7:\"compare\";s:2:\"!=\";}s:8:\"relation\";s:2:\"OR\";}s:8:\"relation\";s:3:\"AND\";}s:8:\"relation\";s:3:\"AND\";s:10:\"meta_table\";s:13:\"wptz_usermeta\";s:14:\"meta_id_column\";s:7:\"user_id\";s:13:\"primary_table\";s:10:\"wptz_users\";s:17:\"primary_id_column\";s:2:\"ID\";s:16:\"\0*\0table_aliases\";a:3:{i:0;s:13:\"wptz_usermeta\";i:1;s:3:\"mt1\";i:2;s:3:\"mt2\";}s:10:\"\0*\0clauses\";a:3:{s:13:\"wptz_usermeta\";a:4:{s:3:\"key\";s:15:\"profile_privacy\";s:7:\"compare\";s:10:\"NOT EXISTS\";s:5:\"alias\";s:13:\"wptz_usermeta\";s:4:\"cast\";s:4:\"CHAR\";}s:3:\"mt1\";a:4:{s:3:\"key\";s:22:\"userpro_account_status\";s:7:\"compare\";s:10:\"NOT EXISTS\";s:5:\"alias\";s:3:\"mt1\";s:4:\"cast\";s:4:\"CHAR\";}s:3:\"mt2\";a:5:{s:3:\"key\";s:22:\"userpro_account_status\";s:5:\"value\";s:1:\"1\";s:7:\"compare\";s:2:\"!=\";s:5:\"alias\";s:3:\"mt2\";s:4:\"cast\";s:4:\"CHAR\";}}s:18:\"\0*\0has_or_relation\";b:1;}s:7:\"request\";s:602:\"SELECT DISTINCT SQL_CALC_FOUND_ROWS wptz_users.* FROM wptz_users LEFT JOIN wptz_usermeta ON (wptz_users.ID = wptz_usermeta.user_id AND wptz_usermeta.meta_key = \'profile_privacy\' )  LEFT JOIN wptz_usermeta AS mt1 ON (wptz_users.ID = mt1.user_id AND mt1.meta_key = \'userpro_account_status\' )  LEFT JOIN wptz_usermeta AS mt2 ON ( wptz_users.ID = mt2.user_id ) WHERE 1=1 AND ( \n  wptz_usermeta.user_id IS NULL \n  AND \n  ( \n    mt1.user_id IS NULL \n    OR \n    ( mt2.meta_key = \'userpro_account_status\' AND mt2.meta_value != \'1\' )\n  )\n) AND wptz_users.ID NOT IN (0) ORDER BY user_registered DESC LIMIT 0, 12\";s:28:\"\0WP_User_Query\0compat_fields\";a:2:{i:0;s:7:\"results\";i:1;s:11:\"total_users\";}s:12:\"query_fields\";s:41:\"DISTINCT SQL_CALC_FOUND_ROWS wptz_users.*\";s:10:\"query_from\";s:307:\"FROM wptz_users LEFT JOIN wptz_usermeta ON (wptz_users.ID = wptz_usermeta.user_id AND wptz_usermeta.meta_key = \'profile_privacy\' )  LEFT JOIN wptz_usermeta AS mt1 ON (wptz_users.ID = mt1.user_id AND mt1.meta_key = \'userpro_account_status\' )  LEFT JOIN wptz_usermeta AS mt2 ON ( wptz_users.ID = mt2.user_id )\";s:11:\"query_where\";s:203:\"WHERE 1=1 AND ( \n  wptz_usermeta.user_id IS NULL \n  AND \n  ( \n    mt1.user_id IS NULL \n    OR \n    ( mt2.meta_key = \'userpro_account_status\' AND mt2.meta_value != \'1\' )\n  )\n) AND wptz_users.ID NOT IN (0)\";s:13:\"query_orderby\";s:29:\"ORDER BY user_registered DESC\";s:11:\"query_limit\";s:11:\"LIMIT 0, 12\";}s:446:\"a:5:{s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:10:\"meta_query\";a:3:{s:8:\"relation\";s:3:\"AND\";i:0;a:2:{s:3:\"key\";s:15:\"profile_privacy\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:8:\"relation\";s:2:\"OR\";i:0;a:2:{s:3:\"key\";s:22:\"userpro_account_status\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:3:\"key\";s:22:\"userpro_account_status\";s:5:\"value\";s:1:\"1\";s:7:\"compare\";s:2:\"!=\";}}}s:7:\"orderby\";s:10:\"registered\";s:5:\"order\";s:4:\"DESC\";s:6:\"number\";i:10000;}\";O:13:\"WP_User_Query\":11:{s:10:\"query_vars\";a:27:{s:7:\"blog_id\";i:1;s:4:\"role\";s:0:\"\";s:8:\"role__in\";a:0:{}s:12:\"role__not_in\";a:0:{}s:8:\"meta_key\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:12:\"meta_compare\";s:0:\"\";s:7:\"include\";a:0:{}s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:6:\"search\";s:0:\"\";s:14:\"search_columns\";a:0:{}s:7:\"orderby\";s:10:\"registered\";s:5:\"order\";s:4:\"DESC\";s:6:\"offset\";s:0:\"\";s:6:\"number\";i:10000;s:5:\"paged\";i:1;s:11:\"count_total\";b:1;s:6:\"fields\";s:3:\"all\";s:3:\"who\";s:0:\"\";s:19:\"has_published_posts\";N;s:8:\"nicename\";s:0:\"\";s:12:\"nicename__in\";a:0:{}s:16:\"nicename__not_in\";a:0:{}s:5:\"login\";s:0:\"\";s:9:\"login__in\";a:0:{}s:13:\"login__not_in\";a:0:{}s:10:\"meta_query\";a:3:{s:8:\"relation\";s:3:\"AND\";i:0;a:2:{s:3:\"key\";s:15:\"profile_privacy\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:8:\"relation\";s:2:\"OR\";i:0;a:2:{s:3:\"key\";s:22:\"userpro_account_status\";s:7:\"compare\";s:10:\"NOT EXISTS\";}i:1;a:3:{s:3:\"key\";s:22:\"userpro_account_status\";s:5:\"value\";s:1:\"1\";s:7:\"compare\";s:2:\"!=\";}}}}s:22:\"\0WP_User_Query\0results\";a:75:{i:0;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"76\";s:10:\"user_login\";s:12:\"wallpaperbri\";s:9:\"user_pass\";s:34:\"$P$BbRK/SDB2ZKa4xX6GEG6JqvDfrMboz.\";s:13:\"user_nicename\";s:12:\"wallpaperbri\";s:10:\"user_email\";s:21:\"murphy.brian@lusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-11 17:29:42\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"wallpaperbri\";}s:2:\"ID\";i:76;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:1;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"75\";s:10:\"user_login\";s:8:\"jjrr2468\";s:9:\"user_pass\";s:34:\"$P$BVj7.Km0jW.jtxeEvBYDWG.6HBap58.\";s:13:\"user_nicename\";s:8:\"jjrr2468\";s:10:\"user_email\";s:23:\"rivera_joseph@lacoe.edu\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-10 22:18:25\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:8:\"jjrr2468\";}s:2:\"ID\";i:75;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:2;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"74\";s:10:\"user_login\";s:15:\"bommersbachpaul\";s:9:\"user_pass\";s:34:\"$P$BAmXbQuaXU.Rr5Ng/LkI7ij4LkcHSb0\";s:13:\"user_nicename\";s:15:\"bommersbachpaul\";s:10:\"user_email\";s:25:\"bommersbach.paul@lusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 21:59:22\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:15:\"bommersbachpaul\";}s:2:\"ID\";i:74;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:3;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"73\";s:10:\"user_login\";s:7:\"dmcphee\";s:9:\"user_pass\";s:34:\"$P$Bk5cSP6mpjkgzcdTuGcDPJVCys/FzM.\";s:13:\"user_nicename\";s:7:\"dmcphee\";s:10:\"user_email\";s:20:\"dmcphee@valverde.edu\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 21:51:29\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"dmcphee\";}s:2:\"ID\";i:73;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:4;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"72\";s:10:\"user_login\";s:8:\"wallacek\";s:9:\"user_pass\";s:34:\"$P$BLs8NgsbATL0YfvQF8aNvsfKvSm8wS0\";s:13:\"user_nicename\";s:8:\"wallacek\";s:10:\"user_email\";s:26:\"Wallace.katherine@lusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 21:06:42\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"Katy Wallace\";}s:2:\"ID\";i:72;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:5;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"71\";s:10:\"user_login\";s:5:\"aleon\";s:9:\"user_pass\";s:34:\"$P$Bsau4xt6k2g3XqUSMvuSEHVVf0sc9R.\";s:13:\"user_nicename\";s:5:\"aleon\";s:10:\"user_email\";s:25:\"Alejandro.leon@emuhsd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 20:32:47\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:5:\"ALEON\";}s:2:\"ID\";i:71;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:6;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"70\";s:10:\"user_login\";s:5:\"bcarr\";s:9:\"user_pass\";s:34:\"$P$Bm7WCp4IUa0GJO6xd9FqiDoAIGMOxj1\";s:13:\"user_nicename\";s:5:\"bcarr\";s:10:\"user_email\";s:16:\"bcarr@vvuhsd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-08 20:19:25\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"DrBCarr\";}s:2:\"ID\";i:70;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:7;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"69\";s:10:\"user_login\";s:9:\"tminjares\";s:9:\"user_pass\";s:34:\"$P$Bcg7h6uKJiggS0o9Mq8p4ZsTAG/q26.\";s:13:\"user_nicename\";s:9:\"tminjares\";s:10:\"user_email\";s:23:\"tminjares@teh.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-06 18:18:53\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:5:\"Traci\";}s:2:\"ID\";i:69;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:8;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"68\";s:10:\"user_login\";s:10:\"erouanzoin\";s:9:\"user_pass\";s:34:\"$P$Bx5ug3PAiBTYS82ricF9j5xoQAHnfP/\";s:13:\"user_nicename\";s:10:\"erouanzoin\";s:10:\"user_email\";s:25:\"errouanzoin@fruitvale.net\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-06 16:22:14\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:10:\"erouanzoin\";}s:2:\"ID\";i:68;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:9;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"67\";s:10:\"user_login\";s:12:\"slotownrocks\";s:9:\"user_pass\";s:34:\"$P$BQ5MQ.bK9uSuf1/3XCwlPpIrYKdJeC/\";s:13:\"user_nicename\";s:12:\"slotownrocks\";s:10:\"user_email\";s:19:\"dmorrison@ssusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-06 16:19:24\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"slotownrocks\";}s:2:\"ID\";i:67;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:10;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"66\";s:10:\"user_login\";s:8:\"srogreen\";s:9:\"user_pass\";s:34:\"$P$BPYcn5FGKPDcC6KOQdkLbPJZmCnmU0.\";s:13:\"user_nicename\";s:8:\"srogreen\";s:10:\"user_email\";s:19:\"green@ci.weed.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-12-04 18:13:17\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:9:\"SRO Green\";}s:2:\"ID\";i:66;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:11;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"65\";s:10:\"user_login\";s:8:\"humberto\";s:9:\"user_pass\";s:34:\"$P$B3OQ5T.qDszlY/bVymKhA8xOJA0Isa0\";s:13:\"user_nicename\";s:8:\"humberto\";s:10:\"user_email\";s:28:\"humberto_coronado@nmcusd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-11-07 19:15:49\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:17:\"Humberto Coronado\";}s:2:\"ID\";i:65;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:12;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"64\";s:10:\"user_login\";s:9:\"brmaberry\";s:9:\"user_pass\";s:34:\"$P$B4Pb5nxTC8xtmn1wDPxnfimq13ryCS0\";s:13:\"user_nicename\";s:9:\"brmaberry\";s:10:\"user_email\";s:19:\"brmaberry@wuesd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-11-02 15:49:13\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:9:\"brmaberry\";}s:2:\"ID\";i:64;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:13;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"63\";s:10:\"user_login\";s:7:\"bullock\";s:9:\"user_pass\";s:34:\"$P$BrCbiKKTAfgTRarBvhQfqQnXYco59Z/\";s:13:\"user_nicename\";s:7:\"bullock\";s:10:\"user_email\";s:25:\"jbullock@hilmar.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-29 16:23:17\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:11:\"Jim Bullock\";}s:2:\"ID\";i:63;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:14;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"62\";s:10:\"user_login\";s:16:\"wheatcheckgeld44\";s:9:\"user_pass\";s:34:\"$P$BoZ789z/YQLeAS37C1xg1b4lraHrOT/\";s:13:\"user_nicename\";s:16:\"wheatcheckgeld44\";s:10:\"user_email\";s:23:\"kaleros.milders@onet.eu\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-28 18:41:17\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:16:\"wheatcheckgeld44\";}s:2:\"ID\";i:62;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:15;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"61\";s:10:\"user_login\";s:14:\"meaganforsberg\";s:9:\"user_pass\";s:34:\"$P$BnXl4yzwcTxfrBO6sbOAqf2kgly8BV.\";s:13:\"user_nicename\";s:14:\"meaganforsberg\";s:10:\"user_email\";s:19:\"mforsberg@sbcsd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-22 21:14:29\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:14:\"meaganforsberg\";}s:2:\"ID\";i:61;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:16;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"60\";s:10:\"user_login\";s:11:\"dhansen4425\";s:9:\"user_pass\";s:34:\"$P$Bj3TN5gCKbGGvWmJ7ZV3haVjC9IoH41\";s:13:\"user_nicename\";s:11:\"dhansen4425\";s:10:\"user_email\";s:33:\"dhansen@townofmammothlakes.ca.gov\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-22 20:10:55\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:13:\"Daniel Hansen\";}s:2:\"ID\";i:60;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:17;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"59\";s:10:\"user_login\";s:7:\"osaki85\";s:9:\"user_pass\";s:34:\"$P$BMPpe.KU6fUlahaMyf3Vqdn3hZNss2/\";s:13:\"user_nicename\";s:7:\"osaki85\";s:10:\"user_email\";s:28:\"marlena.spytowska@cyberia.pl\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-09 22:17:19\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"osaki85\";}s:2:\"ID\";i:59;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:18;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"58\";s:10:\"user_login\";s:8:\"wariga70\";s:9:\"user_pass\";s:34:\"$P$ByI2bj9SVlo7BVLp42EQY2ruGOtzT4/\";s:13:\"user_nicename\";s:8:\"wariga70\";s:10:\"user_email\";s:24:\"anch.wac@maildeviant.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-09 16:45:30\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:8:\"wariga70\";}s:2:\"ID\";i:58;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:19;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"57\";s:10:\"user_login\";s:13:\"waffleiron636\";s:9:\"user_pass\";s:34:\"$P$BArNDNLIL8Lv34jQWzcS/QhlhEetvH0\";s:13:\"user_nicename\";s:13:\"waffleiron636\";s:10:\"user_email\";s:23:\"waffleiron636@yahoo.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-07 16:27:12\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:13:\"waffleiron636\";}s:2:\"ID\";i:57;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:20;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"56\";s:10:\"user_login\";s:12:\"safetyfirst4\";s:9:\"user_pass\";s:34:\"$P$BhgWD27YfZirorxeffNfYbEVWj2UfA1\";s:13:\"user_nicename\";s:12:\"safetyfirst4\";s:10:\"user_email\";s:19:\"moei@dusd.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-05 17:19:54\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"safetyfirst4\";}s:2:\"ID\";i:56;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:21;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"55\";s:10:\"user_login\";s:8:\"meltread\";s:9:\"user_pass\";s:34:\"$P$Bdr6.OwE4f2/UQ/ei4TggsskAnfSS/1\";s:13:\"user_nicename\";s:8:\"meltread\";s:10:\"user_email\";s:25:\"mtreadwell@dusd.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-05 17:01:41\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:8:\"meltread\";}s:2:\"ID\";i:55;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:22;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"54\";s:10:\"user_login\";s:9:\"zumbaking\";s:9:\"user_pass\";s:34:\"$P$BsWieb8lq.okyGkojagLGX5WFJkLW8.\";s:13:\"user_nicename\";s:9:\"zumbaking\";s:10:\"user_email\";s:27:\"darrin.ellis@co.kings.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-04 17:11:25\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"Deputy Ellis\";}s:2:\"ID\";i:54;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:23;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"53\";s:10:\"user_login\";s:12:\"christopher1\";s:9:\"user_pass\";s:34:\"$P$B.JfN5QQQFvBvYxNahS/OuURvmIi/b1\";s:13:\"user_nicename\";s:12:\"christopher1\";s:10:\"user_email\";s:16:\"Cday@stancoe.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-04 15:53:07\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:15:\"Christopher Day\";}s:2:\"ID\";i:53;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:24;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"52\";s:10:\"user_login\";s:7:\"amaggay\";s:9:\"user_pass\";s:34:\"$P$BCVyJTDGFc/c11ip0Hu13n2GO5m7ex0\";s:13:\"user_nicename\";s:7:\"amaggay\";s:10:\"user_email\";s:28:\"amaggay@dhcentralcharter.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-04 15:26:25\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:15:\"Adreinne Maggay\";}s:2:\"ID\";i:52;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:25;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"51\";s:10:\"user_login\";s:7:\"kpoulos\";s:9:\"user_pass\";s:34:\"$P$Bk.EfW0bRQmXdU17GXfz.eJkjikaUB1\";s:13:\"user_nicename\";s:7:\"kpoulos\";s:10:\"user_email\";s:19:\"a3@salida.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-02 23:56:36\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"kpoulos\";}s:2:\"ID\";i:51;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:26;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"50\";s:10:\"user_login\";s:11:\"mguerrero24\";s:9:\"user_pass\";s:34:\"$P$BRh2QPq7GoKuq6xNRLKKwKjWjE6..u0\";s:13:\"user_nicename\";s:11:\"mguerrero24\";s:10:\"user_email\";s:19:\"mguerrero24@att.net\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-02 21:53:57\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:16:\"Miguel AGuerrero\";}s:2:\"ID\";i:50;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:27;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"49\";s:10:\"user_login\";s:12:\"wharveyamoke\";s:9:\"user_pass\";s:34:\"$P$BDqKiZSgU7uU5qWh2CP70Uuxa/9iub0\";s:13:\"user_nicename\";s:12:\"wharveyamoke\";s:10:\"user_email\";s:22:\"wharveyamoke@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-02 04:37:36\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:12:\"wharveyamoke\";}s:2:\"ID\";i:49;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:28;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"48\";s:10:\"user_login\";s:7:\"tammywm\";s:9:\"user_pass\";s:34:\"$P$BQ256xULAK4yidI9bpByASvQ5l9NKc/\";s:13:\"user_nicename\";s:7:\"tammywm\";s:10:\"user_email\";s:19:\"tmcmahon@djuhsd.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-10-01 20:46:00\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"tammywm\";}s:2:\"ID\";i:48;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:29;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"47\";s:10:\"user_login\";s:8:\"berumenm\";s:9:\"user_pass\";s:34:\"$P$BWTJurZpyhdXVyOfpT2COQcKbzD7Ab.\";s:13:\"user_nicename\";s:8:\"berumenm\";s:10:\"user_email\";s:18:\"berumenm@gfusd.net\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-27 19:51:06\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:6:\"Margie\";}s:2:\"ID\";i:47;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:30;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"46\";s:10:\"user_login\";s:6:\"leenjd\";s:9:\"user_pass\";s:34:\"$P$BYTAGej8ogjhUNi8swZ0pJDwfy9HjI0\";s:13:\"user_nicename\";s:6:\"leenjd\";s:10:\"user_email\";s:21:\"Llopez@rsdshafter.org\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-27 16:17:36\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:9:\"Lee Lopez\";}s:2:\"ID\";i:46;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:31;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"45\";s:10:\"user_login\";s:7:\"meems95\";s:9:\"user_pass\";s:34:\"$P$BphQ5G5yVgvFfK9BRpq6h2H5yEDmec/\";s:13:\"user_nicename\";s:7:\"meems95\";s:10:\"user_email\";s:19:\"mmadonna8@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-27 04:13:31\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"meems95\";}s:2:\"ID\";i:45;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:32;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"44\";s:10:\"user_login\";s:8:\"dramirez\";s:9:\"user_pass\";s:34:\"$P$BOcqh.oMOlaOkUTRBjamKhVgTcpOWI/\";s:13:\"user_nicename\";s:8:\"dramirez\";s:10:\"user_email\";s:26:\"dd.ramirez@sdcounty.ca.gov\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-24 20:51:04\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:8:\"dramirez\";}s:2:\"ID\";i:44;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:33;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"43\";s:10:\"user_login\";s:9:\"mcdearmid\";s:9:\"user_pass\";s:34:\"$P$BwjcDsDj1KjRN9wYCT/eBL4XtdKq2h1\";s:13:\"user_nicename\";s:9:\"mcdearmid\";s:10:\"user_email\";s:28:\"jodimcdearmid@angelscamp.gov\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-20 17:16:19\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:9:\"mcdearmid\";}s:2:\"ID\";i:43;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:34;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"42\";s:10:\"user_login\";s:7:\"smaffey\";s:9:\"user_pass\";s:34:\"$P$BPkHZsO6UfAijItNvBkePH0Zv3/3oz/\";s:13:\"user_nicename\";s:7:\"smaffey\";s:10:\"user_email\";s:16:\"Shatch@sdcoe.net\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-20 15:51:27\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"smaffey\";}s:2:\"ID\";i:42;s:4:\"caps\";a:2:{s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:7:\"cap_key\";s:17:\"wptz_capabilities\";s:5:\"roles\";a:2:{i:0;s:10:\"subscriber\";i:1;s:15:\"bbp_participant\";}s:7:\"allcaps\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;s:10:\"subscriber\";b:1;s:15:\"bbp_participant\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:35;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:2:\"41\";s:10:\"user_login\";s:8:\"cmtframe\";s:9:\"user_pass\";s:34:\"$P$B6WPDIp.j60nRljy4GqLg5c23wJw1B.\";s:13:\"user_nicename\";s:8:\"cmtframe\";s:10:\"user_email\";s:27:\"craig_frame@chino.k12.ca.us\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-09-20 15:48:40\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:8:\"cmtframe\";}s:2:\"ID\";i:41;s:4:\"caps\";a:2:{s